/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.metadata;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.plugin.MetadataPluginType;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.metadata.IMetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataEditorDialog;
import org.apache.hop.ui.core.metadata.MetadataFileTypeHandler;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.metadata.MetadataPerspective;
import org.apache.hop.ui.util.HelpUtils;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public abstract class MetadataEditor<T extends IHopMetadata>
extends MetadataFileTypeHandler
implements IMetadataEditor<T> {
    private static final Class<?> PKG = MetadataEditorDialog.class;
    protected HopGui hopGui;
    protected MetadataManager<T> manager;
    protected T metadata;
    protected String title;
    protected String toolTip;
    protected Image titleImage;
    protected Image image;
    protected boolean isChanged = false;
    protected String originalName;

    public MetadataEditor(HopGui hopGui, MetadataManager<T> manager, T metadata) {
        super(metadata);
        this.hopGui = hopGui;
        this.manager = manager;
        this.metadata = metadata;
        this.originalName = metadata.getName();
        Type superclass = this.getClass().getGenericSuperclass();
        ParameterizedType parameterized = (ParameterizedType)superclass;
        Class managedClass = (Class)parameterized.getActualTypeArguments()[0];
        HopMetadata annotation = managedClass.getAnnotation(HopMetadata.class);
        this.setTitle(metadata.getName());
        Object titleToolTip = annotation.name();
        if (StringUtils.isNotEmpty((String)metadata.getMetadataProviderName())) {
            titleToolTip = (String)titleToolTip + Const.CR + "Source: " + metadata.getMetadataProviderName();
        }
        this.setTitleToolTip((String)titleToolTip);
        this.setTitleImage(GuiResource.getInstance().getImage(annotation.image(), managedClass.getClassLoader(), 16, 16));
        this.setImage(SwtSvgImageUtil.getImage(hopGui.getDisplay(), managedClass.getClassLoader(), annotation.image(), 48, 48));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataEditor that = (MetadataEditor)o;
        return Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.hopGui, this.manager, this.metadata, this.title, this.toolTip, this.titleImage, this.image, this.isChanged, this.originalName);
    }

    public Button[] createButtonsForButtonBar(Composite parent) {
        return null;
    }

    protected Button createHelpButton(Shell shell) {
        HopMetadata annotation = this.manager.getManagedClass().getAnnotation(HopMetadata.class);
        IPlugin plugin = PluginRegistry.getInstance().getPlugin(MetadataPluginType.class, annotation.key());
        return HelpUtils.createHelpButton((Composite)shell, plugin);
    }

    public HopGui getHopGui() {
        return this.hopGui;
    }

    public MetadataManager<T> getMetadataManager() {
        return this.manager;
    }

    @Override
    public T getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(T metadata) {
        this.metadata = metadata;
    }

    public Shell getShell() {
        return this.hopGui.getShell();
    }

    public Image getImage() {
        return this.image;
    }

    protected void setImage(Image image) {
        this.image = image;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Image getTitleImage() {
        return this.titleImage;
    }

    protected void setTitleImage(Image image) {
        this.titleImage = image;
    }

    @Override
    public String getTitleToolTip() {
        return this.toolTip;
    }

    protected void setTitleToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    @Override
    public boolean hasChanged() {
        return this.isChanged;
    }

    @Override
    public void resetChanged() {
        this.isChanged = false;
    }

    @Override
    public void setChanged() {
        if (!this.isChanged) {
            this.isChanged = true;
            MetadataPerspective.getInstance().updateEditor(this);
        }
    }

    public abstract void setWidgetsContent();

    public abstract void getWidgetsContent(T var1);

    @Override
    public boolean isCloseable() {
        if (this.hasChanged()) {
            MessageBox messageDialog = new MessageBox(this.getShell(), 452);
            messageDialog.setText(this.manager.getManagedName());
            messageDialog.setMessage(BaseMessages.getString(PKG, (String)"MetadataEditor.WantToSaveBeforeClosing.Message", (String[])new String[]{this.getTitle()}));
            int answer = messageDialog.open();
            if ((answer & 0x40) != 0) {
                try {
                    this.save();
                }
                catch (Exception e) {
                    new ErrorDialog(this.getShell(), "Error", "Error preparing editor close", e);
                    return false;
                }
            }
            if ((answer & 0x100) != 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void save() throws HopException {
        this.getWidgetsContent(this.metadata);
        String name = this.metadata.getName();
        boolean isCreated = false;
        boolean isRename = false;
        if (StringUtils.isEmpty((String)name)) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MetadataEditor.Error.NoName", (String[])new String[0]));
        }
        if (StringUtils.startsWith((String)name, (String)"$")) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MetadataEditor.Error.IncorrectName", (String[])new String[0]));
        }
        IHopMetadataSerializer<T> serializer = this.manager.getSerializer();
        if (StringUtils.isEmpty((String)this.originalName)) {
            isCreated = true;
        } else if (!this.originalName.equals(name)) {
            if (serializer.exists(name)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"MetadataEditor.Error.NameAlreadyExists", (String[])new String[]{name}));
            }
            isRename = true;
        }
        serializer.save(this.metadata);
        if (isCreated) {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.hopGui.getLog(), (IVariables)this.manager.getVariables(), (String)HopExtensionPoint.HopGuiMetadataObjectCreated.id, this.metadata);
        } else {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.hopGui.getLog(), (IVariables)this.manager.getVariables(), (String)HopExtensionPoint.HopGuiMetadataObjectUpdated.id, this.metadata);
        }
        this.isChanged = false;
        this.title = this.metadata.getName();
        if (isRename) {
            if (serializer.exists(this.originalName)) {
                serializer.delete(this.originalName);
            }
            this.originalName = this.metadata.getName();
        }
        MetadataPerspective.getInstance().updateEditor(this);
    }

    @Override
    public void saveAs(String filename) throws HopException {
        throw new HopException("Metadata editor doesn't support saveAs");
    }

    @Override
    public boolean setFocus() {
        return true;
    }

    @Override
    public void dispose() {
    }
}

