/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.gui;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ManagedColor {
    private Color color;
    private boolean systemColor;

    public ManagedColor(Color color, boolean systemColor) {
        this.color = color;
        this.systemColor = systemColor;
    }

    public ManagedColor(Display display, RGB rgb) {
        this.color = new Color((Device)display, rgb);
        this.systemColor = false;
    }

    public ManagedColor(Display display, int r, int g, int b) {
        this.color = new Color((Device)display, r, g, b);
        this.systemColor = false;
    }

    public ManagedColor(Display display, int color) {
        this.color = display.getSystemColor(color);
        this.systemColor = false;
    }

    public void dispose() {
        if (!this.systemColor && !this.color.isDisposed()) {
            this.color.dispose();
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setSystemColor(boolean systemColor) {
        this.systemColor = systemColor;
    }

    public boolean isSystemColor() {
        return this.systemColor;
    }
}

