/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.BooleanValue;
import org.apache.flink.types.NormalizableKey;

@Internal
public class BooleanValueComparator
extends TypeComparator<BooleanValue> {
    private static final long serialVersionUID = 1L;
    private final boolean ascendingComparison;
    private final BooleanValue reference = new BooleanValue();
    private final BooleanValue tempReference = new BooleanValue();
    private final TypeComparator<?>[] comparators = new TypeComparator[]{this};

    public BooleanValueComparator(boolean ascending) {
        this.ascendingComparison = ascending;
    }

    @Override
    public int hash(BooleanValue record) {
        return record.hashCode();
    }

    @Override
    public void setReference(BooleanValue toCompare) {
        toCompare.copyTo(this.reference);
    }

    @Override
    public boolean equalToReference(BooleanValue candidate) {
        return candidate.equals(this.reference);
    }

    @Override
    public int compareToReference(TypeComparator<BooleanValue> referencedComparator) {
        BooleanValue otherRef = ((BooleanValueComparator)referencedComparator).reference;
        int comp = otherRef.compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public int compare(BooleanValue first, BooleanValue second) {
        int comp = first.compareTo(second);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        this.reference.read(firstSource);
        this.tempReference.read(secondSource);
        int comp = this.reference.compareTo(this.tempReference);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return NormalizableKey.class.isAssignableFrom(BooleanValue.class);
    }

    @Override
    public int getNormalizeKeyLen() {
        return this.reference.getMaxNormalizedKeyLen();
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    @Override
    public void putNormalizedKey(BooleanValue record, MemorySegment target, int offset, int numBytes) {
        record.copyNormalizedKey(target, offset, numBytes);
    }

    @Override
    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    @Override
    public TypeComparator<BooleanValue> duplicate() {
        return new BooleanValueComparator(this.ascendingComparison);
    }

    @Override
    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    @Override
    public TypeComparator<?>[] getFlatComparators() {
        return this.comparators;
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public void writeWithKeyNormalization(BooleanValue record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BooleanValue readWithKeyDenormalization(BooleanValue reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }
}

