/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getfilenames;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.getfilenames.GetFileNamesData;
import org.apache.hop.pipeline.transforms.getfilenames.GetFileNamesMeta;

public class GetFileNames
extends BaseTransform<GetFileNamesMeta, GetFileNamesData> {
    private static final Class<?> PKG = GetFileNamesMeta.class;

    public GetFileNames(TransformMeta transformMeta, GetFileNamesMeta meta, GetFileNamesData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private Object[] buildEmptyRow() {
        return RowDataUtil.allocateRowData((int)((GetFileNamesData)this.data).outputRowMeta.size());
    }

    public boolean processRow() throws HopException {
        block31: {
            if (!((GetFileNamesMeta)this.meta).isFileField()) {
                if (((GetFileNamesData)this.data).filenr >= ((GetFileNamesData)this.data).filessize) {
                    this.setOutputDone();
                    return false;
                }
            } else {
                if (((GetFileNamesData)this.data).filenr >= ((GetFileNamesData)this.data).filessize) {
                    ((GetFileNamesData)this.data).readrow = this.getRow();
                }
                if (((GetFileNamesData)this.data).readrow == null) {
                    this.setOutputDone();
                    return false;
                }
                if (this.first) {
                    this.first = false;
                    ((GetFileNamesData)this.data).inputRowMeta = this.getInputRowMeta();
                    ((GetFileNamesData)this.data).outputRowMeta = ((GetFileNamesData)this.data).inputRowMeta.clone();
                    ((GetFileNamesMeta)this.meta).getFields(((GetFileNamesData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                    ((GetFileNamesData)this.data).totalpreviousfields = ((GetFileNamesData)this.data).inputRowMeta.size();
                    if (Utils.isEmpty((CharSequence)((GetFileNamesMeta)this.meta).getDynamicFilenameField())) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"GetFileNames.Log.NoField", (String[])new String[0]));
                    }
                    if (((GetFileNamesData)this.data).indexOfFilenameField < 0) {
                        ((GetFileNamesData)this.data).indexOfFilenameField = ((GetFileNamesData)this.data).inputRowMeta.indexOfValue(((GetFileNamesMeta)this.meta).getDynamicFilenameField());
                        if (((GetFileNamesData)this.data).indexOfFilenameField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"GetFileNames.Log.ErrorFindingField", (String[])new String[]{((GetFileNamesMeta)this.meta).getDynamicFilenameField()}));
                            throw new HopException(BaseMessages.getString(PKG, (String)"GetFileNames.Exception.CouldnotFindField", (String[])new String[]{((GetFileNamesMeta)this.meta).getDynamicFilenameField()}));
                        }
                    }
                    if (!Utils.isEmpty((CharSequence)((GetFileNamesMeta)this.meta).getDynamicWildcardField()) && ((GetFileNamesData)this.data).indexOfWildcardField < 0) {
                        ((GetFileNamesData)this.data).indexOfWildcardField = ((GetFileNamesData)this.data).inputRowMeta.indexOfValue(((GetFileNamesMeta)this.meta).getDynamicWildcardField());
                        if (((GetFileNamesData)this.data).indexOfWildcardField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"GetFileNames.Log.ErrorFindingField", (String[])new String[0]) + "[" + ((GetFileNamesMeta)this.meta).getDynamicWildcardField() + "]");
                            throw new HopException(BaseMessages.getString(PKG, (String)"GetFileNames.Exception.CouldnotFindField", (String[])new String[]{((GetFileNamesMeta)this.meta).getDynamicWildcardField()}));
                        }
                    }
                    if (!Utils.isEmpty((CharSequence)((GetFileNamesMeta)this.meta).getDynamicExcludeWildcardField()) && ((GetFileNamesData)this.data).indexOfExcludeWildcardField < 0) {
                        ((GetFileNamesData)this.data).indexOfExcludeWildcardField = ((GetFileNamesData)this.data).inputRowMeta.indexOfValue(((GetFileNamesMeta)this.meta).getDynamicExcludeWildcardField());
                        if (((GetFileNamesData)this.data).indexOfExcludeWildcardField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"GetFileNames.Log.ErrorFindingField", (String[])new String[0]) + "[" + ((GetFileNamesMeta)this.meta).getDynamicExcludeWildcardField() + "]");
                            throw new HopException(BaseMessages.getString(PKG, (String)"GetFileNames.Exception.CouldnotFindField", (String[])new String[]{((GetFileNamesMeta)this.meta).getDynamicExcludeWildcardField()}));
                        }
                    }
                }
            }
            try {
                Object[] outputRow = this.buildEmptyRow();
                int outputIndex = 0;
                Object[] extraData = new Object[((GetFileNamesData)this.data).nrTransformFields];
                if (((GetFileNamesMeta)this.meta).isFileField()) {
                    if (((GetFileNamesData)this.data).filenr >= ((GetFileNamesData)this.data).filessize) {
                        String filename = this.getInputRowMeta().getString(((GetFileNamesData)this.data).readrow, ((GetFileNamesData)this.data).indexOfFilenameField);
                        String wildcard = "";
                        if (((GetFileNamesData)this.data).indexOfWildcardField >= 0) {
                            wildcard = this.getInputRowMeta().getString(((GetFileNamesData)this.data).readrow, ((GetFileNamesData)this.data).indexOfWildcardField);
                        }
                        String excludeWildcard = "";
                        if (((GetFileNamesData)this.data).indexOfExcludeWildcardField >= 0) {
                            excludeWildcard = this.getInputRowMeta().getString(((GetFileNamesData)this.data).readrow, ((GetFileNamesData)this.data).indexOfExcludeWildcardField);
                        }
                        String[] filesname = new String[]{filename};
                        String[] filesMask = new String[]{wildcard};
                        String[] excludeFilesMask = new String[]{excludeWildcard};
                        String[] filesRequired = new String[]{"N"};
                        boolean[] includeSubfolders = new boolean[]{((GetFileNamesMeta)this.meta).isDynamicIncludeSubFolders()};
                        ((GetFileNamesData)this.data).files = ((GetFileNamesMeta)this.meta).getDynamicFileList((IVariables)this, filesname, filesMask, excludeFilesMask, filesRequired, includeSubfolders);
                        ((GetFileNamesData)this.data).filessize = ((GetFileNamesData)this.data).files.nrOfFiles();
                        ((GetFileNamesData)this.data).filenr = 0;
                    }
                    if (!((GetFileNamesMeta)this.meta).isDoNotFailIfNoFile() && ((GetFileNamesData)this.data).filessize == 0) {
                        if (((GetFileNamesMeta)this.meta).isRaiseAnExceptionIfNoFile()) {
                            if (this.getTransformMeta().isDoingErrorHandling()) {
                                this.sendErrorRow(BaseMessages.getString(PKG, (String)"GetFileNames.Log.NoFile", (String[])new String[0]));
                            } else {
                                throw new HopException(BaseMessages.getString(PKG, (String)"GetFileNames.Log.NoFileStop", (String[])new String[0]));
                            }
                        }
                        this.logError(BaseMessages.getString(PKG, (String)"GetFileNames.Log.NoFile", (String[])new String[0]));
                    } else {
                        outputRow = (Object[])((GetFileNamesData)this.data).readrow.clone();
                    }
                }
                if (((GetFileNamesData)this.data).filessize <= 0) break block31;
                ((GetFileNamesData)this.data).file = ((GetFileNamesData)this.data).files.getFile(((GetFileNamesData)this.data).filenr);
                if (((GetFileNamesMeta)this.meta).isAddResultFile()) {
                    ResultFile resultFile = new ResultFile(0, ((GetFileNamesData)this.data).file, this.getPipelineMeta().getName(), this.getTransformName());
                    resultFile.setComment(BaseMessages.getString(PKG, (String)"GetFileNames.Log.FileReadByTransform", (String[])new String[0]));
                    this.addResultFile(resultFile);
                }
                extraData[outputIndex++] = HopVfs.getFilename((FileObject)((GetFileNamesData)this.data).file);
                extraData[outputIndex++] = ((GetFileNamesData)this.data).file.getName().getBaseName();
                try {
                    extraData[outputIndex++] = HopVfs.getFilename((FileObject)((GetFileNamesData)this.data).file.getParent());
                    extraData[outputIndex++] = ((GetFileNamesData)this.data).file.getType().toString();
                    extraData[outputIndex++] = ((GetFileNamesData)this.data).file.exists();
                    extraData[outputIndex++] = ((GetFileNamesData)this.data).file.isHidden();
                    extraData[outputIndex++] = ((GetFileNamesData)this.data).file.isReadable();
                    extraData[outputIndex++] = ((GetFileNamesData)this.data).file.isWriteable();
                    extraData[outputIndex++] = new Date(((GetFileNamesData)this.data).file.getContent().getLastModifiedTime());
                    Long size = null;
                    if (((GetFileNamesData)this.data).file.getType().equals((Object)FileType.FILE)) {
                        size = ((GetFileNamesData)this.data).file.getContent().getSize();
                    }
                    extraData[outputIndex++] = size;
                }
                catch (IOException e) {
                    throw new HopException((Throwable)e);
                }
                extraData[outputIndex++] = ((GetFileNamesData)this.data).file.getName().getExtension();
                extraData[outputIndex++] = ((GetFileNamesData)this.data).file.getName().getURI();
                extraData[outputIndex++] = ((GetFileNamesData)this.data).file.getName().getRootURI();
                if (((GetFileNamesMeta)this.meta).isIncludeRowNumber() && !Utils.isEmpty((CharSequence)((GetFileNamesMeta)this.meta).getRowNumberField())) {
                    extraData[outputIndex++] = ((GetFileNamesData)this.data).rownr + 1L;
                }
                ++((GetFileNamesData)this.data).rownr;
                outputRow = RowDataUtil.addRowData((Object[])outputRow, (int)((GetFileNamesData)this.data).totalpreviousfields, (Object[])extraData);
                this.putRow(((GetFileNamesData)this.data).outputRowMeta, outputRow);
                if (((GetFileNamesMeta)this.meta).getRowLimit() > 0L && ((GetFileNamesData)this.data).rownr >= ((GetFileNamesMeta)this.meta).getRowLimit()) {
                    this.setOutputDone();
                    return false;
                }
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        ++((GetFileNamesData)this.data).filenr;
        if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"GetFileNames.Log.NrLine", (String[])new String[]{"" + this.getLinesInput()}));
        }
        return true;
    }

    private void sendErrorRow(String errorMsg) {
        try {
            String defaultErrCode = "GetFilenames001";
            if (((GetFileNamesData)this.data).readrow != null) {
                this.putError(this.getInputRowMeta(), ((GetFileNamesData)this.data).readrow, 1L, errorMsg, null, defaultErrCode);
            } else {
                this.putError((IRowMeta)new RowMeta(), new Object[0], 1L, errorMsg, null, defaultErrCode);
            }
        }
        catch (HopTransformException e) {
            this.logError(e.getLocalizedMessage(), e);
        }
    }

    private void handleMissingFiles() throws HopException {
        if (!((GetFileNamesMeta)this.meta).isDoNotFailIfNoFile() && ((GetFileNamesData)this.data).files.nrOfFiles() == 0) {
            if (((GetFileNamesMeta)this.meta).isRaiseAnExceptionIfNoFile()) {
                if (this.getTransformMeta().isDoingErrorHandling()) {
                    this.sendErrorRow(BaseMessages.getString(PKG, (String)"GetFileNames.Log.NoFile", (String[])new String[0]));
                } else {
                    throw new HopException(BaseMessages.getString(PKG, (String)"GetFileNames.Log.NoFileStop", (String[])new String[0]));
                }
            }
            this.logError(BaseMessages.getString(PKG, (String)"GetFileNames.Log.NoFile", (String[])new String[0]));
            return;
        }
        List nonExistantFiles = ((GetFileNamesData)this.data).files.getNonExistantFiles();
        if (nonExistantFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            this.logBasic("ERROR: Missing " + message);
            throw new HopException("Following required files are missing: " + message);
        }
        List nonAccessibleFiles = ((GetFileNamesData)this.data).files.getNonAccessibleFiles();
        if (nonAccessibleFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            this.logBasic("WARNING: Not accessible " + message);
            throw new HopException("Following required files are not accessible: " + message);
        }
    }

    public boolean init() {
        if (super.init()) {
            try {
                ((GetFileNamesData)this.data).outputRowMeta = new RowMeta();
                ((GetFileNamesMeta)this.meta).getFields(((GetFileNamesData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                ((GetFileNamesData)this.data).nrTransformFields = ((GetFileNamesData)this.data).outputRowMeta.size();
                if (!((GetFileNamesMeta)this.meta).isFileField()) {
                    ((GetFileNamesData)this.data).files = ((GetFileNamesMeta)this.meta).getFileList((IVariables)this);
                    ((GetFileNamesData)this.data).filessize = ((GetFileNamesData)this.data).files.nrOfFiles();
                    this.handleMissingFiles();
                } else {
                    ((GetFileNamesData)this.data).filessize = 0;
                }
            }
            catch (Exception e) {
                this.logError("Error initializing transform: " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
                return false;
            }
            ((GetFileNamesData)this.data).rownr = 0L;
            ((GetFileNamesData)this.data).filenr = 0;
            ((GetFileNamesData)this.data).totalpreviousfields = 0;
            return true;
        }
        return false;
    }

    public void dispose() {
        if (((GetFileNamesData)this.data).file != null) {
            try {
                ((GetFileNamesData)this.data).file.close();
                ((GetFileNamesData)this.data).file = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose();
    }
}

