/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.xmlinputstream;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.xml.xmlinputstream.XmlInputStreamData;
import org.apache.hop.pipeline.transforms.xml.xmlinputstream.XmlInputStreamMeta;

public class XmlInputStream
extends BaseTransform<XmlInputStreamMeta, XmlInputStreamData> {
    private static final Class<?> PKG = XmlInputStream.class;
    private static final int PARENT_ID_ALLOCATE_SIZE = 1000;
    private int inputFieldIndex;
    static final String[] eventDescription = new String[]{"UNKNOWN", "START_ELEMENT", "END_ELEMENT", "PROCESSING_INSTRUCTION", "CHARACTERS", "COMMENT", "SPACE", "START_DOCUMENT", "END_DOCUMENT", "ENTITY_REFERENCE", "ATTRIBUTE", "DTD", "CDATA", "NAMESPACE", "NOTATION_DECLARATION", "ENTITY_DECLARATION"};

    public XmlInputStream(TransformMeta transformMeta, XmlInputStreamMeta meta, XmlInputStreamData transformDataInterface, int copyNr, PipelineMeta pipelineMeta, Pipeline trans) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)transformDataInterface, copyNr, pipelineMeta, trans);
    }

    public boolean processRow() throws HopException {
        Object[] outputRowData;
        if (this.first && !((XmlInputStreamMeta)this.meta).sourceFromInput) {
            this.first = false;
            if (((XmlInputStreamData)this.data).filenames == null) {
                this.getFilenames();
            }
            this.openNextFile();
            this.resetElementCounters();
            this.prepareProcessPreviousFields();
        }
        if (((XmlInputStreamMeta)this.meta).sourceFromInput) {
            Object[] row = null;
            if (this.first) {
                this.first = false;
                row = this.getRow();
                if (this.getInputRowMeta() == null) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"XMLInputStream.NoIncomingRowsFound", (String[])new String[0]));
                }
                this.inputFieldIndex = this.getInputRowMeta().indexOfValue(((XmlInputStreamMeta)this.meta).sourceFieldName);
                if (this.inputFieldIndex < 0) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"XMLInputStream.FilenameFieldNotFound", (String[])new String[]{((XmlInputStreamMeta)this.meta).sourceFieldName}));
                }
                this.prepareProcessPreviousFields();
            }
            if (((XmlInputStreamData)this.data).xmlEventReader == null) {
                if (row == null) {
                    row = this.getRow();
                }
                if (row == null) {
                    this.setOutputDone();
                    return false;
                }
                String xml = this.getInputRowMeta().getString(row, this.inputFieldIndex);
                try {
                    ((XmlInputStreamData)this.data).xmlEventReader = ((XmlInputStreamData)this.data).staxInstance.createXMLEventReader(new StringReader(xml));
                }
                catch (XMLStreamException e) {
                    throw new HopException((Throwable)e);
                }
                this.resetElementCounters();
            }
            if (row != null) {
                ((XmlInputStreamData)this.data).currentInputRow = (Object[])row.clone();
            }
            if ((outputRowData = this.getRowFromXML()) == null) {
                ((XmlInputStreamData)this.data).xmlEventReader = null;
                return true;
            }
        } else {
            if (((XmlInputStreamData)this.data).inputDataRows != null) {
                ((XmlInputStreamData)this.data).currentInputRow = (Object[])((XmlInputStreamData)this.data).inputDataRows.get(((XmlInputStreamData)this.data).filenames[((XmlInputStreamData)this.data).filenr - 1]).clone();
            }
            if ((outputRowData = this.getRowFromXML()) == null) {
                if (this.openNextFile()) {
                    this.resetElementCounters();
                    return true;
                }
                this.setOutputDone();
                return false;
            }
        }
        this.putRowOut(outputRowData);
        if (((XmlInputStreamData)this.data).rowLimit > 0L && ((XmlInputStreamData)this.data).rowNumber >= ((XmlInputStreamData)this.data).rowLimit) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private void prepareProcessPreviousFields() throws HopTransformException {
        if (this.getInputRowMeta() == null) {
            ((XmlInputStreamData)this.data).previousFieldsNumber = 0;
            ((XmlInputStreamData)this.data).finalOutputRowMeta = ((XmlInputStreamData)this.data).outputRowMeta;
        } else {
            ((XmlInputStreamData)this.data).previousFieldsNumber = this.getInputRowMeta().size();
            ((XmlInputStreamData)this.data).finalOutputRowMeta = this.getInputRowMeta().clone();
            ((XmlInputStreamMeta)this.meta).getFields(((XmlInputStreamData)this.data).finalOutputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        }
    }

    private boolean openNextFile() throws HopException {
        try {
            this.closeFile();
            if (((XmlInputStreamData)this.data).filenr >= ((XmlInputStreamData)this.data).filenames.length) {
                return false;
            }
            ((XmlInputStreamData)this.data).fileObject = HopVfs.getFileObject((String)((XmlInputStreamData)this.data).filenames[((XmlInputStreamData)this.data).filenr]);
            ((XmlInputStreamData)this.data).inputStream = HopVfs.getInputStream((FileObject)((XmlInputStreamData)this.data).fileObject);
            ((XmlInputStreamData)this.data).xmlEventReader = ((XmlInputStreamData)this.data).staxInstance.createXMLEventReader(((XmlInputStreamData)this.data).inputStream, ((XmlInputStreamData)this.data).encoding);
        }
        catch (IOException e) {
            throw new HopException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new HopException((Throwable)e);
        }
        ++((XmlInputStreamData)this.data).filenr;
        if (((XmlInputStreamMeta)this.meta).isAddResultFile()) {
            ResultFile resultFile = new ResultFile(0, ((XmlInputStreamData)this.data).fileObject, this.getPipelineMeta().getName(), this.getTransformName());
            resultFile.setComment(BaseMessages.getString(PKG, (String)"XMLInputStream.Log.ResultFileWasRead", (String[])new String[0]));
            this.addResultFile(resultFile);
        }
        return true;
    }

    private void closeFile() {
        block11: {
            block10: {
                block9: {
                    if (((XmlInputStreamData)this.data).xmlEventReader != null) {
                        try {
                            ((XmlInputStreamData)this.data).xmlEventReader.close();
                        }
                        catch (XMLStreamException e) {
                            if (!this.log.isBasic()) break block9;
                            this.log.logBasic(BaseMessages.getString(PKG, (String)"XMLInputStream.Log.UnableToCloseFile", (String[])new String[]{((XmlInputStreamData)this.data).filenames[((XmlInputStreamData)this.data).filenr - 1]}), new Object[]{e});
                        }
                    }
                }
                if (((XmlInputStreamData)this.data).inputStream != null) {
                    try {
                        ((XmlInputStreamData)this.data).inputStream.close();
                    }
                    catch (IOException e) {
                        if (!this.log.isBasic()) break block10;
                        this.log.logBasic(BaseMessages.getString(PKG, (String)"XMLInputStream.Log.UnableToCloseFile", (String[])new String[]{((XmlInputStreamData)this.data).filenames[((XmlInputStreamData)this.data).filenr - 1]}), new Object[]{e});
                    }
                }
            }
            if (((XmlInputStreamData)this.data).fileObject != null) {
                try {
                    ((XmlInputStreamData)this.data).fileObject.close();
                }
                catch (FileSystemException e) {
                    if (!this.log.isBasic()) break block11;
                    this.log.logBasic(BaseMessages.getString(PKG, (String)"XMLInputStream.Log.UnableToCloseFile", (String[])new String[]{((XmlInputStreamData)this.data).filenames[((XmlInputStreamData)this.data).filenr - 1]}), new Object[]{e});
                }
            }
        }
    }

    private void getFilenames() throws HopException {
        ArrayList<String> filenames = new ArrayList<String>();
        int index = -1;
        Object[] row = this.getRow();
        String filenameValue = this.resolve(((XmlInputStreamMeta)this.meta).getFilename());
        index = this.getInputRowMeta().indexOfValue(filenameValue);
        if (index < 0) {
            ((XmlInputStreamData)this.data).filenames = new String[]{filenameValue};
        } else {
            ((XmlInputStreamData)this.data).inputDataRows = new HashMap<String, Object[]>();
            while (row != null) {
                String filename = this.getInputRowMeta().getString(row, index);
                filenames.add(filename);
                ((XmlInputStreamData)this.data).inputDataRows.put(filename, row);
                row = this.getRow();
            }
            ((XmlInputStreamData)this.data).filenames = filenames.toArray(new String[filenames.size()]);
            this.logDetailed(BaseMessages.getString(PKG, (String)"XMLInputStream.Log.ReadingFromNrFiles", (String[])new String[]{Integer.toString(((XmlInputStreamData)this.data).filenames.length)}));
        }
    }

    private void putRowOut(Object[] r) throws HopTransformException, HopValueException {
        XmlInputStreamData xmlInputStreamData = (XmlInputStreamData)this.data;
        Long l = xmlInputStreamData.rowNumber;
        Long l2 = xmlInputStreamData.rowNumber = Long.valueOf(xmlInputStreamData.rowNumber + 1L);
        if (((XmlInputStreamData)this.data).pos_xmlFilename != -1) {
            r[((XmlInputStreamData)this.data).pos_xmlFilename] = String.valueOf(((XmlInputStreamData)this.data).filenames[((XmlInputStreamData)this.data).filenr - 1]);
        }
        if (((XmlInputStreamData)this.data).pos_xmlRow_number != -1) {
            r[((XmlInputStreamData)this.data).pos_xmlRow_number] = ((XmlInputStreamData)this.data).rowNumber;
        }
        if (((XmlInputStreamData)this.data).pos_xml_element_id != -1) {
            r[((XmlInputStreamData)this.data).pos_xml_element_id] = ((XmlInputStreamData)this.data).elementLevelID[((XmlInputStreamData)this.data).elementLevel];
        }
        if (((XmlInputStreamData)this.data).pos_xml_element_level != -1) {
            r[((XmlInputStreamData)this.data).pos_xml_element_level] = (long)((XmlInputStreamData)this.data).elementLevel;
        }
        if (((XmlInputStreamData)this.data).pos_xml_parent_element_id != -1) {
            r[((XmlInputStreamData)this.data).pos_xml_parent_element_id] = ((XmlInputStreamData)this.data).elementParentID[((XmlInputStreamData)this.data).elementLevel];
        }
        if (((XmlInputStreamData)this.data).pos_xml_path != -1) {
            r[((XmlInputStreamData)this.data).pos_xml_path] = ((XmlInputStreamData)this.data).elementPath[((XmlInputStreamData)this.data).elementLevel];
        }
        if (((XmlInputStreamData)this.data).pos_xml_parent_path != -1 && ((XmlInputStreamData)this.data).elementLevel > 0) {
            r[((XmlInputStreamData)this.data).pos_xml_parent_path] = ((XmlInputStreamData)this.data).elementPath[((XmlInputStreamData)this.data).elementLevel - 1];
        }
        if (((XmlInputStreamData)this.data).nrRowsToSkip == 0L || ((XmlInputStreamData)this.data).rowNumber > ((XmlInputStreamData)this.data).nrRowsToSkip) {
            if (this.log.isRowLevel()) {
                this.logRowlevel("Read row: " + ((XmlInputStreamData)this.data).outputRowMeta.getString(r));
            }
            if (((XmlInputStreamData)this.data).currentInputRow != null) {
                r = RowDataUtil.addRowData((Object[])((Object[])((XmlInputStreamData)this.data).currentInputRow.clone()), (int)((XmlInputStreamData)this.data).previousFieldsNumber, (Object[])r);
            }
            this.putRow(((XmlInputStreamData)this.data).finalOutputRowMeta, r);
        }
    }

    private Object[] getRowFromXML() throws HopException {
        Object[] outputRowData = null;
        while (((XmlInputStreamData)this.data).xmlEventReader.hasNext() && outputRowData == null && !this.isStopped()) {
            outputRowData = this.processEvent();
            this.incrementLinesInput();
            if (!this.checkFeedback(this.getLinesInput()) || !this.isBasic()) continue;
            this.logBasic(BaseMessages.getString(PKG, (String)"XMLInputStream.Log.LineNumber", (String[])new String[]{Long.toString(this.getLinesInput())}));
        }
        return outputRowData;
    }

    private Object[] processEvent() throws HopException {
        Object[] outputRowData = RowDataUtil.allocateRowData((int)((XmlInputStreamData)this.data).outputRowMeta.size());
        XMLEvent e = null;
        try {
            e = ((XmlInputStreamData)this.data).xmlEventReader.nextEvent();
        }
        catch (XMLStreamException ex) {
            throw new HopException((Throwable)ex);
        }
        int eventType = e.getEventType();
        if (((XmlInputStreamData)this.data).pos_xml_dataType_numeric != -1) {
            outputRowData[((XmlInputStreamData)this.data).pos_xml_dataType_numeric] = (long)eventType;
        }
        if (((XmlInputStreamData)this.data).pos_xml_dataTypeDescription != -1) {
            outputRowData[((XmlInputStreamData)this.data).pos_xml_dataTypeDescription] = eventType == 0 || eventType > eventDescription.length ? eventDescription[0] + "(" + eventType + ")" : eventDescription[eventType];
        }
        if (((XmlInputStreamData)this.data).pos_xml_location_line != -1) {
            outputRowData[((XmlInputStreamData)this.data).pos_xml_location_line] = (long)e.getLocation().getLineNumber();
        }
        if (((XmlInputStreamData)this.data).pos_xml_locationColumn != -1) {
            outputRowData[((XmlInputStreamData)this.data).pos_xml_locationColumn] = (long)e.getLocation().getColumnNumber();
        }
        switch (eventType) {
            case 1: {
                String prefix;
                ++((XmlInputStreamData)this.data).elementLevel;
                if (((XmlInputStreamData)this.data).elementLevel > 999) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"XMLInputStream.Log.TooManyNestedElements", (Object[])new Object[]{1000}));
                }
                if (((XmlInputStreamData)this.data).elementParentID[((XmlInputStreamData)this.data).elementLevel] == null) {
                    ((XmlInputStreamData)this.data).elementParentID[((XmlInputStreamData)this.data).elementLevel] = ((XmlInputStreamData)this.data).elementID;
                }
                XmlInputStreamData xmlInputStreamData = (XmlInputStreamData)this.data;
                Long l = xmlInputStreamData.elementID;
                Long l2 = xmlInputStreamData.elementID = Long.valueOf(xmlInputStreamData.elementID + 1L);
                ((XmlInputStreamData)this.data).elementLevelID[((XmlInputStreamData)this.data).elementLevel] = ((XmlInputStreamData)this.data).elementID;
                Object xmlDataName = ((XmlInputStreamMeta)this.meta).isEnableNamespaces() ? (Utils.isEmpty((CharSequence)(prefix = e.asStartElement().getName().getPrefix())) ? e.asStartElement().getName().getLocalPart() : prefix + ":" + e.asStartElement().getName().getLocalPart()) : e.asStartElement().getName().getLocalPart();
                if (((XmlInputStreamData)this.data).pos_xml_dataName >= 0) {
                    outputRowData[((XmlInputStreamData)this.data).pos_xml_dataName] = xmlDataName;
                }
                ((XmlInputStreamData)this.data).elementName[((XmlInputStreamData)this.data).elementLevel] = xmlDataName;
                ((XmlInputStreamData)this.data).elementPath[((XmlInputStreamData)this.data).elementLevel] = ((XmlInputStreamData)this.data).elementPath[((XmlInputStreamData)this.data).elementLevel - 1] + "/" + (String)xmlDataName;
                if (((XmlInputStreamMeta)this.meta).isEnableNamespaces()) {
                    outputRowData = this.parseNamespaces(outputRowData, e);
                }
                outputRowData = this.parseAttributes(outputRowData, e);
                break;
            }
            case 2: {
                this.parseEndElement(outputRowData, e.asEndElement());
                this.putRowOut(outputRowData);
                ((XmlInputStreamData)this.data).elementParentID[((XmlInputStreamData)this.data).elementLevel + 1] = null;
                --((XmlInputStreamData)this.data).elementLevel;
                outputRowData = null;
                break;
            }
            case 6: {
                outputRowData = null;
                break;
            }
            case 4: 
            case 12: {
                if (((XmlInputStreamData)this.data).pos_xml_dataName >= 0) {
                    outputRowData[((XmlInputStreamData)this.data).pos_xml_dataName] = ((XmlInputStreamData)this.data).elementName[((XmlInputStreamData)this.data).elementLevel];
                }
                String xmlDataValue = e.asCharacters().getData();
                if (((XmlInputStreamData)this.data).pos_xml_dataValue >= 0) {
                    if (((XmlInputStreamMeta)this.meta).isEnableTrim()) {
                        xmlDataValue = Const.trim((String)xmlDataValue);
                    }
                    outputRowData[((XmlInputStreamData)this.data).pos_xml_dataValue] = xmlDataValue;
                }
                if (((XmlInputStreamData)this.data).pos_xml_dataValue >= 0 && !Utils.isEmpty((CharSequence)((String)outputRowData[((XmlInputStreamData)this.data).pos_xml_dataValue]))) break;
                outputRowData = null;
                break;
            }
            case 3: {
                outputRowData = null;
                break;
            }
            case 5: {
                outputRowData = null;
                break;
            }
            case 9: {
                outputRowData = null;
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            default: {
                this.logBasic("Event:" + eventType);
                outputRowData = null;
            }
        }
        return outputRowData;
    }

    private void parseEndElement(Object[] outputRowData, EndElement el) {
        if (((XmlInputStreamData)this.data).pos_xml_dataName >= 0) {
            outputRowData[((XmlInputStreamData)this.data).pos_xml_dataName] = this.getEndElementName(el, ((XmlInputStreamMeta)this.meta).isEnableNamespaces());
        }
    }

    private String getEndElementName(EndElement el, boolean enabledNamespaces) {
        if (!enabledNamespaces) {
            return el.getName().getLocalPart();
        }
        return this.getName(el.getName().getPrefix(), el.getName().getLocalPart());
    }

    private Object[] parseNamespaces(Object[] outputRowData, XMLEvent e) throws HopValueException, HopTransformException {
        Object[] outputRowDataNamespace;
        Iterator<Namespace> iter = e.asStartElement().getNamespaces();
        if (iter.hasNext()) {
            outputRowDataNamespace = ((XmlInputStreamData)this.data).outputRowMeta.cloneRow(outputRowData);
            this.putRowOut(outputRowDataNamespace);
            if (((XmlInputStreamData)this.data).pos_xml_dataType_numeric != -1) {
                outputRowData[((XmlInputStreamData)this.data).pos_xml_dataType_numeric] = 13L;
            }
            if (((XmlInputStreamData)this.data).pos_xml_dataTypeDescription != -1) {
                outputRowData[((XmlInputStreamData)this.data).pos_xml_dataTypeDescription] = eventDescription[13];
            }
        }
        while (iter.hasNext()) {
            outputRowDataNamespace = ((XmlInputStreamData)this.data).outputRowMeta.cloneRow(outputRowData);
            Namespace n = iter.next();
            outputRowDataNamespace[((XmlInputStreamData)this.data).pos_xml_dataName] = n.getPrefix();
            outputRowDataNamespace[((XmlInputStreamData)this.data).pos_xml_dataValue] = n.getNamespaceURI();
            if (iter.hasNext()) {
                this.putRowOut(outputRowDataNamespace);
                continue;
            }
            outputRowData = outputRowDataNamespace;
        }
        return outputRowData;
    }

    private Object[] parseAttributes(Object[] outputRowData, XMLEvent e) throws HopValueException, HopTransformException {
        Object[] outputRowDataAttribute;
        Iterator<Attribute> iter = e.asStartElement().getAttributes();
        if (iter.hasNext()) {
            outputRowDataAttribute = ((XmlInputStreamData)this.data).outputRowMeta.cloneRow(outputRowData);
            this.putRowOut(outputRowDataAttribute);
            if (((XmlInputStreamData)this.data).pos_xml_dataType_numeric != -1) {
                outputRowData[((XmlInputStreamData)this.data).pos_xml_dataType_numeric] = 10L;
            }
            if (((XmlInputStreamData)this.data).pos_xml_dataTypeDescription != -1) {
                outputRowData[((XmlInputStreamData)this.data).pos_xml_dataTypeDescription] = eventDescription[10];
            }
        }
        while (iter.hasNext()) {
            outputRowDataAttribute = ((XmlInputStreamData)this.data).outputRowMeta.cloneRow(outputRowData);
            Attribute a = iter.next();
            this.parseAttribute(outputRowDataAttribute, a, ((XmlInputStreamMeta)this.meta).isEnableNamespaces());
            if (iter.hasNext()) {
                this.putRowOut(outputRowDataAttribute);
                continue;
            }
            outputRowData = outputRowDataAttribute;
        }
        return outputRowData;
    }

    private void parseAttribute(Object[] outputRowDataAttribute, Attribute a, boolean enabledNamespaces) {
        if (((XmlInputStreamData)this.data).pos_xml_dataName != -1) {
            outputRowDataAttribute[((XmlInputStreamData)this.data).pos_xml_dataName] = this.getAttributeName(a, enabledNamespaces);
        }
        if (((XmlInputStreamData)this.data).pos_xml_dataValue != -1) {
            outputRowDataAttribute[((XmlInputStreamData)this.data).pos_xml_dataValue] = a.getValue();
        }
    }

    private String getAttributeName(Attribute a, boolean enabledNamespaces) {
        if (!enabledNamespaces) {
            return a.getName().getLocalPart();
        }
        return this.getName(a.getName().getPrefix(), a.getName().getLocalPart());
    }

    private String getName(String prefix, String localPart) {
        return !Utils.isEmpty((CharSequence)prefix) ? prefix + ":" + localPart : localPart;
    }

    private void resetElementCounters() {
        ((XmlInputStreamData)this.data).rowNumber = 0L;
        ((XmlInputStreamData)this.data).elementLevel = 0;
        ((XmlInputStreamData)this.data).elementID = 0L;
        ((XmlInputStreamData)this.data).elementLevelID = new Long[1000];
        ((XmlInputStreamData)this.data).elementLevelID[0] = ((XmlInputStreamData)this.data).elementID;
        ((XmlInputStreamData)this.data).elementParentID = new Long[1000];
        ((XmlInputStreamData)this.data).elementName = new String[1000];
        ((XmlInputStreamData)this.data).elementPath = new String[1000];
        ((XmlInputStreamData)this.data).elementPath[0] = "";
    }

    public boolean init() {
        if (super.init()) {
            ((XmlInputStreamData)this.data).staxInstance = XMLInputFactory.newInstance();
            ((XmlInputStreamData)this.data).staxInstance.setProperty("javax.xml.stream.isCoalescing", false);
            ((XmlInputStreamData)this.data).filenr = 0;
            if (this.getPipelineMeta().findPreviousTransforms(this.getTransformMeta()).size() == 0 && !((XmlInputStreamMeta)this.meta).sourceFromInput) {
                String filename = this.resolve(((XmlInputStreamMeta)this.meta).getFilename());
                if (Utils.isEmpty((CharSequence)filename)) {
                    this.logError(BaseMessages.getString(PKG, (String)"XMLInputStream.MissingFilename.Message", (String[])new String[0]));
                    return false;
                }
                ((XmlInputStreamData)this.data).filenames = new String[]{filename};
            } else {
                ((XmlInputStreamData)this.data).filenames = null;
            }
            ((XmlInputStreamData)this.data).nrRowsToSkip = Const.toLong((String)this.resolve(((XmlInputStreamMeta)this.meta).getNrRowsToSkip()), (long)0L);
            ((XmlInputStreamData)this.data).rowLimit = Const.toLong((String)this.resolve(((XmlInputStreamMeta)this.meta).getRowLimit()), (long)0L);
            ((XmlInputStreamData)this.data).encoding = this.resolve(((XmlInputStreamMeta)this.meta).getEncoding());
            ((XmlInputStreamData)this.data).outputRowMeta = new RowMeta();
            ((XmlInputStreamMeta)this.meta).getFields(((XmlInputStreamData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((XmlInputStreamData)this.data).pos_xmlFilename = ((XmlInputStreamData)this.data).outputRowMeta.indexOfValue(((XmlInputStreamMeta)this.meta).getFilenameField());
            ((XmlInputStreamData)this.data).pos_xmlRow_number = ((XmlInputStreamData)this.data).outputRowMeta.indexOfValue(((XmlInputStreamMeta)this.meta).getRowNumberField());
            ((XmlInputStreamData)this.data).pos_xml_dataType_numeric = ((XmlInputStreamData)this.data).outputRowMeta.indexOfValue(((XmlInputStreamMeta)this.meta).getXmlDataTypeNumericField());
            ((XmlInputStreamData)this.data).pos_xml_dataTypeDescription = ((XmlInputStreamData)this.data).outputRowMeta.indexOfValue(((XmlInputStreamMeta)this.meta).getXmlDataTypeDescriptionField());
            ((XmlInputStreamData)this.data).pos_xml_location_line = ((XmlInputStreamData)this.data).outputRowMeta.indexOfValue(((XmlInputStreamMeta)this.meta).getXmlLocationLineField());
            ((XmlInputStreamData)this.data).pos_xml_locationColumn = ((XmlInputStreamData)this.data).outputRowMeta.indexOfValue(((XmlInputStreamMeta)this.meta).getXmlLocationColumnField());
            ((XmlInputStreamData)this.data).pos_xml_element_id = ((XmlInputStreamData)this.data).outputRowMeta.indexOfValue(((XmlInputStreamMeta)this.meta).getXmlElementIDField());
            ((XmlInputStreamData)this.data).pos_xml_parent_element_id = ((XmlInputStreamData)this.data).outputRowMeta.indexOfValue(((XmlInputStreamMeta)this.meta).getXmlParentElementIDField());
            ((XmlInputStreamData)this.data).pos_xml_element_level = ((XmlInputStreamData)this.data).outputRowMeta.indexOfValue(((XmlInputStreamMeta)this.meta).getXmlElementLevelField());
            ((XmlInputStreamData)this.data).pos_xml_path = ((XmlInputStreamData)this.data).outputRowMeta.indexOfValue(((XmlInputStreamMeta)this.meta).getXmlPathField());
            ((XmlInputStreamData)this.data).pos_xml_parent_path = ((XmlInputStreamData)this.data).outputRowMeta.indexOfValue(((XmlInputStreamMeta)this.meta).getXmlParentPathField());
            ((XmlInputStreamData)this.data).pos_xml_dataName = ((XmlInputStreamData)this.data).outputRowMeta.indexOfValue(((XmlInputStreamMeta)this.meta).getXmlDataNameField());
            ((XmlInputStreamData)this.data).pos_xml_dataValue = ((XmlInputStreamData)this.data).outputRowMeta.indexOfValue(((XmlInputStreamMeta)this.meta).getXmlDataValueField());
            return true;
        }
        return false;
    }

    public void dispose() {
        this.closeFile();
        ((XmlInputStreamData)this.data).staxInstance = null;
        super.dispose();
    }
}

