/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.systemdata;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.systemdata.Management;
import org.apache.hop.pipeline.transforms.systemdata.SystemDataData;
import org.apache.hop.pipeline.transforms.systemdata.SystemDataMeta;

public class SystemData
extends BaseTransform<SystemDataMeta, SystemDataData> {
    public SystemData(TransformMeta transformMeta, SystemDataMeta meta, SystemDataData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private Object[] getSystemData(IRowMeta inputRowMeta, Object[] inputRowData) throws HopException {
        int i;
        Object[] row = new Object[((SystemDataData)this.data).outputRowMeta.size()];
        for (i = 0; i < inputRowMeta.size(); ++i) {
            row[i] = inputRowData[i];
        }
        i = 0;
        int index = inputRowMeta.size();
        while (i < ((SystemDataMeta)this.meta).getFieldName().length) {
            boolean argnr = false;
            switch (((SystemDataMeta)this.meta).getFieldType()[i]) {
                case TYPE_SYSTEM_INFO_SYSTEM_START: {
                    row[index] = this.getPipeline().getExecutionStartDate();
                    break;
                }
                case TYPE_SYSTEM_INFO_SYSTEM_DATE: {
                    row[index] = new Date();
                    break;
                }
                case TYPE_SYSTEM_INFO_PIPELINE_DATE_FROM: {
                    row[index] = this.getPipeline().getEngineMetrics().getStartDate();
                    break;
                }
                case TYPE_SYSTEM_INFO_PIPELINE_DATE_TO: {
                    row[index] = this.getPipeline().getEngineMetrics().getEndDate();
                    break;
                }
                case TYPE_SYSTEM_INFO_JOB_DATE_FROM: {
                    row[index] = this.getPipeline().getParentWorkflow().getExecutionStartDate();
                    break;
                }
                case TYPE_SYSTEM_INFO_JOB_DATE_TO: {
                    row[index] = this.getPipeline().getParentWorkflow().getExecutionEndDate();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_DAY_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, -1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_DAY_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, -1);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_DAY_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_DAY_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_DAY_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_DAY_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, 1);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_MONTH_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, -1);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_MONTH_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, -1);
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_MONTH_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_MONTH_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_MONTH_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 1);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_MONTH_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 1);
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_COPYNR: {
                    row[index] = (long)this.getCopy();
                    break;
                }
                case TYPE_SYSTEM_INFO_PIPELINE_NAME: {
                    row[index] = this.getPipelineMeta().getName();
                    break;
                }
                case TYPE_SYSTEM_INFO_MODIFIED_USER: {
                    row[index] = this.getPipelineMeta().getModifiedUser();
                    break;
                }
                case TYPE_SYSTEM_INFO_MODIFIED_DATE: {
                    row[index] = this.getPipelineMeta().getModifiedDate();
                    break;
                }
                case TYPE_SYSTEM_INFO_HOSTNAME_REAL: {
                    row[index] = Const.getHostnameReal();
                    break;
                }
                case TYPE_SYSTEM_INFO_HOSTNAME: {
                    row[index] = Const.getHostname();
                    break;
                }
                case TYPE_SYSTEM_INFO_IP_ADDRESS: {
                    try {
                        row[index] = Const.getIPAddress();
                        break;
                    }
                    catch (Exception e) {
                        throw new HopException((Throwable)e);
                    }
                }
                case TYPE_SYSTEM_INFO_FILENAME: {
                    row[index] = this.getPipelineMeta().getFilename();
                    break;
                }
                case TYPE_SYSTEM_INFO_CURRENT_PID: {
                    row[index] = Management.getPID();
                    break;
                }
                case TYPE_SYSTEM_INFO_JVM_TOTAL_MEMORY: {
                    row[index] = Runtime.getRuntime().totalMemory();
                    break;
                }
                case TYPE_SYSTEM_INFO_JVM_FREE_MEMORY: {
                    row[index] = Runtime.getRuntime().freeMemory();
                    break;
                }
                case TYPE_SYSTEM_INFO_JVM_MAX_MEMORY: {
                    row[index] = Runtime.getRuntime().maxMemory();
                    break;
                }
                case TYPE_SYSTEM_INFO_JVM_AVAILABLE_MEMORY: {
                    Runtime rt = Runtime.getRuntime();
                    row[index] = rt.freeMemory() + (rt.maxMemory() - rt.totalMemory());
                    break;
                }
                case TYPE_SYSTEM_INFO_AVAILABLE_PROCESSORS: {
                    row[index] = (long)Runtime.getRuntime().availableProcessors();
                    break;
                }
                case TYPE_SYSTEM_INFO_JVM_CPU_TIME: {
                    row[index] = Management.getJVMCpuTime() / 1000000L;
                    break;
                }
                case TYPE_SYSTEM_INFO_TOTAL_PHYSICAL_MEMORY_SIZE: {
                    row[index] = Management.getTotalPhysicalMemorySize();
                    break;
                }
                case TYPE_SYSTEM_INFO_TOTAL_SWAP_SPACE_SIZE: {
                    row[index] = Management.getTotalSwapSpaceSize();
                    break;
                }
                case TYPE_SYSTEM_INFO_COMMITTED_VIRTUAL_MEMORY_SIZE: {
                    row[index] = Management.getCommittedVirtualMemorySize();
                    break;
                }
                case TYPE_SYSTEM_INFO_FREE_PHYSICAL_MEMORY_SIZE: {
                    row[index] = Management.getFreePhysicalMemorySize();
                    break;
                }
                case TYPE_SYSTEM_INFO_FREE_SWAP_SPACE_SIZE: {
                    row[index] = Management.getFreeSwapSpaceSize();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_WEEK_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(3, -1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_WEEK_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_WEEK_OPEN_END: {
                    Calendar cal = Calendar.getInstance(Locale.ROOT);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    cal.add(7, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_WEEK_START_US: {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.add(3, -1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_WEEK_END_US: {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_WEEK_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_WEEK_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(3, 1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_WEEK_OPEN_END: {
                    Calendar cal = Calendar.getInstance(Locale.ROOT);
                    cal.add(3, 1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    cal.add(7, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_WEEK_START_US: {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_WEEK_END_US: {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.add(3, 1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_WEEK_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(3, 1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_WEEK_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(3, 2);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_WEEK_OPEN_END: {
                    Calendar cal = Calendar.getInstance(Locale.ROOT);
                    cal.add(3, 2);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    cal.add(7, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_WEEK_START_US: {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.add(3, 1);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_WEEK_END_US: {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.add(3, 2);
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, -1);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_QUARTER_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, -3 - cal.get(2) % 3);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_QUARTER_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, -1 - cal.get(2) % 3);
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_QUARTER_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 0 - cal.get(2) % 3);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_QUARTER_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 2 - cal.get(2) % 3);
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_QUARTER_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 3 - cal.get(2) % 3);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_QUARTER_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 5 - cal.get(2) % 3);
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_YEAR_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(1, -1);
                    cal.set(6, cal.getActualMinimum(5));
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREV_YEAR_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(6, cal.getActualMinimum(5));
                    cal.add(6, -1);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_YEAR_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(6, cal.getActualMinimum(5));
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_THIS_YEAR_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(1, 1);
                    cal.set(6, cal.getActualMinimum(5));
                    cal.add(6, -1);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_YEAR_START: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(1, 1);
                    cal.set(6, cal.getActualMinimum(5));
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_NEXT_YEAR_END: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(1, 2);
                    cal.set(6, cal.getActualMinimum(5));
                    cal.add(6, -1);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_RESULT: {
                    Result previousResult = this.getPipeline().getPreviousResult();
                    boolean result = false;
                    if (previousResult != null) {
                        result = previousResult.getResult();
                    }
                    row[index] = result;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_EXIT_STATUS: {
                    Result previousResult = this.getPipeline().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getExitStatus();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_ENTRY_NR: {
                    Result previousResult = this.getPipeline().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getEntryNr();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_FILES: {
                    Result previousResult = this.getPipeline().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getResultFiles().size();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_FILES_RETRIEVED: {
                    Result previousResult = this.getPipeline().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrFilesRetrieved();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_DELETED: {
                    Result previousResult = this.getPipeline().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesDeleted();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_INPUT: {
                    Result previousResult = this.getPipeline().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesInput();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_OUTPUT: {
                    Result previousResult = this.getPipeline().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesOutput();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_READ: {
                    Result previousResult = this.getPipeline().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesRead();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_REJECTED: {
                    Result previousResult = this.getPipeline().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesRejected();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_UPDATED: {
                    Result previousResult = this.getPipeline().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesUpdated();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_WRITTEN: {
                    Result previousResult = this.getPipeline().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrLinesWritten();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_ROWS: {
                    Result previousResult = this.getPipeline().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getRows().size();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_IS_STOPPED: {
                    Result previousResult = this.getPipeline().getPreviousResult();
                    boolean stop = false;
                    if (previousResult != null) {
                        stop = previousResult.isStopped();
                    }
                    row[index] = stop;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_ERRORS: {
                    Result previousResult = this.getPipeline().getPreviousResult();
                    long value = 0L;
                    if (previousResult != null) {
                        value = previousResult.getNrErrors();
                    }
                    row[index] = value;
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_LOG_TEXT: {
                    Result previousResult = this.getPipeline().getPreviousResult();
                    String errorReason = null;
                    if (previousResult != null) {
                        errorReason = previousResult.getLogText();
                    }
                    row[index] = errorReason;
                    break;
                }
            }
            ++i;
            ++index;
        }
        return row;
    }

    public boolean processRow() throws HopException {
        IRowMeta imeta;
        Object[] row;
        if (((SystemDataData)this.data).readsRows) {
            row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((SystemDataData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((SystemDataMeta)this.meta).getFields(((SystemDataData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            }
        } else {
            row = new Object[]{};
            this.incrementLinesRead();
            if (this.first) {
                this.first = false;
                ((SystemDataData)this.data).outputRowMeta = new RowMeta();
                ((SystemDataMeta)this.meta).getFields(((SystemDataData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            }
        }
        if ((imeta = this.getInputRowMeta()) == null) {
            imeta = new RowMeta();
            this.setInputRowMeta(imeta);
        }
        row = this.getSystemData(imeta, row);
        if (this.log.isRowLevel()) {
            this.logRowlevel("System info returned: " + ((SystemDataData)this.data).outputRowMeta.getString(row));
        }
        this.putRow(((SystemDataData)this.data).outputRowMeta, row);
        if (!((SystemDataData)this.data).readsRows) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            List previous = this.getPipelineMeta().findPreviousTransforms(this.getTransformMeta());
            if (previous != null && previous.size() > 0) {
                ((SystemDataData)this.data).readsRows = true;
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        super.dispose();
    }
}

