/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.groupby;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.groupby.Aggregation;
import org.apache.hop.pipeline.transforms.groupby.GroupBy;
import org.apache.hop.pipeline.transforms.groupby.GroupByData;
import org.apache.hop.pipeline.transforms.groupby.GroupingField;
import org.w3c.dom.Node;

@Transform(id="GroupBy", image="groupby.svg", name="i18n::GroupBy.Name", description="i18n::GroupBy.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Statistics", documentationUrl="/pipeline/transforms/groupby.html", keywords={"i18n::GroupByMeta.keyword"})
public class GroupByMeta
extends BaseTransformMeta<GroupBy, GroupByData> {
    private static final Class<?> PKG = GroupByMeta.class;
    @HopMetadataProperty(key="all_rows", injectionKey="PASS_ALL_ROWS", injectionKeyDescription="GroupByMeta.Injection.PASS_ALL_ROWS")
    private boolean passAllRows;
    @HopMetadataProperty(injectionKey="TEMP_DIRECTORY", injectionKeyDescription="GroupByMeta.Injection.TEMP_DIRECTORY")
    private String directory;
    @HopMetadataProperty(injectionKey="TEMP_FILE_PREFIX", injectionKeyDescription="GroupByMeta.Injection.TEMP_FILE_PREFIX")
    private String prefix;
    @HopMetadataProperty(key="ignore_aggregate")
    private boolean aggregateIgnored;
    @HopMetadataProperty(key="field_ignore")
    private String aggregateIgnoredField;
    @HopMetadataProperty(groupKey="group", key="field", injectionGroupKey="GROUPS", injectionGroupDescription="GroupByMeta.Injection.GROUPS")
    private List<GroupingField> groupingFields = new ArrayList<GroupingField>();
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupKey="AGGREGATIONS", injectionGroupDescription="GroupByMeta.Injection.AGGREGATIONS")
    private List<Aggregation> aggregations = new ArrayList<Aggregation>();
    @HopMetadataProperty(key="add_linenr", injectionKey="ADD_GROUP_LINENR", injectionKeyDescription="GroupByMeta.Injection.ADD_GROUP_LINENR")
    private boolean addingLineNrInGroup;
    @HopMetadataProperty(key="linenr_fieldname", injectionKey="ADD_GROUP_LINENR_FIELD", injectionKeyDescription="GroupByMeta.Injection.ADD_GROUP_LINENR_FIELD")
    private String lineNrInGroupField;
    @HopMetadataProperty(key="give_back_row", injectionKey="ALWAYS_GIVE_ROW", injectionKeyDescription="GroupByMeta.Injection.ALWAYS_GIVE_ROW")
    private boolean alwaysGivingBackOneRow;

    public boolean isAggregateIgnored() {
        return this.aggregateIgnored;
    }

    public void setAggregateIgnored(boolean aggregateIgnored) {
        this.aggregateIgnored = aggregateIgnored;
    }

    public String getAggregateIgnoredField() {
        return this.aggregateIgnoredField;
    }

    public void setAggregateIgnoredField(String aggregateIgnoredField) {
        this.aggregateIgnoredField = aggregateIgnoredField;
    }

    public List<GroupingField> getGroupingFields() {
        return this.groupingFields;
    }

    public void setGroupingFields(List<GroupingField> groupingFields) {
        this.groupingFields = groupingFields;
    }

    public boolean isPassAllRows() {
        return this.passAllRows;
    }

    public void setPassAllRows(boolean passAllRows) {
        this.passAllRows = passAllRows;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        super.loadXml(transformNode, metadataProvider);
        boolean hasNumberOfValues = false;
        for (Aggregation item : this.aggregations) {
            int aggType = item.getType();
            if (aggType != 7 && aggType != 17 && aggType != 18) continue;
            hasNumberOfValues = true;
        }
        if (!this.alwaysGivingBackOneRow) {
            this.alwaysGivingBackOneRow = hasNumberOfValues;
        }
    }

    public Object clone() {
        GroupByMeta groupByMeta = (GroupByMeta)((Object)super.clone());
        ArrayList<GroupingField> groupingFieldsCopy = new ArrayList<GroupingField>();
        for (GroupingField item : this.groupingFields) {
            groupingFieldsCopy.add(item.clone());
        }
        groupByMeta.setGroupingFields(groupingFieldsCopy);
        ArrayList<Aggregation> aggsCopy = new ArrayList<Aggregation>();
        for (Aggregation aggregation : this.aggregations) {
            aggsCopy.add(aggregation.clone());
        }
        groupByMeta.setAggregations(aggsCopy);
        return groupByMeta;
    }

    public void setDefault() {
        this.directory = "${java.io.tmpdir}";
        this.prefix = "grp";
        this.passAllRows = false;
        this.aggregateIgnored = false;
        this.aggregateIgnoredField = null;
        boolean sizeGroup = false;
    }

    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        RowMeta fields = new RowMeta();
        if (!this.passAllRows) {
            for (int i = 0; i < this.groupingFields.size(); ++i) {
                IValueMeta valueMeta = rowMeta.searchValueMeta(this.groupingFields.get(i).getName());
                if (valueMeta == null) continue;
                fields.addValueMeta(valueMeta);
            }
        } else {
            fields.addRowMeta(rowMeta);
        }
        for (Aggregation aggregation : this.aggregations) {
            IValueMeta v;
            int aggregationType = aggregation.getType();
            IValueMeta subj = rowMeta.searchValueMeta(aggregation.getSubject());
            if (subj == null && aggregationType != 18) continue;
            String valueName = aggregation.getField();
            int valueType = 0;
            int length = -1;
            int precision = -1;
            switch (aggregationType) {
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    valueType = subj.getType();
                    break;
                }
                case 7: 
                case 17: 
                case 18: {
                    valueType = 5;
                    break;
                }
                case 8: {
                    valueType = 2;
                    break;
                }
                case 3: 
                case 4: 
                case 15: 
                case 19: 
                case 20: {
                    valueType = 1;
                    break;
                }
                case 16: 
                case 21: {
                    valueType = 2;
                    break;
                }
            }
            if (aggregationType == 14 && valueType == 5) {
                valueType = 1;
                precision = -1;
                length = -1;
            } else if (aggregationType == 7 || aggregationType == 17 || aggregationType == 18) {
                length = 10;
                precision = 0;
            } else if (aggregationType == 1 && valueType != 5 && valueType != 1 && valueType != 6) {
                valueType = 1;
                precision = -1;
                length = -1;
            }
            if (valueType == 0) continue;
            try {
                v = ValueMetaFactory.createValueMeta((String)valueName, (int)valueType);
            }
            catch (HopPluginException e) {
                v = new ValueMetaNone(valueName);
            }
            v.setOrigin(origin);
            v.setLength(length, precision);
            if (subj != null) {
                v.setConversionMask(subj.getConversionMask());
            }
            fields.addValueMeta(v);
        }
        if (this.passAllRows && this.addingLineNrInGroup && !Utils.isEmpty((CharSequence)this.lineNrInGroupField)) {
            ValueMetaInteger lineNr = new ValueMetaInteger(this.lineNrInGroupField);
            lineNr.setLength(10, 0);
            lineNr.setOrigin(origin);
            fields.addValueMeta((IValueMeta)lineNr);
        }
        rowMeta.clear();
        rowMeta.addRowMeta((IRowMeta)fields);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GroupByMeta.CheckResult.ReceivingInfoOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GroupByMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isAddingLineNrInGroup() {
        return this.addingLineNrInGroup;
    }

    public void setAddingLineNrInGroup(boolean addingLineNrInGroup) {
        this.addingLineNrInGroup = addingLineNrInGroup;
    }

    public String getLineNrInGroupField() {
        return this.lineNrInGroupField;
    }

    public void setLineNrInGroupField(String lineNrInGroupField) {
        this.lineNrInGroupField = lineNrInGroupField;
    }

    public boolean isAlwaysGivingBackOneRow() {
        return this.alwaysGivingBackOneRow;
    }

    public void setAlwaysGivingBackOneRow(boolean alwaysGivingBackOneRow) {
        this.alwaysGivingBackOneRow = alwaysGivingBackOneRow;
    }

    public PipelineMeta.PipelineType[] getSupportedPipelineTypes() {
        return new PipelineMeta.PipelineType[]{PipelineMeta.PipelineType.Normal};
    }

    public List<Aggregation> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(List<Aggregation> aggregations) {
        this.aggregations = aggregations;
    }
}

