/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.utils.ByteBufferUtil;

public class UnknownColumnException
extends IOException {
    public final ByteBuffer columnName;

    public UnknownColumnException(String ksName, String cfName, ByteBuffer columnName) {
        super(String.format("Unknown column %s in table %s.%s", UnknownColumnException.stringify(columnName), ksName, cfName));
        this.columnName = columnName;
    }

    public UnknownColumnException(CFMetaData metadata, ByteBuffer columnName) {
        this(metadata.ksName, metadata.cfName, columnName);
    }

    private static String stringify(ByteBuffer name) {
        try {
            return UTF8Type.instance.getString(name);
        }
        catch (Exception e) {
            return ByteBufferUtil.bytesToHex(name);
        }
    }
}

