/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class Resource
implements Comparable<Resource> {
    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static Resource newInstance(int memory, int vCores) {
        Resource resource = Records.newRecord(Resource.class);
        resource.setMemorySize(memory);
        resource.setVirtualCores(vCores);
        return resource;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static Resource newInstance(long memory, int vCores) {
        Resource resource = Records.newRecord(Resource.class);
        resource.setMemorySize(memory);
        resource.setVirtualCores(vCores);
        return resource;
    }

    @InterfaceAudience.Public
    @Deprecated
    public abstract int getMemory();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public long getMemorySize() {
        throw new NotImplementedException("This method is implemented by ResourcePBImpl");
    }

    @InterfaceAudience.Public
    @Deprecated
    public abstract void setMemory(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public void setMemorySize(long memory) {
        throw new NotImplementedException("This method is implemented by ResourcePBImpl");
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public abstract int getVirtualCores();

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public abstract void setVirtualCores(int var1);

    public int hashCode() {
        int prime = 263167;
        int result = (int)(939769357L + this.getMemorySize());
        result = 263167 * result + this.getVirtualCores();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return this.getMemorySize() == other.getMemorySize() && this.getVirtualCores() == other.getVirtualCores();
    }

    public String toString() {
        return "<memory:" + this.getMemorySize() + ", vCores:" + this.getVirtualCores() + ">";
    }
}

