/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.AsyncCallback;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.WatchedEvent;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.Watcher;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.ZooDefs;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.ACL;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.Id;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.Stat;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.PendingWatcher;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class ZooKeeperWatcher
implements Watcher,
Abortable,
Closeable {
    private static final Log LOG = LogFactory.getLog(ZooKeeperWatcher.class);
    public static final String META_ZNODE_PREFIX_CONF_KEY = "zookeeper.znode.metaserver";
    public static final String META_ZNODE_PREFIX = "meta-region-server";
    private String prefix;
    private String identifier;
    private String quorum;
    private final RecoverableZooKeeper recoverableZooKeeper;
    protected Abortable abortable;
    private boolean aborted = false;
    private final List<ZooKeeperListener> listeners = new CopyOnWriteArrayList<ZooKeeperListener>();
    private final ImmutableMap<Integer, String> metaReplicaZNodes;
    private final ExecutorService zkEventProcessor = Executors.newSingleThreadExecutor(Threads.getNamedThreadFactory("zk-event-processor"));
    public CountDownLatch saslLatch = new CountDownLatch(1);
    public String baseZNode;
    private Map<Integer, String> metaReplicaZnodes = new HashMap<Integer, String>();
    public String rsZNode;
    public String drainingZNode;
    private String masterAddressZNode;
    public String backupMasterAddressesZNode;
    public String clusterStateZNode;
    public String assignmentZNode;
    public String tableZNode;
    public String clusterIdZNode;
    public String splitLogZNode;
    public String balancerZNode;
    private String regionNormalizerZNode;
    private String switchZNode;
    public String tableLockZNode;
    String snapshotCleanupZNode;
    public String recoveringRegionsZNode;
    public static String namespaceZNode = "namespace";
    public static String masterMaintZNode = "masterMaintenance";
    private final String metaZNodePrefix;
    public static final ArrayList<ACL> CREATOR_ALL_AND_WORLD_READABLE = new ArrayList<ACL>(){
        {
            this.add(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE));
            this.add(new ACL(31, ZooDefs.Ids.AUTH_IDS));
        }
    };
    private static final String DEFAULT_SNAPSHOT_CLEANUP_ZNODE = "snapshot-cleanup";
    private final Configuration conf;
    private final long zkSyncTimeout;
    private static final Pattern NAME_PATTERN = Pattern.compile("([^/@]*)(/([^/@]*))?@([^/@]*)");

    public ZooKeeperWatcher(Configuration conf, String identifier, Abortable abortable) throws ZooKeeperConnectionException, IOException {
        this(conf, identifier, abortable, false);
    }

    public ZooKeeperWatcher(Configuration conf, String identifier, Abortable abortable, boolean canCreateBaseZNode) throws IOException, ZooKeeperConnectionException {
        this.conf = conf;
        this.quorum = ZKConfig.getZKQuorumServersString(conf);
        this.prefix = identifier;
        this.identifier = identifier + "0x0";
        this.abortable = abortable;
        this.setNodeNames(conf);
        PendingWatcher pendingWatcher = new PendingWatcher();
        this.recoverableZooKeeper = ZKUtil.connect(conf, this.quorum, pendingWatcher, identifier);
        pendingWatcher.prepare(this);
        ImmutableMap.Builder<Integer, String> builder = ImmutableMap.builder();
        this.metaZNodePrefix = conf.get(META_ZNODE_PREFIX_CONF_KEY, META_ZNODE_PREFIX);
        String defaultMetaReplicaZNode = ZKUtil.joinZNode(this.baseZNode, this.metaZNodePrefix);
        builder.put(0, defaultMetaReplicaZNode);
        int numMetaReplicas = conf.getInt("hbase.meta.replica.count", 1);
        for (int i = 1; i < numMetaReplicas; ++i) {
            builder.put(i, defaultMetaReplicaZNode + "-" + i);
        }
        this.metaReplicaZNodes = builder.build();
        if (canCreateBaseZNode) {
            try {
                this.createBaseZNodes();
            }
            catch (ZooKeeperConnectionException zce) {
                try {
                    this.recoverableZooKeeper.close();
                }
                catch (InterruptedException ie) {
                    LOG.debug((Object)("Encountered InterruptedException when closing " + this.recoverableZooKeeper));
                    Thread.currentThread().interrupt();
                }
                throw zce;
            }
        }
        this.zkSyncTimeout = conf.getLong("hbase.zookeeper.sync.timeout.millis", 30000L);
    }

    public boolean isAnyMetaReplicaZNode(String node) {
        return this.metaReplicaZNodes.containsValue(node);
    }

    private void createBaseZNodes() throws ZooKeeperConnectionException {
        try {
            ZKUtil.createWithParents(this, this.baseZNode);
            if (this.conf.getBoolean("hbase.assignment.usezk", true)) {
                ZKUtil.createAndFailSilent(this, this.assignmentZNode);
            }
            ZKUtil.createAndFailSilent(this, this.rsZNode);
            ZKUtil.createAndFailSilent(this, this.drainingZNode);
            ZKUtil.createAndFailSilent(this, this.tableZNode);
            ZKUtil.createAndFailSilent(this, this.splitLogZNode);
            ZKUtil.createAndFailSilent(this, this.backupMasterAddressesZNode);
            ZKUtil.createAndFailSilent(this, this.tableLockZNode);
            ZKUtil.createAndFailSilent(this, this.recoveringRegionsZNode);
            ZKUtil.createAndFailSilent(this, masterMaintZNode);
        }
        catch (KeeperException e) {
            throw new ZooKeeperConnectionException(this.prefix("Unexpected KeeperException creating base node"), e);
        }
    }

    public boolean isClientReadable(String node) {
        return node.equals(this.baseZNode) || this.isAnyMetaReplicaZnode(node) || node.equals(this.getMasterAddressZNode()) || node.equals(this.clusterIdZNode) || node.equals(this.rsZNode) || node.equals(this.tableZNode) || node.startsWith(this.tableZNode + "/");
    }

    public void checkAndSetZNodeAcls() {
        if (!ZKUtil.isSecureZooKeeper(this.getConfiguration())) {
            LOG.info((Object)"not a secure deployment, proceeding");
            return;
        }
        try {
            List<ACL> actualAcls = this.recoverableZooKeeper.getAcl(this.baseZNode, new Stat());
            if (!this.isBaseZnodeAclSetup(actualAcls)) {
                LOG.info((Object)"setting znode ACLs");
                this.setZnodeAclsRecursive(this.baseZNode);
            }
        }
        catch (KeeperException.NoNodeException nne) {
            return;
        }
        catch (InterruptedException ie) {
            this.interruptedExceptionNoThrow(ie, false);
        }
        catch (IOException | KeeperException e) {
            LOG.warn((Object)"Received exception while checking and setting zookeeper ACLs", (Throwable)e);
        }
    }

    private void setZnodeAclsRecursive(String znode) throws KeeperException, InterruptedException {
        List<String> children = this.recoverableZooKeeper.getChildren(znode, false);
        for (String child : children) {
            this.setZnodeAclsRecursive(ZKUtil.joinZNode(znode, child));
        }
        ArrayList<ACL> acls = ZKUtil.createACL(this, znode, true);
        LOG.info((Object)("Setting ACLs for znode:" + znode + " , acl:" + acls));
        this.recoverableZooKeeper.setAcl(znode, acls, -1);
    }

    private boolean isBaseZnodeAclSetup(List<ACL> acls) throws IOException {
        String[] superUsers;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Checking znode ACLs");
        }
        if ((superUsers = this.conf.getStrings("hbase.superuser")) != null && !this.checkACLForSuperUsers(superUsers, acls)) {
            return false;
        }
        String hbaseUser = UserGroupInformation.getCurrentUser().getShortUserName();
        if (acls.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"ACL is empty");
            }
            return false;
        }
        for (ACL acl : acls) {
            int perms = acl.getPerms();
            Id id = acl.getId();
            if (ZooDefs.Ids.ANYONE_ID_UNSAFE.equals(id)) {
                if (perms == 1) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("permissions for '%s' are not correct: have 0x%x, want 0x%x", id, perms, 1));
                }
                return false;
            }
            if (superUsers != null && ZooKeeperWatcher.isSuperUserId(superUsers, id)) {
                if (perms == 31) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("permissions for '%s' are not correct: have 0x%x, want 0x%x", id, perms, 31));
                }
                return false;
            }
            if ("sasl".equals(id.getScheme())) {
                String name = id.getId();
                Matcher match = NAME_PATTERN.matcher(name);
                if (match.matches()) {
                    name = match.group(1);
                }
                if (name.equals(hbaseUser)) {
                    if (perms == 31) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("permissions for '%s' are not correct: have 0x%x, want 0x%x", id, perms, 31));
                    }
                    return false;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Unexpected shortname in SASL ACL: " + id));
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("unexpected ACL id '" + id + "'"));
            }
            return false;
        }
        return true;
    }

    private boolean checkACLForSuperUsers(String[] superUsers, List<ACL> acls) {
        for (String user : superUsers) {
            boolean hasAccess = false;
            if (AuthUtil.isGroupPrincipal(user)) continue;
            for (ACL acl : acls) {
                if (!user.equals(acl.getId().getId())) continue;
                if (acl.getPerms() == 31) {
                    hasAccess = true;
                    break;
                }
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)String.format("superuser '%s' does not have correct permissions: have 0x%x, want 0x%x", acl.getId().getId(), acl.getPerms(), 31));
                break;
            }
            if (hasAccess) continue;
            return false;
        }
        return true;
    }

    public static boolean isSuperUserId(String[] superUsers, Id id) {
        for (String user : superUsers) {
            if (AuthUtil.isGroupPrincipal(user) || !new Id("sasl", user).equals(id)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.identifier + ", quorum=" + this.quorum + ", baseZNode=" + this.baseZNode;
    }

    public String prefix(String str) {
        return this.toString() + " " + str;
    }

    private void setNodeNames(Configuration conf) {
        this.baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        this.metaReplicaZnodes.put(0, ZKUtil.joinZNode(this.baseZNode, conf.get(META_ZNODE_PREFIX_CONF_KEY, META_ZNODE_PREFIX)));
        int numMetaReplicas = conf.getInt("hbase.meta.replica.count", 1);
        for (int i = 1; i < numMetaReplicas; ++i) {
            String str = ZKUtil.joinZNode(this.baseZNode, conf.get(META_ZNODE_PREFIX_CONF_KEY, META_ZNODE_PREFIX) + "-" + i);
            this.metaReplicaZnodes.put(i, str);
        }
        this.rsZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.rs", "rs"));
        this.drainingZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.draining.rs", "draining"));
        this.masterAddressZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.master", "master"));
        this.backupMasterAddressesZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.backup.masters", "backup-masters"));
        this.clusterStateZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.state", "running"));
        this.assignmentZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.unassigned", "region-in-transition"));
        this.tableZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.tableEnableDisable", "table"));
        this.clusterIdZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.clusterId", "hbaseid"));
        this.splitLogZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.splitlog", "splitWAL"));
        this.balancerZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.balancer", "balancer"));
        this.regionNormalizerZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.regionNormalizer", "normalizer"));
        this.switchZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.switch", "switch"));
        this.tableLockZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.tableLock", "table-lock"));
        this.snapshotCleanupZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.snapshot.cleanup", DEFAULT_SNAPSHOT_CLEANUP_ZNODE));
        this.recoveringRegionsZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.recovering.regions", "recovering-regions"));
        namespaceZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.namespace", "namespace"));
        masterMaintZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.masterMaintenance", "master-maintenance"));
    }

    public boolean isAnyMetaReplicaZnode(String node) {
        return this.metaReplicaZnodes.values().contains(node);
    }

    public boolean isDefaultMetaReplicaZnode(String node) {
        return this.getZNodeForReplica(0).equals(node);
    }

    public List<String> getMetaReplicaNodes() throws KeeperException {
        List<String> childrenOfBaseNode = ZKUtil.listChildrenNoWatch(this, this.baseZNode);
        ArrayList<String> metaReplicaNodes = new ArrayList<String>(2);
        if (childrenOfBaseNode != null) {
            String pattern = this.conf.get(META_ZNODE_PREFIX_CONF_KEY, META_ZNODE_PREFIX);
            for (String child : childrenOfBaseNode) {
                if (!child.startsWith(pattern)) continue;
                metaReplicaNodes.add(child);
            }
        }
        return metaReplicaNodes;
    }

    public String getZNodeForReplica(int replicaId) {
        String str = this.metaReplicaZnodes.get(replicaId);
        if (str == null) {
            str = ZKUtil.joinZNode(this.baseZNode, this.conf.get(META_ZNODE_PREFIX_CONF_KEY, META_ZNODE_PREFIX) + "-" + replicaId);
        }
        return str;
    }

    public int getMetaReplicaIdFromZnode(String znode) {
        String pattern = this.conf.get(META_ZNODE_PREFIX_CONF_KEY, META_ZNODE_PREFIX);
        if (znode.equals(pattern)) {
            return 0;
        }
        String nonDefaultPattern = pattern + "-";
        return Integer.parseInt(znode.substring(nonDefaultPattern.length()));
    }

    public void registerListener(ZooKeeperListener listener) {
        this.listeners.add(listener);
    }

    public void registerListenerFirst(ZooKeeperListener listener) {
        this.listeners.add(0, listener);
    }

    public void unregisterListener(ZooKeeperListener listener) {
        this.listeners.remove(listener);
    }

    public void unregisterAllListeners() {
        this.listeners.clear();
    }

    public List<ZooKeeperListener> getListeners() {
        return new ArrayList<ZooKeeperListener>(this.listeners);
    }

    public int getNumberOfListeners() {
        return this.listeners.size();
    }

    public RecoverableZooKeeper getRecoverableZooKeeper() {
        return this.recoverableZooKeeper;
    }

    public void reconnectAfterExpiration() throws IOException, KeeperException, InterruptedException {
        this.recoverableZooKeeper.reconnectAfterExpiration();
    }

    public String getQuorum() {
        return this.quorum;
    }

    public String getBaseZNode() {
        return this.baseZNode;
    }

    private void processEvent(WatchedEvent event) {
        switch (event.getType()) {
            case None: {
                this.connectionEvent(event);
                break;
            }
            case NodeCreated: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeCreated(event.getPath());
                }
                break;
            }
            case NodeDeleted: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeDeleted(event.getPath());
                }
                break;
            }
            case NodeDataChanged: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeDataChanged(event.getPath());
                }
                break;
            }
            case NodeChildrenChanged: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeChildrenChanged(event.getPath());
                }
                break;
            }
            default: {
                LOG.error((Object)String.format("Invalid event of type %s received for path %s. Ignoring", new Object[]{event.getType(), event.getPath()}));
            }
        }
    }

    @Override
    public void process(final WatchedEvent event) {
        LOG.debug((Object)this.prefix("Received ZooKeeper Event, type=" + (Object)((Object)event.getType()) + ", " + "state=" + (Object)((Object)event.getState()) + ", " + "path=" + event.getPath()));
        this.zkEventProcessor.submit(new Runnable(){

            @Override
            public void run() {
                ZooKeeperWatcher.this.processEvent(event);
            }
        });
    }

    private void connectionEvent(WatchedEvent event) {
        switch (event.getState()) {
            case SyncConnected: {
                this.identifier = this.prefix + "-0x" + Long.toHexString(this.recoverableZooKeeper.getSessionId());
                LOG.debug((Object)(this.identifier + " connected"));
                break;
            }
            case Disconnected: {
                LOG.debug((Object)this.prefix("Received Disconnected from ZooKeeper, ignoring"));
                break;
            }
            case Expired: {
                String msg = this.prefix(this.identifier + " received expired from " + "ZooKeeper, aborting");
                if (this.abortable == null) break;
                this.abortable.abort(msg, new KeeperException.SessionExpiredException());
                break;
            }
            case ConnectedReadOnly: 
            case SaslAuthenticated: 
            case AuthFailed: {
                break;
            }
            default: {
                throw new IllegalStateException("Received event is not valid: " + (Object)((Object)event.getState()));
            }
        }
    }

    public void syncOrTimeout(String path) throws KeeperException {
        final CountDownLatch latch = new CountDownLatch(1);
        long startTime = EnvironmentEdgeManager.currentTime();
        this.recoverableZooKeeper.sync(path, new AsyncCallback.VoidCallback(){

            @Override
            public void processResult(int i, String s, Object o) {
                latch.countDown();
            }
        }, null);
        try {
            if (!latch.await(this.zkSyncTimeout, TimeUnit.MILLISECONDS)) {
                LOG.warn((Object)String.format("sync() operation to ZK timed out. Configured timeout: %s ms. This usually points to a ZK side issue. Check ZK server logs and metrics.", this.zkSyncTimeout));
                throw new KeeperException.OperationTimeoutException();
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Interrupted waiting for ZK sync() to finish.", (Throwable)e);
            Thread.currentThread().interrupt();
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("ZK sync() operation took %d ms", EnvironmentEdgeManager.currentTime() - startTime));
        }
    }

    public void keeperException(KeeperException ke) throws KeeperException {
        LOG.error((Object)this.prefix("Received unexpected KeeperException, re-throwing exception"), (Throwable)ke);
        throw ke;
    }

    public void interruptedException(InterruptedException ie) throws KeeperException {
        this.interruptedExceptionNoThrow(ie, true);
        throw new KeeperException.SystemErrorException();
    }

    public void interruptedExceptionNoThrow(InterruptedException ie, boolean throwLater) {
        LOG.debug((Object)this.prefix("Received InterruptedException, will interrupt current thread" + (throwLater ? " and rethrow a SystemErrorException" : "")), (Throwable)ie);
        Thread.currentThread().interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.recoverableZooKeeper.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.zkEventProcessor.shutdownNow();
        }
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void abort(String why, Throwable e) {
        if (this.abortable != null) {
            this.abortable.abort(why, e);
        } else {
            this.aborted = true;
        }
    }

    @Override
    public boolean isAborted() {
        return this.abortable == null ? this.aborted : this.abortable.isAborted();
    }

    public String getMasterAddressZNode() {
        return this.masterAddressZNode;
    }

    public String getRegionNormalizerZNode() {
        return this.regionNormalizerZNode;
    }

    public String getSwitchZNode() {
        return this.switchZNode;
    }

    public int getMetaReplicaIdFromPath(String path) {
        int prefixLen = this.baseZNode.length() + 1;
        return this.getMetaReplicaIdFromZnode(path.substring(prefixLen));
    }

    public List<String> getMetaReplicaNodesAndWatchChildren() throws KeeperException {
        List<String> childrenOfBaseNode = ZKUtil.listChildrenAndWatchForNewChildren(this, this.baseZNode);
        return this.filterMetaReplicaNodes(childrenOfBaseNode);
    }

    private List<String> filterMetaReplicaNodes(List<String> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> metaReplicaNodes = new ArrayList<String>(2);
        String pattern = this.conf.get(META_ZNODE_PREFIX_CONF_KEY, META_ZNODE_PREFIX);
        for (String child : nodes) {
            if (!child.startsWith(pattern)) continue;
            metaReplicaNodes.add(child);
        }
        return metaReplicaNodes;
    }
}

