/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.jcodings.unicode;

import org.apache.hadoop.hbase.shaded.org.jcodings.ApplyAllCaseFoldFunction;
import org.apache.hadoop.hbase.shaded.org.jcodings.CaseFoldCodeItem;
import org.apache.hadoop.hbase.shaded.org.jcodings.CodeRange;
import org.apache.hadoop.hbase.shaded.org.jcodings.IntHolder;
import org.apache.hadoop.hbase.shaded.org.jcodings.MultiByteEncoding;
import org.apache.hadoop.hbase.shaded.org.jcodings.exception.CharacterPropertyException;
import org.apache.hadoop.hbase.shaded.org.jcodings.unicode.UnicodeProperties;
import org.apache.hadoop.hbase.shaded.org.jcodings.util.ArrayReader;
import org.apache.hadoop.hbase.shaded.org.jcodings.util.CaseInsensitiveBytesHash;
import org.apache.hadoop.hbase.shaded.org.jcodings.util.IntArrayHash;
import org.apache.hadoop.hbase.shaded.org.jcodings.util.IntHash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnicodeEncoding
extends MultiByteEncoding {
    private static final int PROPERTY_NAME_MAX_SIZE = 20;
    static final short[] UNICODE_ISO_8859_1_CTypeTable = new short[]{16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 17036, 17033, 17032, 17032, 17032, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 17028, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 30896, 30896, 30896, 30896, 30896, 30896, 30896, 30896, 30896, 30896, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 31906, 31906, 31906, 31906, 31906, 31906, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 16800, 16800, 16800, 16800, 20896, 16800, 30946, 30946, 30946, 30946, 30946, 30946, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 16800, 16800, 16800, 16800, 16392, 8, 8, 8, 8, 8, 648, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 644, 416, 160, 160, 160, 160, 160, 160, 160, 160, 12514, 416, 160, 168, 160, 160, 160, 160, 4256, 4256, 160, 12514, 160, 416, 160, 4256, 12514, 416, 4256, 4256, 4256, 416, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 160, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 160, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514};
    static final CaseInsensitiveBytesHash<Integer> CTypeNameHash = UnicodeEncoding.initializeCTypeNameTable();
    static final int[] CaseFold_From = ArrayReader.readIntArray("CaseFold_From");
    static final int[][] CaseFold_To = ArrayReader.readNestedIntArray("CaseFold_To");
    static final int[] CaseFold_Locale_From = ArrayReader.readIntArray("CaseFold_Locale_From");
    static final int[][] CaseFold_Locale_To = ArrayReader.readNestedIntArray("CaseFold_Locale_To");
    static final int[] CaseUnfold_11_From = ArrayReader.readIntArray("CaseUnfold_11_From");
    static final int[][] CaseUnfold_11_To = ArrayReader.readNestedIntArray("CaseUnfold_11_To");
    static final int[] CaseUnfold_11_Locale_From = ArrayReader.readIntArray("CaseUnfold_11_Locale_From");
    static final int[][] CaseUnfold_11_Locale_To = ArrayReader.readNestedIntArray("CaseUnfold_11_Locale_To");
    static final int[][] CaseUnfold_12 = ArrayReader.readNestedIntArray("CaseUnfold_12");
    static final int[][] CaseUnfold_12_Locale = ArrayReader.readNestedIntArray("CaseUnfold_12_Locale");
    static final int[][] CaseUnfold_13 = ArrayReader.readNestedIntArray("CaseUnfold_13");
    static final IntHash<int[]> FoldHash = UnicodeEncoding.initializeFoldHash();
    static final IntHash<int[]> Unfold1Hash = UnicodeEncoding.initializeUnfold1Hash();
    static final IntArrayHash<int[]> Unfold2Hash = UnicodeEncoding.initializeUnfold2Hash();
    static final IntArrayHash<int[]> Unfold3Hash = UnicodeEncoding.initializeUnfold3Hash();

    protected UnicodeEncoding(String name, int minLength, int maxLength, int[] EncLen) {
        super(name, minLength, maxLength, EncLen, null, UNICODE_ISO_8859_1_CTypeTable);
    }

    protected UnicodeEncoding(String name, int minLength, int maxLength, int[] EncLen, int[][] Trans) {
        super(name, minLength, maxLength, EncLen, Trans, UNICODE_ISO_8859_1_CTypeTable);
    }

    @Override
    public String getCharsetName() {
        return new String(this.getName());
    }

    @Override
    public boolean isCodeCType(int code, int ctype) {
        if (ctype <= 14 && code < 256) {
            return this.isCodeCTypeInternal(code, ctype);
        }
        if (ctype > UnicodeProperties.CodeRangeTable.length) {
            throw new InternalError("undefined type (bug)");
        }
        return CodeRange.isInCodeRange(UnicodeProperties.CodeRangeTable[ctype].getRange(), code);
    }

    protected final int[] ctypeCodeRange(int ctype) {
        if (ctype >= UnicodeProperties.CodeRangeTable.length) {
            throw new InternalError("undefined type (bug)");
        }
        return UnicodeProperties.CodeRangeTable[ctype].getRange();
    }

    @Override
    public int propertyNameToCType(byte[] name, int p, int end) {
        byte[] buf = new byte[20];
        int len = 0;
        for (int p_ = p; p_ < end; p_ += this.length(name, p_, end)) {
            int code = this.mbcToCode(name, p_, end);
            if (code >= 128) {
                throw new CharacterPropertyException("invalid character property name <%n>");
            }
            buf[len++] = (byte)code;
            if (len < 20) continue;
            throw new CharacterPropertyException("invalid character property name <%n>", name, p, end);
        }
        Integer ctype = CTypeNameHash.get(buf, 0, len);
        if (ctype == null) {
            throw new CharacterPropertyException("invalid character property name <%n>", name, p, end);
        }
        return ctype;
    }

    @Override
    public int mbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end, byte[] fold) {
        int p = pp.value;
        int foldP = 0;
        int code = this.mbcToCode(bytes, p, end);
        int len = this.length(bytes, p, end);
        pp.value += len;
        int[] to = FoldHash.get(code);
        if (to != null) {
            if (to.length == 1) {
                return this.codeToMbc(to[0], fold, foldP);
            }
            int rlen = 0;
            for (int i = 0; i < to.length; ++i) {
                len = this.codeToMbc(to[i], fold, foldP);
                foldP += len;
                rlen += len;
            }
            return rlen;
        }
        for (int i = 0; i < len; ++i) {
            fold[foldP++] = bytes[p++];
        }
        return len;
    }

    @Override
    public void applyAllCaseFold(int flag, ApplyAllCaseFoldFunction fun, Object arg) {
        int k;
        int j;
        int[] to;
        int from;
        int i;
        int[] code = new int[]{0};
        for (i = 0; i < CaseUnfold_11_From.length; ++i) {
            from = CaseUnfold_11_From[i];
            to = CaseUnfold_11_To[i];
            for (j = 0; j < to.length; ++j) {
                code[0] = from;
                fun.apply(to[j], code, 1, arg);
                code[0] = to[j];
                fun.apply(from, code, 1, arg);
                for (k = 0; k < j; ++k) {
                    code[0] = to[k];
                    fun.apply(to[j], code, 1, arg);
                    code[0] = to[j];
                    fun.apply(to[k], code, 1, arg);
                }
            }
        }
        for (i = 0; i < CaseUnfold_11_Locale_From.length; ++i) {
            from = CaseUnfold_11_Locale_From[i];
            to = CaseUnfold_11_Locale_To[i];
            for (j = 0; j < to.length; ++j) {
                code[0] = from;
                fun.apply(to[j], code, 1, arg);
                code[0] = to[j];
                fun.apply(from, code, 1, arg);
                for (k = 0; k < j; ++k) {
                    code[0] = to[k];
                    fun.apply(to[j], code, 1, arg);
                    code[0] = to[j];
                    fun.apply(to[k], code, 1, arg);
                }
            }
        }
        if ((flag & 0x40000000) != 0) {
            for (i = 0; i < CaseUnfold_12.length; i += 2) {
                int[] from2 = CaseUnfold_12[i];
                to = CaseUnfold_12[i + 1];
                for (j = 0; j < to.length; ++j) {
                    fun.apply(to[j], from2, 2, arg);
                    for (k = 0; k < to.length; ++k) {
                        if (k == j) continue;
                        code[0] = to[k];
                        fun.apply(to[j], code, 1, arg);
                    }
                }
            }
            for (i = 0; i < CaseUnfold_12_Locale.length; i += 2) {
                int[] from3 = CaseUnfold_12_Locale[i];
                to = CaseUnfold_12_Locale[i + 1];
                for (j = 0; j < to.length; ++j) {
                    fun.apply(to[j], from3, 2, arg);
                    for (k = 0; k < to.length; ++k) {
                        if (k == j) continue;
                        code[0] = to[k];
                        fun.apply(to[j], code, 1, arg);
                    }
                }
            }
            for (i = 0; i < CaseUnfold_13.length; i += 2) {
                int[] from4 = CaseUnfold_13[i];
                to = CaseUnfold_13[i + 1];
                for (j = 0; j < to.length; ++j) {
                    fun.apply(to[j], from4, 3, arg);
                    for (k = 0; k < to.length; ++k) {
                        if (k == j) continue;
                        code[0] = to[k];
                        fun.apply(to[j], code, 1, arg);
                    }
                }
            }
        }
    }

    @Override
    public CaseFoldCodeItem[] caseFoldCodesByString(int flag, byte[] bytes, int p, int end) {
        int code = this.mbcToCode(bytes, p, end);
        int len = this.length(bytes, p, end);
        int n = 0;
        int fn = 0;
        int[] to = FoldHash.get(code);
        CaseFoldCodeItem[] items = null;
        if (to != null) {
            items = new CaseFoldCodeItem[13];
            if (to.length == 1) {
                int origCode = code;
                items[0] = new CaseFoldCodeItem(len, 1, new int[]{to[0]});
                ++n;
                code = to[0];
                if ((to = Unfold1Hash.get(code)) != null) {
                    for (int i = 0; i < to.length; ++i) {
                        if (to[i] == origCode) continue;
                        items[n] = new CaseFoldCodeItem(len, 1, new int[]{to[i]});
                        ++n;
                    }
                }
            } else if ((flag & 0x40000000) != 0) {
                int[] z2;
                int j;
                int i;
                int[][] cs = new int[3][4];
                int[] ncs = new int[3];
                for (fn = 0; fn < to.length; ++fn) {
                    cs[fn][0] = to[fn];
                    int[] z3 = Unfold1Hash.get(cs[fn][0]);
                    if (z3 != null) {
                        for (i = 0; i < z3.length; ++i) {
                            cs[fn][i + 1] = z3[i];
                        }
                        ncs[fn] = z3.length + 1;
                        continue;
                    }
                    ncs[fn] = 1;
                }
                if (fn == 2) {
                    for (int i2 = 0; i2 < ncs[0]; ++i2) {
                        for (j = 0; j < ncs[1]; ++j) {
                            items[n] = new CaseFoldCodeItem(len, 2, new int[]{cs[0][i2], cs[1][j]});
                            ++n;
                        }
                    }
                    z2 = Unfold2Hash.get(to);
                    if (z2 != null) {
                        for (i = 0; i < z2.length; ++i) {
                            if (z2[i] == code) continue;
                            items[n] = new CaseFoldCodeItem(len, 1, new int[]{z2[i]});
                            ++n;
                        }
                    }
                } else {
                    for (int i3 = 0; i3 < ncs[0]; ++i3) {
                        for (j = 0; j < ncs[1]; ++j) {
                            for (int k = 0; k < ncs[2]; ++k) {
                                items[n] = new CaseFoldCodeItem(len, 3, new int[]{cs[0][i3], cs[1][j], cs[2][k]});
                                ++n;
                            }
                        }
                    }
                    z2 = Unfold3Hash.get(to);
                    if (z2 != null) {
                        for (i = 0; i < z2.length; ++i) {
                            if (z2[i] == code) continue;
                            items[n] = new CaseFoldCodeItem(len, 1, new int[]{z2[i]});
                            ++n;
                        }
                    }
                }
                flag = 0;
            }
        } else {
            to = Unfold1Hash.get(code);
            if (to != null) {
                items = new CaseFoldCodeItem[13];
                for (int i = 0; i < to.length; ++i) {
                    items[n] = new CaseFoldCodeItem(len, 1, new int[]{to[i]});
                    ++n;
                }
            }
        }
        if ((flag & 0x40000000) != 0) {
            if (items == null) {
                items = new CaseFoldCodeItem[13];
            }
            if ((p += len) < end) {
                int codes0 = code;
                code = this.mbcToCode(bytes, p, end);
                to = FoldHash.get(code);
                int codes1 = to != null && to.length == 1 ? to[0] : code;
                int clen = this.length(bytes, p, end);
                len += clen;
                int[] z2 = Unfold2Hash.get(codes0, codes1);
                if (z2 != null) {
                    for (int i = 0; i < z2.length; ++i) {
                        items[n] = new CaseFoldCodeItem(len, 1, new int[]{z2[i]});
                        ++n;
                    }
                }
                if ((p += clen) < end) {
                    code = this.mbcToCode(bytes, p, end);
                    to = FoldHash.get(code);
                    int codes2 = to != null && to.length == 1 ? to[0] : code;
                    clen = this.length(bytes, p, end);
                    len += clen;
                    z2 = Unfold3Hash.get(codes0, codes1, codes2);
                    if (z2 != null) {
                        for (int i = 0; i < z2.length; ++i) {
                            items[n] = new CaseFoldCodeItem(len, 1, new int[]{z2[i]});
                            ++n;
                        }
                    }
                }
            }
        }
        if (items == null || n == 0) {
            return EMPTY_FOLD_CODES;
        }
        if (n < items.length) {
            CaseFoldCodeItem[] tmp = new CaseFoldCodeItem[n];
            System.arraycopy(items, 0, tmp, 0, n);
            return tmp;
        }
        return items;
    }

    private static CaseInsensitiveBytesHash<Integer> initializeCTypeNameTable() {
        CaseInsensitiveBytesHash<Integer> table = new CaseInsensitiveBytesHash<Integer>();
        for (int i = 0; i < UnicodeProperties.CodeRangeTable.length; ++i) {
            table.putDirect(UnicodeProperties.CodeRangeTable[i].name, i);
        }
        return table;
    }

    private static IntHash<int[]> initializeFoldHash() {
        int i;
        IntHash<int[]> fold = new IntHash<int[]>(1200);
        for (i = 0; i < CaseFold_From.length; ++i) {
            fold.putDirect(CaseFold_From[i], CaseFold_To[i]);
        }
        for (i = 0; i < CaseFold_Locale_From.length; ++i) {
            fold.putDirect(CaseFold_Locale_From[i], CaseFold_Locale_To[i]);
        }
        return fold;
    }

    private static IntHash<int[]> initializeUnfold1Hash() {
        int i;
        IntHash<int[]> unfold1 = new IntHash<int[]>(1000);
        for (i = 0; i < CaseUnfold_11_From.length; ++i) {
            unfold1.putDirect(CaseUnfold_11_From[i], CaseUnfold_11_To[i]);
        }
        for (i = 0; i < CaseUnfold_11_Locale_From.length; ++i) {
            unfold1.putDirect(CaseUnfold_11_Locale_From[i], CaseUnfold_11_Locale_To[i]);
        }
        return unfold1;
    }

    private static IntArrayHash<int[]> initializeUnfold2Hash() {
        int i;
        IntArrayHash<int[]> unfold2 = new IntArrayHash<int[]>(200);
        for (i = 0; i < CaseUnfold_12.length; i += 2) {
            unfold2.putDirect(CaseUnfold_12[i], CaseUnfold_12[i + 1]);
        }
        for (i = 0; i < CaseUnfold_12_Locale.length; i += 2) {
            unfold2.putDirect(CaseUnfold_12_Locale[i], CaseUnfold_12_Locale[i + 1]);
        }
        return unfold2;
    }

    private static IntArrayHash<int[]> initializeUnfold3Hash() {
        IntArrayHash<int[]> unfold3 = new IntArrayHash<int[]>(30);
        for (int i = 0; i < CaseUnfold_13.length; i += 2) {
            unfold3.putDirect(CaseUnfold_13[i], CaseUnfold_13[i + 1]);
        }
        return unfold3;
    }

    static final class CodeRangeEntry {
        final String table;
        final byte[] name;
        int[] range;

        CodeRangeEntry(String name, String table) {
            this.table = table;
            this.name = name.getBytes();
        }

        public int[] getRange() {
            if (this.range == null) {
                this.range = ArrayReader.readIntArray(this.table);
            }
            return this.range;
        }
    }
}

