/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.padata.actions;

import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.util.Strings;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.padata.PaDataContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.types.PaDataType;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.components.PaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreDataType
extends GrammarAction<PaDataContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreDataType.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreDataType() {
        super("PaDataData's padata-type");
    }

    public void action(PaDataContainer paDataContainer) throws DecoderException {
        TLV tlv = paDataContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        PaData paData = paDataContainer.getPaData();
        BerValue value = tlv.getValue();
        try {
            int paDataType = IntegerDecoder.parse((BerValue)value);
            paData.setPaDataType(PaDataType.getTypeByValue(paDataType));
            if (IS_DEBUG) {
                LOG.debug("padata-type : {}", (Object)paDataType);
            }
        }
        catch (IntegerDecoderException ide) {
            LOG.error(I18n.err((I18n)I18n.ERR_04070, (Object[])new Object[]{Strings.dumpBytes(value.getData()), ide.getLocalizedMessage()}));
            throw new DecoderException(ide.getMessage());
        }
    }
}

