/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.net;

import java.net.InetSocketAddress;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.shaded.com.google.common.net.HostAndPort;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Address
implements Comparable<Address> {
    private final HostAndPort hostAndPort;

    private Address(HostAndPort hostAndPort) {
        this.hostAndPort = hostAndPort;
    }

    public static Address fromParts(String hostname, int port) {
        return new Address(HostAndPort.fromParts(hostname, port));
    }

    public static Address fromString(String hostnameAndPort) {
        return new Address(HostAndPort.fromString(hostnameAndPort));
    }

    public static Address fromSocketAddress(InetSocketAddress addr) {
        return Address.fromParts(addr.getHostString(), addr.getPort());
    }

    public InetSocketAddress toSocketAddress() {
        return new InetSocketAddress(this.getHostName(), this.getPort());
    }

    public static InetSocketAddress[] toSocketAddress(Address[] addrs) {
        if (addrs == null) {
            return null;
        }
        InetSocketAddress[] result = new InetSocketAddress[addrs.length];
        for (int i = 0; i < addrs.length; ++i) {
            result[i] = addrs[i].toSocketAddress();
        }
        return result;
    }

    public String getHostName() {
        return this.hostAndPort.getHostText();
    }

    @Deprecated
    public String getHostname() {
        return this.hostAndPort.getHostText();
    }

    public int getPort() {
        return this.hostAndPort.getPort();
    }

    public String toString() {
        return this.hostAndPort.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Address) {
            Address that = (Address)other;
            return this.getHostName().equals(that.getHostName()) && this.getPort() == that.getPort();
        }
        return false;
    }

    public int hashCode() {
        return this.getHostName().hashCode() ^ this.getPort();
    }

    @Override
    public int compareTo(Address that) {
        int compare = this.getHostName().compareTo(that.getHostName());
        if (compare != 0) {
            return compare;
        }
        return this.getPort() - that.getPort();
    }
}

