/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HTableMultiplexer {
    private static final Log LOG = LogFactory.getLog((String)HTableMultiplexer.class.getName());
    public static final String TABLE_MULTIPLEXER_FLUSH_PERIOD_MS = "hbase.tablemultiplexer.flush.period.ms";
    public static final String TABLE_MULTIPLEXER_INIT_THREADS = "hbase.tablemultiplexer.init.threads";
    public static final String TABLE_MULTIPLEXER_MAX_RETRIES_IN_QUEUE = "hbase.client.max.retries.in.queue";
    private final Map<HRegionLocation, FlushWorker> serverToFlushWorkerMap = new ConcurrentHashMap<HRegionLocation, FlushWorker>();
    private final Configuration workerConf;
    private final ClusterConnection conn;
    private final ExecutorService pool;
    private final int retryNum;
    private final int perRegionServerBufferQueueSize;
    private final int maxKeyValueSize;
    private final ScheduledExecutorService executor;
    private final long flushPeriod;

    public HTableMultiplexer(Configuration conf, int perRegionServerBufferQueueSize) throws IOException {
        this(ConnectionFactory.createConnection(conf), conf, perRegionServerBufferQueueSize);
    }

    public HTableMultiplexer(Connection conn, Configuration conf, int perRegionServerBufferQueueSize) {
        this.conn = (ClusterConnection)conn;
        this.pool = HTable.getDefaultExecutor(conf);
        this.retryNum = conf.getInt("hbase.client.retries.number", 31);
        this.perRegionServerBufferQueueSize = perRegionServerBufferQueueSize;
        this.maxKeyValueSize = HTable.getMaxKeyValueSize(conf);
        this.flushPeriod = conf.getLong(TABLE_MULTIPLEXER_FLUSH_PERIOD_MS, 100L);
        int initThreads = conf.getInt(TABLE_MULTIPLEXER_INIT_THREADS, 10);
        this.executor = Executors.newScheduledThreadPool(initThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HTableFlushWorker-%d").build());
        this.workerConf = HBaseConfiguration.create(conf);
        this.workerConf.setInt("hbase.client.retries.number", 0);
    }

    public synchronized void close() throws IOException {
        if (!this.getConnection().isClosed()) {
            this.getConnection().close();
        }
    }

    public boolean put(TableName tableName, Put put) {
        return this.put(tableName, put, this.retryNum);
    }

    public List<Put> put(TableName tableName, List<Put> puts) {
        if (puts == null) {
            return null;
        }
        ArrayList<Put> failedPuts = null;
        for (Put put : puts) {
            boolean result = this.put(tableName, put, this.retryNum);
            if (result) continue;
            if (failedPuts == null) {
                failedPuts = new ArrayList<Put>();
            }
            failedPuts.add(put);
        }
        return failedPuts;
    }

    @Deprecated
    public List<Put> put(byte[] tableName, List<Put> puts) {
        return this.put(TableName.valueOf(tableName), puts);
    }

    public boolean put(TableName tableName, Put put, int maxAttempts) {
        if (maxAttempts <= 0) {
            return false;
        }
        try {
            HTable.validatePut(put, this.maxKeyValueSize);
            ClusterConnection conn = this.getConnection();
            HRegionLocation loc = conn.getRegionLocation(tableName, put.getRow(), false);
            if (loc != null) {
                LinkedBlockingQueue<PutStatus> queue = this.getQueue(loc);
                PutStatus s = new PutStatus(loc.getRegionInfo(), put, maxAttempts);
                return queue.offer(s);
            }
        }
        catch (IOException e) {
            LOG.debug((Object)("Cannot process the put " + put), (Throwable)e);
        }
        return false;
    }

    @Deprecated
    public boolean put(byte[] tableName, Put put, int retry) {
        return this.put(TableName.valueOf(tableName), put, retry);
    }

    @Deprecated
    public boolean put(byte[] tableName, Put put) {
        return this.put(TableName.valueOf(tableName), put);
    }

    public HTableMultiplexerStatus getHTableMultiplexerStatus() {
        return new HTableMultiplexerStatus(this.serverToFlushWorkerMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    LinkedBlockingQueue<PutStatus> getQueue(HRegionLocation addr) {
        FlushWorker worker = this.serverToFlushWorkerMap.get(addr);
        if (worker == null) {
            Map<HRegionLocation, FlushWorker> map = this.serverToFlushWorkerMap;
            synchronized (map) {
                worker = this.serverToFlushWorkerMap.get(addr);
                if (worker == null) {
                    worker = new FlushWorker(this.workerConf, this.conn, addr, this, this.perRegionServerBufferQueueSize, this.pool, this.executor);
                    this.serverToFlushWorkerMap.put(addr, worker);
                    this.executor.scheduleAtFixedRate(worker, this.flushPeriod, this.flushPeriod, TimeUnit.MILLISECONDS);
                }
            }
        }
        return worker.getQueue();
    }

    @InterfaceAudience.Private
    ClusterConnection getConnection() {
        return this.conn;
    }

    @InterfaceAudience.Private
    static class FlushWorker
    implements Runnable {
        private final HRegionLocation addr;
        private final LinkedBlockingQueue<PutStatus> queue;
        private final HTableMultiplexer multiplexer;
        private final AtomicLong totalFailedPutCount = new AtomicLong(0L);
        private final AtomicInteger currentProcessingCount = new AtomicInteger(0);
        private final AtomicAverageCounter averageLatency = new AtomicAverageCounter();
        private final AtomicLong maxLatency = new AtomicLong(0L);
        private final AsyncProcess ap;
        private final List<PutStatus> processingList = new ArrayList<PutStatus>();
        private final ScheduledExecutorService executor;
        private final int maxRetryInQueue;
        private final AtomicInteger retryInQueue = new AtomicInteger(0);
        private final int writeRpcTimeout;

        public FlushWorker(Configuration conf, ClusterConnection conn, HRegionLocation addr, HTableMultiplexer htableMultiplexer, int perRegionServerBufferQueueSize, ExecutorService pool, ScheduledExecutorService executor) {
            this.addr = addr;
            this.multiplexer = htableMultiplexer;
            this.queue = new LinkedBlockingQueue(perRegionServerBufferQueueSize);
            RpcRetryingCallerFactory rpcCallerFactory = RpcRetryingCallerFactory.instantiate(conf);
            RpcControllerFactory rpcControllerFactory = RpcControllerFactory.instantiate(conf);
            this.writeRpcTimeout = conf.getInt("hbase.rpc.write.timeout", conf.getInt("hbase.rpc.timeout", 60000));
            this.ap = new AsyncProcess(conn, conf, pool, rpcCallerFactory, false, rpcControllerFactory, this.writeRpcTimeout);
            this.executor = executor;
            this.maxRetryInQueue = conf.getInt(HTableMultiplexer.TABLE_MULTIPLEXER_MAX_RETRIES_IN_QUEUE, 10000);
        }

        protected LinkedBlockingQueue<PutStatus> getQueue() {
            return this.queue;
        }

        public long getTotalFailedCount() {
            return this.totalFailedPutCount.get();
        }

        public long getTotalBufferedCount() {
            return (long)this.queue.size() + (long)this.currentProcessingCount.get();
        }

        public AtomicAverageCounter getAverageLatencyCounter() {
            return this.averageLatency;
        }

        public long getMaxLatency() {
            return this.maxLatency.getAndSet(0L);
        }

        boolean resubmitFailedPut(PutStatus ps, HRegionLocation oldLoc) throws IOException {
            final int retryCount = ps.retryCount - 1;
            if (retryCount <= 0) {
                return false;
            }
            int cnt = this.getRetryInQueue().incrementAndGet();
            if (cnt > this.getMaxRetryInQueue()) {
                this.getRetryInQueue().decrementAndGet();
                return false;
            }
            final Put failedPut = ps.put;
            final TableName tableName = ps.regionInfo.getTable();
            long delayMs = this.getNextDelay(retryCount);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("resubmitting after " + delayMs + "ms: " + retryCount));
            }
            this.getExecutor().schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean succ = false;
                    try {
                        succ = FlushWorker.this.getMultiplexer().put(tableName, failedPut, retryCount);
                    }
                    finally {
                        FlushWorker.this.getRetryInQueue().decrementAndGet();
                        if (!succ) {
                            FlushWorker.this.getTotalFailedPutCount().incrementAndGet();
                        }
                    }
                }
            }, delayMs, TimeUnit.MILLISECONDS);
            return true;
        }

        @InterfaceAudience.Private
        long getNextDelay(int retryCount) {
            return ConnectionUtils.getPauseTime(this.multiplexer.flushPeriod, this.multiplexer.retryNum - retryCount - 1);
        }

        @InterfaceAudience.Private
        AtomicInteger getRetryInQueue() {
            return this.retryInQueue;
        }

        @InterfaceAudience.Private
        int getMaxRetryInQueue() {
            return this.maxRetryInQueue;
        }

        @InterfaceAudience.Private
        AtomicLong getTotalFailedPutCount() {
            return this.totalFailedPutCount;
        }

        @InterfaceAudience.Private
        HTableMultiplexer getMultiplexer() {
            return this.multiplexer;
        }

        @InterfaceAudience.Private
        ScheduledExecutorService getExecutor() {
            return this.executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int failedCount = 0;
            try {
                Object[] results;
                ArrayList<PutStatus> failed;
                long start;
                block23: {
                    start = EnvironmentEdgeManager.currentTime();
                    this.processingList.clear();
                    this.queue.drainTo(this.processingList);
                    if (this.processingList.size() == 0) {
                        return;
                    }
                    this.currentProcessingCount.set(this.processingList.size());
                    failedCount = this.processingList.size();
                    ArrayList<Action<Row>> retainedActions = new ArrayList<Action<Row>>(this.processingList.size());
                    MultiAction actions = new MultiAction();
                    for (int i = 0; i < this.processingList.size(); ++i) {
                        PutStatus putStatus = this.processingList.get(i);
                        Action action = new Action(putStatus.put, i);
                        actions.add(putStatus.regionInfo.getRegionName(), action);
                        retainedActions.add(action);
                    }
                    failed = null;
                    results = new Object[actions.size()];
                    ServerName server = this.addr.getServerName();
                    Map<ServerName, MultiAction<Row>> actionsByServer = Collections.singletonMap(server, actions);
                    try {
                        AsyncProcess.AsyncRequestFuture arf = this.ap.submitMultiActions(null, retainedActions, 0L, null, results, true, null, null, actionsByServer, null);
                        arf.waitUntilDone();
                        if (!arf.hasError()) break block23;
                        LOG.debug((Object)("Caught some exceptions when flushing puts to region server " + this.addr.getHostnamePort()), (Throwable)arf.getErrors());
                    }
                    catch (Throwable throwable) {
                        for (int i = 0; i < results.length; ++i) {
                            if (results[i] instanceof Result) {
                                --failedCount;
                                continue;
                            }
                            if (failed == null) {
                                failed = new ArrayList<PutStatus>();
                            }
                            failed.add(this.processingList.get(i));
                        }
                        throw throwable;
                    }
                }
                for (int i = 0; i < results.length; ++i) {
                    if (results[i] instanceof Result) {
                        --failedCount;
                        continue;
                    }
                    if (failed == null) {
                        failed = new ArrayList();
                    }
                    failed.add(this.processingList.get(i));
                }
                if (failed != null) {
                    for (PutStatus putStatus : failed) {
                        if (!this.resubmitFailedPut(putStatus, this.addr)) continue;
                        --failedCount;
                    }
                }
                long elapsed = EnvironmentEdgeManager.currentTime() - start;
                this.averageLatency.add(elapsed);
                if (elapsed > this.maxLatency.get()) {
                    this.maxLatency.set(elapsed);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Processed " + this.currentProcessingCount + " put requests for " + this.addr.getHostnamePort() + " and " + failedCount + " failed" + ", latency for this send: " + elapsed));
                }
                this.currentProcessingCount.set(0);
            }
            catch (RuntimeException e) {
                LOG.debug((Object)("Caught some exceptions " + e + " when flushing puts to region server " + this.addr.getHostnamePort()), (Throwable)e);
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LOG.debug((Object)("Caught some exceptions " + e + " when flushing puts to region server " + this.addr.getHostnamePort()), (Throwable)e);
            }
            finally {
                this.totalFailedPutCount.addAndGet(failedCount);
            }
        }
    }

    private static class AtomicAverageCounter {
        private long sum = 0L;
        private int count = 0;

        public synchronized long getAndReset() {
            long result = this.get();
            this.reset();
            return result;
        }

        public synchronized long get() {
            if (this.count == 0) {
                return 0L;
            }
            return this.sum / (long)this.count;
        }

        public synchronized AbstractMap.SimpleEntry<Long, Integer> getComponents() {
            return new AbstractMap.SimpleEntry<Long, Integer>(this.sum, this.count);
        }

        public synchronized void reset() {
            this.sum = 0L;
            this.count = 0;
        }

        public synchronized void add(long value) {
            this.sum += value;
            ++this.count;
        }
    }

    @InterfaceAudience.Private
    static class PutStatus {
        public final HRegionInfo regionInfo;
        public final Put put;
        public final int retryCount;

        public PutStatus(HRegionInfo regionInfo, Put put, int retryCount) {
            this.regionInfo = regionInfo;
            this.put = put;
            this.retryCount = retryCount;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class HTableMultiplexerStatus {
        private long totalFailedPutCounter = 0L;
        private long totalBufferedPutCounter = 0L;
        private long maxLatency = 0L;
        private long overallAverageLatency = 0L;
        private Map<String, Long> serverToFailedCounterMap;
        private Map<String, Long> serverToBufferedCounterMap = new HashMap<String, Long>();
        private Map<String, Long> serverToAverageLatencyMap;
        private Map<String, Long> serverToMaxLatencyMap;

        public HTableMultiplexerStatus(Map<HRegionLocation, FlushWorker> serverToFlushWorkerMap) {
            this.serverToFailedCounterMap = new HashMap<String, Long>();
            this.serverToAverageLatencyMap = new HashMap<String, Long>();
            this.serverToMaxLatencyMap = new HashMap<String, Long>();
            this.initialize(serverToFlushWorkerMap);
        }

        private void initialize(Map<HRegionLocation, FlushWorker> serverToFlushWorkerMap) {
            if (serverToFlushWorkerMap == null) {
                return;
            }
            long averageCalcSum = 0L;
            int averageCalcCount = 0;
            for (Map.Entry<HRegionLocation, FlushWorker> entry : serverToFlushWorkerMap.entrySet()) {
                HRegionLocation addr = entry.getKey();
                FlushWorker worker = entry.getValue();
                long bufferedCounter = worker.getTotalBufferedCount();
                long failedCounter = worker.getTotalFailedCount();
                long serverMaxLatency = worker.getMaxLatency();
                AtomicAverageCounter averageCounter = worker.getAverageLatencyCounter();
                AbstractMap.SimpleEntry<Long, Integer> averageComponents = averageCounter.getComponents();
                long serverAvgLatency = averageCounter.getAndReset();
                this.totalBufferedPutCounter += bufferedCounter;
                this.totalFailedPutCounter += failedCounter;
                if (serverMaxLatency > this.maxLatency) {
                    this.maxLatency = serverMaxLatency;
                }
                averageCalcSum += averageComponents.getKey().longValue();
                averageCalcCount += averageComponents.getValue().intValue();
                this.serverToBufferedCounterMap.put(addr.getHostnamePort(), bufferedCounter);
                this.serverToFailedCounterMap.put(addr.getHostnamePort(), failedCounter);
                this.serverToAverageLatencyMap.put(addr.getHostnamePort(), serverAvgLatency);
                this.serverToMaxLatencyMap.put(addr.getHostnamePort(), serverMaxLatency);
            }
            this.overallAverageLatency = averageCalcCount != 0 ? averageCalcSum / (long)averageCalcCount : 0L;
        }

        public long getTotalBufferedCounter() {
            return this.totalBufferedPutCounter;
        }

        public long getTotalFailedCounter() {
            return this.totalFailedPutCounter;
        }

        public long getMaxLatency() {
            return this.maxLatency;
        }

        public long getOverallAverageLatency() {
            return this.overallAverageLatency;
        }

        public Map<String, Long> getBufferedCounterForEachRegionServer() {
            return this.serverToBufferedCounterMap;
        }

        public Map<String, Long> getFailedCounterForEachRegionServer() {
            return this.serverToFailedCounterMap;
        }

        public Map<String, Long> getMaxLatencyForEachRegionServer() {
            return this.serverToMaxLatencyMap;
        }

        public Map<String, Long> getAverageLatencyForEachRegionServer() {
            return this.serverToAverageLatencyMap;
        }
    }
}

