/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.io.Serializable;
import java.util.Collection;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.joda.time.Instant;

public abstract class WindowFn<T, W extends BoundedWindow>
implements Serializable,
HasDisplayData {
    public abstract Collection<W> assignWindows(AssignContext var1) throws Exception;

    public abstract void mergeWindows(MergeContext var1) throws Exception;

    @Deprecated
    public abstract boolean isCompatible(WindowFn<?, ?> var1);

    public void verifyCompatibility(WindowFn<?, ?> other) throws IncompatibleWindowException {
        if (!this.isCompatible(other)) {
            throw new IncompatibleWindowException(other, String.format("%s is not compatible with %s", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
        }
    }

    public abstract Coder<W> windowCoder();

    public abstract WindowMappingFn<W> getDefaultWindowMappingFn();

    public boolean isNonMerging() {
        return false;
    }

    public boolean assignsToOneWindow() {
        return false;
    }

    public TypeDescriptor<W> getWindowTypeDescriptor() {
        return new TypeDescriptor<W>(this){};
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
    }

    public abstract class MergeContext {
        public abstract Collection<W> windows();

        public abstract void merge(Collection<W> var1, W var2) throws Exception;
    }

    public abstract class AssignContext {
        public abstract T element();

        public abstract Instant timestamp();

        public abstract BoundedWindow window();
    }
}

