/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueSetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.schemas.utils.StaticSchemaInference;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.ByteBuddy;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.NamingStrategy;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.asm.AsmVisitorWrapper;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.field.FieldDescription;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.method.MethodDescription;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.method.MethodList;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.type.TypeDefinition;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.type.TypeDescription;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.DynamicType;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.FixedValue;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.Implementation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.Duplication;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.TypeCreation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.collection.ArrayAccess;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.FieldAccess;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.matcher.ElementMatcher;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class POJOUtils {
    private static final ByteBuddy BYTE_BUDDY = new ByteBuddy();
    private static final Map<ReflectUtils.ClassWithSchema, List<FieldValueTypeInformation>> CACHED_FIELD_TYPES = Maps.newConcurrentMap();
    private static final Map<ReflectUtils.ClassWithSchema, List<FieldValueGetter>> CACHED_GETTERS = Maps.newConcurrentMap();
    public static final Map<ReflectUtils.ClassWithSchema, SchemaUserTypeCreator> CACHED_CREATORS = Maps.newConcurrentMap();
    private static final Map<ReflectUtils.ClassWithSchema, List<FieldValueSetter>> CACHED_SETTERS = Maps.newConcurrentMap();

    public static Schema schemaFromPojoClass(Class<?> clazz, FieldValueTypeSupplier fieldValueTypeSupplier) {
        return StaticSchemaInference.schemaFromClass(clazz, fieldValueTypeSupplier);
    }

    public static List<FieldValueTypeInformation> getFieldTypes(Class<?> clazz, Schema schema, FieldValueTypeSupplier fieldValueTypeSupplier) {
        return CACHED_FIELD_TYPES.computeIfAbsent(ReflectUtils.ClassWithSchema.create(clazz, schema), c -> fieldValueTypeSupplier.get(clazz, schema));
    }

    public static List<FieldValueGetter> getGetters(Class<?> clazz, Schema schema, FieldValueTypeSupplier fieldValueTypeSupplier, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        return CACHED_GETTERS.computeIfAbsent(ReflectUtils.ClassWithSchema.create(clazz, schema), c -> {
            List<FieldValueTypeInformation> types = fieldValueTypeSupplier.get(clazz, schema);
            List getters = types.stream().map(t -> POJOUtils.createGetter(t, typeConversionsFactory)).collect(Collectors.toList());
            if (getters.size() != schema.getFieldCount()) {
                throw new RuntimeException("Was not able to generate getters for schema: " + schema + " class: " + clazz);
            }
            return getters;
        });
    }

    public static <T> SchemaUserTypeCreator getSetFieldCreator(Class<T> clazz, Schema schema, FieldValueTypeSupplier fieldValueTypeSupplier, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        return CACHED_CREATORS.computeIfAbsent(ReflectUtils.ClassWithSchema.create(clazz, schema), c -> {
            List<FieldValueTypeInformation> types = fieldValueTypeSupplier.get(clazz, schema);
            return POJOUtils.createSetFieldCreator(clazz, schema, types, typeConversionsFactory);
        });
    }

    private static <T> SchemaUserTypeCreator createSetFieldCreator(Class<T> clazz, Schema schema, List<FieldValueTypeInformation> types, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        List<Field> fields = types.stream().map(FieldValueTypeInformation::getField).collect(Collectors.toList());
        try {
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = BYTE_BUDDY.with((NamingStrategy)new ByteBuddyUtils.InjectPackageStrategy(clazz)).subclass(SchemaUserTypeCreator.class).method((ElementMatcher)ElementMatchers.named((String)"create")).intercept((Implementation)new SetFieldCreateInstruction(fields, clazz, typeConversionsFactory));
            return (SchemaUserTypeCreator)builder.visit((AsmVisitorWrapper)new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2)).make().load(ReflectHelpers.findClassLoader(clazz.getClassLoader()), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalStateException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(String.format("Unable to generate a creator for POJO '%s' with inferred schema: %s%nNote POJOs must have a zero-argument constructor, or a constructor annotated with @SchemaCreate.", clazz, schema));
        }
    }

    public static SchemaUserTypeCreator getConstructorCreator(Class clazz, Constructor constructor, Schema schema, FieldValueTypeSupplier fieldValueTypeSupplier, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        return CACHED_CREATORS.computeIfAbsent(ReflectUtils.ClassWithSchema.create(clazz, schema), c -> {
            List<FieldValueTypeInformation> types = fieldValueTypeSupplier.get(clazz, schema);
            return POJOUtils.createConstructorCreator(clazz, constructor, schema, types, typeConversionsFactory);
        });
    }

    public static <T> SchemaUserTypeCreator createConstructorCreator(Class<T> clazz, Constructor<T> constructor, Schema schema, List<FieldValueTypeInformation> types, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        try {
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = BYTE_BUDDY.with((NamingStrategy)new ByteBuddyUtils.InjectPackageStrategy(clazz)).subclass(SchemaUserTypeCreator.class).method((ElementMatcher)ElementMatchers.named((String)"create")).intercept((Implementation)new ByteBuddyUtils.ConstructorCreateInstruction(types, clazz, constructor, typeConversionsFactory));
            return (SchemaUserTypeCreator)builder.visit((AsmVisitorWrapper)new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2)).make().load(ReflectHelpers.findClassLoader(clazz.getClassLoader()), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to generate a creator for " + clazz + " with schema " + schema);
        }
    }

    public static SchemaUserTypeCreator getStaticCreator(Class clazz, Method creator, Schema schema, FieldValueTypeSupplier fieldValueTypeSupplier, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        return CACHED_CREATORS.computeIfAbsent(ReflectUtils.ClassWithSchema.create(clazz, schema), c -> {
            List<FieldValueTypeInformation> types = fieldValueTypeSupplier.get(clazz, schema);
            return POJOUtils.createStaticCreator(clazz, creator, schema, types, typeConversionsFactory);
        });
    }

    public static <T> SchemaUserTypeCreator createStaticCreator(Class<T> clazz, Method creator, Schema schema, List<FieldValueTypeInformation> types, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        try {
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = BYTE_BUDDY.with((NamingStrategy)new ByteBuddyUtils.InjectPackageStrategy(clazz)).subclass(SchemaUserTypeCreator.class).method((ElementMatcher)ElementMatchers.named((String)"create")).intercept((Implementation)new ByteBuddyUtils.StaticFactoryMethodInstruction(types, clazz, creator, typeConversionsFactory));
            return (SchemaUserTypeCreator)builder.visit((AsmVisitorWrapper)new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2)).make().load(ReflectHelpers.findClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to generate a creator for class " + clazz + " with schema " + schema);
        }
    }

    static <ObjectT, ValueT> @Nullable FieldValueGetter<ObjectT, ValueT> createGetter(FieldValueTypeInformation typeInformation, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        Field field = typeInformation.getField();
        DynamicType.Builder<FieldValueGetter> builder = ByteBuddyUtils.subclassGetterInterface(BYTE_BUDDY, field.getDeclaringClass(), typeConversionsFactory.createTypeConversion(false).convert(TypeDescriptor.of(field.getType())));
        builder = POJOUtils.implementGetterMethods(builder, field, typeInformation.getName(), typeConversionsFactory);
        try {
            return (FieldValueGetter)builder.visit((AsmVisitorWrapper)new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2)).make().load(ReflectHelpers.findClassLoader(field.getDeclaringClass().getClassLoader()), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to generate a getter for field '" + field + "'.", e);
        }
    }

    private static DynamicType.Builder<FieldValueGetter> implementGetterMethods(DynamicType.Builder<FieldValueGetter> builder, Field field, String name, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        return builder.visit((AsmVisitorWrapper)new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2)).method((ElementMatcher)ElementMatchers.named((String)"name")).intercept((Implementation)FixedValue.reference((Object)name)).method((ElementMatcher)ElementMatchers.named((String)"get")).intercept((Implementation)new ReadFieldInstruction(field, typeConversionsFactory));
    }

    public static List<FieldValueSetter> getSetters(Class<?> clazz, Schema schema, FieldValueTypeSupplier fieldValueTypeSupplier, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        return CACHED_SETTERS.computeIfAbsent(ReflectUtils.ClassWithSchema.create(clazz, schema), c -> {
            List<FieldValueTypeInformation> types = fieldValueTypeSupplier.get(clazz, schema);
            return types.stream().map(t -> POJOUtils.createSetter(t, typeConversionsFactory)).collect(Collectors.toList());
        });
    }

    private static <ObjectT, ValueT> FieldValueSetter<ObjectT, ValueT> createSetter(FieldValueTypeInformation typeInformation, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        Field field = typeInformation.getField();
        DynamicType.Builder<FieldValueSetter> builder = ByteBuddyUtils.subclassSetterInterface(BYTE_BUDDY, field.getDeclaringClass(), typeConversionsFactory.createTypeConversion(false).convert(TypeDescriptor.of(field.getType())));
        builder = POJOUtils.implementSetterMethods(builder, field, typeConversionsFactory);
        try {
            return (FieldValueSetter)builder.visit((AsmVisitorWrapper)new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2)).make().load(ReflectHelpers.findClassLoader(field.getDeclaringClass().getClassLoader()), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to generate a getter for field '" + field + "'.", e);
        }
    }

    private static DynamicType.Builder<FieldValueSetter> implementSetterMethods(DynamicType.Builder<FieldValueSetter> builder, Field field, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        return builder.visit((AsmVisitorWrapper)new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2)).method((ElementMatcher)ElementMatchers.named((String)"name")).intercept((Implementation)FixedValue.reference((Object)field.getName())).method((ElementMatcher)ElementMatchers.named((String)"set")).intercept((Implementation)new SetFieldInstruction(field, typeConversionsFactory));
    }

    static class SetFieldCreateInstruction
    implements Implementation {
        private final List<Field> fields;
        private final Class pojoClass;
        private final ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory;

        SetFieldCreateInstruction(List<Field> fields, Class pojoClass, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
            this.fields = fields;
            this.pojoClass = pojoClass;
            this.typeConversionsFactory = typeConversionsFactory;
        }

        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                int numLocals = 1 + instrumentedMethod.getParameters().size();
                TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(this.pojoClass);
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(new StackManipulation[]{TypeCreation.of((TypeDescription)loadedType), Duplication.SINGLE, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)loadedType.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isConstructor().and((ElementMatcher)ElementMatchers.takesArguments((int)0)))).getOnly()))});
                ByteBuddyUtils.TypeConversion<Type> convertType = this.typeConversionsFactory.createTypeConversion(true);
                for (int i = 0; i < this.fields.size(); ++i) {
                    Field field = this.fields.get(i);
                    TypeDescription.ForLoadedType convertedType = new TypeDescription.ForLoadedType((Class)convertType.convert(TypeDescriptor.of(field.getType())));
                    StackManipulation.Compound readParameter = new StackManipulation.Compound(new StackManipulation[]{MethodVariableAccess.REFERENCE.loadFrom(1), IntegerConstant.forValue((int)i), ArrayAccess.REFERENCE.load(), TypeCasting.to((TypeDefinition)convertedType)});
                    StackManipulation.Compound updateField = new StackManipulation.Compound(new StackManipulation[]{Duplication.SINGLE, this.typeConversionsFactory.createSetterConversions((StackManipulation)readParameter).convert(TypeDescriptor.of(field.getType())), FieldAccess.forField((FieldDescription.InDefinedShape)new FieldDescription.ForLoadedField(field)).write()});
                    stackManipulation = new StackManipulation.Compound(new StackManipulation[]{stackManipulation, updateField});
                }
                stackManipulation = new StackManipulation.Compound(new StackManipulation[]{stackManipulation, MethodReturn.REFERENCE});
                StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
            };
        }
    }

    static class SetFieldInstruction
    implements Implementation {
        private Field field;
        private final ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory;

        SetFieldInstruction(Field field, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
            this.field = field;
            this.typeConversionsFactory = typeConversionsFactory;
        }

        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                int numLocals = 1 + instrumentedMethod.getParameters().size();
                StackManipulation readField = MethodVariableAccess.REFERENCE.loadFrom(2);
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(new StackManipulation[]{MethodVariableAccess.REFERENCE.loadFrom(1), this.typeConversionsFactory.createSetterConversions(readField).convert(TypeDescriptor.of(this.field.getType())), FieldAccess.forField((FieldDescription.InDefinedShape)new FieldDescription.ForLoadedField(this.field)).write(), MethodReturn.VOID});
                StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
            };
        }
    }

    static class ReadFieldInstruction
    implements Implementation {
        private final Field field;
        private final ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory;

        ReadFieldInstruction(Field field, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
            this.field = field;
            this.typeConversionsFactory = typeConversionsFactory;
        }

        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                int numLocals = 1 + instrumentedMethod.getParameters().size();
                StackManipulation.Compound readValue = new StackManipulation.Compound(new StackManipulation[]{MethodVariableAccess.REFERENCE.loadFrom(1), FieldAccess.forField((FieldDescription.InDefinedShape)new FieldDescription.ForLoadedField(this.field)).read()});
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(new StackManipulation[]{this.typeConversionsFactory.createGetterConversions((StackManipulation)readValue).convert(TypeDescriptor.of(this.field.getGenericType())), MethodReturn.REFERENCE});
                StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
            };
        }
    }
}

