/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.coders.CoderProviderRegistrar;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface DefaultCoder {
    @CheckForNull
    public Class<? extends Coder> value();

    public static class DefaultCoderProviderRegistrar
    implements CoderProviderRegistrar {
        @Override
        public List<CoderProvider> getCoderProviders() {
            return ImmutableList.of((Object)new DefaultCoderProvider());
        }

        static class DefaultCoderProvider
        extends CoderProvider {
            private static final Logger LOG = LoggerFactory.getLogger(DefaultCoderProvider.class);

            DefaultCoderProvider() {
            }

            @Override
            public <T> Coder<T> coderFor(TypeDescriptor<T> typeDescriptor, List<? extends Coder<?>> componentCoders) throws CannotProvideCoderException {
                CoderProvider coderProvider;
                Method coderProviderMethod;
                Class<T> clazz = typeDescriptor.getRawType();
                DefaultCoder defaultAnnotation = clazz.getAnnotation(DefaultCoder.class);
                if (defaultAnnotation == null) {
                    throw new CannotProvideCoderException(String.format("Class %s does not have a @DefaultCoder annotation.", clazz.getName()));
                }
                Class<? extends Coder> defaultAnnotationValue = defaultAnnotation.value();
                if (defaultAnnotationValue == null) {
                    throw new CannotProvideCoderException(String.format("Class %s has a @DefaultCoder annotation with a null value.", clazz.getName()));
                }
                LOG.debug("DefaultCoder annotation found for {} with value {}", clazz, defaultAnnotationValue);
                try {
                    coderProviderMethod = defaultAnnotationValue.getMethod("getCoderProvider", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new CannotProvideCoderException(String.format("Unable to find 'public static CoderProvider getCoderProvider()' on %s", defaultAnnotationValue), e);
                }
                try {
                    coderProvider = (CoderProvider)coderProviderMethod.invoke(null, new Object[0]);
                }
                catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException e) {
                    throw new CannotProvideCoderException(String.format("Unable to invoke 'public static CoderProvider getCoderProvider()' on %s", defaultAnnotationValue), e);
                }
                return coderProvider.coderFor(typeDescriptor, componentCoders);
            }
        }
    }
}

