/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.googledrive.config;

import org.apache.hop.core.config.plugin.ConfigPlugin;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.vfs.googledrive.config.GoogleDriveConfig;
import org.apache.hop.vfs.googledrive.config.GoogleDriveConfigSingleton;
import org.eclipse.swt.widgets.Control;
import picocli.CommandLine;

@ConfigPlugin(id="GoogleDriveConfigPlugin", description="Configuration options for the Google Drive VFS plugin", category="config")
@GuiPlugin(description="Google Drive VFS")
public class GoogleDriveConfigPlugin
implements IConfigOptions,
IGuiPluginCompositeWidgetsListener {
    private static final String WIDGET_ID_GOOGLE_DRIVE_VFS_CREDENTIALS_PATH = "10000-google-drive-vfs-credentials-path";
    private static final String WIDGET_ID_GOOGLE_DRIVE_VFS_TOKENS_FOLDER = "10100-google-drive-vfs-tokens-folder";
    @GuiWidgetElement(id="10000-google-drive-vfs-credentials-path", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="Path to a Google Drive credentials JSON file", toolTip="Please note that this is a global configuration option and while you can specify variables that these will be not include project specific settings.")
    @CommandLine.Option(names={"-gdc", "--google-drive-credentials-file"}, description={"Configure the path to a Google Drive credentials JSON file"})
    private String credentialsFile;
    @GuiWidgetElement(id="10100-google-drive-vfs-tokens-folder", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="Path to a tokens folder for credential caching", toolTip="Pick a safe folder to store these tokens")
    @CommandLine.Option(names={"-gdt", "--google-drive-tokens-folder"}, description={"Configure the path to a Google Drive tokens folder"})
    private String tokensFolder;

    public static GoogleDriveConfigPlugin getInstance() {
        GoogleDriveConfigPlugin instance = new GoogleDriveConfigPlugin();
        GoogleDriveConfig config = GoogleDriveConfigSingleton.getConfig();
        instance.credentialsFile = config.getCredentialsFile();
        instance.tokensFolder = config.getTokensFolder();
        return instance;
    }

    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider hasHopMetadataProvider, IVariables variables) throws HopException {
        GoogleDriveConfig config = GoogleDriveConfigSingleton.getConfig();
        try {
            boolean changed = false;
            if (this.credentialsFile != null) {
                config.setCredentialsFile(this.credentialsFile);
                log.logBasic("The Google Drive credentials file is set to '" + this.credentialsFile + "'");
                changed = true;
            }
            if (this.tokensFolder != null) {
                config.setTokensFolder(this.tokensFolder);
                log.logBasic("The Google Drive tokens folder is set to '" + this.tokensFolder + "'");
                changed = true;
            }
            if (changed) {
                GoogleDriveConfigSingleton.saveConfig();
            }
            return changed;
        }
        catch (Exception e) {
            throw new HopException("Error handling Google Drive plugin configuration options", (Throwable)e);
        }
    }

    public void widgetsCreated(GuiCompositeWidgets compositeWidgets) {
    }

    public void widgetsPopulated(GuiCompositeWidgets compositeWidgets) {
    }

    public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
    }

    public void persistContents(GuiCompositeWidgets compositeWidgets) {
        for (String widgetId : compositeWidgets.getWidgetsMap().keySet()) {
            Control control = (Control)compositeWidgets.getWidgetsMap().get(widgetId);
            switch (widgetId) {
                case "10000-google-drive-vfs-credentials-path": {
                    this.credentialsFile = ((TextVar)control).getText();
                    GoogleDriveConfigSingleton.getConfig().setCredentialsFile(this.credentialsFile);
                    break;
                }
                case "10100-google-drive-vfs-tokens-folder": {
                    this.tokensFolder = ((TextVar)control).getText();
                    GoogleDriveConfigSingleton.getConfig().setTokensFolder(this.tokensFolder);
                }
            }
        }
        try {
            GoogleDriveConfigSingleton.saveConfig();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error saving option", e);
        }
    }

    public String getCredentialsFile() {
        return this.credentialsFile;
    }

    public void setCredentialsFile(String credentialsFile) {
        this.credentialsFile = credentialsFile;
    }

    public String getTokensFolder() {
        return this.tokensFolder;
    }

    public void setTokensFolder(String tokensFolder) {
        this.tokensFolder = tokensFolder;
    }
}

