/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.api.core.ApiFunction;
import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutureCallback;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.cloud.bigtable.hbase.adapters.SampledRowKeysAdapter;
import com.google.cloud.bigtable.hbase.util.Logger;
import com.google.cloud.bigtable.hbase.wrappers.BigtableHBaseSettings;
import com.google.cloud.bigtable.hbase.wrappers.DataClientWrapper;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;

@InternalApi(value="For internal usage only")
public abstract class AbstractBigtableRegionLocator {
    public static long MAX_REGION_AGE_MILLIS = 60000L;
    private static final Logger LOG = new Logger(AbstractBigtableRegionLocator.class);
    protected final TableName tableName;
    private ApiFuture<List<HRegionLocation>> regionsFuture;
    private final DataClientWrapper client;
    private final SampledRowKeysAdapter adapter;
    private final String fullTableName;
    private long regionsFetchTimeMillis;

    public AbstractBigtableRegionLocator(TableName tableName, BigtableHBaseSettings settings, DataClientWrapper client) {
        this.tableName = tableName;
        this.client = client;
        this.fullTableName = NameUtil.formatTableName(settings.getProjectId(), settings.getInstanceId(), tableName.getNameAsString());
        ServerName serverName = ServerName.valueOf((String)settings.getDataHost(), (int)settings.getPort(), (long)0L);
        this.adapter = this.getSampledRowKeysAdapter(tableName, serverName);
    }

    public abstract SampledRowKeysAdapter getSampledRowKeysAdapter(TableName var1, ServerName var2);

    protected synchronized ApiFuture<List<HRegionLocation>> getRegionsAsync(boolean reload) {
        if (!reload && this.regionsFuture != null && this.regionsFetchTimeMillis + MAX_REGION_AGE_MILLIS > System.currentTimeMillis()) {
            return this.regionsFuture;
        }
        LOG.debug("Sampling rowkeys for table %s", this.fullTableName);
        try {
            ApiFuture<List<KeyOffset>> future = this.client.sampleRowKeysAsync(this.tableName.getNameAsString());
            this.regionsFuture = ApiFutures.transform(future, new ApiFunction<List<KeyOffset>, List<HRegionLocation>>(){

                @Override
                public List<HRegionLocation> apply(@Nullable List<KeyOffset> input) {
                    return AbstractBigtableRegionLocator.this.adapter.adaptResponse(input);
                }
            }, MoreExecutors.directExecutor());
            ApiFutures.addCallback(this.regionsFuture, new ApiFutureCallback<List<HRegionLocation>>(){

                @Override
                public void onSuccess(@Nullable List<HRegionLocation> result) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(Throwable t) {
                    AbstractBigtableRegionLocator abstractBigtableRegionLocator = AbstractBigtableRegionLocator.this;
                    synchronized (abstractBigtableRegionLocator) {
                        AbstractBigtableRegionLocator.this.regionsFuture = null;
                    }
                }
            }, MoreExecutors.directExecutor());
            this.regionsFetchTimeMillis = System.currentTimeMillis();
            return this.regionsFuture;
        }
        catch (Throwable throwable) {
            this.regionsFuture = null;
            Futures.immediateFailedFuture(throwable);
            return this.regionsFuture;
        }
    }
}

