/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui;

import java.io.Serializable;
import java.util.concurrent.Semaphore;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.scheduler.SchedulingMode$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Random;

public final class UIWorkloadGenerator$ {
    public static UIWorkloadGenerator$ MODULE$;
    private final int NUM_PARTITIONS;
    private final int INTER_JOB_WAIT_MS;

    static {
        new UIWorkloadGenerator$();
    }

    public int NUM_PARTITIONS() {
        return this.NUM_PARTITIONS;
    }

    public int INTER_JOB_WAIT_MS() {
        return this.INTER_JOB_WAIT_MS;
    }

    public void main(String[] args) {
        Enumeration.Value schedulingMode;
        if (args.length < 3) {
            Predef$.MODULE$.println((Object)"Usage: ./bin/spark-class org.apache.spark.ui.UIWorkloadGenerator [master] [FIFO|FAIR] [#job set (4 jobs per set)]");
            System.exit(1);
        }
        SparkConf conf = new SparkConf().setMaster(args[0]).setAppName("Spark UI tester");
        Enumeration.Value value = schedulingMode = SchedulingMode$.MODULE$.withName(args[1]);
        Enumeration.Value value2 = SchedulingMode$.MODULE$.FAIR();
        Object object = !(value != null ? !value.equals(value2) : value2 != null) ? conf.set(package$.MODULE$.SCHEDULER_MODE(), "FAIR") : BoxedUnit.UNIT;
        int nJobSet = new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt();
        SparkContext sc = new SparkContext(conf);
        RDD baseData = sc.makeRDD(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.NUM_PARTITIONS() * 10), this.NUM_PARTITIONS(), ClassTag$.MODULE$.Int());
        Seq jobs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Count", (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> baseData.count()), new Tuple2((Object)"Cache and Count", (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> baseData.map((JFunction1.mcII.sp & Serializable & scala.Serializable)x -> x, ClassTag$.MODULE$.Int()).cache().count()), new Tuple2((Object)"Single Shuffle", (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> RDD$.MODULE$.rddToPairRDDFunctions(baseData.map((Function1 & Serializable & scala.Serializable)x -> UIWorkloadGenerator$.$anonfun$main$5(BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), Ordering.Int$.MODULE$).reduceByKey((JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$1, x$2) -> x$1 + x$2).count()), new Tuple2((Object)"Entirely failed phase", (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> baseData.map((JFunction1.mcII.sp & Serializable & scala.Serializable)x -> {
            throw new Exception();
        }, ClassTag$.MODULE$.Int()).count()), new Tuple2((Object)"Partially failed phase", (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> baseData.map((JFunction1.mcII.sp & Serializable & scala.Serializable)x -> {
            double probFailure = 4.0 / (double)MODULE$.NUM_PARTITIONS();
            if ((double)UIWorkloadGenerator$.nextFloat$1() < probFailure) {
                throw new Exception("This is a task failure");
            }
            return 1;
        }, ClassTag$.MODULE$.Int()).count()), new Tuple2((Object)"Partially failed phase (longer tasks)", (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> baseData.map((JFunction1.mcII.sp & Serializable & scala.Serializable)x -> {
            double probFailure = 4.0 / (double)MODULE$.NUM_PARTITIONS();
            if ((double)UIWorkloadGenerator$.nextFloat$1() < probFailure) {
                Thread.sleep(100L);
                throw new Exception("This is a task failure");
            }
            return 1;
        }, ClassTag$.MODULE$.Int()).count()), new Tuple2((Object)"Job with delays", (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> baseData.map((JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> Thread.sleep(100L), ClassTag$.MODULE$.Unit()).count())}));
        Semaphore barrier = new Semaphore(-nJobSet * jobs.size() + 1);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), nJobSet).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> jobs.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)UIWorkloadGenerator$.$anonfun$main$16(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            UIWorkloadGenerator$.$anonfun$main$17(barrier, schedulingMode, sc, x$4);
            return BoxedUnit.UNIT;
        }));
        barrier.acquire();
        sc.stop();
    }

    public static final void org$apache$spark$ui$UIWorkloadGenerator$$setProperties$1(String s, Enumeration.Value schedulingMode$1, SparkContext sc$1) {
        Enumeration.Value value = schedulingMode$1;
        Enumeration.Value value2 = SchedulingMode$.MODULE$.FAIR();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            sc$1.setLocalProperty(SparkContext$.MODULE$.SPARK_SCHEDULER_POOL(), s);
        }
        sc$1.setLocalProperty(SparkContext$.MODULE$.SPARK_JOB_DESCRIPTION(), s);
    }

    private static final float nextFloat$1() {
        return new Random().nextFloat();
    }

    public static final /* synthetic */ Tuple2 $anonfun$main$5(int x) {
        return new Tuple2.mcII.sp(x % 10, x);
    }

    public static final /* synthetic */ boolean $anonfun$main$16(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$main$17(Semaphore barrier$1, Enumeration.Value schedulingMode$1, SparkContext sc$1, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String desc = (String)tuple2._1();
        Function0 job = (Function0)tuple2._2();
        new Thread(desc, job, barrier$1, schedulingMode$1, sc$1){
            private final String desc$1;
            private final Function0 job$1;
            private final Semaphore barrier$1;
            private final Enumeration.Value schedulingMode$1;
            private final SparkContext sc$1;

            public void run() {
                try {
                    try {
                        UIWorkloadGenerator$.org$apache$spark$ui$UIWorkloadGenerator$$setProperties$1(this.desc$1, this.schedulingMode$1, this.sc$1);
                        this.job$1.apply$mcJ$sp();
                        Predef$.MODULE$.println((Object)new StringBuilder(14).append("Job finished: ").append(this.desc$1).toString());
                    }
                    catch (Exception e) {
                        Predef$.MODULE$.println((Object)new StringBuilder(12).append("Job Failed: ").append(this.desc$1).toString());
                    }
                }
                finally {
                    this.barrier$1.release();
                }
            }
            {
                this.desc$1 = desc$1;
                this.job$1 = job$1;
                this.barrier$1 = barrier$1;
                this.schedulingMode$1 = schedulingMode$1;
                this.sc$1 = sc$1;
            }
        }.start();
        Thread.sleep(MODULE$.INTER_JOB_WAIT_MS());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private UIWorkloadGenerator$() {
        MODULE$ = this;
        this.NUM_PARTITIONS = 100;
        this.INTER_JOB_WAIT_MS = 5000;
    }
}

