/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.api.ShufflePartitionWriter;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.TimeTrackingOutputStream;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.collection.PairsWriter;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}d!\u0002\u0012$\u0001\u0015Z\u0003\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011)\u0003!\u0011!Q\u0001\n-C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t+\u0002\u0011\t\u0011)A\u0005-\"AA\f\u0001B\u0001B\u0003%Q\fC\u0003b\u0001\u0011\u0005!\rC\u0004j\u0001\u0001\u0007I\u0011\u00026\t\u000f9\u0004\u0001\u0019!C\u0005_\"1Q\u000f\u0001Q!\n-D\u0011B\u001e\u0001A\u0002\u0003\u0007I\u0011B<\t\u0013m\u0004\u0001\u0019!a\u0001\n\u0013a\b\"\u0003@\u0001\u0001\u0004\u0005\t\u0015)\u0003y\u0011%y\b\u00011AA\u0002\u0013%q\u000fC\u0006\u0002\u0002\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0001BCA\u0004\u0001\u0001\u0007\t\u0011)Q\u0005q\"Q\u0011\u0011\u0002\u0001A\u0002\u0003\u0007I\u0011B<\t\u0017\u0005-\u0001\u00011AA\u0002\u0013%\u0011Q\u0002\u0005\u000b\u0003#\u0001\u0001\u0019!A!B\u0013A\bbCA\n\u0001\u0001\u0007\t\u0019!C\u0005\u0003+A1\"!\b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002 !Y\u00111\u0005\u0001A\u0002\u0003\u0005\u000b\u0015BA\f\u0011%\t)\u0003\u0001a\u0001\n\u0013\t9\u0003C\u0005\u00020\u0001\u0001\r\u0011\"\u0003\u00022!A\u0011Q\u0007\u0001!B\u0013\tI\u0003C\u0005\u00028\u0001\u0001\r\u0011\"\u0003\u0002:!I\u0011\u0011\t\u0001A\u0002\u0013%\u00111\t\u0005\t\u0003\u000f\u0002\u0001\u0015)\u0003\u0002<!9\u0011\u0011\n\u0001\u0005B\u0005-\u0003bBA.\u0001\u0011%\u0011Q\f\u0005\b\u0003?\u0002A\u0011IA/\u0011\u001d\t\t\u0007\u0001C\u0005\u0003GBq!a\u001f\u0001\t\u0013\ti\u0006C\u0004\u0002~\u0001!I!!\u0018\u00037MCWO\u001a4mKB\u000b'\u000f^5uS>t\u0007+Y5sg^\u0013\u0018\u000e^3s\u0015\t!S%A\u0004tQV4g\r\\3\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001cB\u0001\u0001\u00173uA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t1\u0011I\\=SK\u001a\u0004\"a\r\u001d\u000e\u0003QR!!\u000e\u001c\u0002\u0015\r|G\u000e\\3di&|gN\u0003\u00028K\u0005!Q\u000f^5m\u0013\tIDGA\u0006QC&\u00148o\u0016:ji\u0016\u0014\bCA\u001eA\u001b\u0005a$BA\u001f?\u0003\tIwNC\u0001@\u0003\u0011Q\u0017M^1\n\u0005\u0005c$!C\"m_N,\u0017M\u00197f\u0003=\u0001\u0018M\u001d;ji&|gn\u0016:ji\u0016\u00148\u0001\u0001\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f\u000e\n1!\u00199j\u0013\tIeI\u0001\fTQV4g\r\\3QCJ$\u0018\u000e^5p]^\u0013\u0018\u000e^3s\u0003E\u0019XM]5bY&TXM]'b]\u0006<WM\u001d\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\u0016\n!b]3sS\u0006d\u0017N_3s\u0013\t\u0001VJA\tTKJL\u0017\r\\5{KJl\u0015M\\1hKJ\f!c]3sS\u0006d\u0017N_3s\u0013:\u001cH/\u00198dKB\u0011AjU\u0005\u0003)6\u0013!cU3sS\u0006d\u0017N_3s\u0013:\u001cH/\u00198dK\u00069!\r\\8dW&#\u0007CA,[\u001b\u0005A&BA-&\u0003\u001d\u0019Ho\u001c:bO\u0016L!a\u0017-\u0003\u000f\tcwnY6JI\u0006aqO]5uK6+GO]5dgB\u0011alX\u0007\u0002G%\u0011\u0001m\t\u0002\u001c'\",hM\u001a7f/JLG/Z'fiJL7m\u001d*fa>\u0014H/\u001a:\u0002\rqJg.\u001b;?)\u0019\u0019G-\u001a4hQB\u0011a\f\u0001\u0005\u0006\u0005\u001a\u0001\r\u0001\u0012\u0005\u0006\u0015\u001a\u0001\ra\u0013\u0005\u0006#\u001a\u0001\rA\u0015\u0005\u0006+\u001a\u0001\rA\u0016\u0005\u00069\u001a\u0001\r!X\u0001\tSN\u001cEn\\:fIV\t1\u000e\u0005\u0002.Y&\u0011QN\f\u0002\b\u0005>|G.Z1o\u00031I7o\u00117pg\u0016$w\fJ3r)\t\u00018\u000f\u0005\u0002.c&\u0011!O\f\u0002\u0005+:LG\u000fC\u0004u\u0011\u0005\u0005\t\u0019A6\u0002\u0007a$\u0013'A\u0005jg\u000ecwn]3eA\u0005y\u0001/\u0019:uSRLwN\\*ue\u0016\fW.F\u0001y!\tY\u00140\u0003\u0002{y\taq*\u001e;qkR\u001cFO]3b[\u0006\u0019\u0002/\u0019:uSRLwN\\*ue\u0016\fWn\u0018\u0013fcR\u0011\u0001/ \u0005\bi.\t\t\u00111\u0001y\u0003A\u0001\u0018M\u001d;ji&|gn\u0015;sK\u0006l\u0007%\u0001\nuS6,GK]1dW&twm\u0015;sK\u0006l\u0017A\u0006;j[\u0016$&/Y2lS:<7\u000b\u001e:fC6|F%Z9\u0015\u0007A\f)\u0001C\u0004u\u001d\u0005\u0005\t\u0019\u0001=\u0002'QLW.\u001a+sC\u000e\\\u0017N\\4TiJ,\u0017-\u001c\u0011\u0002\u001b]\u0014\u0018\r\u001d9fIN#(/Z1n\u0003E9(/\u00199qK\u0012\u001cFO]3b[~#S-\u001d\u000b\u0004a\u0006=\u0001b\u0002;\u0012\u0003\u0003\u0005\r\u0001_\u0001\u000foJ\f\u0007\u000f]3e'R\u0014X-Y7!\u0003\u0019y'M[(viV\u0011\u0011q\u0003\t\u0004\u0019\u0006e\u0011bAA\u000e\u001b\n\u00192+\u001a:jC2L'0\u0019;j_:\u001cFO]3b[\u0006QqN\u00196PkR|F%Z9\u0015\u0007A\f\t\u0003\u0003\u0005u)\u0005\u0005\t\u0019AA\f\u0003\u001dy'M[(vi\u0002\n\u0011C\\;n%\u0016\u001cwN\u001d3t/JLG\u000f^3o+\t\tI\u0003E\u0002.\u0003WI1!!\f/\u0005\rIe\u000e^\u0001\u0016]Vl'+Z2pe\u0012\u001cxK]5ui\u0016tw\fJ3r)\r\u0001\u00181\u0007\u0005\ti^\t\t\u00111\u0001\u0002*\u0005\u0011b.^7SK\u000e|'\u000fZ:Xe&$H/\u001a8!\u0003I\u0019WO\u001d(v[\nKH/Z:Xe&$H/\u001a8\u0016\u0005\u0005m\u0002cA\u0017\u0002>%\u0019\u0011q\b\u0018\u0003\t1{gnZ\u0001\u0017GV\u0014h*^7CsR,7o\u0016:jiR,gn\u0018\u0013fcR\u0019\u0001/!\u0012\t\u0011QT\u0012\u0011!a\u0001\u0003w\t1cY;s\u001dVl')\u001f;fg^\u0013\u0018\u000e\u001e;f]\u0002\nQa\u001e:ji\u0016$R\u0001]A'\u0003/Bq!a\u0014\u001d\u0001\u0004\t\t&A\u0002lKf\u00042!LA*\u0013\r\t)F\f\u0002\u0004\u0003:L\bbBA-9\u0001\u0007\u0011\u0011K\u0001\u0006m\u0006dW/Z\u0001\u0005_B,g\u000eF\u0001q\u0003\u0015\u0019Gn\\:f\u00039\u0019Gn\\:f\u0013\u001atuN\u001c(vY2,B!!\u001a\u0002lQ!\u0011qMA<!\u0011\tI'a\u001b\r\u0001\u00119\u0011QN\u0010C\u0002\u0005=$!\u0001+\u0012\u0007\u0005E$\bE\u0002.\u0003gJ1!!\u001e/\u0005\u001dqu\u000e\u001e5j]\u001eDq!!\u001f \u0001\u0004\t9'A\u0005dY>\u001cX-\u00192mK\u0006i!/Z2pe\u0012<&/\u001b;uK:\f!#\u001e9eCR,')\u001f;fg^\u0013\u0018\u000e\u001e;f]\u0002")
public class ShufflePartitionPairsWriter
implements PairsWriter,
Closeable {
    private final ShufflePartitionWriter partitionWriter;
    private final SerializerManager serializerManager;
    private final SerializerInstance serializerInstance;
    private final BlockId blockId;
    private final ShuffleWriteMetricsReporter writeMetrics;
    private boolean isClosed;
    private OutputStream partitionStream;
    private OutputStream timeTrackingStream;
    private OutputStream wrappedStream;
    private SerializationStream objOut;
    private int numRecordsWritten;
    private long curNumBytesWritten;

    private boolean isClosed() {
        return this.isClosed;
    }

    private void isClosed_$eq(boolean x$1) {
        this.isClosed = x$1;
    }

    private OutputStream partitionStream() {
        return this.partitionStream;
    }

    private void partitionStream_$eq(OutputStream x$1) {
        this.partitionStream = x$1;
    }

    private OutputStream timeTrackingStream() {
        return this.timeTrackingStream;
    }

    private void timeTrackingStream_$eq(OutputStream x$1) {
        this.timeTrackingStream = x$1;
    }

    private OutputStream wrappedStream() {
        return this.wrappedStream;
    }

    private void wrappedStream_$eq(OutputStream x$1) {
        this.wrappedStream = x$1;
    }

    private SerializationStream objOut() {
        return this.objOut;
    }

    private void objOut_$eq(SerializationStream x$1) {
        this.objOut = x$1;
    }

    private int numRecordsWritten() {
        return this.numRecordsWritten;
    }

    private void numRecordsWritten_$eq(int x$1) {
        this.numRecordsWritten = x$1;
    }

    private long curNumBytesWritten() {
        return this.curNumBytesWritten;
    }

    private void curNumBytesWritten_$eq(long x$1) {
        this.curNumBytesWritten = x$1;
    }

    @Override
    public void write(Object key, Object value) {
        if (this.isClosed()) {
            throw new IOException("Partition pairs writer is already closed.");
        }
        if (this.objOut() == null) {
            this.open();
        }
        this.objOut().writeKey(key, ClassTag$.MODULE$.Any());
        this.objOut().writeValue(value, ClassTag$.MODULE$.Any());
        this.recordWritten();
    }

    private void open() {
        try {
            this.partitionStream_$eq(this.partitionWriter.openStream());
            this.timeTrackingStream_$eq(new TimeTrackingOutputStream(this.writeMetrics, this.partitionStream()));
            this.wrappedStream_$eq(this.serializerManager.wrapStream(this.blockId, this.timeTrackingStream()));
            this.objOut_$eq(this.serializerInstance.serializeStream(this.wrappedStream()));
        }
        catch (Exception e) {
            Utils$.MODULE$.tryLogNonFatalError((Function0<BoxedUnit>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.close());
            throw e;
        }
    }

    @Override
    public void close() {
        block0: {
            if (this.isClosed()) break block0;
            Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
                Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
                    this.objOut_$eq(this.closeIfNonNull(this.objOut()));
                    this.wrappedStream_$eq(null);
                    this.timeTrackingStream_$eq(null);
                    this.partitionStream_$eq(null);
                }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
                    this.wrappedStream_$eq(this.closeIfNonNull(this.wrappedStream()));
                    this.timeTrackingStream_$eq(null);
                    this.partitionStream_$eq(null);
                }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
                    this.timeTrackingStream_$eq(this.closeIfNonNull(this.timeTrackingStream()));
                    this.partitionStream_$eq(null);
                }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.partitionStream_$eq(this.closeIfNonNull(this.partitionStream())))));
                this.updateBytesWritten();
            }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.isClosed_$eq(true));
        }
    }

    private <T extends Closeable> T closeIfNonNull(T closeable) {
        block0: {
            if (closeable == null) break block0;
            closeable.close();
        }
        return null;
    }

    private void recordWritten() {
        block0: {
            this.numRecordsWritten_$eq(this.numRecordsWritten() + 1);
            this.writeMetrics.incRecordsWritten(1L);
            if (this.numRecordsWritten() % 16384 != 0) break block0;
            this.updateBytesWritten();
        }
    }

    private void updateBytesWritten() {
        long numBytesWritten = this.partitionWriter.getNumBytesWritten();
        long bytesWrittenDiff = numBytesWritten - this.curNumBytesWritten();
        this.writeMetrics.incBytesWritten(bytesWrittenDiff);
        this.curNumBytesWritten_$eq(numBytesWritten);
    }

    public ShufflePartitionPairsWriter(ShufflePartitionWriter partitionWriter, SerializerManager serializerManager, SerializerInstance serializerInstance, BlockId blockId, ShuffleWriteMetricsReporter writeMetrics) {
        this.partitionWriter = partitionWriter;
        this.serializerManager = serializerManager;
        this.serializerInstance = serializerInstance;
        this.blockId = blockId;
        this.writeMetrics = writeMetrics;
        this.isClosed = false;
        this.numRecordsWritten = 0;
        this.curNumBytesWritten = 0L;
    }
}

