/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import com.google.cloud.Timestamp;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.avro.reflect.AvroEncode;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.encoder.TimestampEncoding;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecordMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ColumnType;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.Mod;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ModType;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ValueCaptureType;

@DefaultCoder(value=AvroCoder.class)
public class DataChangeRecord
implements ChangeStreamRecord {
    private static final long serialVersionUID = 1138762498767540898L;
    private String partitionToken;
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp commitTimestamp;
    private String serverTransactionId;
    private boolean isLastRecordInTransactionInPartition;
    private String recordSequence;
    private String tableName;
    private List<ColumnType> rowType;
    private List<Mod> mods;
    private ModType modType;
    private ValueCaptureType valueCaptureType;
    private long numberOfRecordsInTransaction;
    private long numberOfPartitionsInTransaction;
    @org.apache.avro.reflect.Nullable
    private ChangeStreamRecordMetadata metadata;

    private DataChangeRecord() {
    }

    public DataChangeRecord(String partitionToken, Timestamp commitTimestamp, String serverTransactionId, boolean isLastRecordInTransactionInPartition, String recordSequence, String tableName, List<ColumnType> rowType, List<Mod> mods, ModType modType, ValueCaptureType valueCaptureType, long numberOfRecordsInTransaction, long numberOfPartitionsInTransaction, ChangeStreamRecordMetadata metadata) {
        this.commitTimestamp = commitTimestamp;
        this.partitionToken = partitionToken;
        this.serverTransactionId = serverTransactionId;
        this.isLastRecordInTransactionInPartition = isLastRecordInTransactionInPartition;
        this.recordSequence = recordSequence;
        this.tableName = tableName;
        this.rowType = rowType;
        this.mods = mods;
        this.modType = modType;
        this.valueCaptureType = valueCaptureType;
        this.numberOfRecordsInTransaction = numberOfRecordsInTransaction;
        this.numberOfPartitionsInTransaction = numberOfPartitionsInTransaction;
        this.metadata = metadata;
    }

    @Override
    public Timestamp getRecordTimestamp() {
        return this.commitTimestamp;
    }

    public String getPartitionToken() {
        return this.partitionToken;
    }

    public Timestamp getCommitTimestamp() {
        return this.commitTimestamp;
    }

    public String getServerTransactionId() {
        return this.serverTransactionId;
    }

    public boolean isLastRecordInTransactionInPartition() {
        return this.isLastRecordInTransactionInPartition;
    }

    public String getRecordSequence() {
        return this.recordSequence;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<ColumnType> getRowType() {
        return this.rowType;
    }

    public List<Mod> getMods() {
        return this.mods;
    }

    public ModType getModType() {
        return this.modType;
    }

    public ValueCaptureType getValueCaptureType() {
        return this.valueCaptureType;
    }

    public long getNumberOfRecordsInTransaction() {
        return this.numberOfRecordsInTransaction;
    }

    public long getNumberOfPartitionsInTransaction() {
        return this.numberOfPartitionsInTransaction;
    }

    public ChangeStreamRecordMetadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataChangeRecord)) {
            return false;
        }
        DataChangeRecord that = (DataChangeRecord)o;
        return this.isLastRecordInTransactionInPartition == that.isLastRecordInTransactionInPartition && this.numberOfRecordsInTransaction == that.numberOfRecordsInTransaction && this.numberOfPartitionsInTransaction == that.numberOfPartitionsInTransaction && Objects.equals(this.partitionToken, that.partitionToken) && Objects.equals(this.commitTimestamp, that.commitTimestamp) && Objects.equals(this.serverTransactionId, that.serverTransactionId) && Objects.equals(this.recordSequence, that.recordSequence) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.rowType, that.rowType) && Objects.equals(this.mods, that.mods) && this.modType == that.modType && this.valueCaptureType == that.valueCaptureType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partitionToken, this.commitTimestamp, this.serverTransactionId, this.isLastRecordInTransactionInPartition, this.recordSequence, this.tableName, this.rowType, this.mods, this.modType, this.valueCaptureType, this.numberOfRecordsInTransaction, this.numberOfPartitionsInTransaction});
    }

    public String toString() {
        return "DataChangeRecord{partitionToken='" + this.partitionToken + '\'' + ", commitTimestamp=" + this.commitTimestamp + ", serverTransactionId='" + this.serverTransactionId + '\'' + ", isLastRecordInTransactionInPartition=" + this.isLastRecordInTransactionInPartition + ", recordSequence='" + this.recordSequence + '\'' + ", tableName='" + this.tableName + '\'' + ", rowType=" + this.rowType + ", mods=" + this.mods + ", modType=" + (Object)((Object)this.modType) + ", valueCaptureType=" + (Object)((Object)this.valueCaptureType) + ", numberOfRecordsInTransaction=" + this.numberOfRecordsInTransaction + ", numberOfPartitionsInTransaction=" + this.numberOfPartitionsInTransaction + ", metadata" + this.metadata + '}';
    }
}

