/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.TopicStatsClient;
import com.google.cloud.pubsublite.internal.TopicStatsClientSettings;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.AutoValue_TopicBacklogReaderSettings;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.LimitingTopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReaderImpl;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Ticker;

@AutoValue
abstract class TopicBacklogReaderSettings
implements Serializable {
    private static final long serialVersionUID = -4001752066450248673L;

    TopicBacklogReaderSettings() {
    }

    abstract TopicPath topicPath();

    abstract Partition partition();

    static Builder newBuilder() {
        return new AutoValue_TopicBacklogReaderSettings.Builder();
    }

    private TopicStatsClient newClient() {
        return TopicStatsClient.create((TopicStatsClientSettings)TopicStatsClientSettings.newBuilder().setRegion(this.topicPath().location().extractRegion()).build());
    }

    TopicBacklogReader instantiate() throws ApiException {
        TopicBacklogReaderImpl impl = new TopicBacklogReaderImpl(this.newClient(), this.topicPath(), this.partition());
        return new LimitingTopicBacklogReader(impl, Ticker.systemTicker());
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setTopicPath(TopicPath var1);

        abstract Builder setPartition(Partition var1);

        abstract TopicBacklogReaderSettings build();
    }
}

