/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.cloud.firestore.v1.stub.FirestoreStub;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListCollectionIdsResponse;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.PartitionQueryRequest;
import com.google.firestore.v1.PartitionQueryResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Value;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolStringList;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreDoFn;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreStatefulComponentFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1RpcAttemptContexts;
import org.apache.beam.sdk.io.gcp.firestore.JodaClock;
import org.apache.beam.sdk.io.gcp.firestore.RpcQos;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

final class FirestoreV1ReadFn {
    FirestoreV1ReadFn() {
    }

    static final class PartitionQueryPair
    implements Serializable {
        private final PartitionQueryRequest request;
        private final PartitionQueryResponse response;

        @VisibleForTesting
        PartitionQueryPair(PartitionQueryRequest request, PartitionQueryResponse response) {
            this.request = request;
            this.response = response;
        }

        public PartitionQueryRequest getRequest() {
            return this.request;
        }

        public PartitionQueryResponse getResponse() {
            return this.response;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PartitionQueryPair)) {
                return false;
            }
            PartitionQueryPair that = (PartitionQueryPair)o;
            return this.request.equals((Object)that.request) && this.response.equals((Object)that.response);
        }

        public int hashCode() {
            return Objects.hash(this.request, this.response);
        }

        public String toString() {
            return "PartitionQueryPair{request=" + this.request + ", response=" + this.response + '}';
        }
    }

    static abstract class BaseFirestoreV1ReadFn<InT, OutT>
    extends FirestoreDoFn.ImplicitlyWindowedFirestoreDoFn<InT, OutT>
    implements FirestoreV1RpcAttemptContexts.HasRpcAttemptContext {
        protected final JodaClock clock;
        protected final FirestoreStatefulComponentFactory firestoreStatefulComponentFactory;
        protected final RpcQosOptions rpcQosOptions;
        protected transient FirestoreStub firestoreStub;
        protected transient RpcQos rpcQos;
        protected transient String projectId;

        protected BaseFirestoreV1ReadFn(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
            this.clock = Objects.requireNonNull(clock, "clock must be non null");
            this.firestoreStatefulComponentFactory = Objects.requireNonNull(firestoreStatefulComponentFactory, "firestoreFactory must be non null");
            this.rpcQosOptions = Objects.requireNonNull(rpcQosOptions, "rpcQosOptions must be non null");
        }

        @Override
        public void setup() {
            this.rpcQos = this.firestoreStatefulComponentFactory.getRpcQos(this.rpcQosOptions);
        }

        @Override
        public final void startBundle(DoFn.StartBundleContext c) {
            String project = ((GcpOptions)c.getPipelineOptions().as(GcpOptions.class)).getProject();
            this.projectId = Objects.requireNonNull(project, "project must be defined on GcpOptions of PipelineOptions");
            this.firestoreStub = this.firestoreStatefulComponentFactory.getFirestoreStub(c.getPipelineOptions());
        }

        @Override
        public void finishBundle() throws Exception {
            this.projectId = null;
            this.firestoreStub.close();
        }

        @Override
        public final void populateDisplayData(DisplayData.Builder builder) {
            builder.include("rpcQosOptions", (HasDisplayData)this.rpcQosOptions);
        }
    }

    private static abstract class PaginatedFirestoreV1ReadFn<RequestT extends Message, PagedResponseT extends AbstractPagedListResponse<RequestT, ResponseT, ?, PageT, ?>, PageT extends AbstractPage<RequestT, ResponseT, ?, PageT>, ResponseT extends Message>
    extends BaseFirestoreV1ReadFn<RequestT, ResponseT> {
        protected PaginatedFirestoreV1ReadFn(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
        }

        protected abstract UnaryCallable<RequestT, PagedResponseT> getCallable(FirestoreStub var1);

        protected abstract RequestT setPageToken(RequestT var1, String var2);

        @Override
        public final void processElement(DoFn.ProcessContext c) throws Exception {
            Message element = Objects.requireNonNull((Message)c.element(), "c.element() must be non null");
            RpcQos.RpcReadAttempt attempt = this.rpcQos.newReadAttempt(this.getRpcAttemptContext());
            String nextPageToken = null;
            while (true) {
                if (!attempt.awaitSafeToProceed(this.clock.instant())) {
                    continue;
                }
                try {
                    Message request = nextPageToken == null ? element : this.setPageToken(element, nextPageToken);
                    attempt.recordRequestStart(this.clock.instant());
                    AbstractPagedListResponse pagedResponse = (AbstractPagedListResponse)this.getCallable(this.firestoreStub).call((Object)request);
                    for (AbstractPage page : pagedResponse.iteratePages()) {
                        Message response = (Message)page.getResponse();
                        attempt.recordRequestSuccessful(this.clock.instant());
                        c.output((Object)response);
                        if (!page.hasNextPage()) continue;
                        nextPageToken = page.getNextPageToken();
                        attempt.recordRequestStart(this.clock.instant());
                    }
                    attempt.completeSuccess();
                }
                catch (RuntimeException exception) {
                    Instant end = this.clock.instant();
                    attempt.recordRequestFailed(end);
                    attempt.checkCanRetry(end, exception);
                    continue;
                }
                break;
            }
        }
    }

    private static abstract class StreamingFirestoreV1ReadFn<InT extends Message, OutT extends Message>
    extends BaseFirestoreV1ReadFn<InT, OutT> {
        protected StreamingFirestoreV1ReadFn(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
        }

        protected abstract ServerStreamingCallable<InT, OutT> getCallable(FirestoreStub var1);

        protected abstract InT setStartFrom(InT var1, OutT var2);

        @Override
        public final void processElement(DoFn.ProcessContext c) throws Exception {
            Message element = Objects.requireNonNull((Message)c.element(), "c.element() must be non null");
            RpcQos.RpcReadAttempt attempt = this.rpcQos.newReadAttempt(this.getRpcAttemptContext());
            Message lastReceivedValue = null;
            while (true) {
                if (!attempt.awaitSafeToProceed(this.clock.instant())) {
                    continue;
                }
                Instant start = this.clock.instant();
                try {
                    Message request = lastReceivedValue == null ? element : this.setStartFrom(element, lastReceivedValue);
                    attempt.recordRequestStart(start);
                    ServerStream serverStream = this.getCallable(this.firestoreStub).call((Object)request);
                    attempt.recordRequestSuccessful(this.clock.instant());
                    Iterator iterator = serverStream.iterator();
                    while (iterator.hasNext()) {
                        Message out;
                        lastReceivedValue = out = (Message)iterator.next();
                        attempt.recordStreamValue(this.clock.instant());
                        c.output((Object)out);
                    }
                    attempt.completeSuccess();
                }
                catch (RuntimeException exception) {
                    Instant end = this.clock.instant();
                    attempt.recordRequestFailed(end);
                    attempt.checkCanRetry(end, exception);
                    continue;
                }
                break;
            }
        }
    }

    static final class BatchGetDocumentsFn
    extends StreamingFirestoreV1ReadFn<BatchGetDocumentsRequest, BatchGetDocumentsResponse> {
        BatchGetDocumentsFn(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
        }

        @Override
        public RpcQos.RpcAttempt.Context getRpcAttemptContext() {
            return FirestoreV1RpcAttemptContexts.V1FnRpcAttemptContext.BatchGetDocuments;
        }

        @Override
        protected ServerStreamingCallable<BatchGetDocumentsRequest, BatchGetDocumentsResponse> getCallable(FirestoreStub firestoreStub) {
            return firestoreStub.batchGetDocumentsCallable();
        }

        @Override
        protected BatchGetDocumentsRequest setStartFrom(BatchGetDocumentsRequest originalRequest, BatchGetDocumentsResponse mostRecentResponse) {
            int startIndex = -1;
            ProtocolStringList documentsList = originalRequest.getDocumentsList();
            String missing = mostRecentResponse.getMissing();
            String foundName = mostRecentResponse.hasFound() ? mostRecentResponse.getFound().getName() : null;
            int maxIndex = documentsList.size() - 2;
            for (int i = 0; i <= maxIndex; ++i) {
                String docName = (String)documentsList.get(i);
                if (!docName.equals(missing) && !docName.equals(foundName)) continue;
                startIndex = i;
                break;
            }
            if (0 <= startIndex) {
                BatchGetDocumentsRequest.Builder builder = originalRequest.toBuilder().clearDocuments();
                documentsList.stream().skip(startIndex + 1).forEach(arg_0 -> ((BatchGetDocumentsRequest.Builder)builder).addDocuments(arg_0));
                return builder.build();
            }
            throw new IllegalStateException(String.format("Unable to determine BatchGet resumption point. Most recently received doc __name__ '%s'", foundName != null ? foundName : missing));
        }
    }

    static final class ListCollectionIdsFn
    extends PaginatedFirestoreV1ReadFn<ListCollectionIdsRequest, FirestoreClient.ListCollectionIdsPagedResponse, FirestoreClient.ListCollectionIdsPage, ListCollectionIdsResponse> {
        ListCollectionIdsFn(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
        }

        @Override
        public RpcQos.RpcAttempt.Context getRpcAttemptContext() {
            return FirestoreV1RpcAttemptContexts.V1FnRpcAttemptContext.ListCollectionIds;
        }

        @Override
        protected UnaryCallable<ListCollectionIdsRequest, FirestoreClient.ListCollectionIdsPagedResponse> getCallable(FirestoreStub firestoreStub) {
            return firestoreStub.listCollectionIdsPagedCallable();
        }

        @Override
        protected ListCollectionIdsRequest setPageToken(ListCollectionIdsRequest request, String nextPageToken) {
            return request.toBuilder().setPageToken(nextPageToken).build();
        }
    }

    static final class ListDocumentsFn
    extends PaginatedFirestoreV1ReadFn<ListDocumentsRequest, FirestoreClient.ListDocumentsPagedResponse, FirestoreClient.ListDocumentsPage, ListDocumentsResponse> {
        ListDocumentsFn(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
        }

        @Override
        public RpcQos.RpcAttempt.Context getRpcAttemptContext() {
            return FirestoreV1RpcAttemptContexts.V1FnRpcAttemptContext.ListDocuments;
        }

        @Override
        protected UnaryCallable<ListDocumentsRequest, FirestoreClient.ListDocumentsPagedResponse> getCallable(FirestoreStub firestoreStub) {
            return firestoreStub.listDocumentsPagedCallable();
        }

        @Override
        protected ListDocumentsRequest setPageToken(ListDocumentsRequest request, String nextPageToken) {
            return request.toBuilder().setPageToken(nextPageToken).build();
        }
    }

    static final class PartitionQueryFn
    extends BaseFirestoreV1ReadFn<PartitionQueryRequest, PartitionQueryPair> {
        public PartitionQueryFn(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
        }

        @Override
        public RpcQos.RpcAttempt.Context getRpcAttemptContext() {
            return FirestoreV1RpcAttemptContexts.V1FnRpcAttemptContext.PartitionQuery;
        }

        @Override
        public void processElement(DoFn.ProcessContext context) throws Exception {
            PartitionQueryRequest element = Objects.requireNonNull((PartitionQueryRequest)context.element(), "c.element() must be non null");
            RpcQos.RpcReadAttempt attempt = this.rpcQos.newReadAttempt(this.getRpcAttemptContext());
            PartitionQueryResponse.Builder aggregate = null;
            while (true) {
                if (!attempt.awaitSafeToProceed(this.clock.instant())) {
                    continue;
                }
                try {
                    PartitionQueryRequest request = this.setPageToken(element, aggregate);
                    attempt.recordRequestStart(this.clock.instant());
                    FirestoreClient.PartitionQueryPagedResponse pagedResponse = (FirestoreClient.PartitionQueryPagedResponse)this.firestoreStub.partitionQueryPagedCallable().call((Object)request);
                    for (FirestoreClient.PartitionQueryPage page : pagedResponse.iteratePages()) {
                        attempt.recordRequestSuccessful(this.clock.instant());
                        PartitionQueryResponse response = (PartitionQueryResponse)page.getResponse();
                        if (aggregate == null) {
                            aggregate = response.toBuilder();
                        } else {
                            aggregate.addAllPartitions((Iterable)response.getPartitionsList());
                            if (page.hasNextPage()) {
                                aggregate.setNextPageToken(response.getNextPageToken());
                            } else {
                                aggregate.clearNextPageToken();
                            }
                        }
                        if (!page.hasNextPage()) continue;
                        attempt.recordRequestStart(this.clock.instant());
                    }
                    attempt.completeSuccess();
                }
                catch (RuntimeException exception) {
                    Instant end = this.clock.instant();
                    attempt.recordRequestFailed(end);
                    attempt.checkCanRetry(end, exception);
                    continue;
                }
                break;
            }
            if (aggregate != null) {
                context.output((Object)new PartitionQueryPair(element, aggregate.build()));
            }
        }

        private PartitionQueryRequest setPageToken(PartitionQueryRequest request, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable PartitionQueryResponse.Builder aggregate) {
            if (aggregate != null && aggregate.getNextPageToken() != null) {
                return request.toBuilder().setPageToken(aggregate.getNextPageToken()).build();
            }
            return request;
        }
    }

    static final class RunQueryFn
    extends StreamingFirestoreV1ReadFn<RunQueryRequest, RunQueryResponse> {
        RunQueryFn(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
        }

        @Override
        public RpcQos.RpcAttempt.Context getRpcAttemptContext() {
            return FirestoreV1RpcAttemptContexts.V1FnRpcAttemptContext.RunQuery;
        }

        @Override
        protected ServerStreamingCallable<RunQueryRequest, RunQueryResponse> getCallable(FirestoreStub firestoreStub) {
            return firestoreStub.runQueryCallable();
        }

        @Override
        protected RunQueryRequest setStartFrom(RunQueryRequest element, RunQueryResponse runQueryResponse) {
            StructuredQuery.Builder builder;
            StructuredQuery query = element.getStructuredQuery();
            List orderByList = query.getOrderByList();
            if (orderByList.isEmpty()) {
                builder = query.toBuilder().addOrderBy(StructuredQuery.Order.newBuilder().setField(StructuredQuery.FieldReference.newBuilder().setFieldPath("__name__").build()).setDirection(StructuredQuery.Direction.ASCENDING).build()).setStartAt(Cursor.newBuilder().setBefore(false).addValues(Value.newBuilder().setReferenceValue(runQueryResponse.getDocument().getName()).build()));
            } else {
                Cursor.Builder cursor = Cursor.newBuilder().setBefore(false);
                Map fieldsMap = runQueryResponse.getDocument().getFieldsMap();
                for (StructuredQuery.Order order : orderByList) {
                    String fieldPath = order.getField().getFieldPath();
                    Value value = (Value)fieldsMap.get(fieldPath);
                    if (value != null) {
                        cursor.addValues(value);
                        continue;
                    }
                    if (!"__name__".equals(fieldPath)) continue;
                    cursor.addValues(Value.newBuilder().setReferenceValue(runQueryResponse.getDocument().getName()).build());
                }
                builder = query.toBuilder().setStartAt(cursor.build());
            }
            return element.toBuilder().setStructuredQuery(builder.build()).build();
        }
    }
}

