/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoder;

public class TableDestinationCoderV3
extends AtomicCoder<TableDestination> {
    private static final TableDestinationCoderV3 INSTANCE = new TableDestinationCoderV3();
    private static final Coder<String> timePartitioningCoder = NullableCoder.of((Coder)StringUtf8Coder.of());
    private static final Coder<String> clusteringCoder = NullableCoder.of((Coder)StringUtf8Coder.of());

    public static TableDestinationCoderV3 of() {
        return INSTANCE;
    }

    public void encode(TableDestination value, OutputStream outStream) throws IOException {
        TableDestinationCoder.of().encode(value, outStream);
        timePartitioningCoder.encode((Object)value.getJsonTimePartitioning(), outStream);
        clusteringCoder.encode((Object)value.getJsonClustering(), outStream);
    }

    public TableDestination decode(InputStream inStream) throws IOException {
        TableDestination destination = TableDestinationCoder.of().decode(inStream);
        String jsonTimePartitioning = (String)timePartitioningCoder.decode(inStream);
        String jsonClustering = (String)clusteringCoder.decode(inStream);
        return new TableDestination(destination.getTableSpec(), destination.getTableDescription(), jsonTimePartitioning, jsonClustering);
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
    }
}

