/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p43p2.io.grpc.internal;

import com.google.errorprone.annotations.ForOverride;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.common.base.Preconditions;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.common.base.Stopwatch;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.common.base.Supplier;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.common.util.concurrent.ListenableFuture;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.common.util.concurrent.SettableFuture;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.Attributes;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.CallOptions;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.ChannelLogger;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.ClientStreamTracer;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.ConnectivityState;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.ConnectivityStateInfo;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.EquivalentAddressGroup;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.HttpConnectProxiedSocketAddress;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.InternalChannelz;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.InternalInstrumented;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.InternalLogId;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.InternalWithLogId;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.Metadata;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.MethodDescriptor;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.SynchronizationContext;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.internal.BackoffPolicy;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.internal.CallTracer;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.internal.ChannelLoggerImpl;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.internal.ChannelTracer;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.internal.ClientStream;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.internal.ClientStreamListener;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.internal.ClientTransport;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.internal.ClientTransportFactory;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.internal.ConnectionClientTransport;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.internal.ForwardingClientStream;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.internal.ForwardingClientStreamListener;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.internal.ForwardingConnectionClientTransport;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.internal.InUseStateAggregator;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.internal.ManagedClientTransport;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.internal.TransportProvider;

@ThreadSafe
final class InternalSubchannel
implements InternalInstrumented<InternalChannelz.ChannelStats>,
TransportProvider {
    private final InternalLogId logId;
    private final String authority;
    private final String userAgent;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Callback callback;
    private final ClientTransportFactory transportFactory;
    private final ScheduledExecutorService scheduledExecutor;
    private final InternalChannelz channelz;
    private final CallTracer callsTracer;
    private final ChannelTracer channelTracer;
    private final ChannelLogger channelLogger;
    private final SynchronizationContext syncContext;
    private final Index addressIndex;
    private volatile List<EquivalentAddressGroup> addressGroups;
    private BackoffPolicy reconnectPolicy;
    private final Stopwatch connectingTimer;
    @Nullable
    private SynchronizationContext.ScheduledHandle reconnectTask;
    @Nullable
    private SynchronizationContext.ScheduledHandle shutdownDueToUpdateTask;
    @Nullable
    private ManagedClientTransport shutdownDueToUpdateTransport;
    private final Collection<ConnectionClientTransport> transports = new ArrayList<ConnectionClientTransport>();
    private final InUseStateAggregator<ConnectionClientTransport> inUseStateAggregator = new InUseStateAggregator<ConnectionClientTransport>(){

        @Override
        protected void handleInUse() {
            InternalSubchannel.this.callback.onInUse(InternalSubchannel.this);
        }

        @Override
        protected void handleNotInUse() {
            InternalSubchannel.this.callback.onNotInUse(InternalSubchannel.this);
        }
    };
    @Nullable
    private ConnectionClientTransport pendingTransport;
    @Nullable
    private volatile ManagedClientTransport activeTransport;
    private volatile ConnectivityStateInfo state = ConnectivityStateInfo.forNonError(ConnectivityState.IDLE);
    private Status shutdownReason;

    InternalSubchannel(List<EquivalentAddressGroup> addressGroups, String authority, String userAgent, BackoffPolicy.Provider backoffPolicyProvider, ClientTransportFactory transportFactory, ScheduledExecutorService scheduledExecutor, Supplier<Stopwatch> stopwatchSupplier, SynchronizationContext syncContext, Callback callback, InternalChannelz channelz, CallTracer callsTracer, ChannelTracer channelTracer, InternalLogId logId, ChannelLogger channelLogger) {
        Preconditions.checkNotNull(addressGroups, "addressGroups");
        Preconditions.checkArgument(!addressGroups.isEmpty(), "addressGroups is empty");
        InternalSubchannel.checkListHasNoNulls(addressGroups, "addressGroups contains null entry");
        List<EquivalentAddressGroup> unmodifiableAddressGroups = Collections.unmodifiableList(new ArrayList<EquivalentAddressGroup>(addressGroups));
        this.addressGroups = unmodifiableAddressGroups;
        this.addressIndex = new Index(unmodifiableAddressGroups);
        this.authority = authority;
        this.userAgent = userAgent;
        this.backoffPolicyProvider = backoffPolicyProvider;
        this.transportFactory = transportFactory;
        this.scheduledExecutor = scheduledExecutor;
        this.connectingTimer = stopwatchSupplier.get();
        this.syncContext = syncContext;
        this.callback = callback;
        this.channelz = channelz;
        this.callsTracer = callsTracer;
        this.channelTracer = Preconditions.checkNotNull(channelTracer, "channelTracer");
        this.logId = Preconditions.checkNotNull(logId, "logId");
        this.channelLogger = Preconditions.checkNotNull(channelLogger, "channelLogger");
    }

    ChannelLogger getChannelLogger() {
        return this.channelLogger;
    }

    @Override
    public ClientTransport obtainActiveTransport() {
        ManagedClientTransport savedTransport = this.activeTransport;
        if (savedTransport != null) {
            return savedTransport;
        }
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (InternalSubchannel.this.state.getState() == ConnectivityState.IDLE) {
                    InternalSubchannel.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "CONNECTING as requested");
                    InternalSubchannel.this.gotoNonErrorState(ConnectivityState.CONNECTING);
                    InternalSubchannel.this.startNewTransport();
                }
            }
        });
        return null;
    }

    @Nullable
    ClientTransport getTransport() {
        return this.activeTransport;
    }

    String getAuthority() {
        return this.authority;
    }

    private void startNewTransport() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        Preconditions.checkState(this.reconnectTask == null, "Should have no reconnectTask scheduled");
        if (this.addressIndex.isAtBeginning()) {
            this.connectingTimer.reset().start();
        }
        SocketAddress address = this.addressIndex.getCurrentAddress();
        HttpConnectProxiedSocketAddress proxiedAddr = null;
        if (address instanceof HttpConnectProxiedSocketAddress) {
            proxiedAddr = (HttpConnectProxiedSocketAddress)address;
            address = proxiedAddr.getTargetAddress();
        }
        Attributes currentEagAttributes = this.addressIndex.getCurrentEagAttributes();
        String eagChannelAuthority = currentEagAttributes.get(EquivalentAddressGroup.ATTR_AUTHORITY_OVERRIDE);
        ClientTransportFactory.ClientTransportOptions options = new ClientTransportFactory.ClientTransportOptions().setAuthority(eagChannelAuthority != null ? eagChannelAuthority : this.authority).setEagAttributes(currentEagAttributes).setUserAgent(this.userAgent).setHttpConnectProxiedSocketAddress(proxiedAddr);
        TransportLogger transportLogger = new TransportLogger();
        transportLogger.logId = this.getLogId();
        CallTracingTransport transport = new CallTracingTransport(this.transportFactory.newClientTransport(address, options, transportLogger), this.callsTracer);
        transportLogger.logId = transport.getLogId();
        this.channelz.addClientSocket(transport);
        this.pendingTransport = transport;
        this.transports.add(transport);
        Runnable runnable = transport.start(new TransportListener(transport, address));
        if (runnable != null) {
            this.syncContext.executeLater(runnable);
        }
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Started transport {0}", transportLogger.logId);
    }

    private void scheduleBackoff(Status status) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        this.gotoState(ConnectivityStateInfo.forTransientFailure(status));
        if (this.reconnectPolicy == null) {
            this.reconnectPolicy = this.backoffPolicyProvider.get();
        }
        long delayNanos = this.reconnectPolicy.nextBackoffNanos() - this.connectingTimer.elapsed(TimeUnit.NANOSECONDS);
        this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "TRANSIENT_FAILURE ({0}). Will reconnect after {1} ns", this.printShortStatus(status), delayNanos);
        Preconditions.checkState(this.reconnectTask == null, "previous reconnectTask is not done");
        class EndOfCurrentBackoff
        implements Runnable {
            EndOfCurrentBackoff() {
            }

            @Override
            public void run() {
                InternalSubchannel.this.reconnectTask = null;
                InternalSubchannel.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "CONNECTING after backoff");
                InternalSubchannel.this.gotoNonErrorState(ConnectivityState.CONNECTING);
                InternalSubchannel.this.startNewTransport();
            }
        }
        this.reconnectTask = this.syncContext.schedule(new EndOfCurrentBackoff(), delayNanos, TimeUnit.NANOSECONDS, this.scheduledExecutor);
    }

    void resetConnectBackoff() {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (InternalSubchannel.this.state.getState() != ConnectivityState.TRANSIENT_FAILURE) {
                    return;
                }
                InternalSubchannel.this.cancelReconnectTask();
                InternalSubchannel.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "CONNECTING; backoff interrupted");
                InternalSubchannel.this.gotoNonErrorState(ConnectivityState.CONNECTING);
                InternalSubchannel.this.startNewTransport();
            }
        });
    }

    private void gotoNonErrorState(ConnectivityState newState) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        this.gotoState(ConnectivityStateInfo.forNonError(newState));
    }

    private void gotoState(ConnectivityStateInfo newState) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.state.getState() != newState.getState()) {
            Preconditions.checkState(this.state.getState() != ConnectivityState.SHUTDOWN, "Cannot transition out of SHUTDOWN to " + newState);
            this.state = newState;
            this.callback.onStateChange(this, newState);
        }
    }

    public void updateAddresses(List<EquivalentAddressGroup> newAddressGroups) {
        Preconditions.checkNotNull(newAddressGroups, "newAddressGroups");
        InternalSubchannel.checkListHasNoNulls(newAddressGroups, "newAddressGroups contains null entry");
        Preconditions.checkArgument(!newAddressGroups.isEmpty(), "newAddressGroups is empty");
        final List<EquivalentAddressGroup> newImmutableAddressGroups = Collections.unmodifiableList(new ArrayList<EquivalentAddressGroup>(newAddressGroups));
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ManagedClientTransport savedTransport = null;
                SocketAddress previousAddress = InternalSubchannel.this.addressIndex.getCurrentAddress();
                InternalSubchannel.this.addressIndex.updateGroups(newImmutableAddressGroups);
                InternalSubchannel.this.addressGroups = newImmutableAddressGroups;
                if (!(InternalSubchannel.this.state.getState() != ConnectivityState.READY && InternalSubchannel.this.state.getState() != ConnectivityState.CONNECTING || InternalSubchannel.this.addressIndex.seekTo(previousAddress))) {
                    if (InternalSubchannel.this.state.getState() == ConnectivityState.READY) {
                        savedTransport = InternalSubchannel.this.activeTransport;
                        InternalSubchannel.this.activeTransport = null;
                        InternalSubchannel.this.addressIndex.reset();
                        InternalSubchannel.this.gotoNonErrorState(ConnectivityState.IDLE);
                    } else {
                        InternalSubchannel.this.pendingTransport.shutdown(Status.UNAVAILABLE.withDescription("InternalSubchannel closed pending transport due to address change"));
                        InternalSubchannel.this.pendingTransport = null;
                        InternalSubchannel.this.addressIndex.reset();
                        InternalSubchannel.this.startNewTransport();
                    }
                }
                if (savedTransport != null) {
                    if (InternalSubchannel.this.shutdownDueToUpdateTask != null) {
                        InternalSubchannel.this.shutdownDueToUpdateTransport.shutdown(Status.UNAVAILABLE.withDescription("InternalSubchannel closed transport early due to address change"));
                        InternalSubchannel.this.shutdownDueToUpdateTask.cancel();
                        InternalSubchannel.this.shutdownDueToUpdateTask = null;
                        InternalSubchannel.this.shutdownDueToUpdateTransport = null;
                    }
                    InternalSubchannel.this.shutdownDueToUpdateTransport = savedTransport;
                    InternalSubchannel.this.shutdownDueToUpdateTask = InternalSubchannel.this.syncContext.schedule(new Runnable(){

                        @Override
                        public void run() {
                            ManagedClientTransport transport = InternalSubchannel.this.shutdownDueToUpdateTransport;
                            InternalSubchannel.this.shutdownDueToUpdateTask = null;
                            InternalSubchannel.this.shutdownDueToUpdateTransport = null;
                            transport.shutdown(Status.UNAVAILABLE.withDescription("InternalSubchannel closed transport due to address change"));
                        }
                    }, 5L, TimeUnit.SECONDS, InternalSubchannel.this.scheduledExecutor);
                }
            }
        });
    }

    public void shutdown(final Status reason) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (InternalSubchannel.this.state.getState() == ConnectivityState.SHUTDOWN) {
                    return;
                }
                InternalSubchannel.this.shutdownReason = reason;
                ManagedClientTransport savedActiveTransport = InternalSubchannel.this.activeTransport;
                ConnectionClientTransport savedPendingTransport = InternalSubchannel.this.pendingTransport;
                InternalSubchannel.this.activeTransport = null;
                InternalSubchannel.this.pendingTransport = null;
                InternalSubchannel.this.gotoNonErrorState(ConnectivityState.SHUTDOWN);
                InternalSubchannel.this.addressIndex.reset();
                if (InternalSubchannel.this.transports.isEmpty()) {
                    InternalSubchannel.this.handleTermination();
                }
                InternalSubchannel.this.cancelReconnectTask();
                if (InternalSubchannel.this.shutdownDueToUpdateTask != null) {
                    InternalSubchannel.this.shutdownDueToUpdateTask.cancel();
                    InternalSubchannel.this.shutdownDueToUpdateTransport.shutdown(reason);
                    InternalSubchannel.this.shutdownDueToUpdateTask = null;
                    InternalSubchannel.this.shutdownDueToUpdateTransport = null;
                }
                if (savedActiveTransport != null) {
                    savedActiveTransport.shutdown(reason);
                }
                if (savedPendingTransport != null) {
                    savedPendingTransport.shutdown(reason);
                }
            }
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("logId", this.logId.getId()).add("addressGroups", this.addressGroups).toString();
    }

    private void handleTermination() {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                InternalSubchannel.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "Terminated");
                InternalSubchannel.this.callback.onTerminated(InternalSubchannel.this);
            }
        });
    }

    private void handleTransportInUseState(final ConnectionClientTransport transport, final boolean inUse) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                InternalSubchannel.this.inUseStateAggregator.updateObjectInUse(transport, inUse);
            }
        });
    }

    void shutdownNow(final Status reason) {
        this.shutdown(reason);
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ArrayList transportsCopy = new ArrayList(InternalSubchannel.this.transports);
                for (ManagedClientTransport transport : transportsCopy) {
                    transport.shutdownNow(reason);
                }
            }
        });
    }

    List<EquivalentAddressGroup> getAddressGroups() {
        return this.addressGroups;
    }

    private void cancelReconnectTask() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.reconnectTask != null) {
            this.reconnectTask.cancel();
            this.reconnectTask = null;
            this.reconnectPolicy = null;
        }
    }

    @Override
    public InternalLogId getLogId() {
        return this.logId;
    }

    @Override
    public ListenableFuture<InternalChannelz.ChannelStats> getStats() {
        final SettableFuture<InternalChannelz.ChannelStats> channelStatsFuture = SettableFuture.create();
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                InternalChannelz.ChannelStats.Builder builder = new InternalChannelz.ChannelStats.Builder();
                List<EquivalentAddressGroup> addressGroupsSnapshot = InternalSubchannel.this.addressIndex.getGroups();
                ArrayList<InternalWithLogId> transportsSnapshot = new ArrayList<InternalWithLogId>(InternalSubchannel.this.transports);
                builder.setTarget(addressGroupsSnapshot.toString()).setState(InternalSubchannel.this.getState());
                builder.setSockets(transportsSnapshot);
                InternalSubchannel.this.callsTracer.updateBuilder(builder);
                InternalSubchannel.this.channelTracer.updateBuilder(builder);
                channelStatsFuture.set(builder.build());
            }
        });
        return channelStatsFuture;
    }

    ConnectivityState getState() {
        return this.state.getState();
    }

    private static void checkListHasNoNulls(List<?> list, String msg) {
        for (Object item : list) {
            Preconditions.checkNotNull(item, msg);
        }
    }

    private String printShortStatus(Status status) {
        StringBuilder buffer = new StringBuilder();
        buffer.append((Object)status.getCode());
        if (status.getDescription() != null) {
            buffer.append("(").append(status.getDescription()).append(")");
        }
        return buffer.toString();
    }

    @VisibleForTesting
    static final class TransportLogger
    extends ChannelLogger {
        InternalLogId logId;

        TransportLogger() {
        }

        @Override
        public void log(ChannelLogger.ChannelLogLevel level, String message) {
            ChannelLoggerImpl.logOnly(this.logId, level, message);
        }

        @Override
        public void log(ChannelLogger.ChannelLogLevel level, String messageFormat, Object ... args) {
            ChannelLoggerImpl.logOnly(this.logId, level, messageFormat, args);
        }
    }

    @VisibleForTesting
    static final class Index {
        private List<EquivalentAddressGroup> addressGroups;
        private int groupIndex;
        private int addressIndex;

        public Index(List<EquivalentAddressGroup> groups) {
            this.addressGroups = groups;
        }

        public boolean isValid() {
            return this.groupIndex < this.addressGroups.size();
        }

        public boolean isAtBeginning() {
            return this.groupIndex == 0 && this.addressIndex == 0;
        }

        public void increment() {
            EquivalentAddressGroup group = this.addressGroups.get(this.groupIndex);
            ++this.addressIndex;
            if (this.addressIndex >= group.getAddresses().size()) {
                ++this.groupIndex;
                this.addressIndex = 0;
            }
        }

        public void reset() {
            this.groupIndex = 0;
            this.addressIndex = 0;
        }

        public SocketAddress getCurrentAddress() {
            return this.addressGroups.get(this.groupIndex).getAddresses().get(this.addressIndex);
        }

        public Attributes getCurrentEagAttributes() {
            return this.addressGroups.get(this.groupIndex).getAttributes();
        }

        public List<EquivalentAddressGroup> getGroups() {
            return this.addressGroups;
        }

        public void updateGroups(List<EquivalentAddressGroup> newGroups) {
            this.addressGroups = newGroups;
            this.reset();
        }

        public boolean seekTo(SocketAddress needle) {
            for (int i = 0; i < this.addressGroups.size(); ++i) {
                EquivalentAddressGroup group = this.addressGroups.get(i);
                int j = group.getAddresses().indexOf(needle);
                if (j == -1) continue;
                this.groupIndex = i;
                this.addressIndex = j;
                return true;
            }
            return false;
        }
    }

    @VisibleForTesting
    static final class CallTracingTransport
    extends ForwardingConnectionClientTransport {
        private final ConnectionClientTransport delegate;
        private final CallTracer callTracer;

        private CallTracingTransport(ConnectionClientTransport delegate, CallTracer callTracer) {
            this.delegate = delegate;
            this.callTracer = callTracer;
        }

        @Override
        protected ConnectionClientTransport delegate() {
            return this.delegate;
        }

        @Override
        public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
            final ClientStream streamDelegate = super.newStream(method, headers, callOptions, tracers);
            return new ForwardingClientStream(){

                @Override
                protected ClientStream delegate() {
                    return streamDelegate;
                }

                @Override
                public void start(final ClientStreamListener listener) {
                    CallTracingTransport.this.callTracer.reportCallStarted();
                    super.start(new ForwardingClientStreamListener(){

                        @Override
                        protected ClientStreamListener delegate() {
                            return listener;
                        }

                        @Override
                        public void closed(Status status, ClientStreamListener.RpcProgress rpcProgress, Metadata trailers) {
                            CallTracingTransport.this.callTracer.reportCallEnded(status.isOk());
                            super.closed(status, rpcProgress, trailers);
                        }
                    });
                }
            };
        }
    }

    static abstract class Callback {
        Callback() {
        }

        @ForOverride
        void onTerminated(InternalSubchannel is) {
        }

        @ForOverride
        void onStateChange(InternalSubchannel is, ConnectivityStateInfo newState) {
        }

        @ForOverride
        void onInUse(InternalSubchannel is) {
        }

        @ForOverride
        void onNotInUse(InternalSubchannel is) {
        }
    }

    private class TransportListener
    implements ManagedClientTransport.Listener {
        final ConnectionClientTransport transport;
        final SocketAddress address;
        boolean shutdownInitiated = false;

        TransportListener(ConnectionClientTransport transport, SocketAddress address) {
            this.transport = transport;
            this.address = address;
        }

        @Override
        public void transportReady() {
            InternalSubchannel.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "READY");
            InternalSubchannel.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    InternalSubchannel.this.reconnectPolicy = null;
                    if (InternalSubchannel.this.shutdownReason != null) {
                        Preconditions.checkState(InternalSubchannel.this.activeTransport == null, "Unexpected non-null activeTransport");
                        TransportListener.this.transport.shutdown(InternalSubchannel.this.shutdownReason);
                    } else if (InternalSubchannel.this.pendingTransport == TransportListener.this.transport) {
                        InternalSubchannel.this.activeTransport = TransportListener.this.transport;
                        InternalSubchannel.this.pendingTransport = null;
                        InternalSubchannel.this.gotoNonErrorState(ConnectivityState.READY);
                    }
                }
            });
        }

        @Override
        public void transportInUse(boolean inUse) {
            InternalSubchannel.this.handleTransportInUseState(this.transport, inUse);
        }

        @Override
        public void transportShutdown(final Status s) {
            InternalSubchannel.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "{0} SHUTDOWN with {1}", this.transport.getLogId(), InternalSubchannel.this.printShortStatus(s));
            this.shutdownInitiated = true;
            InternalSubchannel.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    if (InternalSubchannel.this.state.getState() == ConnectivityState.SHUTDOWN) {
                        return;
                    }
                    if (InternalSubchannel.this.activeTransport == TransportListener.this.transport) {
                        InternalSubchannel.this.activeTransport = null;
                        InternalSubchannel.this.addressIndex.reset();
                        InternalSubchannel.this.gotoNonErrorState(ConnectivityState.IDLE);
                    } else if (InternalSubchannel.this.pendingTransport == TransportListener.this.transport) {
                        Preconditions.checkState(InternalSubchannel.this.state.getState() == ConnectivityState.CONNECTING, "Expected state is CONNECTING, actual state is %s", (Object)InternalSubchannel.this.state.getState());
                        InternalSubchannel.this.addressIndex.increment();
                        if (!InternalSubchannel.this.addressIndex.isValid()) {
                            InternalSubchannel.this.pendingTransport = null;
                            InternalSubchannel.this.addressIndex.reset();
                            InternalSubchannel.this.scheduleBackoff(s);
                        } else {
                            InternalSubchannel.this.startNewTransport();
                        }
                    }
                }
            });
        }

        @Override
        public void transportTerminated() {
            Preconditions.checkState(this.shutdownInitiated, "transportShutdown() must be called before transportTerminated().");
            InternalSubchannel.this.channelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "{0} Terminated", this.transport.getLogId());
            InternalSubchannel.this.channelz.removeClientSocket(this.transport);
            InternalSubchannel.this.handleTransportInUseState(this.transport, false);
            InternalSubchannel.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    InternalSubchannel.this.transports.remove(TransportListener.this.transport);
                    if (InternalSubchannel.this.state.getState() == ConnectivityState.SHUTDOWN && InternalSubchannel.this.transports.isEmpty()) {
                        InternalSubchannel.this.handleTermination();
                    }
                }
            });
        }
    }
}

