/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dorisbulkloader;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.pipeline.transforms.dorisbulkloader.DorisStreamLoadException;
import org.apache.hop.pipeline.transforms.dorisbulkloader.RecordStream;
import org.apache.hop.pipeline.transforms.dorisbulkloader.ResponseContent;
import org.apache.hop.pipeline.transforms.dorisbulkloader.StreamLoadProperty;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class DorisStreamLoad {
    private static final byte[] JSON_ARRAY_START = "[".getBytes(StandardCharsets.UTF_8);
    private static final byte[] JSON_ARRAY_END = "]".getBytes(StandardCharsets.UTF_8);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String loadUrl;
    private String loginUser;
    private String loginPassword;
    private Map<String, String> httpHeaders;
    private String format;
    private final byte[] lineDelimiter;
    private CloseableHttpClient httpClient;
    private final RecordStream recordStream;
    private boolean loadBatchFirstRecord;

    public DorisStreamLoad(StreamLoadProperty streamLoadProperty) {
        this.loadUrl = String.format("http://%s:%s/api/%s/%s/_stream_load", streamLoadProperty.getFeHost(), streamLoadProperty.getFeHttpPort(), streamLoadProperty.getDatabaseName(), streamLoadProperty.getTableName());
        this.loginUser = streamLoadProperty.getLoginUser();
        this.loginPassword = streamLoadProperty.getLoginPassword();
        this.httpHeaders = streamLoadProperty.getHttpHeaders();
        this.format = this.httpHeaders.get("format");
        this.lineDelimiter = "json".equals(this.format) ? ",".getBytes() : this.httpHeaders.get("line_delimiter").getBytes();
        this.recordStream = new RecordStream(streamLoadProperty.getBufferSize(), streamLoadProperty.getBufferCount());
        this.loadBatchFirstRecord = true;
    }

    public void startWritingIntoBuffer() throws IOException {
        this.loadBatchFirstRecord = true;
        this.recordStream.startInput();
        if ("json".equals(this.format)) {
            this.recordStream.write(JSON_ARRAY_START);
        }
    }

    public void writeRecord(byte[] record) throws IOException {
        if (this.loadBatchFirstRecord) {
            this.loadBatchFirstRecord = false;
        } else {
            this.recordStream.write(this.lineDelimiter);
        }
        this.recordStream.write(record);
    }

    public boolean canWrite(long writeLength) {
        if ("json".equals(this.format)) {
            ++writeLength;
        }
        return this.recordStream.canWrite(writeLength);
    }

    public void endWritingIntoBuffer() throws IOException, InterruptedException {
        if ("json".equals(this.format)) {
            this.recordStream.write(JSON_ARRAY_END);
        }
        this.recordStream.endInput();
    }

    public ResponseContent executeDorisStreamLoad() throws IOException, DorisStreamLoadException {
        CloseableHttpResponse response;
        int statusCode;
        HttpPut put = new HttpPut(this.loadUrl);
        put.setHeader("Expect", "100-continue");
        put.setHeader("Authorization", this.basicAuthHeader(this.loginUser, this.loginPassword));
        put.setHeader("label", "HopDorisBulkLoad" + UUID.randomUUID().toString());
        if ("json".equals(this.format)) {
            put.setHeader("strip_outer_array", "true");
        }
        this.httpHeaders.forEach((arg_0, arg_1) -> ((HttpPut)put).setHeader(arg_0, arg_1));
        InputStreamEntity entity = new InputStreamEntity((InputStream)this.recordStream, this.recordStream.getWriteLength());
        entity.setChunked(false);
        put.setEntity((HttpEntity)entity);
        if (this.httpClient == null) {
            this.httpClient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

                protected boolean isRedirectable(String method) {
                    return true;
                }
            }).build();
        }
        if ((statusCode = (response = this.httpClient.execute((HttpUriRequest)put)).getStatusLine().getStatusCode()) == 200 && response.getEntity() != null) {
            String loadResult = EntityUtils.toString((HttpEntity)response.getEntity());
            return (ResponseContent)OBJECT_MAPPER.readValue(loadResult, ResponseContent.class);
        }
        throw new DorisStreamLoadException("stream load error: " + response.getStatusLine().toString());
    }

    public void clearRecordStream() throws InterruptedException {
        this.recordStream.clearRecordStream();
    }

    public void close() throws IOException {
        if (null != this.httpClient) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                throw new IOException("Closing httpClient failed.", e);
            }
        }
    }

    private String basicAuthHeader(String username, String password) {
        String tobeEncode = username + ":" + Encr.decryptPasswordOptionallyEncrypted((String)password);
        byte[] encoded = Base64.encodeBase64((byte[])tobeEncode.getBytes(StandardCharsets.UTF_8));
        return "Basic " + new String(encoded);
    }
}

