/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.jdk8;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.IgnoreJDK6Requirement;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalQueries;
import java.util.List;

@IgnoreJDK6Requirement
public class ZonedDateTimeCodec
extends TypeCodec.AbstractTupleCodec<ZonedDateTime> {
    private static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter DEFAULT_ZONE_FORMATTER = new DateTimeFormatterBuilder().appendZoneOrOffsetId().toFormatter();
    private final DateTimeFormatter dateTimeFormatter;
    private final DateTimeFormatter zoneFormatter;

    public ZonedDateTimeCodec(TupleType tupleType) {
        this(tupleType, DEFAULT_DATE_TIME_FORMATTER, DEFAULT_ZONE_FORMATTER);
    }

    public ZonedDateTimeCodec(TupleType tupleType, DateTimeFormatter dateTimeFormatter, DateTimeFormatter zoneFormatter) {
        super(tupleType, ZonedDateTime.class);
        this.dateTimeFormatter = dateTimeFormatter;
        this.zoneFormatter = zoneFormatter;
        List types = tupleType.getComponentTypes();
        Preconditions.checkArgument((types.size() == 2 && ((DataType)types.get(0)).equals(DataType.timestamp()) && ((DataType)types.get(1)).equals(DataType.varchar()) ? 1 : 0) != 0, (String)"Expected tuple<timestamp,varchar>, got %s", (Object[])new Object[]{tupleType});
    }

    protected ZonedDateTime newInstance() {
        return null;
    }

    protected ByteBuffer serializeField(ZonedDateTime source, int index, ProtocolVersion protocolVersion) {
        if (index == 0) {
            long millis = source.toInstant().toEpochMilli();
            return ZonedDateTimeCodec.bigint().serializeNoBoxing(millis, protocolVersion);
        }
        if (index == 1) {
            return ZonedDateTimeCodec.varchar().serialize((Object)this.zoneFormatter.format(source), protocolVersion);
        }
        throw new IndexOutOfBoundsException("Tuple index out of bounds. " + index);
    }

    protected ZonedDateTime deserializeAndSetField(ByteBuffer input, ZonedDateTime target, int index, ProtocolVersion protocolVersion) {
        if (index == 0) {
            long millis = ZonedDateTimeCodec.bigint().deserializeNoBoxing(input, protocolVersion);
            return Instant.ofEpochMilli(millis).atZone(ZoneOffset.UTC);
        }
        if (index == 1) {
            String zoneId = (String)ZonedDateTimeCodec.varchar().deserialize(input, protocolVersion);
            return target.withZoneSameInstant(this.zoneFormatter.parse((CharSequence)zoneId, TemporalQueries.zone()));
        }
        throw new IndexOutOfBoundsException("Tuple index out of bounds. " + index);
    }

    protected String formatField(ZonedDateTime value, int index) {
        if (index == 0) {
            return ParseUtils.quote((String)this.dateTimeFormatter.format(value));
        }
        if (index == 1) {
            return ParseUtils.quote((String)this.zoneFormatter.format(value));
        }
        throw new IndexOutOfBoundsException("Tuple index out of bounds. " + index);
    }

    protected ZonedDateTime parseAndSetField(String input, ZonedDateTime target, int index) {
        if (index == 0) {
            if (ParseUtils.isQuoted((String)input)) {
                input = ParseUtils.unquote((String)input);
            }
            if (ParseUtils.isLongLiteral((String)input)) {
                try {
                    long millis = Long.parseLong(input);
                    return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
                }
                catch (NumberFormatException e) {
                    throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", input));
                }
            }
            try {
                return ZonedDateTime.from(this.dateTimeFormatter.parse(input));
            }
            catch (DateTimeParseException e) {
                throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", target));
            }
        }
        if (index == 1) {
            String zoneId = (String)ZonedDateTimeCodec.varchar().parse(input);
            return target.withZoneSameInstant(this.zoneFormatter.parse((CharSequence)zoneId, TemporalQueries.zone()));
        }
        throw new IndexOutOfBoundsException("Tuple index out of bounds. " + index);
    }
}

