/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.InMemoryBundleFinalizer;
import org.apache.beam.runners.core.NullSideInputReader;
import org.apache.beam.runners.core.ProcessFnRunner;
import org.apache.beam.runners.core.PushbackSideInputDoFnRunner;
import org.apache.beam.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.runners.core.SideInputHandler;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.SimplePushbackSideInputDoFnRunner;
import org.apache.beam.runners.core.SplittableParDoViaKeyedWorkItems;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.StatefulDoFnRunner;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.metrics.DoFnRunnerWithMetricsUpdate;
import org.apache.beam.runners.flink.metrics.FlinkMetricContainer;
import org.apache.beam.runners.flink.translation.types.CoderTypeSerializer;
import org.apache.beam.runners.flink.translation.utils.CheckpointStats;
import org.apache.beam.runners.flink.translation.utils.Workarounds;
import org.apache.beam.runners.flink.translation.wrappers.streaming.AbstractStreamOperatorCompat;
import org.apache.beam.runners.flink.translation.wrappers.streaming.KeyedPushedBackElementsHandler;
import org.apache.beam.runners.flink.translation.wrappers.streaming.NonKeyedPushedBackElementsHandler;
import org.apache.beam.runners.flink.translation.wrappers.streaming.PushedBackElementsHandler;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferingDoFnRunner;
import org.apache.beam.runners.flink.translation.wrappers.streaming.state.FlinkBroadcastStateInternals;
import org.apache.beam.runners.flink.translation.wrappers.streaming.state.FlinkStateInternals;
import org.apache.beam.runners.fnexecution.control.BundleCheckpointHandlers;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.StateBinder;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.NoopLock;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.state.InternalPriorityQueue;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.OutputTag;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public class DoFnOperator<InputT, OutputT>
extends AbstractStreamOperatorCompat<WindowedValue<OutputT>>
implements OneInputStreamOperator<WindowedValue<InputT>, WindowedValue<OutputT>>,
TwoInputStreamOperator<WindowedValue<InputT>, RawUnionValue, WindowedValue<OutputT>>,
Triggerable<ByteBuffer, TimerInternals.TimerData> {
    private static final Logger LOG = LoggerFactory.getLogger(DoFnOperator.class);
    protected DoFn<InputT, OutputT> doFn;
    protected final SerializablePipelineOptions serializedOptions;
    protected final TupleTag<OutputT> mainOutputTag;
    protected final List<TupleTag<?>> additionalOutputTags;
    protected final Collection<PCollectionView<?>> sideInputs;
    protected final Map<Integer, PCollectionView<?>> sideInputTagMapping;
    protected final WindowingStrategy<?, ?> windowingStrategy;
    protected final OutputManagerFactory<OutputT> outputManagerFactory;
    protected transient DoFnRunner<InputT, OutputT> doFnRunner;
    protected transient PushbackSideInputDoFnRunner<InputT, OutputT> pushbackDoFnRunner;
    protected transient BufferingDoFnRunner<InputT, OutputT> bufferingDoFnRunner;
    protected transient SideInputHandler sideInputHandler;
    protected transient SideInputReader sideInputReader;
    protected transient BufferedOutputManager<OutputT> outputManager;
    private transient DoFnInvoker<InputT, OutputT> doFnInvoker;
    protected transient FlinkStateInternals<?> keyedStateInternals;
    protected transient FlinkTimerInternals timerInternals;
    protected final String stepName;
    private final Coder<WindowedValue<InputT>> windowedInputCoder;
    private final Map<TupleTag<?>, Coder<?>> outputCoders;
    protected final Coder<?> keyCoder;
    final KeySelector<WindowedValue<InputT>, ?> keySelector;
    private final TimerInternals.TimerDataCoderV2 timerCoder;
    private final long maxBundleSize;
    private final long maxBundleTimeMills;
    private final DoFnSchemaInformation doFnSchemaInformation;
    private final Map<String, PCollectionView<?>> sideInputMapping;
    private final boolean requiresStableInput;
    private final boolean usesOnWindowExpiration;
    private final boolean finishBundleBeforeCheckpointing;
    private transient InMemoryBundleFinalizer bundleFinalizer;
    private transient LinkedHashMap<Long, List<InMemoryBundleFinalizer.Finalization>> pendingFinalizations;
    private static final int MAX_NUMBER_PENDING_BUNDLE_FINALIZATIONS = 32;
    protected transient InternalTimerService<TimerInternals.TimerData> timerService;
    private transient InternalTimeServiceManager<?> timeServiceManagerCompat;
    private transient PushedBackElementsHandler<WindowedValue<InputT>> pushedBackElementsHandler;
    transient @Nullable FlinkMetricContainer flinkMetricContainer;
    private transient @Nullable CheckpointStats checkpointStats;
    private transient ScheduledFuture<?> checkFinishBundleTimer;
    private volatile transient boolean bundleStarted;
    private volatile transient long elementCount;
    private volatile transient long lastFinishBundleTime;
    private volatile transient Runnable preBundleCallback;
    private volatile transient Runnable bundleFinishedCallback;
    private volatile transient long currentInputWatermark;
    private volatile transient long currentSideInputWatermark;
    private volatile transient long currentOutputWatermark;
    private volatile transient long pushedBackWatermark;

    public DoFnOperator(DoFn<InputT, OutputT> doFn, String stepName, Coder<WindowedValue<InputT>> inputWindowedCoder, Map<TupleTag<?>, Coder<?>> outputCoders, TupleTag<OutputT> mainOutputTag, List<TupleTag<?>> additionalOutputTags, OutputManagerFactory<OutputT> outputManagerFactory, WindowingStrategy<?, ?> windowingStrategy, Map<Integer, PCollectionView<?>> sideInputTagMapping, Collection<PCollectionView<?>> sideInputs, PipelineOptions options, Coder<?> keyCoder, KeySelector<WindowedValue<InputT>, ?> keySelector, DoFnSchemaInformation doFnSchemaInformation, Map<String, PCollectionView<?>> sideInputMapping) {
        this.doFn = doFn;
        this.stepName = stepName;
        this.windowedInputCoder = inputWindowedCoder;
        this.outputCoders = outputCoders;
        this.mainOutputTag = mainOutputTag;
        this.additionalOutputTags = additionalOutputTags;
        this.sideInputTagMapping = sideInputTagMapping;
        this.sideInputs = sideInputs;
        this.serializedOptions = new SerializablePipelineOptions(options);
        this.windowingStrategy = windowingStrategy;
        this.outputManagerFactory = outputManagerFactory;
        this.setChainingStrategy(ChainingStrategy.ALWAYS);
        this.keyCoder = keyCoder;
        this.keySelector = keySelector;
        this.timerCoder = TimerInternals.TimerDataCoderV2.of((Coder)windowingStrategy.getWindowFn().windowCoder());
        FlinkPipelineOptions flinkOptions = (FlinkPipelineOptions)options.as(FlinkPipelineOptions.class);
        this.maxBundleSize = flinkOptions.getMaxBundleSize();
        Preconditions.checkArgument((this.maxBundleSize > 0L ? 1 : 0) != 0, (Object)"Bundle size must be at least 1");
        this.maxBundleTimeMills = flinkOptions.getMaxBundleTimeMills();
        Preconditions.checkArgument((this.maxBundleTimeMills > 0L ? 1 : 0) != 0, (Object)"Bundle time must be at least 1");
        this.doFnSchemaInformation = doFnSchemaInformation;
        this.sideInputMapping = sideInputMapping;
        this.requiresStableInput = doFn != null && DoFnSignatures.getSignature(doFn.getClass()).processElement().requiresStableInput();
        boolean bl = this.usesOnWindowExpiration = doFn != null && DoFnSignatures.getSignature(doFn.getClass()).onWindowExpiration() != null;
        if (this.requiresStableInput) {
            Preconditions.checkState((CheckpointingMode.valueOf((String)flinkOptions.getCheckpointingMode()) == CheckpointingMode.EXACTLY_ONCE ? 1 : 0) != 0, (Object)"Checkpointing mode is not set to exactly once but @RequiresStableInput is used.");
            Preconditions.checkState((flinkOptions.getCheckpointingInterval() > 0L ? 1 : 0) != 0, (Object)"No checkpointing configured but pipeline uses @RequiresStableInput");
            LOG.warn("Enabling stable input for transform {}. Will only process elements at most every {} milliseconds.", (Object)stepName, (Object)(flinkOptions.getCheckpointingInterval() + Math.max(0L, flinkOptions.getMinPauseBetweenCheckpoints())));
        }
        this.finishBundleBeforeCheckpointing = flinkOptions.getFinishBundleBeforeCheckpointing();
    }

    protected DoFn<InputT, OutputT> getDoFn() {
        return this.doFn;
    }

    protected DoFnRunner<InputT, OutputT> createWrappingDoFnRunner(DoFnRunner<InputT, OutputT> wrappedRunner, StepContext stepContext) {
        if (this.keyCoder != null) {
            StatefulDoFnRunner.TimeInternalsCleanupTimer cleanupTimer = new StatefulDoFnRunner.TimeInternalsCleanupTimer<InputT>(this.timerInternals, this.windowingStrategy){

                public void setForWindow(InputT input, BoundedWindow window) {
                    if (!window.equals(GlobalWindow.INSTANCE) || DoFnOperator.this.usesOnWindowExpiration) {
                        super.setForWindow(input, window);
                    }
                }
            };
            Coder windowCoder = this.windowingStrategy.getWindowFn().windowCoder();
            StatefulDoFnRunner.StateInternalsStateCleaner stateCleaner = new StatefulDoFnRunner.StateInternalsStateCleaner(this.doFn, this.keyedStateInternals, windowCoder);
            return DoFnRunners.defaultStatefulDoFnRunner(this.doFn, this.getInputCoder(), wrappedRunner, (StepContext)stepContext, this.windowingStrategy, (StatefulDoFnRunner.CleanupTimer)cleanupTimer, (StatefulDoFnRunner.StateCleaner)stateCleaner, (boolean)true);
        }
        return this.doFnRunner;
    }

    public void setup(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<WindowedValue<OutputT>>> output) {
        FileSystems.setDefaultPipelineOptions((PipelineOptions)this.serializedOptions.get());
        super.setup(containingTask, config, output);
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        ListStateDescriptor pushedBackStateDescriptor = new ListStateDescriptor("pushed-back-elements", new CoderTypeSerializer<WindowedValue<InputT>>(this.windowedInputCoder, this.serializedOptions));
        if (this.keySelector != null) {
            this.pushedBackElementsHandler = KeyedPushedBackElementsHandler.create(this.keySelector, this.getKeyedStateBackend(), pushedBackStateDescriptor);
        } else {
            ListState listState = this.getOperatorStateBackend().getListState(pushedBackStateDescriptor);
            this.pushedBackElementsHandler = NonKeyedPushedBackElementsHandler.create(listState);
        }
        this.currentInputWatermark = BoundedWindow.TIMESTAMP_MIN_VALUE.getMillis();
        this.currentSideInputWatermark = BoundedWindow.TIMESTAMP_MIN_VALUE.getMillis();
        this.currentOutputWatermark = BoundedWindow.TIMESTAMP_MIN_VALUE.getMillis();
        this.sideInputReader = NullSideInputReader.of(this.sideInputs);
        if (!this.sideInputs.isEmpty()) {
            long min;
            FlinkBroadcastStateInternals sideInputStateInternals = new FlinkBroadcastStateInternals(this.getContainingTask().getIndexInSubtaskGroup(), this.getOperatorStateBackend(), this.serializedOptions);
            this.sideInputHandler = new SideInputHandler(this.sideInputs, sideInputStateInternals);
            this.sideInputReader = this.sideInputHandler;
            Stream<WindowedValue<InputT>> pushedBack = this.pushedBackElementsHandler.getElements();
            this.pushedBackWatermark = min = pushedBack.map(v -> v.getTimestamp().getMillis()).reduce(Long.MAX_VALUE, Math::min).longValue();
        } else {
            this.pushedBackWatermark = Long.MAX_VALUE;
        }
        if (this.keyCoder != null) {
            this.keyedStateInternals = new FlinkStateInternals((KeyedStateBackend<ByteBuffer>)this.getKeyedStateBackend(), this.keyCoder, this.serializedOptions);
            if (this.timerService == null) {
                this.timerService = this.getInternalTimerService("beam-timer", new CoderTypeSerializer(this.timerCoder, this.serializedOptions), this);
            }
            this.timerInternals = new FlinkTimerInternals();
            this.timeServiceManagerCompat = this.getTimeServiceManagerCompat();
        }
        this.outputManager = this.outputManagerFactory.create(this.output, this.getLockToAcquireForStateAccessDuringBundles(), this.getOperatorStateBackend());
    }

    protected Lock getLockToAcquireForStateAccessDuringBundles() {
        return NoopLock.get();
    }

    public void open() throws Exception {
        this.doFn = this.getDoFn();
        FlinkPipelineOptions options = (FlinkPipelineOptions)this.serializedOptions.get().as(FlinkPipelineOptions.class);
        this.doFnInvoker = DoFnInvokers.tryInvokeSetupFor(this.doFn, (PipelineOptions)options);
        FlinkStepContext stepContext = new FlinkStepContext();
        this.doFnRunner = DoFnRunners.simpleRunner((PipelineOptions)options, this.doFn, (SideInputReader)this.sideInputReader, this.outputManager, this.mainOutputTag, this.additionalOutputTags, (StepContext)stepContext, this.getInputCoder(), this.outputCoders, this.windowingStrategy, (DoFnSchemaInformation)this.doFnSchemaInformation, this.sideInputMapping);
        if (this.requiresStableInput) {
            this.bufferingDoFnRunner = BufferingDoFnRunner.create(this.doFnRunner, "stable-input-buffer", this.windowedInputCoder, this.windowingStrategy.getWindowFn().windowCoder(), this.getOperatorStateBackend(), (KeyedStateBackend<Object>)this.getKeyedStateBackend(), options.getNumConcurrentCheckpoints(), this.serializedOptions);
            this.doFnRunner = this.bufferingDoFnRunner;
        }
        this.doFnRunner = this.createWrappingDoFnRunner(this.doFnRunner, stepContext);
        this.earlyBindStateIfNeeded();
        if (!options.getDisableMetrics().booleanValue()) {
            this.flinkMetricContainer = new FlinkMetricContainer((RuntimeContext)this.getRuntimeContext());
            this.doFnRunner = new DoFnRunnerWithMetricsUpdate<InputT, OutputT>(this.stepName, this.doFnRunner, this.flinkMetricContainer);
            String checkpointMetricNamespace = options.getReportCheckpointDuration();
            if (checkpointMetricNamespace != null) {
                MetricName checkpointMetric = MetricName.named((String)checkpointMetricNamespace, (String)"checkpoint_duration");
                this.checkpointStats = new CheckpointStats(() -> this.flinkMetricContainer.getMetricsContainer(this.stepName).getDistribution(checkpointMetric));
            }
        }
        this.elementCount = 0L;
        this.lastFinishBundleTime = this.getProcessingTimeService().getCurrentProcessingTime();
        long bundleCheckPeriod = Math.max(this.maxBundleTimeMills / 2L, 1L);
        this.checkFinishBundleTimer = this.getProcessingTimeService().scheduleAtFixedRate(timestamp -> this.checkInvokeFinishBundleByTime(), bundleCheckPeriod, bundleCheckPeriod);
        this.pushbackDoFnRunner = this.doFn instanceof SplittableParDoViaKeyedWorkItems.ProcessFn ? new ProcessFnRunner(this.doFnRunner, this.sideInputs, (ReadyCheckingSideInputReader)this.sideInputHandler) : SimplePushbackSideInputDoFnRunner.create(this.doFnRunner, this.sideInputs, (ReadyCheckingSideInputReader)this.sideInputHandler);
        this.bundleFinalizer = new InMemoryBundleFinalizer();
        this.pendingFinalizations = new LinkedHashMap();
    }

    private void earlyBindStateIfNeeded() throws IllegalArgumentException, IllegalAccessException {
        if (this.keyCoder != null && this.doFn != null) {
            DoFnSignature signature = DoFnSignatures.getSignature(this.doFn.getClass());
            FlinkStateInternals.EarlyBinder earlyBinder = new FlinkStateInternals.EarlyBinder(this.getKeyedStateBackend(), this.serializedOptions);
            for (DoFnSignature.StateDeclaration value : signature.stateDeclarations().values()) {
                StateSpec spec = (StateSpec)((DoFnSignature.StateDeclaration)signature.stateDeclarations().get(value.id())).field().get(this.doFn);
                spec.bind(value.id(), (StateBinder)earlyBinder);
            }
            if (this.doFnRunner instanceof StatefulDoFnRunner) {
                ((StatefulDoFnRunner)this.doFnRunner).getSystemStateTags().forEach(tag -> tag.getSpec().bind(tag.getId(), (StateBinder)earlyBinder));
            }
        }
    }

    @Override
    void cleanUp() throws Exception {
        Optional.ofNullable(this.flinkMetricContainer).ifPresent(FlinkMetricContainer::registerMetricsForPipelineResult);
        Optional.ofNullable(this.checkFinishBundleTimer).ifPresent(timer -> timer.cancel(true));
        Workarounds.deleteStaticCaches();
        Optional.ofNullable(this.doFnInvoker).ifPresent(DoFnInvoker::invokeTeardown);
    }

    @Override
    void flushData() throws Exception {
        List pushedBackElements;
        if (this.numProcessingTimeTimers() > 0) {
            this.timerInternals.processPendingProcessingTimeTimers();
        }
        if (this.numProcessingTimeTimers() > 0) {
            throw new RuntimeException("There are still " + this.numProcessingTimeTimers() + " processing-time timers left, this indicates a bug");
        }
        this.processWatermark(new Watermark(Long.MAX_VALUE));
        while (this.bundleStarted) {
            this.invokeFinishBundle();
        }
        if (this.currentOutputWatermark < Long.MAX_VALUE) {
            throw new RuntimeException("There are still watermark holds. Watermark held at " + this.currentOutputWatermark);
        }
        if (!this.sideInputs.isEmpty() && (pushedBackElements = this.pushedBackElementsHandler.getElements().collect(Collectors.toList())).size() > 0) {
            String pushedBackString = Joiner.on((String)",").join(pushedBackElements);
            throw new RuntimeException("Leftover pushed-back data: " + pushedBackString + ". This indicates a bug.");
        }
    }

    public long getEffectiveInputWatermark() {
        return Math.min(this.pushedBackWatermark, this.currentInputWatermark);
    }

    public long getCurrentOutputWatermark() {
        return this.currentOutputWatermark;
    }

    protected final void setPreBundleCallback(Runnable callback) {
        this.preBundleCallback = callback;
    }

    protected final void setBundleFinishedCallback(Runnable callback) {
        this.bundleFinishedCallback = callback;
    }

    public final void processElement(StreamRecord<WindowedValue<InputT>> streamRecord) {
        this.checkInvokeStartBundle();
        long oldHold = this.keyCoder != null ? this.keyedStateInternals.minWatermarkHoldMs() : -1L;
        this.doFnRunner.processElement((WindowedValue)streamRecord.getValue());
        this.checkInvokeFinishBundleByCount();
        this.emitWatermarkIfHoldChanged(oldHold);
    }

    public final void processElement1(StreamRecord<WindowedValue<InputT>> streamRecord) throws Exception {
        this.checkInvokeStartBundle();
        Iterable justPushedBack = this.pushbackDoFnRunner.processElementInReadyWindows((WindowedValue)streamRecord.getValue());
        long min = this.pushedBackWatermark;
        for (WindowedValue pushedBackValue : justPushedBack) {
            min = Math.min(min, pushedBackValue.getTimestamp().getMillis());
            this.pushedBackElementsHandler.pushBack(pushedBackValue);
        }
        this.pushedBackWatermark = min;
        this.checkInvokeFinishBundleByCount();
    }

    protected void addSideInputValue(StreamRecord<RawUnionValue> streamRecord) {
        WindowedValue value = (WindowedValue)((RawUnionValue)streamRecord.getValue()).getValue();
        PCollectionView<?> sideInput = this.sideInputTagMapping.get(((RawUnionValue)streamRecord.getValue()).getUnionTag());
        this.sideInputHandler.addSideInputValue(sideInput, value);
    }

    public final void processElement2(StreamRecord<RawUnionValue> streamRecord) throws Exception {
        this.invokeFinishBundle();
        this.checkInvokeStartBundle();
        this.addSideInputValue(streamRecord);
        ArrayList newPushedBack = new ArrayList();
        Iterator it = this.pushedBackElementsHandler.getElements().iterator();
        while (it.hasNext()) {
            WindowedValue element = (WindowedValue)it.next();
            this.setKeyContextElement1(new StreamRecord((Object)element));
            Iterable justPushedBack = this.pushbackDoFnRunner.processElementInReadyWindows(element);
            Iterables.addAll(newPushedBack, (Iterable)justPushedBack);
        }
        this.pushedBackElementsHandler.clear();
        long min = Long.MAX_VALUE;
        for (WindowedValue pushedBackValue : newPushedBack) {
            min = Math.min(min, pushedBackValue.getTimestamp().getMillis());
            this.pushedBackElementsHandler.pushBack(pushedBackValue);
        }
        this.pushedBackWatermark = min;
        this.checkInvokeFinishBundleByCount();
        this.processWatermark1(new Watermark(this.currentInputWatermark));
    }

    public final void processWatermark(Watermark mark) throws Exception {
        this.processWatermark1(mark);
    }

    public final void processWatermark1(Watermark mark) throws Exception {
        this.outputManager.flushBuffer();
        if (this.currentSideInputWatermark >= BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis()) {
            this.emitAllPushedBackData();
        }
        this.currentInputWatermark = mark.getTimestamp();
        this.processInputWatermark(true);
    }

    private void processInputWatermark(boolean advanceInputWatermark) throws Exception {
        long inputWatermarkHold = this.applyInputWatermarkHold(this.getEffectiveInputWatermark());
        if (this.keyCoder != null && advanceInputWatermark) {
            this.timeServiceManagerCompat.advanceWatermark(new Watermark(inputWatermarkHold));
        }
        long potentialOutputWatermark = this.applyOutputWatermarkHold(this.currentOutputWatermark, this.computeOutputWatermark(inputWatermarkHold));
        this.maybeEmitWatermark(potentialOutputWatermark);
    }

    public long applyInputWatermarkHold(long inputWatermark) {
        return inputWatermark;
    }

    public long applyOutputWatermarkHold(long currentOutputWatermark, long potentialOutputWatermark) {
        return potentialOutputWatermark;
    }

    private long computeOutputWatermark(long inputWatermarkHold) {
        long potentialOutputWatermark = this.keyCoder == null ? inputWatermarkHold : Math.min(this.keyedStateInternals.minWatermarkHoldMs(), inputWatermarkHold);
        return potentialOutputWatermark;
    }

    private void maybeEmitWatermark(long watermark) {
        if (watermark > this.currentOutputWatermark) {
            if (watermark >= BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis()) {
                this.invokeFinishBundle();
            }
            LOG.debug("Emitting watermark {}", (Object)watermark);
            this.currentOutputWatermark = watermark;
            this.output.emitWatermark(new Watermark(watermark));
            if (this.keyedStateInternals != null && this.currentOutputWatermark > DoFnOperator.adjustTimestampForFlink(GlobalWindow.INSTANCE.maxTimestamp().getMillis())) {
                this.keyedStateInternals.clearGlobalState();
            }
        }
    }

    public final void processWatermark2(Watermark mark) throws Exception {
        this.currentSideInputWatermark = mark.getTimestamp();
        if (mark.getTimestamp() >= BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis()) {
            this.emitAllPushedBackData();
            this.processWatermark1(new Watermark(this.currentInputWatermark));
        }
    }

    private void emitAllPushedBackData() throws Exception {
        Iterator it = this.pushedBackElementsHandler.getElements().iterator();
        while (it.hasNext()) {
            this.checkInvokeStartBundle();
            WindowedValue element = (WindowedValue)it.next();
            this.setKeyContextElement1(new StreamRecord((Object)element));
            this.doFnRunner.processElement(element);
        }
        this.pushedBackElementsHandler.clear();
        this.pushedBackWatermark = Long.MAX_VALUE;
    }

    private void checkInvokeStartBundle() {
        if (!this.bundleStarted) {
            this.outputManager.flushBuffer();
            LOG.debug("Starting bundle.");
            if (this.preBundleCallback != null) {
                this.preBundleCallback.run();
            }
            this.pushbackDoFnRunner.startBundle();
            this.bundleStarted = true;
        }
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"})
    private void checkInvokeFinishBundleByCount() {
        ++this.elementCount;
        if (this.elementCount >= this.maxBundleSize) {
            this.invokeFinishBundle();
        }
    }

    private void checkInvokeFinishBundleByTime() {
        long now = this.getProcessingTimeService().getCurrentProcessingTime();
        if (now - this.lastFinishBundleTime >= this.maxBundleTimeMills) {
            this.invokeFinishBundle();
        }
    }

    protected final void invokeFinishBundle() {
        if (this.bundleStarted) {
            LOG.debug("Finishing bundle.");
            this.pushbackDoFnRunner.finishBundle();
            LOG.debug("Finished bundle. Element count: {}", (Object)this.elementCount);
            this.elementCount = 0L;
            this.lastFinishBundleTime = this.getProcessingTimeService().getCurrentProcessingTime();
            this.bundleStarted = false;
            if (this.bundleFinishedCallback != null) {
                LOG.debug("Invoking bundle finish callback.");
                this.bundleFinishedCallback.run();
            }
        }
    }

    public void prepareSnapshotPreBarrier(long checkpointId) {
        if (this.finishBundleBeforeCheckpointing) {
            while (this.bundleStarted) {
                this.invokeFinishBundle();
            }
        }
    }

    public final void snapshotState(StateSnapshotContext context) throws Exception {
        int diff;
        if (this.checkpointStats != null) {
            this.checkpointStats.snapshotStart(context.getCheckpointId());
        }
        if (this.requiresStableInput) {
            this.bufferingDoFnRunner.checkpoint(context.getCheckpointId());
        }
        if ((diff = this.pendingFinalizations.size() - 32) >= 0) {
            Iterator<Long> iterator = this.pendingFinalizations.keySet().iterator();
            while (diff >= 0) {
                iterator.next();
                iterator.remove();
                --diff;
            }
        }
        this.pendingFinalizations.put(context.getCheckpointId(), this.bundleFinalizer.getAndClearFinalizations());
        try {
            this.outputManager.openBuffer();
            while (this.bundleStarted) {
                this.invokeFinishBundle();
            }
            this.outputManager.closeBuffer();
        }
        catch (Exception e) {
            throw new Error("Checkpointing failed because bundle failed to finalize.", e);
        }
        super.snapshotState(context);
    }

    public DoFn.BundleFinalizer getBundleFinalizer() {
        return this.bundleFinalizer;
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        List finalizations;
        if (this.checkpointStats != null) {
            this.checkpointStats.reportCheckpointDuration(checkpointId);
        }
        if (this.requiresStableInput) {
            this.bufferingDoFnRunner.checkpointCompleted(checkpointId);
        }
        if ((finalizations = (List)this.pendingFinalizations.remove(checkpointId)) != null) {
            for (InMemoryBundleFinalizer.Finalization finalization : finalizations) {
                finalization.getCallback().onBundleSuccess();
            }
        }
        super.notifyCheckpointComplete(checkpointId);
    }

    public void onEventTime(InternalTimer<ByteBuffer, TimerInternals.TimerData> timer) {
        this.checkInvokeStartBundle();
        this.fireTimerInternal((ByteBuffer)timer.getKey(), (TimerInternals.TimerData)timer.getNamespace());
    }

    public void onProcessingTime(InternalTimer<ByteBuffer, TimerInternals.TimerData> timer) {
        this.checkInvokeStartBundle();
        this.fireTimerInternal((ByteBuffer)timer.getKey(), (TimerInternals.TimerData)timer.getNamespace());
    }

    protected void fireTimerInternal(ByteBuffer key, TimerInternals.TimerData timerData) {
        long oldHold = this.keyCoder != null ? this.keyedStateInternals.minWatermarkHoldMs() : -1L;
        this.fireTimer(timerData);
        this.emitWatermarkIfHoldChanged(oldHold);
    }

    void emitWatermarkIfHoldChanged(long currentWatermarkHold) {
        long newWatermarkHold;
        if (this.keyCoder != null && (newWatermarkHold = this.keyedStateInternals.minWatermarkHoldMs().longValue()) > currentWatermarkHold) {
            try {
                this.processInputWatermark(false);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    protected void fireTimer(TimerInternals.TimerData timerData) {
        LOG.debug("Firing timer: {} at {} with output time {}", new Object[]{timerData.getTimerId(), timerData.getTimestamp().getMillis(), timerData.getOutputTimestamp().getMillis()});
        StateNamespace namespace = timerData.getNamespace();
        org.apache.flink.util.Preconditions.checkArgument((boolean)(namespace instanceof StateNamespaces.WindowNamespace));
        BoundedWindow window = ((StateNamespaces.WindowNamespace)namespace).getWindow();
        this.timerInternals.onFiredOrDeletedTimer(timerData);
        this.pushbackDoFnRunner.onTimer(timerData.getTimerId(), timerData.getTimerFamilyId(), this.keyedStateInternals.getKey(), window, timerData.getTimestamp(), timerData.getOutputTimestamp(), timerData.getDomain());
    }

    Coder<InputT> getInputCoder() {
        return (Coder)Iterables.getOnlyElement((Iterable)this.windowedInputCoder.getCoderArguments());
    }

    static long adjustTimestampForFlink(long beamTimerTimestamp) {
        if (beamTimerTimestamp == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return beamTimerTimestamp + 1L;
    }

    class FlinkTimerInternals
    implements TimerInternals {
        private static final String PENDING_TIMERS_STATE_NAME = "pending-timers";
        @VisibleForTesting
        final MapState<String, TimerInternals.TimerData> pendingTimersById;

        private FlinkTimerInternals() {
            MapStateDescriptor pendingTimersByIdStateDescriptor = new MapStateDescriptor(PENDING_TIMERS_STATE_NAME, (TypeSerializer)new StringSerializer(), new CoderTypeSerializer(DoFnOperator.this.timerCoder, DoFnOperator.this.serializedOptions));
            this.pendingTimersById = DoFnOperator.this.getKeyedStateStore().getMapState(pendingTimersByIdStateDescriptor);
            this.populateOutputTimestampQueue();
        }

        void processPendingProcessingTimeTimers() {
            InternalTimer internalTimer;
            KeyedStateBackend keyedStateBackend = DoFnOperator.this.getKeyedStateBackend();
            InternalPriorityQueue<InternalTimer<Object, TimerInternals.TimerData>> processingTimeTimersQueue = Workarounds.retrieveInternalProcessingTimerQueue(DoFnOperator.this.timerService);
            while ((internalTimer = (InternalTimer)processingTimeTimersQueue.poll()) != null) {
                keyedStateBackend.setCurrentKey(internalTimer.getKey());
                TimerInternals.TimerData timer = (TimerInternals.TimerData)internalTimer.getNamespace();
                DoFnOperator.this.checkInvokeStartBundle();
                DoFnOperator.this.fireTimerInternal((ByteBuffer)internalTimer.getKey(), timer);
            }
        }

        private void onNewEventTimer(TimerInternals.TimerData newTimer) {
            Preconditions.checkState((newTimer.getDomain() == TimeDomain.EVENT_TIME ? 1 : 0) != 0, (String)"Timer with id %s is not an event time timer!", (Object)newTimer.getTimerId());
            if (this.timerUsesOutputTimestamp(newTimer)) {
                DoFnOperator.this.keyedStateInternals.addWatermarkHoldUsage(newTimer.getOutputTimestamp());
            }
        }

        private void onNewSdfTimer(TimerInternals.TimerData newTimer) {
            Preconditions.checkState((boolean)BundleCheckpointHandlers.StateAndTimerBundleCheckpointHandler.isSdfTimer((String)newTimer.getTimerId()));
            Preconditions.checkState((boolean)this.timerUsesOutputTimestamp(newTimer));
            DoFnOperator.this.keyedStateInternals.addWatermarkHoldUsage(newTimer.getOutputTimestamp());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void populateOutputTimestampQueue() {
            KeyedStateBackend keyedStateBackend = DoFnOperator.this.getKeyedStateBackend();
            Object currentKey = keyedStateBackend.getCurrentKey();
            try (Stream keys = keyedStateBackend.getKeys(PENDING_TIMERS_STATE_NAME, (Object)VoidNamespace.INSTANCE);){
                keys.forEach(key -> {
                    keyedStateBackend.setCurrentKey(key);
                    try {
                        for (TimerInternals.TimerData timerData : this.pendingTimersById.values()) {
                            if (timerData.getDomain() != TimeDomain.EVENT_TIME && !BundleCheckpointHandlers.StateAndTimerBundleCheckpointHandler.isSdfTimer((String)timerData.getTimerId()) || !this.timerUsesOutputTimestamp(timerData)) continue;
                            DoFnOperator.this.keyedStateInternals.addWatermarkHoldUsage(timerData.getOutputTimestamp());
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Exception while reading set of timers for key: " + key, e);
                    }
                });
            }
            finally {
                if (currentKey != null) {
                    keyedStateBackend.setCurrentKey(currentKey);
                }
            }
        }

        private boolean timerUsesOutputTimestamp(TimerInternals.TimerData timer) {
            return timer.getOutputTimestamp().isBefore((ReadableInstant)timer.getTimestamp());
        }

        private String constructTimerId(String timerFamilyId, String timerId) {
            return timerFamilyId + "+" + timerId;
        }

        public void setTimer(StateNamespace namespace, String timerId, String timerFamilyId, Instant target, Instant outputTimestamp, TimeDomain timeDomain) {
            this.setTimer(TimerInternals.TimerData.of((String)timerId, (String)timerFamilyId, (StateNamespace)namespace, (Instant)target, (Instant)outputTimestamp, (TimeDomain)timeDomain));
        }

        @Deprecated
        public void setTimer(TimerInternals.TimerData timer) {
            try {
                LOG.debug("Setting timer: {} at {} with output time {}", new Object[]{timer.getTimerId(), timer.getTimestamp().getMillis(), timer.getOutputTimestamp().getMillis()});
                String contextTimerId = this.getContextTimerId(this.constructTimerId(timer.getTimerFamilyId(), timer.getTimerId()), timer.getNamespace());
                // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable TimerInternals.TimerData oldTimer = (TimerInternals.TimerData)this.pendingTimersById.get((Object)contextTimerId);
                if (!timer.equals(oldTimer)) {
                    this.cancelPendingTimer(oldTimer);
                    this.registerTimer(timer, contextTimerId);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to set timer", e);
            }
        }

        private void registerTimer(TimerInternals.TimerData timer, String contextTimerId) throws Exception {
            this.pendingTimersById.put((Object)contextTimerId, (Object)timer);
            long time = timer.getTimestamp().getMillis();
            switch (timer.getDomain()) {
                case EVENT_TIME: {
                    DoFnOperator.this.timerService.registerEventTimeTimer((Object)timer, DoFnOperator.adjustTimestampForFlink(time));
                    this.onNewEventTimer(timer);
                    break;
                }
                case PROCESSING_TIME: 
                case SYNCHRONIZED_PROCESSING_TIME: {
                    DoFnOperator.this.timerService.registerProcessingTimeTimer((Object)timer, DoFnOperator.adjustTimestampForFlink(time));
                    if (!BundleCheckpointHandlers.StateAndTimerBundleCheckpointHandler.isSdfTimer((String)timer.getTimerId())) break;
                    this.onNewSdfTimer(timer);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported time domain: " + timer.getDomain());
                }
            }
        }

        private void cancelPendingTimerById(String contextTimerId) throws Exception {
            this.cancelPendingTimer((TimerInternals.TimerData)this.pendingTimersById.get((Object)contextTimerId));
        }

        private void cancelPendingTimer(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable TimerInternals.TimerData timer) {
            if (timer != null) {
                this.deleteTimerInternal(timer);
            }
        }

        void onFiredOrDeletedTimer(TimerInternals.TimerData timer) {
            try {
                this.pendingTimersById.remove((Object)this.getContextTimerId(this.constructTimerId(timer.getTimerFamilyId(), timer.getTimerId()), timer.getNamespace()));
                if ((timer.getDomain() == TimeDomain.EVENT_TIME || BundleCheckpointHandlers.StateAndTimerBundleCheckpointHandler.isSdfTimer((String)timer.getTimerId())) && this.timerUsesOutputTimestamp(timer)) {
                    DoFnOperator.this.keyedStateInternals.removeWatermarkHoldUsage(timer.getOutputTimestamp());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to cleanup pending timers state.", e);
            }
        }

        @Deprecated
        public void deleteTimer(StateNamespace namespace, String timerId, String timerFamilyId) {
            throw new UnsupportedOperationException("Canceling of a timer by ID is not yet supported.");
        }

        public void deleteTimer(StateNamespace namespace, String timerId, String timerFamilyId, TimeDomain timeDomain) {
            try {
                this.cancelPendingTimerById(this.getContextTimerId(timerId, namespace));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to cancel timer", e);
            }
        }

        @Deprecated
        public void deleteTimer(TimerInternals.TimerData timer) {
            this.deleteTimer(timer.getNamespace(), this.constructTimerId(timer.getTimerFamilyId(), timer.getTimerId()), timer.getTimerFamilyId(), timer.getDomain());
        }

        void deleteTimerInternal(TimerInternals.TimerData timer) {
            long time = timer.getTimestamp().getMillis();
            switch (timer.getDomain()) {
                case EVENT_TIME: {
                    DoFnOperator.this.timerService.deleteEventTimeTimer((Object)timer, DoFnOperator.adjustTimestampForFlink(time));
                    break;
                }
                case PROCESSING_TIME: 
                case SYNCHRONIZED_PROCESSING_TIME: {
                    DoFnOperator.this.timerService.deleteProcessingTimeTimer((Object)timer, DoFnOperator.adjustTimestampForFlink(time));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported time domain: " + timer.getDomain());
                }
            }
            this.onFiredOrDeletedTimer(timer);
        }

        public Instant currentProcessingTime() {
            return new Instant(DoFnOperator.this.timerService.currentProcessingTime());
        }

        public @Nullable Instant currentSynchronizedProcessingTime() {
            return new Instant(DoFnOperator.this.timerService.currentProcessingTime());
        }

        public Instant currentInputWatermarkTime() {
            return new Instant(DoFnOperator.this.getEffectiveInputWatermark());
        }

        public @Nullable Instant currentOutputWatermarkTime() {
            return new Instant(DoFnOperator.this.currentOutputWatermark);
        }

        public boolean hasPendingEventTimeTimers(long maxTimestamp) throws Exception {
            for (TimerInternals.TimerData timer : this.pendingTimersById.values()) {
                if (timer.getDomain() != TimeDomain.EVENT_TIME || timer.getTimestamp().getMillis() > maxTimestamp) continue;
                return true;
            }
            return false;
        }

        private String getContextTimerId(String timerId, StateNamespace namespace) {
            return timerId + namespace.stringKey();
        }
    }

    protected class FlinkStepContext
    implements StepContext {
        protected FlinkStepContext() {
        }

        public StateInternals stateInternals() {
            return DoFnOperator.this.keyedStateInternals;
        }

        public TimerInternals timerInternals() {
            return DoFnOperator.this.timerInternals;
        }

        public DoFn.BundleFinalizer bundleFinalizer() {
            return DoFnOperator.this.bundleFinalizer;
        }
    }

    public static class MultiOutputOutputManagerFactory<OutputT>
    implements OutputManagerFactory<OutputT> {
        private final TupleTag<OutputT> mainTag;
        private final Map<TupleTag<?>, Integer> tagsToIds;
        private final Map<TupleTag<?>, OutputTag<WindowedValue<?>>> tagsToOutputTags;
        private final Map<TupleTag<?>, Coder<WindowedValue<?>>> tagsToCoders;
        private final SerializablePipelineOptions pipelineOptions;

        public MultiOutputOutputManagerFactory(TupleTag<OutputT> mainTag, Coder<WindowedValue<OutputT>> mainCoder, SerializablePipelineOptions pipelineOptions) {
            this(mainTag, new HashMap(), (Map<TupleTag<?>, Coder<WindowedValue<?>>>)ImmutableMap.builder().put(mainTag, mainCoder).build(), (Map<TupleTag<?>, Integer>)ImmutableMap.builder().put(mainTag, (Object)0).build(), pipelineOptions);
        }

        public MultiOutputOutputManagerFactory(TupleTag<OutputT> mainTag, Map<TupleTag<?>, OutputTag<WindowedValue<?>>> tagsToOutputTags, Map<TupleTag<?>, Coder<WindowedValue<?>>> tagsToCoders, Map<TupleTag<?>, Integer> tagsToIds, SerializablePipelineOptions pipelineOptions) {
            this.mainTag = mainTag;
            this.tagsToOutputTags = tagsToOutputTags;
            this.tagsToCoders = tagsToCoders;
            this.tagsToIds = tagsToIds;
            this.pipelineOptions = pipelineOptions;
        }

        @Override
        public BufferedOutputManager<OutputT> create(Output<StreamRecord<WindowedValue<OutputT>>> output, Lock bufferLock, OperatorStateBackend operatorStateBackend) throws Exception {
            Preconditions.checkNotNull(output);
            Preconditions.checkNotNull((Object)bufferLock);
            Preconditions.checkNotNull((Object)operatorStateBackend);
            TaggedKvCoder taggedKvCoder = this.buildTaggedKvCoder();
            ListStateDescriptor taggedOutputPushbackStateDescriptor = new ListStateDescriptor("bundle-buffer-tag", new CoderTypeSerializer(taggedKvCoder, this.pipelineOptions));
            ListState listStateBuffer = operatorStateBackend.getListState(taggedOutputPushbackStateDescriptor);
            NonKeyedPushedBackElementsHandler<KV<Integer, WindowedValue<?>>> pushedBackElementsHandler = NonKeyedPushedBackElementsHandler.create(listStateBuffer);
            return new BufferedOutputManager<OutputT>(output, this.mainTag, this.tagsToOutputTags, this.tagsToIds, bufferLock, pushedBackElementsHandler);
        }

        private TaggedKvCoder buildTaggedKvCoder() {
            ImmutableMap.Builder idsToCodersBuilder = ImmutableMap.builder();
            for (Map.Entry<TupleTag<?>, Integer> entry : this.tagsToIds.entrySet()) {
                idsToCodersBuilder.put((Object)entry.getValue(), this.tagsToCoders.get(entry.getKey()));
            }
            return new TaggedKvCoder((Map<Integer, Coder<WindowedValue<?>>>)idsToCodersBuilder.build());
        }
    }

    private static class TaggedKvCoder
    extends StructuredCoder<KV<Integer, WindowedValue<?>>> {
        private final Map<Integer, Coder<WindowedValue<?>>> idsToCoders;

        TaggedKvCoder(Map<Integer, Coder<WindowedValue<?>>> idsToCoders) {
            this.idsToCoders = idsToCoders;
        }

        public void encode(KV<Integer, WindowedValue<?>> kv, OutputStream out) throws IOException {
            Coder<WindowedValue<?>> coder = this.idsToCoders.get(kv.getKey());
            VarIntCoder.of().encode((Integer)kv.getKey(), out);
            coder.encode((Object)((WindowedValue)kv.getValue()), out);
        }

        public KV<Integer, WindowedValue<?>> decode(InputStream in) throws IOException {
            Integer id = VarIntCoder.of().decode(in);
            Coder<WindowedValue<?>> coder = this.idsToCoders.get(id);
            WindowedValue value = (WindowedValue)coder.decode(in);
            return KV.of((Object)id, (Object)value);
        }

        public List<? extends Coder<?>> getCoderArguments() {
            return new ArrayList(this.idsToCoders.values());
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
            for (Coder<WindowedValue<?>> coder : this.idsToCoders.values()) {
                TaggedKvCoder.verifyDeterministic((Coder)this, (String)"Coder must be deterministic", (Coder[])new Coder[]{coder});
            }
        }
    }

    public static class BufferedOutputManager<OutputT>
    implements DoFnRunners.OutputManager {
        private final TupleTag<OutputT> mainTag;
        private final Map<TupleTag<?>, OutputTag<WindowedValue<?>>> tagsToOutputTags;
        private final Map<TupleTag<?>, Integer> tagsToIds;
        private final Lock bufferLock;
        private Map<Integer, TupleTag<?>> idsToTags;
        @VisibleForTesting
        final PushedBackElementsHandler<KV<Integer, WindowedValue<?>>> pushedBackElementsHandler;
        protected final Output<StreamRecord<WindowedValue<OutputT>>> output;
        private boolean openBuffer = false;
        private boolean bufferIsEmpty = false;

        BufferedOutputManager(Output<StreamRecord<WindowedValue<OutputT>>> output, TupleTag<OutputT> mainTag, Map<TupleTag<?>, OutputTag<WindowedValue<?>>> tagsToOutputTags, Map<TupleTag<?>, Integer> tagsToIds, Lock bufferLock, PushedBackElementsHandler<KV<Integer, WindowedValue<?>>> pushedBackElementsHandler) {
            this.output = output;
            this.mainTag = mainTag;
            this.tagsToOutputTags = tagsToOutputTags;
            this.tagsToIds = tagsToIds;
            this.bufferLock = bufferLock;
            this.idsToTags = new HashMap();
            for (Map.Entry<TupleTag<?>, Integer> entry : tagsToIds.entrySet()) {
                this.idsToTags.put(entry.getValue(), entry.getKey());
            }
            this.pushedBackElementsHandler = pushedBackElementsHandler;
        }

        void openBuffer() {
            this.openBuffer = true;
        }

        void closeBuffer() {
            this.openBuffer = false;
        }

        public <T> void output(TupleTag<T> tag, WindowedValue<T> value) {
            if (!this.openBuffer) {
                this.emit(tag, value);
            } else {
                this.buffer(KV.of((Object)this.tagsToIds.get(tag), value));
            }
        }

        private void buffer(KV<Integer, WindowedValue<?>> taggedValue) {
            this.bufferLock.lock();
            try {
                this.pushedBackElementsHandler.pushBack(taggedValue);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't pushback element.", e);
            }
            finally {
                this.bufferLock.unlock();
                this.bufferIsEmpty = false;
            }
        }

        void flushBuffer() {
            if (this.openBuffer || this.bufferIsEmpty) {
                return;
            }
            try {
                this.pushedBackElementsHandler.getElements().forEach(element -> this.emit(this.idsToTags.get(element.getKey()), (WindowedValue)element.getValue()));
                this.pushedBackElementsHandler.clear();
                this.bufferIsEmpty = true;
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't flush pushed back elements.", e);
            }
        }

        private <T> void emit(TupleTag<T> tag, WindowedValue<T> value) {
            if (tag.equals(this.mainTag)) {
                WindowedValue<T> castValue = value;
                this.output.collect((Object)new StreamRecord(castValue));
            } else {
                OutputTag<WindowedValue<?>> outputTag = this.tagsToOutputTags.get(tag);
                this.output.collect(outputTag, new StreamRecord(value));
            }
        }
    }

    static interface OutputManagerFactory<OutputT>
    extends Serializable {
        public BufferedOutputManager<OutputT> create(Output<StreamRecord<WindowedValue<OutputT>>> var1, Lock var2, OperatorStateBackend var3) throws Exception;
    }
}

