/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.joda.time.Instant;

class FlinkAssignContext<InputT, W extends BoundedWindow>
extends WindowFn.AssignContext {
    private final WindowedValue<InputT> value;

    FlinkAssignContext(WindowFn<InputT, W> fn, WindowedValue<InputT> value) {
        super(fn);
        if (Iterables.size((Iterable)value.getWindows()) != 1) {
            throw new IllegalArgumentException(String.format("%s passed to window assignment must be in a single window, but it was in %s: %s", WindowedValue.class.getSimpleName(), Iterables.size((Iterable)value.getWindows()), value.getWindows()));
        }
        this.value = value;
    }

    public InputT element() {
        return (InputT)this.value.getValue();
    }

    public Instant timestamp() {
        return this.value.getTimestamp();
    }

    public BoundedWindow window() {
        return (BoundedWindow)Iterables.getOnlyElement((Iterable)this.value.getWindows());
    }
}

