/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Date;
import com.ibm.as400.access.AS400Time;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlDataValues;
import com.ibm.as400.data.PcmlDataVector;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.PcmlNode;
import com.ibm.as400.data.PcmlProgram;
import com.ibm.as400.data.PcmlStruct;
import com.ibm.as400.data.ProgramCallDocument;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;

class PcmlData
extends PcmlDocNode {
    public static final int UNSUPPORTED = 0;
    public static final int CHAR = 1;
    public static final int INT = 2;
    public static final int PACKED = 3;
    public static final int ZONED = 4;
    public static final int FLOAT = 5;
    public static final int BYTE = 6;
    public static final int STRUCT = 7;
    public static final int DATE = 8;
    public static final int TIME = 9;
    public static final int TIMESTAMP = 10;
    public static final int MAX_STRING_LENGTH = 0xFFEFF0;
    static final long serialVersionUID = 8578048664805881489L;
    private static final String[] DATAATTRIBUTES = new String[]{"name", "usage", "count", "minvrm", "maxvrm", "offset", "offsetfrom", "outputsize", "type", "length", "precision", "ccsid", "init", "struct", "passby", "bidistringtype", "trim", "chartype", "dateformat", "dateseparator", "timeformat", "timeseparator"};
    private static final int VERSION_1_ATTRIBUTE_COUNT = 14;
    private static final int VERSION_2_ATTRIBUTE_COUNT = 15;
    private static final int VERSION_3_ATTRIBUTE_COUNT = 16;
    private static final int VERSION_4_ATTRIBUTE_COUNT = 18;
    private static final int VERSION_5_ATTRIBUTE_COUNT = 20;
    private static Hashtable bidiTypeMap_;
    private int m_Count;
    private String m_CountId;
    private int m_Offset;
    private String m_OffsetId;
    private boolean m_OffsetfromFixed;
    private int m_Offsetfrom;
    private String m_OffsetfromId;
    private String m_Minvrm;
    private int m_MinvrmInt;
    private String m_Maxvrm;
    private int m_MaxvrmInt;
    private int m_Outputsize;
    private String m_OutputsizeId;
    private String m_TypeStr;
    private int m_Type;
    private int m_Length;
    private String m_LengthId;
    private boolean m_LengthWasSpecified;
    private int m_Precision;
    private int m_Ccsid;
    private String m_CcsidId;
    private boolean m_CcsidWasSpecified;
    private String m_Init;
    private String m_StructId;
    private String m_PassbyStr;
    private int m_Passby;
    private String m_BidistringtypeStr;
    private int m_Bidistringtype;
    private boolean m_IsRfml;
    private String m_TrimStr;
    private String m_CharType;
    private String m_KeyFieldStr;
    private boolean m_KeyField;
    private String m_DateFormat;
    private String m_DateSeparator;
    private String m_TimeFormat;
    private String m_TimeSeparator;
    private PcmlDataValues m_scalarValue;
    private PcmlDataVector m_vectorValue;
    private static final String vrmDelimChars = "VRM";
    static /* synthetic */ Class class$com$ibm$as400$data$PcmlData;

    PcmlData() {
        this(false);
    }

    PcmlData(PcmlAttributeList pcmlAttributeList) {
        this(pcmlAttributeList, false);
    }

    PcmlData(boolean bl) {
        this.m_IsRfml = bl;
    }

    PcmlData(PcmlAttributeList pcmlAttributeList, boolean bl) {
        super(pcmlAttributeList);
        this.m_IsRfml = bl;
        this.setNodeType(4);
        this.setCount(this.getAttributeValue("count"));
        this.setOffset(this.getAttributeValue("offset"));
        this.setOffsetfrom(this.getAttributeValue("offsetfrom"));
        this.setMinvrm(this.getAttributeValue("minvrm"));
        this.setMaxvrm(this.getAttributeValue("maxvrm"));
        this.setType(this.getAttributeValue("type"));
        this.setLength(this.getAttributeValue("length"));
        this.setPrecision(this.getAttributeValue("precision"));
        this.setCcsid(this.getAttributeValue("ccsid"));
        this.setInit(this.getAttributeValue("init"));
        this.setOutputsize(this.getAttributeValue("outputsize"));
        this.setStruct(this.getAttributeValue("struct"));
        this.setPassby(this.getAttributeValue("passby"));
        this.setBidiStringType(this.getAttributeValue("bidistringtype"));
        this.setTrim(this.getAttributeValue("trim"));
        this.setCharType(this.getAttributeValue("chartype"));
        this.setKeyField(this.getAttributeValue("keyfield"));
        this.setDateFormat(this.getAttributeValue("dateformat"));
        this.setDateSeparator(this.getAttributeValue("dateseparator"));
        this.setTimeFormat(this.getAttributeValue("timeformat"));
        this.setTimeSeparator(this.getAttributeValue("timeseparator"));
        this.m_scalarValue = null;
        this.m_vectorValue = null;
    }

    public Object clone() {
        PcmlData pcmlData = (PcmlData)super.clone();
        pcmlData.m_scalarValue = null;
        pcmlData.m_vectorValue = null;
        return pcmlData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        PcmlData pcmlData = this;
        synchronized (pcmlData) {
            PcmlDataValues pcmlDataValues = this.m_scalarValue;
            PcmlDataVector pcmlDataVector = this.m_vectorValue;
            if (!this.getDoc().isSerializingWithData()) {
                this.m_scalarValue = null;
                this.m_vectorValue = null;
            }
            objectOutputStream.defaultWriteObject();
            this.m_scalarValue = pcmlDataValues;
            this.m_vectorValue = pcmlDataVector;
        }
    }

    void readObjectPostprocessing() {
        if (this.m_scalarValue != null) {
            this.m_scalarValue.readObjectPostprocessing();
        }
        if (this.m_vectorValue != null) {
            this.m_vectorValue.readObjectPostprocessing();
        }
        super.readObjectPostprocessing();
    }

    private PcmlDataValues getPcmlDataValues(PcmlDimensions pcmlDimensions) throws PcmlException {
        int[] nArray = this.getDimensions(pcmlDimensions).asArray();
        if (pcmlDimensions.size() < nArray.length) {
            throw new PcmlException("TOO_FEW_INDICES", new Object[]{new Integer(pcmlDimensions.size()), new Integer(nArray.length), this.getNameForException()});
        }
        if (nArray.length == 0) {
            if (this.m_scalarValue == null) {
                this.m_scalarValue = new PcmlDataValues(this, new PcmlDimensions());
            }
            return this.m_scalarValue;
        }
        PcmlDimensions pcmlDimensions2 = new PcmlDimensions();
        if (this.m_vectorValue == null) {
            this.m_vectorValue = new PcmlDataVector(nArray[0], this, pcmlDimensions2);
            for (int i = 0; i < nArray[0]; ++i) {
                this.m_vectorValue.addElement(null);
            }
        }
        long[] lArray = this.getDimensionTimestamps(pcmlDimensions);
        PcmlDataVector pcmlDataVector = this.m_vectorValue;
        for (int i = 0; i < nArray.length; ++i) {
            PcmlDataVector pcmlDataVector2;
            if (lArray[i] > pcmlDataVector.getTimestamp()) {
                pcmlDataVector.redimension(nArray[i]);
            }
            int n = pcmlDimensions.at(i);
            pcmlDimensions2.add(n);
            if (n < 0 || n >= nArray[i]) {
                throw new PcmlException("INDEX_OUT_OF_BOUNDS", new Object[]{new Integer(nArray[i] - 1), new Integer(i), pcmlDimensions, this.getNameForException()});
            }
            if (i != nArray.length - 1) {
                pcmlDataVector2 = pcmlDataVector.vectorAt(n);
                if (pcmlDataVector2 == null) {
                    pcmlDataVector2 = new PcmlDataVector(nArray[i + 1], this, pcmlDimensions2);
                    for (int j = 0; j < nArray[i + 1]; ++j) {
                        pcmlDataVector2.addElement(null);
                    }
                    pcmlDataVector.setElementAt(pcmlDataVector2, n);
                }
            } else {
                PcmlDataValues pcmlDataValues = pcmlDataVector.valuesAt(n);
                if (pcmlDataValues == null) {
                    pcmlDataValues = new PcmlDataValues(this, pcmlDimensions2);
                    pcmlDataVector.setElementAt(pcmlDataValues, n);
                }
                return pcmlDataValues;
            }
            pcmlDataVector = pcmlDataVector2;
        }
        throw new PcmlException("ERROR_ACCESSING_VALUE", new Object[]{pcmlDimensions, nArray, this.getNameForException()});
    }

    long getTimestamp(PcmlDimensions pcmlDimensions) throws PcmlException {
        if (pcmlDimensions.size() >= this.getNbrOfDimensions()) {
            PcmlDataValues pcmlDataValues = this.getPcmlDataValues(pcmlDimensions);
            return pcmlDataValues.getTimestamp();
        }
        throw new PcmlException("TOO_FEW_INDICES", new Object[]{new Integer(pcmlDimensions.size()), new Integer(this.getNbrOfDimensions()), this.getNameForException()});
    }

    final Object getValue() throws PcmlException {
        return this.getValue(new PcmlDimensions());
    }

    final Object getValue(PcmlDimensions pcmlDimensions) throws PcmlException {
        if (this.m_Type == 1) {
            return this.getStringValue(pcmlDimensions, this.m_Bidistringtype);
        }
        if (pcmlDimensions.size() >= this.getNbrOfDimensions()) {
            PcmlDataValues pcmlDataValues = this.getPcmlDataValues(pcmlDimensions);
            return pcmlDataValues.getValue();
        }
        throw new PcmlException("TOO_FEW_INDICES", new Object[]{new Integer(pcmlDimensions.size()), new Integer(this.getNbrOfDimensions()), this.getNameForException()});
    }

    final String getStringValue(PcmlDimensions pcmlDimensions, int n) throws PcmlException {
        Object object = null;
        if (pcmlDimensions.size() >= this.getNbrOfDimensions()) {
            PcmlDataValues pcmlDataValues = this.getPcmlDataValues(pcmlDimensions);
            if (this.m_Type == 1) {
                pcmlDataValues.setStringType(n);
            }
            if ((object = pcmlDataValues.getValue()) == null) {
                return null;
            }
            if (object instanceof Number) {
                return ((Number)object).toString();
            }
            if (object instanceof String) {
                return (String)object;
            }
            throw new PcmlException("STRING_OR_NUMBER", new Object[]{object.getClass().getName(), this.getNameForException()});
        }
        throw new PcmlException("TOO_FEW_INDICES", new Object[]{new Integer(pcmlDimensions.size()), new Integer(this.getNbrOfDimensions()), this.getNameForException()});
    }

    final void setValue(Object object) throws PcmlException {
        this.setValue(object, new PcmlDimensions());
    }

    final void setValue(Object object, PcmlDimensions pcmlDimensions) throws PcmlException {
        if (pcmlDimensions.size() < this.getNbrOfDimensions()) {
            throw new PcmlException("TOO_FEW_INDICES", new Object[]{new Integer(pcmlDimensions.size()), new Integer(this.getNbrOfDimensions()), this.getNameForException()});
        }
        PcmlDataValues pcmlDataValues = this.getPcmlDataValues(pcmlDimensions);
        pcmlDataValues.setStringType(this.m_Bidistringtype);
        pcmlDataValues.setValue(object);
    }

    final void setStringValue(String string, PcmlDimensions pcmlDimensions, int n) throws PcmlException {
        if (pcmlDimensions.size() < this.getNbrOfDimensions()) {
            throw new PcmlException("TOO_FEW_INDICES", new Object[]{new Integer(pcmlDimensions.size()), new Integer(this.getNbrOfDimensions()), this.getNameForException()});
        }
        PcmlDataValues pcmlDataValues = this.getPcmlDataValues(pcmlDimensions);
        pcmlDataValues.flushValues();
        pcmlDataValues.setStringType(n);
        pcmlDataValues.setValue(string);
    }

    void setBytes(byte[] byArray) {
    }

    String[] getAttributeList() {
        int n = 0;
        if (this.getDoc().getVersion().compareTo("2.0") < 0) {
            n = 14;
        } else if (this.getDoc().getVersion().compareTo("3.0") < 0) {
            n = 15;
        } else if (this.getDoc().getVersion().compareTo("4.0") < 0) {
            n = 16;
        } else if (this.getDoc().getVersion().compareTo("6.0") < 0) {
            n = 18;
        } else {
            return DATAATTRIBUTES;
        }
        String[] stringArray = new String[n];
        System.arraycopy(DATAATTRIBUTES, 0, stringArray, 0, n);
        return stringArray;
    }

    final int getCcsid(PcmlDimensions pcmlDimensions) throws PcmlException {
        int n = this.resolveIntegerValue(this.getCcsid(), this.getCcsidId(), pcmlDimensions);
        if (n == 0) {
            PcmlNode pcmlNode = this.getParent();
            while (pcmlNode.getParent() != this.getDoc()) {
                pcmlNode = pcmlNode.getParent();
            }
            if (pcmlNode instanceof PcmlProgram) {
                return ((PcmlProgram)pcmlNode).getProgramCCSID();
            }
            return this.getDoc().getAs400().getCcsid();
        }
        return n;
    }

    final int getCount(PcmlDimensions pcmlDimensions) throws PcmlException {
        return this.resolveIntegerValue(this.getCount(), this.getCountId(), pcmlDimensions);
    }

    final int getXPCMLCount(PcmlDimensions pcmlDimensions) throws PcmlException {
        try {
            int n = this.resolveIntegerValue(this.getCount(), this.getCountId(), pcmlDimensions);
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public final int getCount() {
        return this.m_Count;
    }

    public final String getCountId() {
        return this.resolveRelativeName(this.m_CountId);
    }

    public final String getUnqualifiedCountId() {
        return this.m_CountId;
    }

    final int getLength(PcmlDimensions pcmlDimensions) throws PcmlException {
        return this.resolveIntegerValue(this.getLength(), this.getLengthId(), pcmlDimensions);
    }

    final int getOffset(PcmlDimensions pcmlDimensions) throws PcmlException {
        return this.resolveIntegerValue(this.getOffset(), this.getOffsetId(), pcmlDimensions);
    }

    public final int getOffset() {
        return this.m_Offset;
    }

    public final String getOffsetId() {
        return this.resolveRelativeName(this.m_OffsetId);
    }

    public final String getUnqualifiedOffsetId() {
        return this.m_OffsetId;
    }

    private final boolean isOffsetfromFixed() {
        return this.m_OffsetfromFixed;
    }

    public final int getPassby() {
        if (this.m_PassbyStr != null) {
            return this.m_Passby;
        }
        return 2;
    }

    public final String getBidistringtypeStr() {
        return this.m_BidistringtypeStr;
    }

    final int getOffsetfrom() {
        if (this.isOffsetfromFixed()) {
            return this.m_Offsetfrom;
        }
        return -1;
    }

    final String getOffsetfromId() {
        return this.resolveRelativeName(this.m_OffsetfromId);
    }

    public final String getUnqualifiedOffsetfromId() {
        return this.m_OffsetfromId;
    }

    PcmlDimensions getDimensions(PcmlDimensions pcmlDimensions) throws PcmlException {
        PcmlDimensions pcmlDimensions2 = null;
        PcmlNode pcmlNode = this.getParent();
        pcmlDimensions2 = pcmlNode instanceof PcmlData ? ((PcmlData)pcmlNode).getDimensions(pcmlDimensions) : (pcmlNode instanceof PcmlStruct ? ((PcmlStruct)pcmlNode).getDimensions(pcmlDimensions) : new PcmlDimensions(this.getNbrOfDimensions()));
        if (this.isArray()) {
            int n = this.getCount(pcmlDimensions);
            pcmlDimensions2.add(n);
        }
        return pcmlDimensions2;
    }

    long[] getDimensionTimestamps(PcmlDimensions pcmlDimensions) throws PcmlException {
        long[] lArray;
        Integer n = null;
        PcmlNode pcmlNode = this.getParent();
        if (this.isArray()) {
            n = pcmlDimensions.integerAt(pcmlDimensions.size() - 1);
            pcmlDimensions.remove();
        }
        long[] lArray2 = pcmlNode instanceof PcmlData ? ((PcmlData)pcmlNode).getDimensionTimestamps(pcmlDimensions) : (pcmlNode instanceof PcmlStruct ? ((PcmlStruct)pcmlNode).getDimensionTimestamps(pcmlDimensions) : new long[]{});
        if (n != null) {
            int n2;
            pcmlDimensions.add(n);
            lArray = new long[lArray2.length + 1];
            for (n2 = 0; n2 < lArray2.length; ++n2) {
                lArray[n2] = lArray2[n2];
            }
            lArray[n2] = this.resolveDimensionTimestamp(pcmlDimensions);
            if (n2 > 0) {
                lArray[n2] = Math.max(lArray[n2], lArray[n2 - 1]);
            }
        } else {
            lArray = lArray2;
        }
        return lArray;
    }

    int getNbrOfDimensions() {
        int n = 0;
        PcmlNode pcmlNode = this.getParent();
        if (this.isArray()) {
            ++n;
        }
        if (pcmlNode instanceof PcmlData) {
            n += ((PcmlData)pcmlNode).getNbrOfDimensions();
        } else if (pcmlNode instanceof PcmlStruct) {
            n += ((PcmlStruct)pcmlNode).getNbrOfDimensions();
        }
        return n;
    }

    int getOutputsize(PcmlDimensions pcmlDimensions) throws PcmlException {
        boolean bl;
        int n;
        int n2 = 0;
        n2 = this.resolveIntegerValue(this.getOutputsize(), this.getOutputsizeId(), pcmlDimensions);
        if (n2 > 0) {
            return n2;
        }
        if (this.isArray() && pcmlDimensions.size() < this.getNbrOfDimensions()) {
            n = this.getCount(pcmlDimensions);
            bl = true;
        } else {
            n = 1;
            bl = false;
        }
        for (int i = 0; i < n; ++i) {
            if (bl) {
                pcmlDimensions.add(i);
            }
            switch (this.getDataType()) {
                case 7: {
                    Enumeration enumeration = this.getChildren();
                    block8: while (enumeration.hasMoreElements()) {
                        PcmlDocNode pcmlDocNode = (PcmlDocNode)enumeration.nextElement();
                        switch (pcmlDocNode.getNodeType()) {
                            case 3: {
                                n2 += ((PcmlStruct)pcmlDocNode).getOutputsize(pcmlDimensions);
                                continue block8;
                            }
                            case 4: {
                                n2 += ((PcmlData)pcmlDocNode).getOutputsize(pcmlDimensions);
                                continue block8;
                            }
                        }
                        throw new PcmlException("BAD_NODE_TYPE", new Object[]{new Integer(pcmlDocNode.getNodeType()), this.getNameForException()});
                    }
                    break;
                }
                default: {
                    if ((n2 += this.getPcmlDataValues(pcmlDimensions).byteLength()) != 0) break;
                    n2 = 32;
                }
            }
            if (!bl) continue;
            pcmlDimensions.remove();
        }
        return n2;
    }

    public final String getTrim() {
        return this.m_TrimStr;
    }

    public final String getCharType() {
        return this.m_CharType;
    }

    boolean isArray() {
        if (this.getCount() > 0) {
            return true;
        }
        return this.getCountId() != null;
    }

    boolean isInArray() {
        PcmlNode pcmlNode = this.getParent();
        if (this.isArray()) {
            return true;
        }
        if (pcmlNode instanceof PcmlData) {
            return ((PcmlData)pcmlNode).isInArray();
        }
        if (pcmlNode instanceof PcmlStruct) {
            return ((PcmlStruct)pcmlNode).isInArray();
        }
        return false;
    }

    public final boolean isLengthSpecified() {
        return this.m_LengthWasSpecified || this.m_Length != 0 || this.m_LengthId != null;
    }

    boolean isSupportedAtHostVRM() throws PcmlException {
        if (this.m_IsRfml) {
            return true;
        }
        int n = this.getAs400VRM();
        if (this.getMinvrm() > n) {
            return false;
        }
        return this.getMaxvrm() >= n;
    }

    int toBytes(OutputStream outputStream, int n, PcmlDimensions pcmlDimensions) throws PcmlException {
        boolean bl;
        int n2;
        int n3 = 0;
        if (!this.isSupportedAtHostVRM()) {
            return 0;
        }
        if (this.isArray() && pcmlDimensions.size() < this.getNbrOfDimensions()) {
            n2 = this.getCount(pcmlDimensions);
            bl = true;
        } else {
            n2 = 1;
            bl = false;
        }
        for (int i = 0; i < n2; ++i) {
            if (bl) {
                pcmlDimensions.add(i);
            }
            switch (this.getDataType()) {
                case 7: {
                    Enumeration enumeration = this.getChildren();
                    block8: while (enumeration.hasMoreElements()) {
                        PcmlDocNode pcmlDocNode = (PcmlDocNode)enumeration.nextElement();
                        switch (pcmlDocNode.getNodeType()) {
                            case 3: {
                                n3 += ((PcmlStruct)pcmlDocNode).toBytes(outputStream, n + n3, pcmlDimensions);
                                continue block8;
                            }
                            case 4: {
                                n3 += ((PcmlData)pcmlDocNode).toBytes(outputStream, n + n3, pcmlDimensions);
                                continue block8;
                            }
                        }
                        throw new PcmlException("BAD_NODE_TYPE", new Object[]{new Integer(pcmlDocNode.getNodeType()), this.getNameForException()});
                    }
                    break;
                }
                default: {
                    n3 += this.getPcmlDataValues(pcmlDimensions).toBytes(outputStream, n + n3);
                }
            }
            if (!bl) continue;
            pcmlDimensions.remove();
        }
        return n3;
    }

    int parseBytes(byte[] byArray, int n, Hashtable hashtable, PcmlDimensions pcmlDimensions) throws PcmlException {
        Object object;
        Object object2;
        int n2;
        boolean bl;
        int n3;
        int n4 = 0;
        if (!this.isSupportedAtHostVRM()) {
            return 0;
        }
        if (this.isArray() && pcmlDimensions.size() < this.getNbrOfDimensions()) {
            n3 = this.getCount(pcmlDimensions);
            bl = true;
        } else {
            n3 = 1;
            bl = false;
        }
        int n5 = 0;
        if (this.getDataType() == 7 && (n2 = this.getOffset(pcmlDimensions)) > 0) {
            object2 = null;
            object = this.getOffsetfromId();
            if (object != null) {
                object2 = (Integer)hashtable.get(object);
                if (object2 == null) {
                    throw new PcmlException("OFFSETFROM_NOT_FOUND", new Object[]{object, this.getNameForException()});
                }
            } else {
                object2 = this.getOffsetfrom() >= 0 ? new Integer(this.getOffsetfrom()) : (Integer)hashtable.get(((PcmlDocNode)this.getParent()).getQualifiedName());
            }
            if (object2 != null) {
                n2 += ((Integer)object2).intValue();
            }
            if (n2 > n) {
                n5 = n2 - n;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (bl) {
                pcmlDimensions.add(n2);
            }
            if (this.getDataType() != 7) {
                n4 += this.getPcmlDataValues(pcmlDimensions).parseBytes(byArray, n + n5 + n4, hashtable);
            } else {
                String string = this.getQualifiedName();
                if (!string.equals("")) {
                    hashtable.put(string, new Integer(n + n5 + n4));
                }
                object2 = this.getChildren();
                block5: while (object2.hasMoreElements()) {
                    object = (PcmlDocNode)object2.nextElement();
                    switch (((PcmlDocNode)object).getNodeType()) {
                        case 3: {
                            PcmlStruct pcmlStruct = (PcmlStruct)object;
                            n4 += pcmlStruct.parseBytes(byArray, n + n5 + n4, hashtable, pcmlDimensions);
                            continue block5;
                        }
                        case 4: {
                            PcmlData pcmlData = (PcmlData)object;
                            n4 += pcmlData.parseBytes(byArray, n + n5 + n4, hashtable, pcmlDimensions);
                            continue block5;
                        }
                    }
                    throw new PcmlException("BAD_NODE_TYPE", new Object[]{new Integer(((PcmlDocNode)object).getNodeType()), this.getNameForException()});
                }
                if (!string.equals("")) {
                    hashtable.remove(string);
                }
            }
            if (!bl) continue;
            pcmlDimensions.remove();
        }
        return n4 + n5;
    }

    private int resolveIntegerValue(int n, String string, PcmlDimensions pcmlDimensions) throws PcmlException {
        if (string != null) {
            PcmlNode pcmlNode = this.getDoc().getElement(string);
            if (pcmlNode instanceof PcmlData) {
                PcmlData pcmlData = (PcmlData)pcmlNode;
                Object object = pcmlData.getValue(pcmlDimensions);
                if (object instanceof String) {
                    return Integer.parseInt((String)object);
                }
                if (object instanceof Number) {
                    return ((Number)object).intValue();
                }
                if (object == null) {
                    throw new PcmlException("INPUT_VALUE_NOT_SET", new Object[]{pcmlData.getNameForException()});
                }
                throw new PcmlException("STRING_OR_NUMBER", new Object[]{object.getClass().getName(), pcmlData.getNameForException()});
            }
            if (pcmlNode == null) {
                throw new PcmlException("ELEMENT_NOT_FOUND", new Object[]{string, "<data>"});
            }
            throw new PcmlException("WRONG_ELEMENT_TYPE", new Object[]{string, "<data>"});
        }
        return n;
    }

    private long resolveDimensionTimestamp(PcmlDimensions pcmlDimensions) throws PcmlException {
        String string = this.getCountId();
        if (string != null) {
            PcmlNode pcmlNode = this.getDoc().getElement(string);
            if (pcmlNode instanceof PcmlData) {
                return ((PcmlData)pcmlNode).getTimestamp(pcmlDimensions);
            }
            if (pcmlNode == null) {
                throw new PcmlException("ELEMENT_NOT_FOUND", new Object[]{string, "<data>"});
            }
            throw new PcmlException("WRONG_ELEMENT_TYPE", new Object[]{string, "<data>"});
        }
        return Long.MIN_VALUE;
    }

    public final int getCcsid() {
        return this.m_Ccsid;
    }

    public final String getCcsidId() {
        return this.resolveRelativeName(this.m_CcsidId);
    }

    public final String getUnqualifiedCcsidId() {
        return this.m_CcsidId;
    }

    public final int getDataType() {
        return this.m_Type;
    }

    public final String getDataTypeString() {
        return this.m_TypeStr;
    }

    public final String getInit() {
        return this.m_Init;
    }

    public final int getLength() {
        return this.m_Length;
    }

    public final String getLengthId() {
        return this.resolveRelativeName(this.m_LengthId);
    }

    public final String getUnqualifiedLengthId() {
        return this.m_LengthId;
    }

    public final int getMaxvrm() {
        return this.m_MaxvrmInt;
    }

    public final String getMaxvrmString() {
        return this.m_Maxvrm;
    }

    public final int getMinvrm() {
        return this.m_MinvrmInt;
    }

    public final String getMinvrmString() {
        return this.m_Minvrm;
    }

    public final int getOutputsize() {
        return this.m_Outputsize;
    }

    public final String getOutputsizeId() {
        return this.resolveRelativeName(this.m_OutputsizeId);
    }

    public final String getUnqualifiedOutputsizeId() {
        return this.m_OutputsizeId;
    }

    public final int getPrecision() {
        return this.m_Precision;
    }

    public final String getStruct() {
        return this.m_StructId;
    }

    public final String getDateFormat() {
        return this.m_DateFormat;
    }

    public final String getDateSeparator() {
        return this.m_DateSeparator;
    }

    public final String getTimeFormat() {
        return this.m_TimeFormat;
    }

    public final String getTimeSeparator() {
        return this.m_TimeSeparator;
    }

    public boolean isKeyField() {
        return this.m_KeyField;
    }

    private void setCount(String string) {
        if (string == null || string.equals("")) {
            this.m_Count = 0;
            this.m_CountId = null;
            return;
        }
        try {
            this.m_Count = Integer.parseInt(string);
            this.m_CountId = null;
        }
        catch (NumberFormatException numberFormatException) {
            this.m_Count = 0;
            this.m_CountId = string;
        }
    }

    private void setCcsid(String string) {
        if (string == null || string.equals("")) {
            this.m_Ccsid = 0;
            this.m_CcsidId = null;
            return;
        }
        this.m_CcsidWasSpecified = true;
        try {
            this.m_Ccsid = Integer.parseInt(string);
            this.m_CcsidId = null;
        }
        catch (NumberFormatException numberFormatException) {
            this.m_Ccsid = 0;
            this.m_CcsidId = string;
        }
    }

    void setInit(String string) {
        this.m_Init = string;
    }

    protected void setLength(String string) {
        if (string == null || string.equals("")) {
            this.m_Length = 0;
            this.m_LengthId = null;
            return;
        }
        this.m_LengthWasSpecified = true;
        try {
            this.m_Length = Integer.parseInt(string);
            this.m_LengthId = null;
        }
        catch (NumberFormatException numberFormatException) {
            this.m_Length = 0;
            this.m_LengthId = string;
        }
    }

    private void setMaxvrm(String string) {
        this.m_MaxvrmInt = Integer.MAX_VALUE;
        if (string == null || string.equals("")) {
            this.m_Maxvrm = null;
            return;
        }
        this.m_Maxvrm = string;
    }

    private void setMinvrm(String string) {
        this.m_MinvrmInt = Integer.MIN_VALUE;
        if (string == null || string.equals("")) {
            this.m_Minvrm = null;
            return;
        }
        this.m_Minvrm = string;
    }

    private void setOffset(String string) {
        if (string == null || string.equals("")) {
            this.m_Offset = 0;
            this.m_OffsetId = null;
            return;
        }
        try {
            this.m_Offset = Integer.parseInt(string);
            this.m_OffsetId = null;
        }
        catch (NumberFormatException numberFormatException) {
            this.m_Offset = 0;
            this.m_OffsetId = string;
        }
    }

    private void setOffsetfrom(String string) {
        this.m_OffsetfromFixed = true;
        if (string == null || string.equals("")) {
            this.m_Offsetfrom = -1;
            this.m_OffsetfromId = null;
            return;
        }
        try {
            this.m_Offsetfrom = Integer.parseInt(string);
            this.m_OffsetfromId = null;
        }
        catch (NumberFormatException numberFormatException) {
            this.m_Offsetfrom = 0;
            this.m_OffsetfromId = string;
        }
    }

    private void setOutputsize(String string) {
        if (string == null || string.equals("")) {
            this.m_Outputsize = 0;
            return;
        }
        try {
            this.m_Outputsize = Integer.parseInt(string);
            this.m_OutputsizeId = null;
        }
        catch (NumberFormatException numberFormatException) {
            this.m_Outputsize = 0;
            this.m_OutputsizeId = string;
        }
    }

    private void setPassby(String string) {
        if (string == null || string.equals("")) {
            this.m_PassbyStr = null;
            this.m_Passby = 2;
            return;
        }
        this.m_PassbyStr = string;
        this.m_Passby = this.m_PassbyStr.equals("value") ? 1 : 2;
    }

    private void setBidiStringType(String string) {
        if (string == null || string.equals("") || string.equals("DEFAULT")) {
            this.m_BidistringtypeStr = null;
            this.m_Bidistringtype = 0;
            return;
        }
        this.m_BidistringtypeStr = string;
        Integer n = (Integer)PcmlData.getBidiTypeMap().get(this.m_BidistringtypeStr);
        if (n == null) {
            this.m_Bidistringtype = 0;
            if (Trace.isTraceOn()) {
                Trace.log(7, "[Warning]: Value of 'bidistringtype' attribute is not recognized: " + this.m_BidistringtypeStr);
            }
        } else {
            this.m_Bidistringtype = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable getBidiTypeMap() {
        if (bidiTypeMap_ == null) {
            Class clazz = class$com$ibm$as400$data$PcmlData == null ? (class$com$ibm$as400$data$PcmlData = PcmlData.class$("com.ibm.as400.data.PcmlData")) : class$com$ibm$as400$data$PcmlData;
            synchronized (clazz) {
                if (bidiTypeMap_ == null) {
                    bidiTypeMap_ = new Hashtable(10);
                    bidiTypeMap_.put("DEFAULT", new Integer(0));
                    bidiTypeMap_.put("NONE", new Integer(-1));
                    bidiTypeMap_.put("ST4", new Integer(4));
                    bidiTypeMap_.put("ST5", new Integer(5));
                    bidiTypeMap_.put("ST6", new Integer(6));
                    bidiTypeMap_.put("ST7", new Integer(7));
                    bidiTypeMap_.put("ST8", new Integer(8));
                    bidiTypeMap_.put("ST9", new Integer(9));
                    bidiTypeMap_.put("ST10", new Integer(10));
                    bidiTypeMap_.put("ST11", new Integer(11));
                }
            }
        }
        return bidiTypeMap_;
    }

    private void setPrecision(String string) {
        if (string == null || string.equals("")) {
            this.m_Precision = 0;
            return;
        }
        try {
            this.m_Precision = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.m_Precision = -1;
        }
    }

    private void setStruct(String string) {
        if (string == null || string.equals("")) {
            this.m_StructId = null;
            return;
        }
        this.m_StructId = string;
    }

    private void setType(String string) {
        this.m_TypeStr = string;
        this.m_Type = string.equals("char") ? 1 : (string.equals("int") ? 2 : (string.equals("packed") ? 3 : (string.equals("zoned") ? 4 : (string.equals("float") ? 5 : (string.equals("byte") ? 6 : (string.equals("struct") ? 7 : (string.equals("date") ? 8 : (string.equals("time") ? 9 : (string.equals("timestamp") ? 10 : 0)))))))));
    }

    private void setTrim(String string) {
        if (string == null || string.equals("")) {
            this.m_TrimStr = null;
            return;
        }
        this.m_TrimStr = string;
    }

    private void setCharType(String string) {
        if (string == null || string.equals("")) {
            this.m_CharType = null;
            return;
        }
        this.m_CharType = string;
    }

    private void setKeyField(String string) {
        if (string == null || string.equals("")) {
            this.m_KeyField = false;
            return;
        }
        this.m_KeyFieldStr = string;
        this.m_KeyField = string.equalsIgnoreCase("true");
    }

    private void setDateFormat(String string) {
        if (string == null || string.equals("")) {
            this.m_DateFormat = null;
            return;
        }
        this.m_DateFormat = string;
    }

    private void setDateSeparator(String string) {
        if (string == null || string.equals("")) {
            this.m_DateSeparator = null;
            return;
        }
        this.m_DateSeparator = string;
    }

    private void setTimeFormat(String string) {
        if (string == null || string.equals("")) {
            this.m_TimeFormat = null;
            return;
        }
        this.m_TimeFormat = string;
    }

    private void setTimeSeparator(String string) {
        if (string == null || string.equals("")) {
            this.m_TimeSeparator = null;
            return;
        }
        this.m_TimeSeparator = string;
    }

    protected void checkAttributes() {
        Object object;
        PcmlDocNode pcmlDocNode = null;
        super.checkAttributes();
        if (this.m_CountId != null) {
            pcmlDocNode = this.resolveRelativeNode(this.m_CountId);
            if (pcmlDocNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlDocNode.makeQuotedAttr("count", this.m_CountId), this.getNameForException()});
            } else if (pcmlDocNode instanceof PcmlData) {
                if (((PcmlData)pcmlDocNode).getDataType() != 2) {
                    this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_NODETYPE", new Object[]{PcmlDocNode.makeQuotedAttr("count", this.m_CountId), pcmlDocNode.getQualifiedName(), "<data>", this.getNameForException()});
                }
            } else {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_DATATYPE", new Object[]{PcmlDocNode.makeQuotedAttr("count", this.m_CountId), pcmlDocNode.getQualifiedName(), "type=\"int\"", this.getNameForException()});
            }
        } else if (this.m_Count < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("count", this.m_Count), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_IsRfml && this.m_CcsidWasSpecified && this.getDataType() != 1) {
            this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlDocNode.makeQuotedAttr("ccsid", this.getAttributeValue("ccsid")), PcmlDocNode.makeQuotedAttr("type", this.getDataTypeString()), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_CcsidId != null) {
            pcmlDocNode = this.resolveRelativeNode(this.m_CcsidId);
            if (pcmlDocNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlDocNode.makeQuotedAttr("ccsid", this.m_CcsidId), this.getNameForException()});
            } else if (pcmlDocNode instanceof PcmlData) {
                if (((PcmlData)pcmlDocNode).getDataType() != 2) {
                    this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_NODETYPE", new Object[]{PcmlDocNode.makeQuotedAttr("ccsid", this.m_CcsidId), pcmlDocNode.getQualifiedName(), "<data>", this.getNameForException()});
                }
            } else {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_DATATYPE", new Object[]{PcmlDocNode.makeQuotedAttr("ccsid", this.m_CcsidId), pcmlDocNode.getQualifiedName(), "type=\"int\"", this.getNameForException()});
            }
        } else if (this.m_Ccsid < 0 || this.m_Ccsid > 65535) {
            this.getDoc().addPcmlSpecificationError("DATA_LENGTH_OUT_OF_RANGE", new Object[]{new Integer(this.m_Ccsid), new Integer(0), new Integer(65535), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.getInit() != null) {
            switch (this.getDataType()) {
                default: 
            }
            try {
                object = this.getDoc().getTimeZone();
                PcmlDataValues.convertValue(this.getInit(), this.getDataType(), this.getLength(), this.getPrecision(), this.getNameForException(), (TimeZone)object);
            }
            catch (Exception exception) {
                this.getDoc().addPcmlSpecificationError("INITIAL_VALUE_ERROR", new Object[]{this.getInit(), this.getBracketedTagName(), this.getNameForException()});
            }
        }
        if (this.m_LengthId != null) {
            switch (this.getDataType()) {
                case 1: 
                case 6: {
                    break;
                }
                default: {
                    this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlDocNode.makeQuotedAttr("length", this.getAttributeValue("length")), this.getDataTypeString(), this.getBracketedTagName(), this.getNameForException()});
                }
            }
            pcmlDocNode = this.resolveRelativeNode(this.m_LengthId);
            if (pcmlDocNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlDocNode.makeQuotedAttr("length", this.m_LengthId), this.getNameForException()});
            } else if (pcmlDocNode instanceof PcmlData) {
                if (((PcmlData)pcmlDocNode).getDataType() != 2) {
                    this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_NODETYPE", new Object[]{PcmlDocNode.makeQuotedAttr("length", this.m_LengthId), pcmlDocNode.getQualifiedName(), "<data>", this.getNameForException()});
                }
            } else {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_DATATYPE", new Object[]{PcmlDocNode.makeQuotedAttr("length", this.m_LengthId), pcmlDocNode.getQualifiedName(), "type=\"int\"", this.getNameForException()});
            }
        } else if (this.m_Length < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_SYNTAX", new Object[]{PcmlDocNode.makeQuotedAttr("length", this.getAttributeValue("length")), "type=\"int\"", this.getBracketedTagName(), this.getNameForException()});
        } else {
            switch (this.getDataType()) {
                case 1: 
                case 6: {
                    if (this.m_Length >= 0 && this.m_Length <= 0xFFEFF0) break;
                    this.getDoc().addPcmlSpecificationError("DATA_LENGTH_OUT_OF_RANGE", new Object[]{new Integer(this.m_Length), new Integer(0), new Integer(0xFFEFF0), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                case 2: {
                    if (this.m_Length == 2 || this.m_Length == 4 || this.m_Length == 8) break;
                    this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("length", this.m_Length), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                case 3: 
                case 4: {
                    if (this.m_Length >= 1 && this.m_Length <= 31) break;
                    this.getDoc().addPcmlSpecificationError("DATA_LENGTH_OUT_OF_RANGE", new Object[]{new Integer(this.m_Length), new Integer(1), new Integer(31), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                case 5: {
                    if (this.m_Length == 4 || this.m_Length == 8) break;
                    this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("length", this.m_Length), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    if (this.getAttributeValue("length") == null || this.getAttributeValue("length").equals("")) break;
                    this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlDocNode.makeQuotedAttr("length", this.getAttributeValue("length")), PcmlDocNode.makeQuotedAttr("type", this.getAttributeValue("type")), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                default: {
                    this.getDoc().addPcmlSpecificationError("BAD_DATA_TYPE", new Object[]{PcmlDocNode.makeQuotedAttr("type", this.getAttributeValue("type")), this.getBracketedTagName(), this.getNameForException()});
                }
            }
            if (!this.m_LengthWasSpecified && this.getDataType() != 7 && this.getDataType() != 8 && this.getDataType() != 9 && this.getDataType() != 10) {
                if (this.m_IsRfml || ProgramCallDocument.exceptionIfParseError_) {
                    this.getDoc().addPcmlSpecificationError("NO_LENGTH", new Object[]{PcmlDocNode.makeQuotedAttr("length", null), this.getBracketedTagName(), this.getNameForException()});
                } else if (Trace.isTraceOn()) {
                    Trace.log(7, "[Warning]: 'length' attribute was not specified in " + this.getBracketedTagName() + " element: " + this.getNameForException());
                }
            }
            if (this.m_IsRfml) {
                if (this.getDataType() == 7) {
                    if (this.getAttributeValue("struct") == null || this.getAttributeValue("struct").equals("")) {
                        this.getDoc().addPcmlSpecificationError("NO_STRUCT", new Object[]{PcmlDocNode.makeQuotedAttr("struct", null), this.getBracketedTagName(), this.getNameForException()});
                    }
                } else if (this.getDataType() != 8 && this.getDataType() != 9 && this.getDataType() != 10 && !this.m_LengthWasSpecified) {
                    this.getDoc().addPcmlSpecificationError("NO_LENGTH", new Object[]{PcmlDocNode.makeQuotedAttr("length", null), this.getBracketedTagName(), this.getNameForException()});
                }
            }
        }
        if (this.m_OffsetId != null) {
            pcmlDocNode = this.resolveRelativeNode(this.m_OffsetId);
            if (pcmlDocNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlDocNode.makeQuotedAttr("offset", this.m_OffsetId), this.getNameForException()});
            } else if (pcmlDocNode instanceof PcmlData) {
                if (((PcmlData)pcmlDocNode).getDataType() != 2) {
                    this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_NODETYPE", new Object[]{PcmlDocNode.makeQuotedAttr("offset", this.m_OffsetId), pcmlDocNode.getQualifiedName(), "<data>", this.getNameForException()});
                }
            } else {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_DATATYPE", new Object[]{PcmlDocNode.makeQuotedAttr("offset", this.m_OffsetId), pcmlDocNode.getQualifiedName(), "type=\"int\"", this.getNameForException()});
            }
        } else if (this.m_Offset < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("offset", this.m_Offset), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_OffsetfromId != null) {
            pcmlDocNode = this.resolveRelativeNode(this.m_OffsetfromId);
            if (pcmlDocNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlDocNode.makeQuotedAttr("offsetfrom", this.m_OffsetfromId), this.getNameForException()});
            } else {
                String string;
                object = this.getQualifiedName();
                if (((String)object).equals("")) {
                    object = this.getNameForException();
                }
                if (!((String)object).startsWith((string = pcmlDocNode.getQualifiedName()) + ".")) {
                    this.getDoc().addPcmlSpecificationError("OFFSETFROM_NOT_FOUND", new Object[]{this.m_OffsetfromId, this.getNameForException()});
                }
            }
        } else if (this.m_Offsetfrom < -1) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("offsetfrom", this.m_Offsetfrom), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_OutputsizeId != null) {
            pcmlDocNode = this.resolveRelativeNode(this.m_OutputsizeId);
            if (pcmlDocNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlDocNode.makeQuotedAttr("outputsize", this.m_OutputsizeId), this.getNameForException()});
            } else if (pcmlDocNode instanceof PcmlData) {
                if (((PcmlData)pcmlDocNode).getDataType() != 2) {
                    this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_NODETYPE", new Object[]{PcmlDocNode.makeQuotedAttr("outputsize", this.m_OutputsizeId), pcmlDocNode.getQualifiedName(), "<data>", this.getNameForException()});
                }
            } else {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_DATATYPE", new Object[]{PcmlDocNode.makeQuotedAttr("outputsize", this.m_OutputsizeId), pcmlDocNode.getQualifiedName(), "type=\"int\"", this.getNameForException()});
            }
        } else if (this.m_Outputsize < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("outputsize", this.m_Outputsize), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.getAttributeValue("precision") != null && !this.getAttributeValue("precision").equals("")) {
            switch (this.getDataType()) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlDocNode.makeQuotedAttr("precision", this.getAttributeValue("precision")), PcmlDocNode.makeQuotedAttr("type", this.getDataTypeString()), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                case 2: {
                    if (this.m_Length == 2 && this.m_Precision != 15 && this.m_Precision != 16) {
                        this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("precision", this.getAttributeValue("precision")), this.getBracketedTagName(), this.getNameForException()});
                    }
                    if (this.m_Length == 4 && this.m_Precision != 31 && this.m_Precision != 32) {
                        this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("precision", this.getAttributeValue("precision")), this.getBracketedTagName(), this.getNameForException()});
                    }
                    if (this.m_Length != 8 || this.m_Precision == 63 || this.m_Precision == 64) break;
                    this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("precision", this.getAttributeValue("precision")), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                case 3: 
                case 4: {
                    if (this.m_Precision >= 0 && this.m_Precision <= this.m_Length) break;
                    this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("precision", this.getAttributeValue("precision")), this.getBracketedTagName(), this.getNameForException()});
                }
            }
        }
        if (this.m_StructId != null && this.getDataType() != 7) {
            this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlDocNode.makeQuotedAttr("struct", this.getAttributeValue("struct")), PcmlDocNode.makeQuotedAttr("type", this.getDataTypeString()), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_Minvrm != null) {
            this.m_MinvrmInt = PcmlData.validateVRM(this.m_Minvrm);
            if (this.m_MinvrmInt <= 0) {
                this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("minvrm", this.m_Minvrm), this.getBracketedTagName(), this.getNameForException()});
            }
        }
        if (this.m_Maxvrm != null) {
            this.m_MaxvrmInt = PcmlData.validateVRM(this.m_Maxvrm);
            if (this.m_MaxvrmInt <= 0) {
                this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("maxvrm", this.m_Maxvrm), this.getBracketedTagName(), this.getNameForException()});
            }
        }
        if (this.m_PassbyStr != null) {
            if (this.getDoc().getVersion().compareTo("2.0") < 0) {
                this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlDocNode.makeQuotedAttr("passby", this.m_PassbyStr), "2.0", this.getBracketedTagName(), this.getNameForException()});
            }
            if (!(this.getParent() instanceof PcmlProgram)) {
                this.getDoc().addPcmlSpecificationError("NOT_CHILD_OF_PGM", new Object[]{PcmlDocNode.makeQuotedAttr("passby", this.m_PassbyStr), this.getBracketedTagName(), this.getNameForException()});
            }
        }
        if (this.m_BidistringtypeStr != null && this.getDoc().getVersion().compareTo("3.0") < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlDocNode.makeQuotedAttr("bidistringtype", this.m_BidistringtypeStr), "3.0", this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_TrimStr != null && this.getDoc().getVersion().compareTo("4.0") < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlDocNode.makeQuotedAttr("trim", this.m_TrimStr), "4.0", this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_CharType != null) {
            if (this.getDoc().getVersion().compareTo("4.0") < 0) {
                this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlDocNode.makeQuotedAttr("chartype", this.m_CharType), "4.0", this.getBracketedTagName(), this.getNameForException()});
            } else if (this.getDataType() != 1) {
                this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlDocNode.makeQuotedAttr("chartype", this.getAttributeValue("chartype")), PcmlDocNode.makeQuotedAttr("type", this.getDataTypeString()), this.getBracketedTagName(), this.getNameForException()});
            }
        }
        if (this.m_KeyFieldStr != null) {
            if (!this.m_IsRfml) {
                this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlDocNode.makeQuotedAttr("keyfield", this.getAttributeValue("keyfield")), PcmlDocNode.makeQuotedAttr("pcml", this.getDataTypeString()), this.getBracketedTagName(), this.getNameForException()});
            }
            if (this.getDoc().getVersion().compareTo("5.0") < 0) {
                this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlDocNode.makeQuotedAttr("keyfield", this.m_KeyFieldStr), "5.0", this.getBracketedTagName(), this.getNameForException()});
            }
        }
        if (this.m_DateFormat != null) {
            if (this.getDoc().getVersion().compareTo("6.0") < 0) {
                this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlDocNode.makeQuotedAttr("dateformat", this.m_DateFormat), "6.0", this.getBracketedTagName(), this.getNameForException()});
            }
            switch (this.getDataType()) {
                case 8: {
                    if (AS400Date.validateFormat(AS400Date.toFormat(this.m_DateFormat))) break;
                    this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("dateformat", this.getAttributeValue("dateformat")), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                default: {
                    this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlDocNode.makeQuotedAttr("dateformat", this.getAttributeValue("dateformat")), PcmlDocNode.makeQuotedAttr("type", this.getDataTypeString()), this.getBracketedTagName(), this.getNameForException()});
                }
            }
        }
        if (this.m_DateSeparator != null) {
            if (this.getDoc().getVersion().compareTo("6.0") < 0) {
                this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlDocNode.makeQuotedAttr("dateseparator", this.m_DateSeparator), "6.0", this.getBracketedTagName(), this.getNameForException()});
            }
            switch (this.getDataType()) {
                case 8: {
                    if (PcmlNode.isValidSeparatorName(this.m_DateSeparator)) break;
                    Trace.log(7, "Separator name '" + this.m_DateSeparator + "' is not recognized.");
                    this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("dateseparator", this.getAttributeValue("dateseparator")), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                default: {
                    this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlDocNode.makeQuotedAttr("dateseparator", this.getAttributeValue("dateseparator")), PcmlDocNode.makeQuotedAttr("type", this.getDataTypeString()), this.getBracketedTagName(), this.getNameForException()});
                }
            }
        }
        if (this.m_TimeFormat != null) {
            if (this.getDoc().getVersion().compareTo("6.0") < 0) {
                this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlDocNode.makeQuotedAttr("timeformat", this.m_TimeFormat), "6.0", this.getBracketedTagName(), this.getNameForException()});
            }
            switch (this.getDataType()) {
                case 9: {
                    if (AS400Time.validateFormat(AS400Time.toFormat(this.m_TimeFormat))) break;
                    this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("timeformat", this.getAttributeValue("timeformat")), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                default: {
                    this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlDocNode.makeQuotedAttr("timeformat", this.getAttributeValue("timeformat")), PcmlDocNode.makeQuotedAttr("type", this.getDataTypeString()), this.getBracketedTagName(), this.getNameForException()});
                }
            }
        }
        if (this.m_TimeSeparator != null) {
            if (this.getDoc().getVersion().compareTo("6.0") < 0) {
                this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlDocNode.makeQuotedAttr("timeseparator", this.m_TimeSeparator), "6.0", this.getBracketedTagName(), this.getNameForException()});
            }
            switch (this.getDataType()) {
                case 9: {
                    if (PcmlNode.isValidSeparatorName(this.m_TimeSeparator)) break;
                    Trace.log(7, "Separator name '" + this.m_TimeSeparator + "' is not recognized.");
                    this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("timeseparator", this.getAttributeValue("timeseparator")), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                default: {
                    this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlDocNode.makeQuotedAttr("timeseparator", this.getAttributeValue("timeseparator")), PcmlDocNode.makeQuotedAttr("type", this.getDataTypeString()), this.getBracketedTagName(), this.getNameForException()});
                }
            }
        }
    }

    static int validateVRM(String string) {
        int n = -1;
        int[] nArray = new int[]{-1, -1, -1};
        StringTokenizer stringTokenizer = new StringTokenizer(string, vrmDelimChars, true);
        int n2 = 0;
        StringTokenizer stringTokenizer2 = new StringTokenizer(vrmDelimChars, vrmDelimChars, true);
        if (stringTokenizer.countTokens() == 6) {
            while (stringTokenizer2.hasMoreTokens()) {
                if (!stringTokenizer.nextToken().equals(stringTokenizer2.nextToken())) continue;
                try {
                    nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
                    ++n2;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        if (nArray[0] >= 1 && nArray[0] <= 255 && nArray[1] >= 0 && nArray[0] <= 255 && nArray[2] >= 0 && nArray[0] <= 255) {
            n = AS400.generateVRM(nArray[0], nArray[1], nArray[2]);
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

