/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.PermissionAccess;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.QSYSPermission;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserPermission;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;

class PermissionAccessQSYS
extends PermissionAccess {
    public PermissionAccessQSYS(AS400 aS400) {
        super(aS400);
    }

    public void addUser(String string, UserPermission userPermission) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall commandCall = PermissionAccessQSYS.getAddCommand(this.as400_, string, userPermission);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    protected final String expandQuotes(String string) {
        return PermissionAccessQSYS.expandQuotes0(string);
    }

    static String expandQuotes0(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.insert(0, '\'');
        stringBuffer.append('\'');
        if (string.indexOf(34) != -1) {
            stringBuffer.insert(0, "''");
            stringBuffer.append("''");
        }
        return stringBuffer.toString();
    }

    private static CommandCall getAddCommand(AS400 aS400, String string, UserPermission userPermission) {
        String string2;
        String string3;
        QSYSPermission qSYSPermission;
        boolean bl;
        block3: {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
            String string4 = qSYSObjectPathName.getObjectType();
            bl = string4.equals("AUTL");
            if (!bl) {
                return PermissionAccessQSYS.getChgCommand(aS400, string, userPermission);
            }
            qSYSPermission = (QSYSPermission)userPermission;
            string3 = qSYSPermission.getUserID();
            string2 = qSYSObjectPathName.getObjectName();
            try {
                string2 = CharConverter.convertIFSQSYSPathnameToJobPathname(string2, aS400.getCcsid());
            }
            catch (Exception exception) {
                if (!Trace.traceOn_) break block3;
                Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)exception);
            }
        }
        String string5 = "ADDAUTLE AUTL(" + string2 + ")" + " USER(" + string3 + ")" + " AUT(" + qSYSPermission.getAuthorities(bl) + ")";
        CommandCall commandCall = new CommandCall(aS400, string5);
        return commandCall;
    }

    private static CommandCall getClrCommand(AS400 aS400, String string, UserPermission userPermission) {
        Object object;
        String string2;
        String string3;
        String string4;
        String string5;
        QSYSObjectPathName qSYSObjectPathName;
        block9: {
            qSYSObjectPathName = new QSYSObjectPathName(string);
            QSYSPermission qSYSPermission = (QSYSPermission)userPermission;
            string5 = qSYSPermission.getUserID();
            string4 = qSYSObjectPathName.getObjectName();
            string3 = qSYSObjectPathName.getObjectType();
            boolean bl = string3.equals("AUTL");
            if (string4.equals("")) {
                string4 = qSYSObjectPathName.getLibraryName();
            } else if (!bl) {
                string4 = qSYSObjectPathName.getLibraryName() + "/" + string4;
            }
            if (string3.equalsIgnoreCase("MBR")) {
                string3 = "FILE";
            }
            try {
                string4 = CharConverter.convertIFSQSYSPathnameToJobPathname(string4, aS400.getCcsid());
            }
            catch (Exception exception) {
                if (!Trace.traceOn_) break block9;
                Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)exception);
            }
        }
        if (string3.equals("AUTL")) {
            string2 = "CHGAUTLE AUTL(" + string4 + ")" + " USER(" + string5 + ")" + " AUT(*EXCLUDE)";
        } else {
            object = "";
            String string6 = qSYSObjectPathName.getAspName();
            if (!string6.equals("")) {
                object = " ASPDEV(" + string6 + ")";
            }
            string2 = "GRTOBJAUT OBJ(" + string4 + ")" + " OBJTYPE(*" + string3 + ")" + " USER(" + string5 + ")" + (String)object + " AUT(*EXCLUDE)";
        }
        object = new CommandCall(aS400, string2);
        return object;
    }

    private static CommandCall getChgCommand(AS400 aS400, String string, UserPermission userPermission) {
        Object object;
        String string2;
        boolean bl;
        String string3;
        String string4;
        String string5;
        QSYSPermission qSYSPermission;
        QSYSObjectPathName qSYSObjectPathName;
        block9: {
            qSYSObjectPathName = new QSYSObjectPathName(string);
            qSYSPermission = (QSYSPermission)userPermission;
            string5 = qSYSPermission.getUserID();
            string4 = qSYSObjectPathName.getObjectName();
            string3 = qSYSObjectPathName.getObjectType();
            bl = string3.equals("AUTL");
            if (string4.equals("")) {
                string4 = "QSYS/" + qSYSObjectPathName.getLibraryName();
            } else if (!bl) {
                string4 = qSYSObjectPathName.getLibraryName() + "/" + string4;
            }
            if (string3.equalsIgnoreCase("MBR")) {
                string3 = "FILE";
            }
            try {
                string4 = CharConverter.convertIFSQSYSPathnameToJobPathname(string4, aS400.getCcsid());
            }
            catch (Exception exception) {
                if (!Trace.traceOn_) break block9;
                Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)exception);
            }
        }
        if (string3.equals("AUTL")) {
            string2 = "CHGAUTLE AUTL(" + string4 + ")" + " USER(" + string5 + ")" + " AUT(" + qSYSPermission.getAuthorities(bl) + ")";
        } else {
            object = "";
            String string6 = qSYSObjectPathName.getAspName();
            if (!string6.equals("")) {
                object = " ASPDEV(" + string6 + ")";
            }
            string2 = "GRTOBJAUT OBJ(" + string4 + ")" + " OBJTYPE(*" + string3 + ")" + " USER(" + string5 + ")" + (String)object + " AUT(" + qSYSPermission.getAuthorities(bl) + ")" + " REPLACE(*YES)";
        }
        object = new CommandCall(aS400, string2);
        return object;
    }

    private static CommandCall getRmvCommand(AS400 aS400, String string, String string2, boolean bl) {
        Object object;
        String string3;
        QSYSObjectPathName qSYSObjectPathName;
        String string4;
        String string5 = PermissionAccess.toUpperCasePath(string);
        String string6 = null;
        int n = string5.toUpperCase().indexOf("/QSYS.LIB");
        if (n > 0) {
            string6 = string.substring(0, n);
            string = string.substring(n);
        }
        if ((string4 = (qSYSObjectPathName = new QSYSObjectPathName(string)).getObjectType()).equals("AUTL")) {
            String string7;
            block11: {
                string7 = qSYSObjectPathName.getObjectName();
                try {
                    string7 = CharConverter.convertIFSQSYSPathnameToJobPathname(string7, aS400.getCcsid());
                }
                catch (Exception exception) {
                    if (!Trace.traceOn_) break block11;
                    Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)exception);
                }
            }
            string3 = "RMVAUTLE AUTL(" + string7 + ")" + " USER(" + string2 + ")";
        } else if (string4.equals("MBR")) {
            String string8 = string6 != null ? string6 + "/QSYS.LIB/" : "/QSYS.LIB/";
            if (!qSYSObjectPathName.getLibraryName().equals("")) {
                string8 = string8 + qSYSObjectPathName.getLibraryName() + ".LIB/";
            }
            string8 = string8 + qSYSObjectPathName.getObjectName() + ".FILE";
            string3 = "CHGAUT OBJ(" + PermissionAccessQSYS.expandQuotes0(string8) + ")" + " USER(" + string2 + ")" + " DTAAUT(*NONE)" + " OBJAUT(*NONE)";
            if (!bl) {
                string3 = string3 + " SYMLNK(*YES)";
            }
        } else {
            object = string;
            if (string6 != null) {
                object = string6 + (String)object;
            }
            string3 = "CHGAUT OBJ(" + PermissionAccessQSYS.expandQuotes0((String)object) + ")" + " USER(" + string2 + ")" + " DTAAUT(*NONE)" + " OBJAUT(*NONE)";
            if (!bl) {
                string3 = string3 + " SYMLNK(*YES)";
            }
        }
        object = new CommandCall(aS400, string3);
        return object;
    }

    public UserPermission getUserPermission(Record record) throws UnsupportedEncodingException {
        String string = ((String)record.getField("profileName")).trim();
        String string2 = ((String)record.getField("userOrGroup")).trim();
        String string3 = ((String)record.getField("dataAuthority")).trim();
        String string4 = ((String)record.getField("autListMgt")).trim();
        String string5 = ((String)record.getField("objMgt")).trim();
        String string6 = ((String)record.getField("objExistence")).trim();
        String string7 = ((String)record.getField("objAlter")).trim();
        String string8 = ((String)record.getField("objRef")).trim();
        String string9 = ((String)record.getField("objOperational")).trim();
        String string10 = ((String)record.getField("dataRead")).trim();
        String string11 = ((String)record.getField("dataAdd")).trim();
        String string12 = ((String)record.getField("dataUpdate")).trim();
        String string13 = ((String)record.getField("dataDelete")).trim();
        String string14 = ((String)record.getField("dataExecute")).trim();
        String string15 = ((String)record.getField("reserved2")).trim();
        QSYSPermission qSYSPermission = new QSYSPermission(string);
        qSYSPermission.setGroupIndicator(this.getIntValue(string2));
        qSYSPermission.setAuthorizationListManagement(this.getBooleanValue(string4));
        qSYSPermission.setManagement(this.getBooleanValue(string5));
        qSYSPermission.setExistence(this.getBooleanValue(string6));
        qSYSPermission.setAlter(this.getBooleanValue(string7));
        qSYSPermission.setReference(this.getBooleanValue(string8));
        qSYSPermission.setOperational(this.getBooleanValue(string9));
        qSYSPermission.setRead(this.getBooleanValue(string10));
        qSYSPermission.setAdd(this.getBooleanValue(string11));
        qSYSPermission.setUpdate(this.getBooleanValue(string12));
        qSYSPermission.setDelete(this.getBooleanValue(string13));
        qSYSPermission.setExecute(this.getBooleanValue(string14));
        if (string3.equalsIgnoreCase("*AUTL")) {
            qSYSPermission.setFromAuthorizationList(true);
        }
        return qSYSPermission;
    }

    public void removeUser(String string, String string2) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall commandCall = PermissionAccessQSYS.getRmvCommand(this.as400_, string, string2, this.followSymbolicLinks_);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public synchronized void setAuthority(String string, UserPermission userPermission) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall commandCall = PermissionAccessQSYS.getChgCommand(this.as400_, string, userPermission);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public synchronized void setAuthorizationList(String string, String string2, String string3) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall commandCall;
        String string4;
        String string5;
        QSYSObjectPathName qSYSObjectPathName;
        block5: {
            qSYSObjectPathName = new QSYSObjectPathName(string);
            string5 = qSYSObjectPathName.getObjectName();
            string5 = string5.equals("") ? "QSYS/" + qSYSObjectPathName.getLibraryName() : qSYSObjectPathName.getLibraryName() + "/" + string5;
            string4 = qSYSObjectPathName.getObjectType();
            if (string4.trim().equalsIgnoreCase("MBR")) {
                string4 = "FILE";
            }
            commandCall = new CommandCall(this.as400_);
            try {
                string5 = CharConverter.convertIFSQSYSPathnameToJobPathname(string5, this.as400_.getCcsid());
            }
            catch (Exception exception) {
                if (!Trace.traceOn_) break block5;
                Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)exception);
            }
        }
        String string6 = "";
        String string7 = qSYSObjectPathName.getAspName();
        if (!string7.equals("")) {
            string6 = " ASPDEV(" + string7 + ")";
        }
        String string8 = !string3.equalsIgnoreCase("*NONE") && string2.equalsIgnoreCase("*NONE") ? "RVKOBJAUT OBJ(" + string5 + ")" + " OBJTYPE(*" + string4 + ")" + string6 + " AUTL(" + string3 + ")" : "GRTOBJAUT OBJ(" + string5 + ")" + " OBJTYPE(*" + string4 + ")" + string6 + " AUTL(" + string2 + ")";
        commandCall.setCommand(string8);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public synchronized void setFromAuthorizationList(String string, boolean bl) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall commandCall;
        String string2;
        String string3;
        QSYSObjectPathName qSYSObjectPathName;
        block5: {
            qSYSObjectPathName = new QSYSObjectPathName(string);
            string3 = qSYSObjectPathName.getObjectName();
            string3 = string3.equals("") ? "QSYS/" + qSYSObjectPathName.getLibraryName() : qSYSObjectPathName.getLibraryName() + "/" + string3;
            string2 = qSYSObjectPathName.getObjectType();
            if (string2.equalsIgnoreCase("MBR")) {
                string2 = "FILE";
            }
            commandCall = new CommandCall(this.as400_);
            try {
                string3 = CharConverter.convertIFSQSYSPathnameToJobPathname(string3, this.as400_.getCcsid());
            }
            catch (Exception exception) {
                if (!Trace.traceOn_) break block5;
                Trace.log(4, "Unable to convert CL command to correct job CCSID.", (Throwable)exception);
            }
        }
        String string4 = "";
        String string5 = qSYSObjectPathName.getAspName();
        if (!string5.equals("")) {
            string4 = " ASPDEV(" + string5 + ")";
        }
        String string6 = bl ? "GRTOBJAUT OBJ(" + string3 + ")" + " OBJTYPE(*" + string2 + ")" + " USER(*PUBLIC)" + string4 + " AUT(*AUTL)" : "GRTOBJAUT OBJ(" + string3 + ")" + " OBJTYPE(*" + string2 + ")" + " USER(*PUBLIC)" + string4 + " AUT(*EXCLUDE)";
        commandCall.setCommand(string6);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public synchronized void setSensitivity(String string, int n) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
    }
}

