/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import io.netty.channel.Channel;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.StreamCallbackWithID;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.server.OneForOneStreamManager;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.network.shuffle.ExternalShuffleBlockResolver;
import org.apache.spark.network.shuffle.MergedBlockMeta;
import org.apache.spark.network.shuffle.MergedShuffleFileManager;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.apache.spark.network.shuffle.protocol.BlocksRemoved;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;
import org.apache.spark.network.shuffle.protocol.FetchShuffleBlocks;
import org.apache.spark.network.shuffle.protocol.FinalizeShuffleMerge;
import org.apache.spark.network.shuffle.protocol.GetLocalDirsForExecutors;
import org.apache.spark.network.shuffle.protocol.LocalDirsForExecutors;
import org.apache.spark.network.shuffle.protocol.MergeStatuses;
import org.apache.spark.network.shuffle.protocol.OpenBlocks;
import org.apache.spark.network.shuffle.protocol.PushBlockStream;
import org.apache.spark.network.shuffle.protocol.RegisterExecutor;
import org.apache.spark.network.shuffle.protocol.RemoveBlocks;
import org.apache.spark.network.shuffle.protocol.StreamHandle;
import org.apache.spark.network.util.NettyUtils;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.guava.annotations.VisibleForTesting;

public class ExternalBlockHandler
extends RpcHandler {
    private static final Logger logger = LoggerFactory.getLogger(ExternalBlockHandler.class);
    @VisibleForTesting
    final ExternalShuffleBlockResolver blockManager;
    private final OneForOneStreamManager streamManager;
    private final ShuffleMetrics metrics = new ShuffleMetrics();
    private final MergedShuffleFileManager mergeManager;

    public ExternalBlockHandler(TransportConf conf, File registeredExecutorFile) throws IOException {
        this(new OneForOneStreamManager(), new ExternalShuffleBlockResolver(conf, registeredExecutorFile), (MergedShuffleFileManager)new NoOpMergedShuffleFileManager(conf));
    }

    public ExternalBlockHandler(TransportConf conf, File registeredExecutorFile, MergedShuffleFileManager mergeManager) throws IOException {
        this(new OneForOneStreamManager(), new ExternalShuffleBlockResolver(conf, registeredExecutorFile), mergeManager);
    }

    @VisibleForTesting
    public ExternalShuffleBlockResolver getBlockResolver() {
        return this.blockManager;
    }

    @VisibleForTesting
    public ExternalBlockHandler(OneForOneStreamManager streamManager, ExternalShuffleBlockResolver blockManager) {
        this(streamManager, blockManager, (MergedShuffleFileManager)new NoOpMergedShuffleFileManager(null));
    }

    @VisibleForTesting
    public ExternalBlockHandler(OneForOneStreamManager streamManager, ExternalShuffleBlockResolver blockManager, MergedShuffleFileManager mergeManager) {
        this.streamManager = streamManager;
        this.blockManager = blockManager;
        this.mergeManager = mergeManager;
    }

    public void receive(TransportClient client, ByteBuffer message, RpcResponseCallback callback) {
        BlockTransferMessage msgObj = BlockTransferMessage.Decoder.fromByteBuffer(message);
        this.handleMessage(msgObj, client, callback);
    }

    public StreamCallbackWithID receiveStream(TransportClient client, ByteBuffer messageHeader, RpcResponseCallback callback) {
        BlockTransferMessage msgObj = BlockTransferMessage.Decoder.fromByteBuffer(messageHeader);
        if (msgObj instanceof PushBlockStream) {
            PushBlockStream message = (PushBlockStream)msgObj;
            this.checkAuth(client, message.appId);
            return this.mergeManager.receiveBlockDataAsStream(message);
        }
        throw new UnsupportedOperationException("Unexpected message with #receiveStream: " + msgObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessage(BlockTransferMessage msgObj, TransportClient client, RpcResponseCallback callback) {
        if (msgObj instanceof FetchShuffleBlocks || msgObj instanceof OpenBlocks) {
            Timer.Context responseDelayContext = this.metrics.openBlockRequestLatencyMillis.time();
            try {
                long streamId;
                int numBlockIds;
                if (msgObj instanceof FetchShuffleBlocks) {
                    FetchShuffleBlocks msg = (FetchShuffleBlocks)msgObj;
                    this.checkAuth(client, msg.appId);
                    numBlockIds = 0;
                    if (msg.batchFetchEnabled) {
                        numBlockIds = msg.mapIds.length;
                    } else {
                        for (int[] ids : msg.reduceIds) {
                            numBlockIds += ids.length;
                        }
                    }
                    streamId = this.streamManager.registerStream(client.getClientId(), (Iterator)new ShuffleManagedBufferIterator(msg), client.getChannel());
                } else {
                    OpenBlocks msg = (OpenBlocks)msgObj;
                    numBlockIds = msg.blockIds.length;
                    this.checkAuth(client, msg.appId);
                    streamId = this.streamManager.registerStream(client.getClientId(), (Iterator)new ManagedBufferIterator(msg), client.getChannel());
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Registered streamId {} with {} buffers for client {} from host {}", new Object[]{streamId, numBlockIds, client.getClientId(), NettyUtils.getRemoteAddress((Channel)client.getChannel())});
                }
                callback.onSuccess(new StreamHandle(streamId, numBlockIds).toByteBuffer());
            }
            finally {
                responseDelayContext.stop();
            }
        } else if (msgObj instanceof RegisterExecutor) {
            Timer.Context responseDelayContext = this.metrics.registerExecutorRequestLatencyMillis.time();
            try {
                RegisterExecutor msg = (RegisterExecutor)msgObj;
                this.checkAuth(client, msg.appId);
                this.blockManager.registerExecutor(msg.appId, msg.execId, msg.executorInfo);
                this.mergeManager.registerExecutor(msg.appId, msg.executorInfo);
                callback.onSuccess(ByteBuffer.wrap(new byte[0]));
            }
            finally {
                responseDelayContext.stop();
            }
        } else if (msgObj instanceof RemoveBlocks) {
            RemoveBlocks msg = (RemoveBlocks)msgObj;
            this.checkAuth(client, msg.appId);
            int numRemovedBlocks = this.blockManager.removeBlocks(msg.appId, msg.execId, msg.blockIds);
            callback.onSuccess(new BlocksRemoved(numRemovedBlocks).toByteBuffer());
        } else if (msgObj instanceof GetLocalDirsForExecutors) {
            GetLocalDirsForExecutors msg = (GetLocalDirsForExecutors)msgObj;
            this.checkAuth(client, msg.appId);
            Map<String, String[]> localDirs = this.blockManager.getLocalDirs(msg.appId, msg.execIds);
            callback.onSuccess(new LocalDirsForExecutors(localDirs).toByteBuffer());
        } else if (msgObj instanceof FinalizeShuffleMerge) {
            Timer.Context responseDelayContext = this.metrics.finalizeShuffleMergeLatencyMillis.time();
            FinalizeShuffleMerge msg = (FinalizeShuffleMerge)msgObj;
            try {
                this.checkAuth(client, msg.appId);
                MergeStatuses statuses = this.mergeManager.finalizeShuffleMerge(msg);
                callback.onSuccess(statuses.toByteBuffer());
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error while finalizing shuffle merge for application %s shuffle %d", msg.appId, msg.shuffleId), e);
            }
            finally {
                responseDelayContext.stop();
            }
        } else {
            throw new UnsupportedOperationException("Unexpected message: " + msgObj);
        }
    }

    public void exceptionCaught(Throwable cause, TransportClient client) {
        this.metrics.caughtExceptions.inc();
    }

    public MetricSet getAllMetrics() {
        return this.metrics;
    }

    public StreamManager getStreamManager() {
        return this.streamManager;
    }

    public void applicationRemoved(String appId, boolean cleanupLocalDirs) {
        this.blockManager.applicationRemoved(appId, cleanupLocalDirs);
        this.mergeManager.applicationRemoved(appId, cleanupLocalDirs);
    }

    public void executorRemoved(String executorId, String appId) {
        this.blockManager.executorRemoved(executorId, appId);
    }

    public void reregisterExecutor(ExternalShuffleBlockResolver.AppExecId appExecId, ExecutorShuffleInfo executorInfo) {
        this.blockManager.registerExecutor(appExecId.appId, appExecId.execId, executorInfo);
    }

    public void close() {
        this.blockManager.close();
    }

    private void checkAuth(TransportClient client, String appId) {
        if (client.getClientId() != null && !client.getClientId().equals(appId)) {
            throw new SecurityException(String.format("Client for %s not authorized for application %s.", client.getClientId(), appId));
        }
    }

    public void channelActive(TransportClient client) {
        this.metrics.activeConnections.inc();
        super.channelActive(client);
    }

    public void channelInactive(TransportClient client) {
        this.metrics.activeConnections.dec();
        super.channelInactive(client);
    }

    public static class NoOpMergedShuffleFileManager
    implements MergedShuffleFileManager {
        public NoOpMergedShuffleFileManager(TransportConf transportConf) {
        }

        @Override
        public StreamCallbackWithID receiveBlockDataAsStream(PushBlockStream msg) {
            throw new UnsupportedOperationException("Cannot handle shuffle block merge");
        }

        @Override
        public MergeStatuses finalizeShuffleMerge(FinalizeShuffleMerge msg) throws IOException {
            throw new UnsupportedOperationException("Cannot handle shuffle block merge");
        }

        @Override
        public void registerExecutor(String appId, ExecutorShuffleInfo executorInfo) {
        }

        @Override
        public void applicationRemoved(String appId, boolean cleanupLocalDirs) {
        }

        @Override
        public ManagedBuffer getMergedBlockData(String appId, int shuffleId, int reduceId, int chunkId) {
            throw new UnsupportedOperationException("Cannot handle shuffle block merge");
        }

        @Override
        public MergedBlockMeta getMergedBlockMeta(String appId, int shuffleId, int reduceId) {
            throw new UnsupportedOperationException("Cannot handle shuffle block merge");
        }

        @Override
        public String[] getMergedBlockDirs(String appId) {
            throw new UnsupportedOperationException("Cannot handle shuffle block merge");
        }
    }

    private class ShuffleManagedBufferIterator
    implements Iterator<ManagedBuffer> {
        private int mapIdx = 0;
        private int reduceIdx = 0;
        private final String appId;
        private final String execId;
        private final int shuffleId;
        private final long[] mapIds;
        private final int[][] reduceIds;
        private final boolean batchFetchEnabled;

        ShuffleManagedBufferIterator(FetchShuffleBlocks msg) {
            this.appId = msg.appId;
            this.execId = msg.execId;
            this.shuffleId = msg.shuffleId;
            this.mapIds = msg.mapIds;
            this.reduceIds = msg.reduceIds;
            this.batchFetchEnabled = msg.batchFetchEnabled;
        }

        @Override
        public boolean hasNext() {
            assert (this.mapIds.length != 0 && this.mapIds.length == this.reduceIds.length);
            return this.mapIdx < this.mapIds.length && this.reduceIdx < this.reduceIds[this.mapIdx].length;
        }

        @Override
        public ManagedBuffer next() {
            ManagedBuffer block;
            if (!this.batchFetchEnabled) {
                block = ExternalBlockHandler.this.blockManager.getBlockData(this.appId, this.execId, this.shuffleId, this.mapIds[this.mapIdx], this.reduceIds[this.mapIdx][this.reduceIdx]);
                if (this.reduceIdx < this.reduceIds[this.mapIdx].length - 1) {
                    ++this.reduceIdx;
                } else {
                    this.reduceIdx = 0;
                    ++this.mapIdx;
                }
            } else {
                assert (this.reduceIds[this.mapIdx].length == 2);
                block = ExternalBlockHandler.this.blockManager.getContinuousBlocksData(this.appId, this.execId, this.shuffleId, this.mapIds[this.mapIdx], this.reduceIds[this.mapIdx][0], this.reduceIds[this.mapIdx][1]);
                ++this.mapIdx;
            }
            ExternalBlockHandler.this.metrics.blockTransferRateBytes.mark(block != null ? block.size() : 0L);
            return block;
        }
    }

    private class ManagedBufferIterator
    implements Iterator<ManagedBuffer> {
        private int index = 0;
        private final Function<Integer, ManagedBuffer> blockDataForIndexFn;
        private final int size;

        ManagedBufferIterator(OpenBlocks msg) {
            String appId = msg.appId;
            String execId = msg.execId;
            String[] blockIds = msg.blockIds;
            String[] blockId0Parts = blockIds[0].split("_");
            if (blockId0Parts.length == 4 && blockId0Parts[0].equals("shuffle")) {
                int shuffleId = Integer.parseInt(blockId0Parts[1]);
                int[] mapIdAndReduceIds = this.shuffleMapIdAndReduceIds(blockIds, shuffleId);
                this.size = mapIdAndReduceIds.length;
                this.blockDataForIndexFn = index -> ExternalBlockHandler.this.blockManager.getBlockData(appId, execId, shuffleId, mapIdAndReduceIds[index], mapIdAndReduceIds[index + 1]);
            } else if (blockId0Parts.length == 3 && blockId0Parts[0].equals("rdd")) {
                int[] rddAndSplitIds = this.rddAndSplitIds(blockIds);
                this.size = rddAndSplitIds.length;
                this.blockDataForIndexFn = index -> ExternalBlockHandler.this.blockManager.getRddBlockData(appId, execId, rddAndSplitIds[index], rddAndSplitIds[index + 1]);
            } else {
                throw new IllegalArgumentException("Unexpected block id format: " + blockIds[0]);
            }
        }

        private int[] rddAndSplitIds(String[] blockIds) {
            int[] rddAndSplitIds = new int[2 * blockIds.length];
            for (int i = 0; i < blockIds.length; ++i) {
                String[] blockIdParts = blockIds[i].split("_");
                if (blockIdParts.length != 3 || !blockIdParts[0].equals("rdd")) {
                    throw new IllegalArgumentException("Unexpected RDD block id format: " + blockIds[i]);
                }
                rddAndSplitIds[2 * i] = Integer.parseInt(blockIdParts[1]);
                rddAndSplitIds[2 * i + 1] = Integer.parseInt(blockIdParts[2]);
            }
            return rddAndSplitIds;
        }

        private int[] shuffleMapIdAndReduceIds(String[] blockIds, int shuffleId) {
            int[] mapIdAndReduceIds = new int[2 * blockIds.length];
            for (int i = 0; i < blockIds.length; ++i) {
                String[] blockIdParts = blockIds[i].split("_");
                if (blockIdParts.length != 4 || !blockIdParts[0].equals("shuffle")) {
                    throw new IllegalArgumentException("Unexpected shuffle block id format: " + blockIds[i]);
                }
                if (Integer.parseInt(blockIdParts[1]) != shuffleId) {
                    throw new IllegalArgumentException("Expected shuffleId=" + shuffleId + ", got:" + blockIds[i]);
                }
                mapIdAndReduceIds[2 * i] = Integer.parseInt(blockIdParts[2]);
                mapIdAndReduceIds[2 * i + 1] = Integer.parseInt(blockIdParts[3]);
            }
            return mapIdAndReduceIds;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public ManagedBuffer next() {
            ManagedBuffer block = this.blockDataForIndexFn.apply(this.index);
            this.index += 2;
            ExternalBlockHandler.this.metrics.blockTransferRateBytes.mark(block != null ? block.size() : 0L);
            return block;
        }
    }

    @VisibleForTesting
    public class ShuffleMetrics
    implements MetricSet {
        private final Map<String, Metric> allMetrics;
        private final Timer openBlockRequestLatencyMillis = new Timer();
        private final Timer registerExecutorRequestLatencyMillis = new Timer();
        private final Timer finalizeShuffleMergeLatencyMillis = new Timer();
        private final Meter blockTransferRateBytes = new Meter();
        private Counter activeConnections = new Counter();
        private Counter caughtExceptions = new Counter();

        public ShuffleMetrics() {
            this.allMetrics = new HashMap<String, Metric>();
            this.allMetrics.put("openBlockRequestLatencyMillis", (Metric)this.openBlockRequestLatencyMillis);
            this.allMetrics.put("registerExecutorRequestLatencyMillis", (Metric)this.registerExecutorRequestLatencyMillis);
            this.allMetrics.put("finalizeShuffleMergeLatencyMillis", (Metric)this.finalizeShuffleMergeLatencyMillis);
            this.allMetrics.put("blockTransferRateBytes", (Metric)this.blockTransferRateBytes);
            this.allMetrics.put("registeredExecutorsSize", (Metric)((Gauge)() -> ExternalBlockHandler.this.blockManager.getRegisteredExecutorsSize()));
            this.allMetrics.put("numActiveConnections", (Metric)this.activeConnections);
            this.allMetrics.put("numCaughtExceptions", (Metric)this.caughtExceptions);
        }

        public Map<String, Metric> getMetrics() {
            return this.allMetrics;
        }
    }
}

