/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.combinationlookup;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.IProvidesModelerMeta;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.AfterInjection;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.combinationlookup.CombinationLookup;
import org.apache.hop.pipeline.transforms.combinationlookup.CombinationLookupData;
import org.w3c.dom.Node;

@Transform(id="CombinationLookup", image="combinationlookup.svg", name="i18n::CombinationLookup.Name", description="i18n::CombinationLookup.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.DataWarehouse", keywords={"i18n::CombinationLookupMeta.keyword"}, documentationUrl="/pipeline/transforms/combinationlookup.html")
@InjectionSupported(localizationPrefix="CombinationLookup.Injection.")
public class CombinationLookupMeta
extends BaseTransformMeta<CombinationLookup, CombinationLookupData>
implements IProvidesModelerMeta {
    private static final Class<?> PKG = CombinationLookupMeta.class;
    public static final int DEFAULT_CACHE_SIZE = 9999;
    @Injection(name="SCHEMA_NAME")
    private String schemaName;
    @Injection(name="TABLE_NAME")
    private String tableName;
    private DatabaseMeta databaseMeta;
    @Injection(name="REPLACE_FIELDS")
    private boolean replaceFields;
    @Injection(name="KEY_FIELDS")
    private String[] keyField;
    @Injection(name="KEY_LOOKUP")
    private String[] keyLookup;
    @Injection(name="USE_HASH")
    private boolean useHash;
    @Injection(name="HASH_FIELD")
    private String hashField;
    @Injection(name="TECHNICAL_KEY_FIELD")
    private String technicalKeyField;
    @Injection(name="SEQUENCE_FROM")
    private String sequenceFrom;
    @Injection(name="COMMIT_SIZE")
    private int commitSize;
    @Injection(name="PRELOAD_CACHE")
    private boolean preloadCache = false;
    @Injection(name="CACHE_SIZE")
    private int cacheSize;
    @Injection(name="AUTO_INC")
    private boolean useAutoinc;
    @Injection(name="TECHNICAL_KEY_CREATION")
    private String techKeyCreation = null;
    @Injection(name="LAST_UPDATE_FIELD")
    private String lastUpdateField;
    public static final String CREATION_METHOD_AUTOINC = "autoinc";
    public static final String CREATION_METHOD_SEQUENCE = "sequence";
    public static final String CREATION_METHOD_TABLEMAX = "tablemax";

    @Injection(name="CONNECTIONNAME")
    public void setConnection(String connectionName) {
        this.databaseMeta = DatabaseMeta.findDatabase((List)this.getParentTransformMeta().getParentPipelineMeta().getDatabases(), (String)connectionName);
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public void setTechKeyCreation(String techKeyCreation) {
        this.techKeyCreation = techKeyCreation;
    }

    public String getTechKeyCreation() {
        return this.techKeyCreation;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public String getHashField() {
        return this.hashField;
    }

    public void setHashField(String hashField) {
        this.hashField = hashField;
    }

    public String[] getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String[] keyField) {
        this.keyField = keyField;
    }

    public String[] getKeyLookup() {
        return this.keyLookup;
    }

    public void setKeyLookup(String[] keyLookup) {
        this.keyLookup = keyLookup;
    }

    public boolean replaceFields() {
        return this.replaceFields;
    }

    public void setReplaceFields(boolean replaceFields) {
        this.replaceFields = replaceFields;
    }

    public void setPreloadCache(boolean preloadCache) {
        this.preloadCache = preloadCache;
    }

    public boolean getPreloadCache() {
        return this.preloadCache;
    }

    public String getSequenceFrom() {
        return this.sequenceFrom;
    }

    public void setSequenceFrom(String sequenceFrom) {
        this.sequenceFrom = sequenceFrom;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTablename(String tableName) {
        this.tableName = tableName;
    }

    public String getTechnicalKeyField() {
        return this.technicalKeyField;
    }

    public void setTechnicalKeyField(String technicalKeyField) {
        this.technicalKeyField = technicalKeyField;
    }

    public boolean isUseAutoinc() {
        return this.useAutoinc;
    }

    public void setUseAutoinc(boolean useAutoinc) {
        this.useAutoinc = useAutoinc;
    }

    public boolean useHash() {
        return this.useHash;
    }

    public void setUseHash(boolean useHash) {
        this.useHash = useHash;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public void allocate(int nrkeys) {
        this.keyField = new String[nrkeys];
        this.keyLookup = new String[nrkeys];
    }

    public Object clone() {
        CombinationLookupMeta retval = (CombinationLookupMeta)((Object)super.clone());
        int nrkeys = this.keyField.length;
        retval.allocate(nrkeys);
        System.arraycopy(this.keyField, 0, retval.keyField, 0, nrkeys);
        System.arraycopy(this.keyLookup, 0, retval.keyLookup, 0, nrkeys);
        return retval;
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.databases = this.databases;
        try {
            this.schemaName = XmlHandler.getTagValue((Node)transformNode, (String)"schema");
            this.tableName = XmlHandler.getTagValue((Node)transformNode, (String)"table");
            String con = XmlHandler.getTagValue((Node)transformNode, (String)"connection");
            this.databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)con);
            String commit = XmlHandler.getTagValue((Node)transformNode, (String)"commit");
            this.commitSize = Const.toInt((String)commit, (int)0);
            String csize = XmlHandler.getTagValue((Node)transformNode, (String)"cache_size");
            this.cacheSize = Const.toInt((String)csize, (int)0);
            this.replaceFields = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"replace"));
            this.preloadCache = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"preloadCache"));
            this.useHash = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"crc"));
            this.hashField = XmlHandler.getTagValue((Node)transformNode, (String)"crcfield");
            Node keys = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrkeys = XmlHandler.countNodes((Node)keys, (String)"key");
            this.allocate(nrkeys);
            for (int i = 0; i < nrkeys; ++i) {
                Node knode = XmlHandler.getSubNodeByNr((Node)keys, (String)"key", (int)i);
                this.keyField[i] = XmlHandler.getTagValue((Node)knode, (String)"name");
                this.keyLookup[i] = XmlHandler.getTagValue((Node)knode, (String)"lookup");
            }
            this.sequenceFrom = XmlHandler.getTagValue((Node)transformNode, (String)CREATION_METHOD_SEQUENCE);
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            Node retkey = XmlHandler.getSubNode((Node)fields, (String)"return");
            this.technicalKeyField = XmlHandler.getTagValue((Node)retkey, (String)"name");
            this.useAutoinc = !"N".equalsIgnoreCase(XmlHandler.getTagValue((Node)retkey, (String)"use_autoinc"));
            this.lastUpdateField = XmlHandler.getTagValue((Node)transformNode, (String)"last_update_field");
            this.setTechKeyCreation(XmlHandler.getTagValue((Node)retkey, (String)"creation_method"));
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.Exception.UnableToLoadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"CombinationLookupMeta.DimensionTableName.Label", (String[])new String[0]);
        this.databaseMeta = null;
        this.commitSize = 100;
        this.cacheSize = 9999;
        this.replaceFields = false;
        this.preloadCache = false;
        this.useHash = false;
        this.hashField = "hashcode";
        int nrkeys = 0;
        this.allocate(nrkeys);
        for (int i = 0; i < nrkeys; ++i) {
            this.keyField[i] = "key" + i;
            this.keyLookup[i] = "keylookup" + i;
        }
        this.technicalKeyField = "technical/surrogate key field";
        this.useAutoinc = false;
    }

    public void getFields(IRowMeta row, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaInteger v = new ValueMetaInteger(this.technicalKeyField);
        v.setLength(10);
        v.setPrecision(0);
        v.setOrigin(origin);
        row.addValueMeta((IValueMeta)v);
        if (this.replaceFields) {
            for (int i = 0; i < this.keyField.length; ++i) {
                int idx = row.indexOfValue(this.keyField[i]);
                if (idx < 0) continue;
                row.removeValueMeta(idx);
            }
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(512);
        retval.append("      ").append(XmlHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("      ").append(XmlHandler.addTagValue((String)"commit", (int)this.commitSize));
        retval.append("      ").append(XmlHandler.addTagValue((String)"cache_size", (int)this.cacheSize));
        retval.append("      ").append(XmlHandler.addTagValue((String)"replace", (boolean)this.replaceFields));
        retval.append("      ").append(XmlHandler.addTagValue((String)"preloadCache", (boolean)this.preloadCache));
        retval.append("      ").append(XmlHandler.addTagValue((String)"crc", (boolean)this.useHash));
        retval.append("      ").append(XmlHandler.addTagValue((String)"crcfield", (String)this.hashField));
        retval.append("      <fields>").append(Const.CR);
        for (int i = 0; i < this.keyField.length; ++i) {
            retval.append("        <key>").append(Const.CR);
            retval.append("          ").append(XmlHandler.addTagValue((String)"name", (String)this.keyField[i]));
            retval.append("          ").append(XmlHandler.addTagValue((String)"lookup", (String)this.keyLookup[i]));
            retval.append("        </key>").append(Const.CR);
        }
        retval.append("        <return>").append(Const.CR);
        retval.append("          ").append(XmlHandler.addTagValue((String)"name", (String)this.technicalKeyField));
        retval.append("          ").append(XmlHandler.addTagValue((String)"creation_method", (String)this.techKeyCreation));
        retval.append("          ").append(XmlHandler.addTagValue((String)"use_autoinc", (boolean)this.useAutoinc));
        retval.append("        </return>").append(Const.CR);
        retval.append("      </fields>").append(Const.CR);
        retval.append("      ").append(XmlHandler.addTagValue((String)CREATION_METHOD_SEQUENCE, (String)this.sequenceFrom));
        retval.append("      ").append(XmlHandler.addTagValue((String)"last_update_field", (String)this.lastUpdateField));
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        errorMessage = "";
        if (this.databaseMeta != null) {
            db = new Database(CombinationLookupMeta.loggingObject, variables, this.databaseMeta);
            try {
                db.connect();
                if (!Utils.isEmpty((CharSequence)this.tableName)) {
                    first = true;
                    errorFound = false;
                    errorMessage = "";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                    r = db.getTableFields(schemaTable);
                    if (r != null) {
                        for (i = 0; i < this.keyLookup.length; ++i) {
                            lufield = this.keyLookup[i];
                            v = r.searchValueMeta(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage = (String)errorMessage + BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.MissingCompareFields", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = (String)errorMessage + "\t\t" + lufield + Const.CR;
                        }
                        cr = errorFound != false ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        if (r.indexOfValue(this.technicalKeyField) < 0) {
                            errorMessage = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.TechnicalKeyNotFound", (String[])new String[]{this.technicalKeyField}) + Const.CR;
                            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                        } else {
                            errorMessage = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.TechnicalKeyFound", (String[])new String[]{this.technicalKeyField}) + Const.CR;
                            cr = new CheckResult(1, (String)errorMessage, (ICheckResultSource)transformMeta);
                        }
                        remarks.add((ICheckResult)cr);
                    } else {
                        errorMessage = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    first = true;
                    errorMessage = "";
                    errorFound = false;
                    for (i = 0; i < this.keyField.length; ++i) {
                        v = prev.searchValueMeta(this.keyField[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = (String)errorMessage + BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.MissingFields", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = (String)errorMessage + "\t\t" + this.keyField[i] + Const.CR;
                    }
                    cr = errorFound != false ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.AllFieldsFoundInInputStream", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    errorMessage = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.CouldNotReadFields", (String[])new String[0]) + Const.CR;
                    cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                if (this.databaseMeta.supportsSequences() && "sequence".equals(this.getTechKeyCreation())) {
                    if (Utils.isEmpty((CharSequence)this.sequenceFrom)) {
                        errorMessage = (String)errorMessage + BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.ErrorNoSequenceName", (String[])new String[0]) + "!";
                        cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    } else if (db.checkSequenceExists(this.sequenceFrom)) {
                        errorMessage = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.ReadingSequenceOK", (String[])new String[]{this.sequenceFrom});
                        cr = new CheckResult(1, (String)errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    } else {
                        errorMessage = (String)errorMessage + BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.ErrorReadingSequence", (String[])new String[0]) + this.sequenceFrom + "!";
                        cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                }
                if (this.techKeyCreation == null || "autoinc".equals(this.techKeyCreation) || "sequence".equals(this.techKeyCreation) || "tablemax".equals(this.techKeyCreation)) ** GOTO lbl96
                errorMessage = (String)errorMessage + BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.ErrorTechKeyCreation", (String[])new String[0]) + ": " + this.techKeyCreation + "!";
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                errorMessage = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            errorMessage = BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
lbl96:
        // 4 sources

        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(CombinationLookupMeta.PKG, (String)"CombinationLookupMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) {
        SqlStatement retval = new SqlStatement(transformMeta.getName(), this.databaseMeta, null);
        if (this.databaseMeta != null) {
            if (prev != null && prev.size() > 0) {
                if (!Utils.isEmpty((CharSequence)this.tableName)) {
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                    Database db = new Database(loggingObject, variables, this.databaseMeta);
                    try {
                        String[] techKeyArr;
                        IValueMeta v;
                        int i;
                        boolean doHash = false;
                        String crTable = null;
                        db.connect();
                        RowMeta fields = new RowMeta();
                        ValueMetaInteger vkeyfield = new ValueMetaInteger(this.technicalKeyField);
                        vkeyfield.setLength(10);
                        vkeyfield.setPrecision(0);
                        ValueMetaInteger vhashfield = null;
                        if (this.useHash && !Utils.isEmpty((CharSequence)this.hashField)) {
                            vhashfield = new ValueMetaInteger(this.hashField);
                            vhashfield.setLength(15);
                            vhashfield.setPrecision(0);
                            doHash = true;
                        }
                        ValueMetaDate vLastUpdateField = null;
                        if (!Utils.isEmpty((CharSequence)this.lastUpdateField)) {
                            vLastUpdateField = new ValueMetaDate(this.lastUpdateField);
                        }
                        if (!db.checkTableExists(variables.resolve(this.schemaName), variables.resolve(this.tableName))) {
                            fields.addValueMeta((IValueMeta)vkeyfield);
                            if (this.keyField != null && this.keyLookup != null) {
                                int cnt = this.keyField.length;
                                for (i = 0; i < cnt; ++i) {
                                    Object errorField = "";
                                    v = prev.searchValueMeta(this.keyField[i]);
                                    if (v == null) continue;
                                    String name = this.keyLookup[i];
                                    IValueMeta newValue = v.clone();
                                    newValue.setName(name);
                                    if (name.equals(vkeyfield.getName()) || doHash && name.equals(vhashfield.getName())) {
                                        errorField = (String)errorField + name;
                                    }
                                    if (((String)errorField).length() > 0) {
                                        retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.NameCollision", (String[])new String[]{errorField}));
                                        continue;
                                    }
                                    fields.addValueMeta(newValue);
                                }
                            }
                            if (doHash) {
                                fields.addValueMeta((IValueMeta)vhashfield);
                            }
                            if (vLastUpdateField != null) {
                                fields.addValueMeta((IValueMeta)vLastUpdateField);
                            }
                        } else {
                            IRowMeta tabFields = db.getTableFields(schemaTable);
                            this.databaseMeta.quoteReservedWords(tabFields);
                            if (tabFields.searchValueMeta(vkeyfield.getName()) == null) {
                                fields.addValueMeta((IValueMeta)vkeyfield);
                            }
                            int cnt = tabFields.size();
                            for (i = 0; i < cnt; ++i) {
                                v = tabFields.getValueMeta(i);
                                fields.addValueMeta(v);
                            }
                            String[] keyLookup = this.getKeyLookup();
                            String[] keyField = this.getKeyField();
                            if (keyField != null && keyLookup != null) {
                                cnt = keyField.length;
                                for (i = 0; i < cnt; ++i) {
                                    IValueMeta v2 = prev.searchValueMeta(keyField[i]);
                                    if (v2 == null) continue;
                                    IValueMeta newValue = v2.clone();
                                    newValue.setName(keyLookup[i]);
                                    if (tabFields.searchValueMeta(newValue.getName()) != null) continue;
                                    fields.addValueMeta(newValue);
                                }
                            }
                            if (doHash && tabFields.searchValueMeta(vhashfield.getName()) == null) {
                                fields.addValueMeta((IValueMeta)vhashfield);
                            }
                            if (vLastUpdateField != null && tabFields.searchValueMeta(vLastUpdateField.getName()) == null) {
                                fields.addValueMeta((IValueMeta)vLastUpdateField);
                            }
                        }
                        crTable = db.getDDL(schemaTable, (IRowMeta)fields, (String)(CREATION_METHOD_SEQUENCE.equals(this.getTechKeyCreation()) && this.sequenceFrom != null && this.sequenceFrom.length() != 0 ? null : this.technicalKeyField), CREATION_METHOD_AUTOINC.equals(this.getTechKeyCreation()), null, true);
                        Object crIndex = "";
                        Object crUniqIndex = "";
                        CharSequence[] idxFields = null;
                        if (this.useHash) {
                            if (this.hashField != null && this.hashField.length() > 0) {
                                idxFields = new String[]{this.hashField};
                            } else {
                                retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.NotHashFieldSpecified", (String[])new String[0]));
                            }
                        } else if (!Utils.isEmpty((CharSequence[])this.keyLookup)) {
                            int nrFields = this.keyLookup.length;
                            int maxFields = this.databaseMeta.getMaxColumnsInIndex();
                            if (maxFields > 0 && nrFields > maxFields) {
                                nrFields = maxFields;
                            }
                            idxFields = new String[nrFields];
                            for (i = 0; i < nrFields; ++i) {
                                idxFields[i] = this.keyLookup[i];
                            }
                        } else {
                            retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.NotFieldsSpecified", (String[])new String[0]));
                        }
                        if (!Utils.isEmpty((CharSequence)this.technicalKeyField) && !db.checkIndexExists(schemaTable, techKeyArr = new String[]{this.technicalKeyField})) {
                            String indexname = "idx_" + this.tableName + "_pk";
                            crUniqIndex = db.getCreateIndexStatement(schemaTable, indexname, techKeyArr, true, true, false, true);
                            crUniqIndex = (String)crUniqIndex + Const.CR;
                        }
                        if (!Utils.isEmpty((CharSequence[])idxFields) && !db.checkIndexExists(schemaTable, (String[])idxFields)) {
                            String indexname = "idx_" + this.tableName + "_lookup";
                            crIndex = db.getCreateIndexStatement(schemaTable, indexname, (String[])idxFields, false, false, false, true);
                            crIndex = (String)crIndex + Const.CR;
                        }
                        Object crSeq = "";
                        if (this.databaseMeta.supportsSequences() && !Utils.isEmpty((CharSequence)this.sequenceFrom) && !db.checkSequenceExists(this.schemaName, this.sequenceFrom)) {
                            crSeq = (String)crSeq + db.getCreateSequenceStatement(this.schemaName, this.sequenceFrom, 1L, 1L, -1L, true);
                            crSeq = (String)crSeq + Const.CR;
                        }
                        retval.setSql(variables.resolve(crTable + (String)crUniqIndex + (String)crIndex + (String)crSeq));
                    }
                    catch (HopException e) {
                        retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.ErrorOccurred", (String[])new String[0]) + Const.CR + e.getMessage());
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.NotTableDefined", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.NotReceivingField", (String[])new String[0]));
            }
        } else {
            retval.setError(BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReturnValue.NotConnectionDefined", (String[])new String[0]));
        }
        return retval;
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) {
        for (int i = 0; i < this.keyField.length; ++i) {
            IValueMeta v = prev.searchValueMeta(this.keyField[i]);
            DatabaseImpact ii = new DatabaseImpact(3, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.keyLookup[i], this.keyField[i], v != null ? v.getOrigin() : "?", "", this.useHash ? BaseMessages.getString(PKG, (String)"CombinationLookupMeta.ReadAndInsert.Label", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"CombinationLookupMeta.LookupAndInsert.Label", (String[])new String[0]));
            impact.add(ii);
        }
        if (this.useHash) {
            DatabaseImpact ii = new DatabaseImpact(3, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.hashField, "", "", "", BaseMessages.getString(PKG, (String)"CombinationLookupMeta.KeyLookup.Label", (String[])new String[0]));
            impact.add(ii);
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        CombinationLookupMeta o = (CombinationLookupMeta)((Object)other);
        if (this.getCommitSize() != o.getCommitSize()) {
            return false;
        }
        if (this.getCacheSize() != o.getCacheSize()) {
            return false;
        }
        if (!this.getTechKeyCreation().equals(o.getTechKeyCreation())) {
            return false;
        }
        if (this.replaceFields() != o.replaceFields()) {
            return false;
        }
        if (this.useHash() != o.useHash()) {
            return false;
        }
        if (this.getPreloadCache() != o.getPreloadCache()) {
            return false;
        }
        if (this.getSequenceFrom() == null && o.getSequenceFrom() != null || this.getSequenceFrom() != null && o.getSequenceFrom() == null || this.getSequenceFrom() != null && o.getSequenceFrom() != null && !this.getSequenceFrom().equals(o.getSequenceFrom())) {
            return false;
        }
        if (this.getSchemaName() == null && o.getSchemaName() != null || this.getSchemaName() != null && o.getSchemaName() == null || this.getSchemaName() != null && o.getSchemaName() != null && !this.getSchemaName().equals(o.getSchemaName())) {
            return false;
        }
        if (this.getTableName() == null && o.getTableName() != null || this.getTableName() != null && o.getTableName() == null || this.getTableName() != null && o.getTableName() != null && !this.getTableName().equals(o.getTableName())) {
            return false;
        }
        if (this.getHashField() == null && o.getHashField() != null || this.getHashField() != null && o.getHashField() == null || this.getHashField() != null && o.getHashField() != null && !this.getHashField().equals(o.getHashField())) {
            return false;
        }
        return !(this.getTechnicalKeyField() == null && o.getTechnicalKeyField() != null || this.getTechnicalKeyField() != null && o.getTechnicalKeyField() == null) && (this.getTechnicalKeyField() == null || o.getTechnicalKeyField() == null || this.getTechnicalKeyField().equals(o.getTechnicalKeyField()));
    }

    public int hashCode() {
        return Objects.hash(this.getCommitSize(), this.getCacheSize(), this.getTechKeyCreation(), this.replaceFields(), this.useHash(), this.getPreloadCache(), this.getSequenceFrom(), this.getSchemaName(), this.getTableName(), this.getHashField(), this.getTechnicalKeyField());
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getLastUpdateField() {
        return this.lastUpdateField;
    }

    public void setLastUpdateField(String lastUpdateField) {
        this.lastUpdateField = lastUpdateField;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    protected IRowMeta getDatabaseTableFields(Database db, String schemaName, String tableName) throws HopDatabaseException {
        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination((IVariables)db, schemaName, tableName);
        IRowMeta extraFields = db.getTableFields(schemaTable);
        if (extraFields == null) {
            db.connect();
            extraFields = db.getTableFields(schemaTable);
        }
        return extraFields;
    }

    Database createDatabaseObject(IVariables variables) {
        return new Database(loggingObject, variables, this.databaseMeta);
    }

    public RowMeta getRowMeta(IVariables variables, ITransformData transformData) {
        try {
            return (RowMeta)this.getDatabaseTableFields(this.createDatabaseObject(variables), this.schemaName, this.getTableName());
        }
        catch (HopDatabaseException e) {
            this.log.logError("", (Throwable)e);
            return new RowMeta();
        }
    }

    public List<String> getDatabaseFields() {
        return Arrays.asList(this.keyLookup);
    }

    public List<String> getStreamFields() {
        return Arrays.asList(this.keyField);
    }

    @AfterInjection
    public void afterInjectionSynchronization() {
        int nrFields;
        int n = nrFields = this.keyField == null ? -1 : this.keyField.length;
        if (nrFields <= 0) {
            return;
        }
        String[][] rtn = Utils.normalizeArrays((int)nrFields, (String[][])new String[][]{this.keyLookup});
        this.keyLookup = rtn[0];
    }
}

