/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NoEOFWALStreamReader
implements WALStreamReader {
    private static final Logger LOG = LoggerFactory.getLogger(NoEOFWALStreamReader.class);
    private WALStreamReader reader;

    private NoEOFWALStreamReader(WALStreamReader reader) {
        this.reader = reader;
    }

    public WAL.Entry next(WAL.Entry reuse) throws IOException {
        try {
            return this.reader.next(reuse);
        }
        catch (EOFException e) {
            LOG.warn("Got EOF while reading", (Throwable)e);
            return null;
        }
    }

    public long getPosition() throws IOException {
        return this.reader.getPosition();
    }

    public void close() {
        this.reader.close();
    }

    private int count() throws IOException {
        int count = 0;
        WAL.Entry entry = new WAL.Entry();
        while (this.next(entry) != null) {
            ++count;
        }
        return count;
    }

    public static NoEOFWALStreamReader create(FileSystem fs, Path path, Configuration conf) throws IOException {
        return new NoEOFWALStreamReader(WALFactory.createStreamReader((FileSystem)fs, (Path)path, (Configuration)conf));
    }

    public static NoEOFWALStreamReader create(WALFactory walFactory, FileSystem fs, Path path) throws IOException {
        return new NoEOFWALStreamReader(walFactory.createStreamReader(fs, path));
    }

    public static int count(FileSystem fs, Path path, Configuration conf) throws IOException {
        try (NoEOFWALStreamReader reader = NoEOFWALStreamReader.create(fs, path, conf);){
            int n = reader.count();
            return n;
        }
    }

    public static int count(WALFactory walFactory, FileSystem fs, Path path) throws IOException {
        try (NoEOFWALStreamReader reader = NoEOFWALStreamReader.create(walFactory, fs, path);){
            int n = reader.count();
            return n;
        }
    }
}

