/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationMarkerChore;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestWALEdit {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALEdit.class);
    private static final String RS_NAME = "test-region-server-name";

    @Test
    public void testCreateReplicationMarkerEdit() {
        long timestamp = EnvironmentEdgeManager.currentTime();
        byte[] rowkey = ReplicationMarkerChore.getRowKey((String)RS_NAME, (long)timestamp);
        WALEdit edit = WALEdit.createReplicationMarkerEdit((byte[])rowkey, (long)timestamp);
        Assert.assertEquals((long)1L, (long)edit.getCells().size());
        Cell cell = (Cell)edit.getCells().get(0);
        Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)cell, (byte[])WALEdit.METAFAMILY));
        Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)cell, (byte[])WALEdit.REPLICATION_MARKER));
        Assert.assertTrue((boolean)WALEdit.isReplicationMarkerEdit((WALEdit)edit));
    }
}

