/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ReopenTableRegionsProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestReopenTableRegionsProcedureInfiniteLoop {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReopenTableRegionsProcedureInfiniteLoop.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"InfiniteLoop");
    private static byte[] CF = Bytes.toBytes((String)"cf");

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setInt("hbase.master.wait.on.regionservers.mintostart", 1);
        UTIL.startMiniCluster(1);
        UTIL.createTable(TABLE_NAME, CF);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInfiniteLoop() throws IOException {
        long procId;
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        AssignmentManager am = master.getAssignmentManager();
        ProcedureExecutor exec = master.getMasterProcedureExecutor();
        RegionInfo regionInfo = (RegionInfo)UTIL.getAdmin().getRegions(TABLE_NAME).get(0);
        RegionStateNode regionNode = am.getRegionStates().getRegionStateNode(regionInfo);
        ReopenTableRegionsProcedure proc = new ReopenTableRegionsProcedure(TABLE_NAME);
        regionNode.lock();
        try {
            procId = exec.submitProcedure((Procedure)proc);
            UTIL.waitFor(30000L, () -> proc.hasLock());
            TransitRegionStateProcedure trsp = TransitRegionStateProcedure.reopen((MasterProcedureEnv)((MasterProcedureEnv)exec.getEnvironment()), (RegionInfo)regionInfo);
            regionNode.setProcedure(trsp);
            exec.submitProcedure((Procedure)trsp);
        }
        finally {
            regionNode.unlock();
        }
        UTIL.waitFor(60000L, () -> exec.isFinished(procId));
    }
}

