/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestStochasticLoadBalancerRegionReplicaWithRacks
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStochasticLoadBalancerRegionReplicaWithRacks.class);

    @Test
    public void testRegionReplicationOnMidClusterWithRacks() {
        conf.setLong("hbase.master.balancer.stochastic.maxSteps", 100000000L);
        conf.setBoolean("hbase.master.balancer.stochastic.runMaxSteps", true);
        this.setMaxRunTime(Duration.ofSeconds(5L));
        loadBalancer.onConfigurationChange(conf);
        int numNodes = 4;
        int numRegions = numNodes * 1;
        int replication = 3;
        int numRegionsPerServer = 1;
        int numTables = 1;
        int numRacks = 3;
        Map<ServerName, List<RegionInfo>> serverMap = this.createServerMap(numNodes, numRegions, numRegionsPerServer, replication, numTables);
        ForTestRackManager rm = new ForTestRackManager(numRacks);
        this.testWithClusterWithIteration(serverMap, rm, true, true);
    }

    @Test
    public void testRegionReplicationOnLargeClusterWithRacks() {
        conf.setBoolean("hbase.master.balancer.stochastic.runMaxSteps", true);
        conf.setLong("hbase.master.balancer.stochastic.maxSteps", 100000000L);
        this.setMaxRunTime(Duration.ofSeconds(30L));
        loadBalancer.onConfigurationChange(conf);
        int numNodes = 100;
        int numRegions = numNodes * 30;
        int replication = 3;
        int numRegionsPerServer = 28;
        int numTables = 1;
        int numRacks = 4;
        Map<ServerName, List<RegionInfo>> serverMap = this.createServerMap(numNodes, numRegions, numRegionsPerServer, replication, numTables);
        ForTestRackManager rm = new ForTestRackManager(numRacks);
        this.testWithClusterWithIteration(serverMap, rm, true, true);
    }

    private static class ForTestRackManager
    extends RackManager {
        int numRacks;
        Map<String, Integer> serverIndexes = new HashMap<String, Integer>();
        int numServers = 0;

        public ForTestRackManager(int numRacks) {
            this.numRacks = numRacks;
        }

        public String getRack(ServerName server) {
            String key = server.getServerName();
            if (!this.serverIndexes.containsKey(key)) {
                this.serverIndexes.put(key, this.numServers++);
            }
            return "rack_" + this.serverIndexes.get(key) % this.numRacks;
        }
    }
}

