/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.agrona.nio;

import java.nio.channels.SelectionKey;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.ToIntFunction;

public class NioSelectedKeySet
extends AbstractSet<SelectionKey> {
    private static final int INITIAL_CAPACITY = 10;
    private SelectionKey[] keys;
    private int size = 0;

    public NioSelectedKeySet() {
        this.keys = new SelectionKey[10];
    }

    public NioSelectedKeySet(int initialCapacity) {
        if (initialCapacity < 0 || initialCapacity > 0x7FFFFFF7) {
            throw new IllegalArgumentException("invalid initial capacity: " + initialCapacity);
        }
        this.keys = new SelectionKey[Math.max(initialCapacity, 10)];
    }

    @Override
    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.keys.length;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean add(SelectionKey selectionKey) {
        if (null == selectionKey) {
            return false;
        }
        this.ensureCapacity(this.size + 1);
        this.keys[this.size++] = selectionKey;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        for (int i = 0; i < this.size; ++i) {
            SelectionKey key = this.keys[i];
            if (!key.equals(o)) continue;
            this.keys[i] = this.keys[--this.size];
            this.keys[this.size] = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.size; ++i) {
            SelectionKey key = this.keys[i];
            if (!key.equals(o)) continue;
            return true;
        }
        return false;
    }

    public SelectionKey[] keys() {
        return this.keys;
    }

    public void reset() {
        this.size = 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, null);
        this.size = 0;
    }

    public void reset(int skipCount) {
        if (skipCount > this.size) {
            throw new IllegalArgumentException("skipCount " + skipCount + " > size " + this.size);
        }
        if (0 != this.size) {
            SelectionKey[] keys = this.keys;
            int newSize = this.size - skipCount;
            System.arraycopy(keys, skipCount, keys, 0, newSize);
            this.size = newSize;
        }
    }

    public int forEach(ToIntFunction<SelectionKey> function) {
        int handledFrames = 0;
        SelectionKey[] keys = this.keys;
        for (int i = this.size - 1; i >= 0; --i) {
            handledFrames += function.applyAsInt(keys[i]);
        }
        this.size = 0;
        return handledFrames;
    }

    @Override
    public Iterator<SelectionKey> iterator() {
        throw new UnsupportedOperationException();
    }

    private void ensureCapacity(int requiredCapacity) {
        if (requiredCapacity < 0) {
            throw new IllegalStateException("insufficient capacity: length=" + this.keys.length + " required=" + requiredCapacity);
        }
        int currentCapacity = this.keys.length;
        if (requiredCapacity > currentCapacity) {
            int newCapacity = currentCapacity + (currentCapacity >> 1);
            if (newCapacity < 0 || newCapacity > 0x7FFFFFF7) {
                if (currentCapacity == 0x7FFFFFF7) {
                    throw new IllegalStateException("max capacity reached: 2147483639");
                }
                newCapacity = 0x7FFFFFF7;
            }
            this.keys = Arrays.copyOf(this.keys, newCapacity);
        }
    }
}

