/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.agrona.concurrent;

import java.util.Objects;
import org.apache.hadoop.hbase.shaded.org.agrona.ErrorHandler;
import org.apache.hadoop.hbase.shaded.org.agrona.concurrent.status.AtomicCounter;

public class CountedErrorHandler
implements ErrorHandler,
AutoCloseable {
    private final ErrorHandler errorHandler;
    private final AtomicCounter errorCounter;
    private volatile boolean isClosed;

    public CountedErrorHandler(ErrorHandler errorHandler, AtomicCounter errorCounter) {
        Objects.requireNonNull(errorHandler, "errorHandler");
        Objects.requireNonNull(errorCounter, "errorCounter");
        this.errorHandler = errorHandler;
        this.errorCounter = errorCounter;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.isClosed) {
            throwable.printStackTrace(System.err);
        } else {
            if (!this.errorCounter.isClosed()) {
                this.errorCounter.increment();
            }
            this.errorHandler.onError(throwable);
        }
    }
}

