/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.replication.master.ReplicationSinkTrackerTableCreator;
import org.apache.hadoop.hbase.replication.regionserver.DefaultSourceFSConfigurationProvider;
import org.apache.hadoop.hbase.replication.regionserver.HFileReplicator;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSink;
import org.apache.hadoop.hbase.replication.regionserver.SourceFSConfigurationProvider;
import org.apache.hadoop.hbase.replication.regionserver.WALEntrySinkFilter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.protobuf.ProtocolStringList;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReplicationSink {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationSink.class);
    private final Configuration conf;
    private volatile Connection sharedConnection;
    private volatile AsyncConnection sharedAsyncConnection;
    private final MetricsSink metrics;
    private final AtomicLong totalReplicatedEdits = new AtomicLong();
    private final Object sharedConnectionLock = new Object();
    private final Object sharedAsyncConnectionLock = new Object();
    private long hfilesReplicated = 0L;
    private SourceFSConfigurationProvider provider;
    private WALEntrySinkFilter walEntrySinkFilter;
    private final int rowSizeWarnThreshold;
    private boolean replicationSinkTrackerEnabled;
    private final RegionServerCoprocessorHost rsServerHost;

    public ReplicationSink(Configuration conf, RegionServerCoprocessorHost rsServerHost) throws IOException {
        this.conf = HBaseConfiguration.create((Configuration)conf);
        this.rsServerHost = rsServerHost;
        this.rowSizeWarnThreshold = conf.getInt("hbase.rpc.rows.warning.threshold", 5000);
        this.replicationSinkTrackerEnabled = conf.getBoolean("hbase.regionserver.replication.sink.tracker.enabled", false);
        this.decorateConf();
        this.metrics = new MetricsSink();
        this.walEntrySinkFilter = this.setupWALEntrySinkFilter();
        String className = conf.get("hbase.replication.source.fs.conf.provider", DefaultSourceFSConfigurationProvider.class.getCanonicalName());
        try {
            Class<?> c = Class.forName(className);
            this.provider = (SourceFSConfigurationProvider)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Configured source fs configuration provider class " + className + " throws error.", e);
        }
    }

    private WALEntrySinkFilter setupWALEntrySinkFilter() throws IOException {
        Class walEntryFilterClass = this.conf.getClass("hbase.replication.sink.walentrysinkfilter", null);
        WALEntrySinkFilter filter = null;
        try {
            filter = walEntryFilterClass == null ? null : (WALEntrySinkFilter)walEntryFilterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.warn("Failed to instantiate " + walEntryFilterClass);
        }
        if (filter != null) {
            filter.init(this.getConnection());
        }
        return filter;
    }

    private void decorateConf() {
        this.conf.setInt("hbase.client.retries.number", this.conf.getInt("replication.sink.client.retries.number", 4));
        this.conf.setInt("hbase.client.operation.timeout", this.conf.getInt("replication.sink.client.ops.timeout", 10000));
        String replicationCodec = this.conf.get("hbase.replication.rpc.codec");
        if (StringUtils.isNotEmpty((CharSequence)replicationCodec)) {
            this.conf.set("hbase.client.rpc.codec", replicationCodec);
        }
        if (this.conf.get("hbase.client.zookeeper.quorum") != null) {
            this.conf.unset("hbase.client.zookeeper.quorum");
        }
    }

    public void replicateEntries(List<AdminProtos.WALEntry> entries, CellScanner cells, String replicationClusterId, String sourceBaseNamespaceDirPath, String sourceHFileArchiveDirPath) throws IOException {
        if (entries.isEmpty()) {
            return;
        }
        try {
            long totalReplicated = 0L;
            TreeMap rowMap = new TreeMap();
            HashMap<List, Map> bulkLoadsPerClusters = null;
            Pair mutationsToWalEntriesPairs = new Pair(new ArrayList(), new ArrayList());
            for (AdminProtos.WALEntry wALEntry : entries) {
                TableName table = TableName.valueOf((byte[])wALEntry.getKey().getTableName().toByteArray());
                if (this.walEntrySinkFilter != null && this.walEntrySinkFilter.filter(table, wALEntry.getKey().getWriteTime())) {
                    int count = wALEntry.getAssociatedCellCount();
                    for (int i = 0; i < count; ++i) {
                        if (cells.advance()) continue;
                        this.metrics.incrementFailedBatches();
                        throw new ArrayIndexOutOfBoundsException("Expected=" + count + ", index=" + i);
                    }
                    continue;
                }
                Cell previousCell = null;
                Delete mutation = null;
                int count = wALEntry.getAssociatedCellCount();
                for (int i = 0; i < count; ++i) {
                    if (!cells.advance()) {
                        this.metrics.incrementFailedBatches();
                        throw new ArrayIndexOutOfBoundsException("Expected=" + count + ", index=" + i);
                    }
                    Cell cell = cells.current();
                    if (CellUtil.matchingQualifier((Cell)cell, (byte[])WALEdit.BULK_LOAD)) {
                        WALProtos.BulkLoadDescriptor bld = WALEdit.getBulkLoadDescriptor(cell);
                        if (!bld.getReplicate()) continue;
                        if (bulkLoadsPerClusters == null) {
                            bulkLoadsPerClusters = new HashMap<List, Map>();
                        }
                        Map bulkLoadHFileMap = bulkLoadsPerClusters.computeIfAbsent((List)bld.getClusterIdsList(), k -> new HashMap());
                        this.buildBulkLoadHFileMap(bulkLoadHFileMap, table, bld);
                        continue;
                    }
                    if (CellUtil.matchingQualifier((Cell)cell, (byte[])WALEdit.REPLICATION_MARKER)) {
                        Put put = this.processReplicationMarkerEntry(cell);
                        if (put == null) continue;
                        table = ReplicationSinkTrackerTableCreator.REPLICATION_SINK_TRACKER_TABLE_NAME;
                        ArrayList<UUID> clusterIds = new ArrayList<UUID>();
                        for (HBaseProtos.UUID clusterId : wALEntry.getKey().getClusterIdsList()) {
                            clusterIds.add(this.toUUID(clusterId));
                        }
                        put.setClusterIds(clusterIds);
                        this.addToHashMultiMap(rowMap, table, clusterIds, put);
                        continue;
                    }
                    if (this.isNewRowOrType(previousCell, cell)) {
                        mutation = CellUtil.isDelete((Cell)cell) ? new Delete(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength()) : new Put(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength());
                        ArrayList<UUID> clusterIds = new ArrayList<UUID>(wALEntry.getKey().getClusterIdsList().size());
                        for (HBaseProtos.UUID clusterId : wALEntry.getKey().getClusterIdsList()) {
                            clusterIds.add(this.toUUID(clusterId));
                        }
                        mutation.setClusterIds(clusterIds);
                        if (this.rsServerHost != null) {
                            this.rsServerHost.preReplicationSinkBatchMutate(wALEntry, (Mutation)mutation);
                            ((List)mutationsToWalEntriesPairs.getFirst()).add(mutation);
                            ((List)mutationsToWalEntriesPairs.getSecond()).add(wALEntry);
                        }
                        this.addToHashMultiMap(rowMap, table, clusterIds, mutation);
                    }
                    if (CellUtil.isDelete((Cell)cell)) {
                        ((Delete)mutation).add(cell);
                    } else {
                        ((Put)mutation).add(cell);
                    }
                    previousCell = cell;
                }
                ++totalReplicated;
            }
            if (!rowMap.isEmpty()) {
                LOG.debug("Started replicating mutations.");
                for (Map.Entry entry : rowMap.entrySet()) {
                    this.batch((TableName)entry.getKey(), ((Map)entry.getValue()).values(), this.rowSizeWarnThreshold);
                }
                LOG.debug("Finished replicating mutations.");
            }
            if (this.rsServerHost != null) {
                List mutations = (List)mutationsToWalEntriesPairs.getFirst();
                List list = (List)mutationsToWalEntriesPairs.getSecond();
                for (int i = 0; i < mutations.size(); ++i) {
                    this.rsServerHost.postReplicationSinkBatchMutate((AdminProtos.WALEntry)list.get(i), (Mutation)mutations.get(i));
                }
            }
            if (bulkLoadsPerClusters != null) {
                for (Map.Entry entry : bulkLoadsPerClusters.entrySet()) {
                    Map bulkLoadHFileMap = (Map)entry.getValue();
                    if (bulkLoadHFileMap == null || bulkLoadHFileMap.isEmpty()) continue;
                    LOG.debug("Replicating {} bulk loaded data", (Object)((List)entry.getKey()).toString());
                    Configuration providerConf = this.provider.getConf(this.conf, replicationClusterId);
                    HFileReplicator hFileReplicator = new HFileReplicator(providerConf, sourceBaseNamespaceDirPath, sourceHFileArchiveDirPath, bulkLoadHFileMap, this.conf, this.getConnection(), (List)entry.getKey());
                    Throwable throwable = null;
                    try {
                        hFileReplicator.replicate();
                        LOG.debug("Finished replicating {} bulk loaded data", (Object)((List)entry.getKey()).toString());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (hFileReplicator == null) continue;
                        if (throwable != null) {
                            try {
                                hFileReplicator.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        hFileReplicator.close();
                    }
                }
            }
            int size = entries.size();
            this.metrics.setAgeOfLastAppliedOp(entries.get(size - 1).getKey().getWriteTime());
            this.metrics.applyBatch((long)size + this.hfilesReplicated, this.hfilesReplicated);
            this.totalReplicatedEdits.addAndGet(totalReplicated);
        }
        catch (IOException ex) {
            LOG.error("Unable to accept edit because:", (Throwable)ex);
            this.metrics.incrementFailedBatches();
            throw ex;
        }
    }

    private Put processReplicationMarkerEntry(Cell cell) throws IOException {
        if (!this.replicationSinkTrackerEnabled) {
            return null;
        }
        WALProtos.ReplicationMarkerDescriptor descriptor = WALProtos.ReplicationMarkerDescriptor.parseFrom((InputStream)new ByteArrayInputStream(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
        Put put = new Put(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength());
        put.addColumn(ReplicationSinkTrackerTableCreator.REPLICATION_SINK_TRACKER_INFO_FAMILY, ReplicationSinkTrackerTableCreator.RS_COLUMN, cell.getTimestamp(), Bytes.toBytes((String)descriptor.getRegionServerName()));
        put.addColumn(ReplicationSinkTrackerTableCreator.REPLICATION_SINK_TRACKER_INFO_FAMILY, ReplicationSinkTrackerTableCreator.WAL_NAME_COLUMN, cell.getTimestamp(), Bytes.toBytes((String)descriptor.getWalName()));
        put.addColumn(ReplicationSinkTrackerTableCreator.REPLICATION_SINK_TRACKER_INFO_FAMILY, ReplicationSinkTrackerTableCreator.TIMESTAMP_COLUMN, cell.getTimestamp(), Bytes.toBytes((long)cell.getTimestamp()));
        put.addColumn(ReplicationSinkTrackerTableCreator.REPLICATION_SINK_TRACKER_INFO_FAMILY, ReplicationSinkTrackerTableCreator.OFFSET_COLUMN, cell.getTimestamp(), Bytes.toBytes((long)descriptor.getOffset()));
        return put;
    }

    private void buildBulkLoadHFileMap(Map<String, List<Pair<byte[], List<String>>>> bulkLoadHFileMap, TableName table, WALProtos.BulkLoadDescriptor bld) throws IOException {
        List storesList = bld.getStoresList();
        int storesSize = storesList.size();
        for (int j = 0; j < storesSize; ++j) {
            WALProtos.StoreDescriptor storeDescriptor = (WALProtos.StoreDescriptor)storesList.get(j);
            ProtocolStringList storeFileList = storeDescriptor.getStoreFileList();
            int storeFilesSize = storeFileList.size();
            this.hfilesReplicated += (long)storeFilesSize;
            for (int k = 0; k < storeFilesSize; ++k) {
                byte[] family = storeDescriptor.getFamilyName().toByteArray();
                String pathToHfileFromNS = this.getHFilePath(table, bld, (String)storeFileList.get(k), family);
                String tableName = table.getNameWithNamespaceInclAsString();
                List<Pair<byte[], List<String>>> familyHFilePathsList = bulkLoadHFileMap.get(tableName);
                if (familyHFilePathsList != null) {
                    boolean foundFamily = false;
                    for (Pair<byte[], List<String>> familyHFilePathsPair : familyHFilePathsList) {
                        if (!Bytes.equals((byte[])((byte[])familyHFilePathsPair.getFirst()), (byte[])family)) continue;
                        ((List)familyHFilePathsPair.getSecond()).add(pathToHfileFromNS);
                        foundFamily = true;
                        break;
                    }
                    if (foundFamily) continue;
                    this.addFamilyAndItsHFilePathToTableInMap(family, pathToHfileFromNS, familyHFilePathsList);
                    continue;
                }
                this.addNewTableEntryInMap(bulkLoadHFileMap, family, pathToHfileFromNS, tableName);
            }
        }
    }

    private void addFamilyAndItsHFilePathToTableInMap(byte[] family, String pathToHfileFromNS, List<Pair<byte[], List<String>>> familyHFilePathsList) {
        ArrayList<String> hfilePaths = new ArrayList<String>(1);
        hfilePaths.add(pathToHfileFromNS);
        familyHFilePathsList.add((Pair<byte[], List<String>>)new Pair((Object)family, hfilePaths));
    }

    private void addNewTableEntryInMap(Map<String, List<Pair<byte[], List<String>>>> bulkLoadHFileMap, byte[] family, String pathToHfileFromNS, String tableName) {
        ArrayList<String> hfilePaths = new ArrayList<String>(1);
        hfilePaths.add(pathToHfileFromNS);
        Pair newFamilyHFilePathsPair = new Pair((Object)family, hfilePaths);
        ArrayList<Pair> newFamilyHFilePathsList = new ArrayList<Pair>();
        newFamilyHFilePathsList.add(newFamilyHFilePathsPair);
        bulkLoadHFileMap.put(tableName, newFamilyHFilePathsList);
    }

    private String getHFilePath(TableName table, WALProtos.BulkLoadDescriptor bld, String storeFile, byte[] family) {
        return new StringBuilder(100).append(table.getNamespaceAsString()).append("/").append(table.getQualifierAsString()).append("/").append(Bytes.toString((byte[])bld.getEncodedRegionName().toByteArray())).append("/").append(Bytes.toString((byte[])family)).append("/").append(storeFile).toString();
    }

    private boolean isNewRowOrType(Cell previousCell, Cell cell) {
        return previousCell == null || previousCell.getTypeByte() != cell.getTypeByte() || !CellUtil.matchingRows((Cell)previousCell, (Cell)cell);
    }

    private UUID toUUID(HBaseProtos.UUID uuid) {
        return new UUID(uuid.getMostSigBits(), uuid.getLeastSigBits());
    }

    private <K1, K2, V> List<V> addToHashMultiMap(Map<K1, Map<K2, List<V>>> map, K1 key1, K2 key2, V value) {
        Map innerMap = map.computeIfAbsent(key1, k -> new HashMap());
        List values = innerMap.computeIfAbsent(key2, k -> new ArrayList());
        values.add(value);
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReplicationSinkServices() {
        block13: {
            block12: {
                try {
                    if (this.sharedConnection == null) break block12;
                    Object object = this.sharedConnectionLock;
                    synchronized (object) {
                        if (this.sharedConnection != null) {
                            this.sharedConnection.close();
                            this.sharedConnection = null;
                        }
                    }
                }
                catch (IOException e) {
                    LOG.warn("IOException while closing the sharedConnection", (Throwable)e);
                }
            }
            try {
                if (this.sharedAsyncConnection == null) break block13;
                Object e = this.sharedAsyncConnectionLock;
                synchronized (e) {
                    if (this.sharedAsyncConnection != null) {
                        this.sharedAsyncConnection.close();
                        this.sharedAsyncConnection = null;
                    }
                }
            }
            catch (IOException e) {
                LOG.warn("IOException while closing the sharedAsyncConnection", (Throwable)e);
            }
        }
    }

    private void batch(TableName tableName, Collection<List<Row>> allRows, int batchRowSizeThreshold) throws IOException {
        if (allRows.isEmpty()) {
            return;
        }
        AsyncTable table = this.getAsyncConnection().getTable(tableName);
        ArrayList futures = new ArrayList();
        for (List<Row> rows : allRows) {
            List batchRows = rows.size() > batchRowSizeThreshold ? Lists.partition(rows, (int)batchRowSizeThreshold) : Collections.singletonList(rows);
            futures.addAll(batchRows.stream().map(arg_0 -> ((AsyncTable)table).batchAll(arg_0)).collect(Collectors.toList()));
        }
        RetriesExhaustedException error = null;
        for (Future future : futures) {
            try {
                FutureUtils.get((Future)future);
            }
            catch (RetriesExhaustedException e) {
                Throwable ioe = e.getCause() instanceof TableNotFoundException ? new TableNotFoundException("'" + tableName + "'") : e;
                if (error == null) {
                    error = ioe;
                    continue;
                }
                error.addSuppressed(ioe);
            }
        }
        if (error != null) {
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection() throws IOException {
        Connection connection = this.sharedConnection;
        if (connection == null) {
            Object object = this.sharedConnectionLock;
            synchronized (object) {
                connection = this.sharedConnection;
                if (connection == null) {
                    this.sharedConnection = connection = ConnectionFactory.createConnection((Configuration)this.conf);
                }
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncConnection getAsyncConnection() throws IOException {
        AsyncConnection asyncConnection = this.sharedAsyncConnection;
        if (asyncConnection == null) {
            Object object = this.sharedAsyncConnectionLock;
            synchronized (object) {
                asyncConnection = this.sharedAsyncConnection;
                if (asyncConnection == null) {
                    this.sharedAsyncConnection = asyncConnection = (AsyncConnection)FutureUtils.get((Future)ConnectionFactory.createAsyncConnection((Configuration)this.conf));
                }
            }
        }
        return asyncConnection;
    }

    public String getStats() {
        return this.totalReplicatedEdits.get() == 0L ? "" : "Sink: age in ms of last applied edit: " + this.metrics.refreshAgeOfLastAppliedOp() + ", total replicated edits: " + this.totalReplicatedEdits;
    }

    public MetricsSink getSinkMetrics() {
        return this.metrics;
    }
}

