/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.regionserver.CustomTieringMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.DateTieredMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.CustomCellTieringValueProvider;
import org.apache.hadoop.hbase.regionserver.compactions.DateTieredCompactor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CustomTieredCompactor
extends DateTieredCompactor {
    public static final String TIERING_VALUE_PROVIDER = "hbase.hstore.custom-tiering-value.provider.class";
    private TieringValueProvider tieringValueProvider;

    public CustomTieredCompactor(Configuration conf, HStore store) throws IOException {
        super(conf, store);
        String className = conf.get(TIERING_VALUE_PROVIDER, CustomCellTieringValueProvider.class.getName());
        try {
            this.tieringValueProvider = (TieringValueProvider)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.tieringValueProvider.init(conf);
        }
        catch (Exception e) {
            throw new IOException("Unable to load configured tiering value provider '" + className + "'", e);
        }
    }

    @Override
    protected List<Cell> decorateCells(List<Cell> cells) {
        return this.tieringValueProvider.decorateCells(cells);
    }

    @Override
    protected DateTieredMultiFileWriter createMultiWriter(CompactionRequestImpl request, List<Long> lowerBoundaries, Map<Long, String> lowerBoundariesPolicies) {
        return new CustomTieringMultiFileWriter(lowerBoundaries, lowerBoundariesPolicies, this.needEmptyFile(request), this.tieringValueProvider::getTieringValue);
    }

    public static interface TieringValueProvider {
        public void init(Configuration var1) throws Exception;

        default public List<Cell> decorateCells(List<Cell> cells) {
            return cells;
        }

        public long getTieringValue(Cell var1);
    }
}

