/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableSnapshotScanner;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TestHDFSAclHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TestHDFSAclHelper.class);
    static final byte[] COLUMN1 = Bytes.toBytes((String)"A");
    static final byte[] COLUMN2 = Bytes.toBytes((String)"B");

    private TestHDFSAclHelper() {
    }

    static void grantOnTable(HBaseTestingUtility util, String user, TableName tableName, Permission.Action ... actions) throws Exception {
        SecureTestUtil.grantOnTable(util, user, tableName, null, null, actions);
    }

    static void createNamespace(HBaseTestingUtility util, String namespace) throws IOException {
        if (Arrays.stream(util.getAdmin().listNamespaceDescriptors()).noneMatch(ns -> ns.getName().equals(namespace))) {
            NamespaceDescriptor namespaceDescriptor = NamespaceDescriptor.create((String)namespace).build();
            util.getAdmin().createNamespace(namespaceDescriptor);
        }
    }

    static Table createTable(HBaseTestingUtility util, TableName tableName) throws IOException {
        TestHDFSAclHelper.createNamespace(util, tableName.getNamespaceAsString());
        TableDescriptor td = TestHDFSAclHelper.getTableDescriptorBuilder(util, tableName).setValue("hbase.acl.sync.to.hdfs.enable", "true").build();
        byte[][] splits = new byte[][]{Bytes.toBytes((String)"2"), Bytes.toBytes((String)"4")};
        return util.createTable(td, (byte[][])splits);
    }

    static Table createMobTable(HBaseTestingUtility util, TableName tableName) throws IOException {
        TestHDFSAclHelper.createNamespace(util, tableName.getNamespaceAsString());
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])COLUMN1).setMobEnabled(true).setMobThreshold(0L).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])COLUMN2).setMobEnabled(true).setMobThreshold(0L).build()).setOwner(User.createUserForTesting((Configuration)util.getConfiguration(), (String)"owner", (String[])new String[0])).setValue("hbase.acl.sync.to.hdfs.enable", "true").build();
        byte[][] splits = new byte[][]{Bytes.toBytes((String)"2"), Bytes.toBytes((String)"4")};
        return util.createTable(td, (byte[][])splits);
    }

    static TableDescriptor createUserScanSnapshotDisabledTable(HBaseTestingUtility util, TableName tableName) throws IOException {
        TestHDFSAclHelper.createNamespace(util, tableName.getNamespaceAsString());
        TableDescriptor td = TestHDFSAclHelper.getTableDescriptorBuilder(util, tableName).build();
        byte[][] splits = new byte[][]{Bytes.toBytes((String)"2"), Bytes.toBytes((String)"4")};
        try (Table t = util.createTable(td, (byte[][])splits);){
            TestHDFSAclHelper.put(t);
        }
        return td;
    }

    static TableDescriptorBuilder getTableDescriptorBuilder(HBaseTestingUtility util, TableName tableName) {
        return TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])COLUMN1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])COLUMN2).build()).setOwner(User.createUserForTesting((Configuration)util.getConfiguration(), (String)"owner", (String[])new String[0]));
    }

    static void createTableAndPut(HBaseTestingUtility util, TableName tableNam) throws IOException {
        try (Table t = TestHDFSAclHelper.createTable(util, tableNam);){
            TestHDFSAclHelper.put(t);
        }
    }

    static void put(Table hTable) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < 6; ++i) {
            Put put = new Put(Bytes.toBytes((int)i));
            put.addColumn(COLUMN1, null, Bytes.toBytes((int)i));
            put.addColumn(COLUMN2, null, Bytes.toBytes((int)(i + 1)));
            puts.add(put);
        }
        hTable.put(puts);
    }

    static void put2(Table hTable) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < 10; ++i) {
            if (i == 5) continue;
            Put put = new Put(Bytes.toBytes((int)i));
            put.addColumn(COLUMN1, null, Bytes.toBytes((int)(i + 2)));
            put.addColumn(COLUMN2, null, Bytes.toBytes((int)(i + 3)));
            puts.add(put);
        }
        hTable.put(puts);
    }

    static void canUserScanSnapshot(HBaseTestingUtility util, User user, String snapshot, int expectedRowCount) throws IOException, InterruptedException {
        PrivilegedExceptionAction<Void> action = TestHDFSAclHelper.getScanSnapshotAction(util.getConfiguration(), snapshot, expectedRowCount);
        user.runAs(action);
    }

    static PrivilegedExceptionAction<Void> getScanSnapshotAction(Configuration conf, String snapshotName, long expectedRowCount) {
        return () -> {
            try {
                Result result;
                Path restoreDir = new Path("/hbase/.tmpdir-to-restore-snapshot");
                Scan scan = new Scan();
                TableSnapshotScanner scanner = new TableSnapshotScanner(conf, restoreDir, snapshotName, scan);
                int rowCount = 0;
                while ((result = scanner.next()) != null) {
                    ++rowCount;
                }
                scanner.close();
                Assert.assertEquals((long)expectedRowCount, (long)rowCount);
            }
            catch (Exception e) {
                LOG.debug("Scan snapshot error, snapshot {}", (Object)snapshotName, (Object)e);
                Assert.assertEquals((long)expectedRowCount, (long)-1L);
            }
            return null;
        };
    }
}

