/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestProcedureBypass {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureBypass.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestProcedureBypass.class);
    private static final int PROCEDURE_EXECUTOR_SLOTS = 1;
    private static TestProcEnv procEnv;
    private static ProcedureStore procStore;
    private static ProcedureExecutor<TestProcEnv> procExecutor;
    private static HBaseCommonTestingUtility htu;
    private static FileSystem fs;
    private static Path testDir;
    private static Path logDir;

    @BeforeClass
    public static void setUp() throws Exception {
        htu = new HBaseCommonTestingUtility();
        procEnv = new TestProcEnv();
        testDir = htu.getDataTestDir();
        fs = testDir.getFileSystem(htu.getConfiguration());
        Assert.assertTrue((testDir.depth() > 1 ? 1 : 0) != 0);
        logDir = new Path(testDir, "proc-logs");
        procStore = ProcedureTestingUtility.createWalStore(htu.getConfiguration(), logDir);
        procExecutor = new ProcedureExecutor(htu.getConfiguration(), (Object)procEnv, procStore);
        procStore.start(1);
        ProcedureTestingUtility.initAndStartWorkers(procExecutor, 1, true);
    }

    @Test
    public void testBypassSuspendProcedure() throws Exception {
        SuspendProcedure proc = new SuspendProcedure();
        long id = procExecutor.submitProcedure((Procedure)proc);
        Thread.sleep(500L);
        Assert.assertTrue((boolean)procExecutor.bypassProcedure(id, 30000L, false, false));
        htu.waitFor(5000L, () -> proc.isSuccess() && proc.isBypass());
        LOG.info("{} finished", (Object)proc);
    }

    @Test
    public void testStuckProcedure() throws Exception {
        StuckProcedure proc = new StuckProcedure();
        long id = procExecutor.submitProcedure((Procedure)proc);
        Thread.sleep(500L);
        Assert.assertTrue((boolean)procExecutor.bypassProcedure(id, 1000L, true, false));
        ProcedureTestingUtility.restart(procExecutor);
        htu.waitFor(5000L, () -> proc.isSuccess() && proc.isBypass());
        LOG.info("{} finished", (Object)proc);
    }

    @Test
    public void testBypassingProcedureWithParent() throws Exception {
        RootProcedure proc = new RootProcedure();
        long rootId = procExecutor.submitProcedure((Procedure)proc);
        htu.waitFor(5000L, () -> procExecutor.getProcedures().stream().filter(p -> p.getParentProcId() == rootId).collect(Collectors.toList()).size() > 0);
        SuspendProcedure suspendProcedure = (SuspendProcedure)((Object)procExecutor.getProcedures().stream().filter(p -> p.getParentProcId() == rootId).collect(Collectors.toList()).get(0));
        Assert.assertTrue((boolean)procExecutor.bypassProcedure(suspendProcedure.getProcId(), 1000L, false, false));
        htu.waitFor(5000L, () -> proc.isSuccess() && proc.isBypass());
        LOG.info("{} finished", (Object)proc);
    }

    @Test
    public void testBypassingStuckStateMachineProcedure() throws Exception {
        StuckStateMachineProcedure proc = new StuckStateMachineProcedure(procEnv, StuckStateMachineState.START);
        long id = procExecutor.submitProcedure((Procedure)proc);
        Thread.sleep(500L);
        Assert.assertFalse((boolean)procExecutor.bypassProcedure(id, 1000L, false, false));
        Assert.assertTrue((boolean)procExecutor.bypassProcedure(id, 1000L, true, false));
        htu.waitFor(5000L, () -> proc.isSuccess() && proc.isBypass());
        LOG.info("{} finished", (Object)proc);
    }

    @Test
    public void testBypassingProcedureWithParentRecursive() throws Exception {
        RootProcedure proc = new RootProcedure();
        long rootId = procExecutor.submitProcedure((Procedure)proc);
        htu.waitFor(5000L, () -> procExecutor.getProcedures().stream().filter(p -> p.getParentProcId() == rootId).collect(Collectors.toList()).size() > 0);
        SuspendProcedure suspendProcedure = (SuspendProcedure)((Object)procExecutor.getProcedures().stream().filter(p -> p.getParentProcId() == rootId).collect(Collectors.toList()).get(0));
        Assert.assertTrue((boolean)procExecutor.bypassProcedure(rootId, 1000L, false, true));
        htu.waitFor(5000L, () -> proc.isSuccess() && proc.isBypass());
        LOG.info("{} finished", (Object)proc);
    }

    @Test
    public void testBypassingWaitingTimeoutProcedures() throws Exception {
        WaitingTimeoutProcedure proc = new WaitingTimeoutProcedure();
        long id = procExecutor.submitProcedure((Procedure)proc);
        Thread.sleep(500L);
        Assert.assertTrue((boolean)procExecutor.bypassProcedure(id, 1000L, true, false));
        htu.waitFor(5000L, () -> proc.isSuccess() && proc.isBypass());
        LOG.info("{} finished", (Object)proc);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        procExecutor.stop();
        procStore.stop(false);
        procExecutor.join();
    }

    public static class StuckStateMachineProcedure
    extends ProcedureTestingUtility.NoopStateMachineProcedure<TestProcEnv, StuckStateMachineState> {
        private AtomicBoolean stop = new AtomicBoolean(false);

        public StuckStateMachineProcedure() {
        }

        public StuckStateMachineProcedure(TestProcEnv env, StuckStateMachineState initialState) {
            super(env, initialState);
        }

        @Override
        protected StateMachineProcedure.Flow executeFromState(TestProcEnv env, StuckStateMachineState tState) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
            switch (tState) {
                case START: {
                    LOG.info("PHASE 1: START");
                    this.setNextState((Object)StuckStateMachineState.THEN);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case THEN: {
                    if (this.stop.get()) {
                        this.setNextState((Object)StuckStateMachineState.END);
                    }
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case END: {
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
            }
            throw new UnsupportedOperationException("unhandled state=" + (Object)((Object)tState));
        }

        @Override
        protected StuckStateMachineState getState(int stateId) {
            return StuckStateMachineState.values()[stateId];
        }

        @Override
        protected int getStateId(StuckStateMachineState tState) {
            return tState.ordinal();
        }
    }

    public static enum StuckStateMachineState {
        START,
        THEN,
        END;

    }

    public static class WaitingTimeoutProcedure
    extends ProcedureTestingUtility.NoopProcedure<TestProcEnv> {
        @Override
        protected Procedure[] execute(TestProcEnv env) throws ProcedureSuspendedException {
            this.setTimeout(50000);
            this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
            this.skipPersistence();
            throw new ProcedureSuspendedException();
        }

        protected synchronized boolean setTimeoutFailure(TestProcEnv env) {
            this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
            procExecutor.getScheduler().addFront((Procedure)this);
            return false;
        }
    }

    public static class RootProcedure
    extends ProcedureTestingUtility.NoopProcedure<TestProcEnv> {
        private boolean childSpwaned = false;

        @Override
        protected Procedure[] execute(TestProcEnv env) throws ProcedureSuspendedException {
            if (!this.childSpwaned) {
                this.childSpwaned = true;
                return new Procedure[]{new SuspendProcedure()};
            }
            return null;
        }
    }

    public static class StuckProcedure
    extends ProcedureTestingUtility.NoopProcedure<TestProcEnv> {
        @Override
        protected Procedure[] execute(TestProcEnv env) {
            try {
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (Throwable t) {
                LOG.debug("Sleep is interrupted.", t);
            }
            return null;
        }
    }

    public static class SuspendProcedure
    extends ProcedureTestingUtility.NoopProcedure<TestProcEnv> {
        @Override
        protected Procedure[] execute(TestProcEnv env) throws ProcedureSuspendedException {
            throw new ProcedureSuspendedException();
        }
    }

    private static class TestProcEnv {
        private TestProcEnv() {
        }
    }
}

