/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.provider.example;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ShadeTokenIdentifier
extends TokenIdentifier {
    private static final Text TEXT_TOKEN_KIND = new Text("HBASE_EXAMPLE_SHADE_TOKEN");
    private String username;

    public ShadeTokenIdentifier() {
    }

    public ShadeTokenIdentifier(String username) {
        this.username = Objects.requireNonNull(username);
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.username);
    }

    public void readFields(DataInput in) throws IOException {
        this.username = in.readUTF();
    }

    public Text getKind() {
        return TEXT_TOKEN_KIND;
    }

    public UserGroupInformation getUser() {
        if (this.username == null || "".equals(this.username)) {
            return null;
        }
        return UserGroupInformation.createRemoteUser((String)this.username);
    }
}

