/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.nonstop.store;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.config.NonstopConfiguration;
import net.sf.ehcache.constructs.nonstop.NonstopActiveDelegateHolder;
import net.sf.ehcache.constructs.nonstop.concurrency.ExplicitLockingContextThreadLocal;
import net.sf.ehcache.constructs.nonstop.store.ExecutorServiceStore;
import net.sf.ehcache.constructs.nonstop.store.NonstopTimeoutBehaviorStoreResolver;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.transaction.manager.TransactionManagerLookup;
import net.sf.ehcache.writer.CacheWriterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalExecutorServiceStore
extends ExecutorServiceStore {
    private static final Logger LOG = LoggerFactory.getLogger((String)TransactionalExecutorServiceStore.class.getName());
    private final TransactionManager transactionManager;

    public TransactionalExecutorServiceStore(NonstopActiveDelegateHolder nonstopActiveDelegateHolder, NonstopConfiguration nonstopConfiguration, NonstopTimeoutBehaviorStoreResolver timeoutBehaviorResolver, CacheCluster cacheCluster, TransactionManagerLookup transactionManagerLookup, ExplicitLockingContextThreadLocal explicitLockingContextThreadLocal) {
        super(nonstopActiveDelegateHolder, nonstopConfiguration, timeoutBehaviorResolver, cacheCluster, explicitLockingContextThreadLocal);
        this.transactionManager = transactionManagerLookup.getTransactionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(final Element element) throws CacheException {
        boolean rv = false;
        final Transaction tx = this.suspendCaller();
        try {
            rv = this.executeWithExecutor(new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean call() throws Exception {
                    TransactionalExecutorServiceStore.this.resumeCallee(tx);
                    try {
                        Boolean bl = TransactionalExecutorServiceStore.this.underlyingTerracottaStore().put(element);
                        return bl;
                    }
                    finally {
                        TransactionalExecutorServiceStore.this.suspendCallee();
                    }
                }
            });
        }
        catch (TimeoutException e) {
            boolean bl = this.resolveTimeoutBehaviorStore().put(element);
            return bl;
        }
        finally {
            this.resumeCaller(tx);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putWithWriter(final Element element, final CacheWriterManager writerManager) throws CacheException {
        boolean rv = false;
        final Transaction tx = this.suspendCaller();
        try {
            rv = this.executeWithExecutor(new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean call() throws Exception {
                    TransactionalExecutorServiceStore.this.resumeCallee(tx);
                    try {
                        Boolean bl = TransactionalExecutorServiceStore.this.underlyingTerracottaStore().putWithWriter(element, writerManager);
                        return bl;
                    }
                    finally {
                        TransactionalExecutorServiceStore.this.suspendCallee();
                    }
                }
            });
        }
        catch (TimeoutException e) {
            boolean bl = this.resolveTimeoutBehaviorStore().putWithWriter(element, writerManager);
            return bl;
        }
        finally {
            this.resumeCaller(tx);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element get(final Object key) {
        Element rv = null;
        final Transaction tx = this.suspendCaller();
        try {
            rv = this.executeWithExecutor(new Callable<Element>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Element call() throws Exception {
                    TransactionalExecutorServiceStore.this.resumeCallee(tx);
                    try {
                        Element element = TransactionalExecutorServiceStore.this.underlyingTerracottaStore().get(key);
                        return element;
                    }
                    finally {
                        TransactionalExecutorServiceStore.this.suspendCallee();
                    }
                }
            });
        }
        catch (TimeoutException e) {
            Element element = this.resolveTimeoutBehaviorStore().get(key);
            return element;
        }
        finally {
            this.resumeCaller(tx);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getQuiet(final Object key) {
        Element rv = null;
        final Transaction tx = this.suspendCaller();
        try {
            rv = this.executeWithExecutor(new Callable<Element>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Element call() throws Exception {
                    TransactionalExecutorServiceStore.this.resumeCallee(tx);
                    try {
                        Element element = TransactionalExecutorServiceStore.this.underlyingTerracottaStore().getQuiet(key);
                        return element;
                    }
                    finally {
                        TransactionalExecutorServiceStore.this.suspendCallee();
                    }
                }
            });
        }
        catch (TimeoutException e) {
            Element element = this.resolveTimeoutBehaviorStore().getQuiet(key);
            return element;
        }
        finally {
            this.resumeCaller(tx);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getKeys() {
        List rv = null;
        final Transaction tx = this.suspendCaller();
        try {
            rv = this.executeWithExecutor(new Callable<List>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public List call() throws Exception {
                    TransactionalExecutorServiceStore.this.resumeCallee(tx);
                    try {
                        List list = TransactionalExecutorServiceStore.this.underlyingTerracottaStore().getKeys();
                        return list;
                    }
                    finally {
                        TransactionalExecutorServiceStore.this.suspendCallee();
                    }
                }
            });
        }
        catch (TimeoutException e) {
            List list = this.resolveTimeoutBehaviorStore().getKeys();
            return list;
        }
        finally {
            this.resumeCaller(tx);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element remove(final Object key) {
        Element rv = null;
        final Transaction tx = this.suspendCaller();
        try {
            rv = this.executeWithExecutor(new Callable<Element>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Element call() throws Exception {
                    TransactionalExecutorServiceStore.this.resumeCallee(tx);
                    try {
                        Element element = TransactionalExecutorServiceStore.this.underlyingTerracottaStore().remove(key);
                        return element;
                    }
                    finally {
                        TransactionalExecutorServiceStore.this.suspendCallee();
                    }
                }
            });
        }
        catch (TimeoutException e) {
            Element element = this.resolveTimeoutBehaviorStore().remove(key);
            return element;
        }
        finally {
            this.resumeCaller(tx);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element removeWithWriter(final Object key, final CacheWriterManager writerManager) throws CacheException {
        Element rv = null;
        final Transaction tx = this.suspendCaller();
        try {
            rv = this.executeWithExecutor(new Callable<Element>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Element call() throws Exception {
                    TransactionalExecutorServiceStore.this.resumeCallee(tx);
                    try {
                        Element element = TransactionalExecutorServiceStore.this.underlyingTerracottaStore().removeWithWriter(key, writerManager);
                        return element;
                    }
                    finally {
                        TransactionalExecutorServiceStore.this.suspendCallee();
                    }
                }
            });
        }
        catch (TimeoutException e) {
            Element element = this.resolveTimeoutBehaviorStore().removeWithWriter(key, writerManager);
            return element;
        }
        finally {
            this.resumeCaller(tx);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() throws CacheException {
        final Transaction tx = this.suspendCaller();
        try {
            this.executeWithExecutor(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    TransactionalExecutorServiceStore.this.resumeCallee(tx);
                    try {
                        TransactionalExecutorServiceStore.this.underlyingTerracottaStore().removeAll();
                        Void void_ = null;
                        return void_;
                    }
                    finally {
                        TransactionalExecutorServiceStore.this.suspendCallee();
                    }
                }
            }, this.nonstopConfiguration.getTimeoutMillis() * (long)this.nonstopConfiguration.getBulkOpsTimeoutMultiplyFactor());
        }
        catch (TimeoutException e) {
            this.resolveTimeoutBehaviorStore().removeAll();
        }
        finally {
            this.resumeCaller(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element putIfAbsent(final Element element) throws NullPointerException {
        Element rv = null;
        final Transaction tx = this.suspendCaller();
        try {
            rv = this.executeWithExecutor(new Callable<Element>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Element call() throws Exception {
                    TransactionalExecutorServiceStore.this.resumeCallee(tx);
                    try {
                        Element element2 = TransactionalExecutorServiceStore.this.underlyingTerracottaStore().putIfAbsent(element);
                        return element2;
                    }
                    finally {
                        TransactionalExecutorServiceStore.this.suspendCallee();
                    }
                }
            });
        }
        catch (TimeoutException e) {
            Element element2 = this.resolveTimeoutBehaviorStore().putIfAbsent(element);
            return element2;
        }
        finally {
            this.resumeCaller(tx);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element removeElement(final Element element, final ElementValueComparator comparator) throws NullPointerException {
        Element rv = null;
        final Transaction tx = this.suspendCaller();
        try {
            rv = this.executeWithExecutor(new Callable<Element>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Element call() throws Exception {
                    TransactionalExecutorServiceStore.this.resumeCallee(tx);
                    try {
                        Element element2 = TransactionalExecutorServiceStore.this.underlyingTerracottaStore().removeElement(element, comparator);
                        return element2;
                    }
                    finally {
                        TransactionalExecutorServiceStore.this.suspendCallee();
                    }
                }
            });
        }
        catch (TimeoutException e) {
            Element element2 = this.resolveTimeoutBehaviorStore().removeElement(element, comparator);
            return element2;
        }
        finally {
            this.resumeCaller(tx);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(final Element old, final Element element, final ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        boolean rv = false;
        final Transaction tx = this.suspendCaller();
        try {
            rv = this.executeWithExecutor(new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean call() throws Exception {
                    TransactionalExecutorServiceStore.this.resumeCallee(tx);
                    try {
                        Boolean bl = TransactionalExecutorServiceStore.this.underlyingTerracottaStore().replace(old, element, comparator);
                        return bl;
                    }
                    finally {
                        TransactionalExecutorServiceStore.this.suspendCallee();
                    }
                }
            });
        }
        catch (TimeoutException e) {
            boolean bl = this.resolveTimeoutBehaviorStore().replace(old, element, comparator);
            return bl;
        }
        finally {
            this.resumeCaller(tx);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element replace(final Element element) throws NullPointerException {
        Element rv = null;
        final Transaction tx = this.suspendCaller();
        try {
            rv = this.executeWithExecutor(new Callable<Element>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Element call() throws Exception {
                    TransactionalExecutorServiceStore.this.resumeCallee(tx);
                    try {
                        Element element2 = TransactionalExecutorServiceStore.this.underlyingTerracottaStore().replace(element);
                        return element2;
                    }
                    finally {
                        TransactionalExecutorServiceStore.this.suspendCallee();
                    }
                }
            });
        }
        catch (TimeoutException e) {
            Element element2 = this.resolveTimeoutBehaviorStore().replace(element);
            return element2;
        }
        finally {
            this.resumeCaller(tx);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        int rv = 0;
        final Transaction tx = this.suspendCaller();
        try {
            rv = this.executeWithExecutor(new Callable<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Integer call() throws Exception {
                    TransactionalExecutorServiceStore.this.resumeCallee(tx);
                    try {
                        Integer n = TransactionalExecutorServiceStore.this.underlyingTerracottaStore().getSize();
                        return n;
                    }
                    finally {
                        TransactionalExecutorServiceStore.this.suspendCallee();
                    }
                }
            });
        }
        catch (TimeoutException e) {
            int n = this.resolveTimeoutBehaviorStore().getSize();
            return n;
        }
        finally {
            this.resumeCaller(tx);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTerracottaClusteredSize() {
        int rv = 0;
        final Transaction tx = this.suspendCaller();
        try {
            rv = this.executeWithExecutor(new Callable<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Integer call() throws Exception {
                    TransactionalExecutorServiceStore.this.resumeCallee(tx);
                    try {
                        Integer n = TransactionalExecutorServiceStore.this.underlyingTerracottaStore().getTerracottaClusteredSize();
                        return n;
                    }
                    finally {
                        TransactionalExecutorServiceStore.this.suspendCallee();
                    }
                }
            });
        }
        catch (TimeoutException e) {
            int n = this.resolveTimeoutBehaviorStore().getTerracottaClusteredSize();
            return n;
        }
        finally {
            this.resumeCaller(tx);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(final Object key) {
        boolean rv = false;
        final Transaction tx = this.suspendCaller();
        try {
            rv = this.executeWithExecutor(new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean call() throws Exception {
                    TransactionalExecutorServiceStore.this.resumeCallee(tx);
                    try {
                        Boolean bl = TransactionalExecutorServiceStore.this.underlyingTerracottaStore().containsKey(key);
                        return bl;
                    }
                    finally {
                        TransactionalExecutorServiceStore.this.suspendCallee();
                    }
                }
            });
        }
        catch (TimeoutException e) {
            boolean bl = this.resolveTimeoutBehaviorStore().containsKey(key);
            return bl;
        }
        finally {
            this.resumeCaller(tx);
        }
        return rv;
    }

    private void resumeCaller(Transaction tx) {
        if (tx == null) {
            return;
        }
        try {
            this.transactionManager.resume(tx);
        }
        catch (IllegalStateException ise) {
            LOG.warn("error resuming JTA transaction context on caller thread", (Throwable)ise);
        }
        catch (InvalidTransactionException ite) {
            LOG.warn("error resuming JTA transaction context on caller thread", (Throwable)ite);
        }
        catch (SystemException se) {
            LOG.warn("error resuming JTA transaction context on caller thread", (Throwable)se);
        }
    }

    private Transaction suspendCaller() {
        try {
            return this.transactionManager.suspend();
        }
        catch (SystemException se) {
            throw new CacheException("error suspending JTA transaction context", se);
        }
    }

    private void resumeCallee(Transaction tx) {
        if (tx == null) {
            return;
        }
        try {
            this.transactionManager.resume(tx);
        }
        catch (IllegalStateException ise) {
            throw new CacheException("error resuming JTA transaction context on caller thread", ise);
        }
        catch (InvalidTransactionException ite) {
            throw new CacheException("error resuming JTA transaction context on caller thread", ite);
        }
        catch (SystemException se) {
            throw new CacheException("error resuming JTA transaction context on caller thread", se);
        }
    }

    private Transaction suspendCallee() {
        try {
            return this.transactionManager.suspend();
        }
        catch (SystemException se) {
            LOG.warn("error suspending JTA transaction context", (Throwable)se);
            return null;
        }
    }
}

