/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.internal;

import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.internal.AddressAndPort;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.internal.AddressAndPortExtractor;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.ClientAttributes;

public final class InternalClientAttributesExtractor<REQUEST> {
    private final AddressAndPortExtractor<REQUEST> addressAndPortExtractor;
    private final boolean capturePort;

    public InternalClientAttributesExtractor(AddressAndPortExtractor<REQUEST> addressAndPortExtractor, boolean capturePort) {
        this.addressAndPortExtractor = addressAndPortExtractor;
        this.capturePort = capturePort;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        AddressAndPort clientAddressAndPort = this.addressAndPortExtractor.extract(request);
        if (clientAddressAndPort.address != null) {
            AttributesExtractorUtil.internalSet(attributes, ClientAttributes.CLIENT_ADDRESS, clientAddressAndPort.address);
            if (this.capturePort && clientAddressAndPort.port != null && clientAddressAndPort.port > 0) {
                AttributesExtractorUtil.internalSet(attributes, ClientAttributes.CLIENT_PORT, Long.valueOf(clientAddressAndPort.port.intValue()));
            }
        }
    }
}

