/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ZKFCProtocol;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.tools.DFSHAAdmin;
import org.apache.hadoop.test.MockitoUtil;
import org.apache.hadoop.util.Shell;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDFSHAAdmin {
    private static final Log LOG = LogFactory.getLog(TestDFSHAAdmin.class);
    private DFSHAAdmin tool;
    private final ByteArrayOutputStream errOutBytes = new ByteArrayOutputStream();
    private final ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
    private String errOutput;
    private String output;
    private HAServiceProtocol mockProtocol;
    private ZKFCProtocol mockZkfcProtocol;
    private static final String NSID = "ns1";
    private static final HAServiceStatus STANDBY_READY_RESULT = new HAServiceStatus(HAServiceProtocol.HAServiceState.STANDBY).setReadyToBecomeActive();
    private final ArgumentCaptor<HAServiceProtocol.StateChangeRequestInfo> reqInfoCaptor = ArgumentCaptor.forClass(HAServiceProtocol.StateChangeRequestInfo.class);
    private static final String HOST_A = "1.2.3.1";
    private static final String HOST_B = "1.2.3.2";
    private static final String FENCER_TRUE_COMMAND_UNIX = "shell(true)";
    private static final String FENCER_FALSE_COMMAND_UNIX = "shell(false)";
    private static final String FENCER_TRUE_COMMAND_WINDOWS = "shell(rem)";
    private static final String FENCER_FALSE_COMMAND_WINDOWS = "shell(help.exe /? >NUL)";

    private HdfsConfiguration getHAConf() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", NSID);
        conf.set("dfs.nameservice.id", NSID);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{NSID}), "nn1,nn2");
        conf.set("dfs.ha.namenode.id", "nn1");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{NSID, "nn1"}), "1.2.3.1:12345");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{NSID, "nn2"}), "1.2.3.2:12345");
        return conf;
    }

    public static String getFencerTrueCommand() {
        return Shell.WINDOWS ? FENCER_TRUE_COMMAND_WINDOWS : FENCER_TRUE_COMMAND_UNIX;
    }

    public static String getFencerFalseCommand() {
        return Shell.WINDOWS ? FENCER_FALSE_COMMAND_WINDOWS : FENCER_FALSE_COMMAND_UNIX;
    }

    @Before
    public void setup() throws IOException {
        this.mockProtocol = (HAServiceProtocol)MockitoUtil.mockProtocol(HAServiceProtocol.class);
        this.mockZkfcProtocol = (ZKFCProtocol)MockitoUtil.mockProtocol(ZKFCProtocol.class);
        this.tool = new DFSHAAdmin(){

            protected HAServiceTarget resolveTarget(String nnId) {
                HAServiceTarget target = super.resolveTarget(nnId);
                HAServiceTarget spy = (HAServiceTarget)Mockito.spy((Object)target);
                try {
                    ((HAServiceTarget)Mockito.doReturn((Object)TestDFSHAAdmin.this.mockProtocol).when((Object)spy)).getProxy((Configuration)Mockito.any(), Mockito.anyInt());
                    ((HAServiceTarget)Mockito.doReturn((Object)TestDFSHAAdmin.this.mockZkfcProtocol).when((Object)spy)).getZKFCProxy((Configuration)Mockito.any(), Mockito.anyInt());
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
                return spy;
            }
        };
        this.tool.setConf((Configuration)this.getHAConf());
        this.tool.setErrOut(new PrintStream(this.errOutBytes));
        this.tool.setOut(new PrintStream(this.outBytes));
    }

    private void assertOutputContains(String string) {
        if (!this.errOutput.contains(string) && !this.output.contains(string)) {
            Assert.fail((String)("Expected output to contain '" + string + "' but err_output was:\n" + this.errOutput + "\n and output was: \n" + this.output));
        }
    }

    @Test
    public void testNameserviceOption() throws Exception {
        Assert.assertEquals((Object)-1, (Object)this.runTool("-ns"));
        this.assertOutputContains("Missing nameservice ID");
        Assert.assertEquals((Object)-1, (Object)this.runTool("-ns", NSID));
        this.assertOutputContains("Missing command");
        Assert.assertEquals((Object)0, (Object)this.runTool("-ns", NSID, "-help", "transitionToActive"));
        this.assertOutputContains("Transitions the service into Active");
    }

    @Test
    public void testNamenodeResolution() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)STANDBY_READY_RESULT).when((Object)this.mockProtocol)).getServiceStatus();
        Assert.assertEquals((Object)0, (Object)this.runTool("-getServiceState", "nn1"));
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol)).getServiceStatus();
        Assert.assertEquals((Object)-1, (Object)this.runTool("-getServiceState", "undefined"));
        this.assertOutputContains("Unable to determine service address for namenode 'undefined'");
    }

    @Test
    public void testHelp() throws Exception {
        Assert.assertEquals((Object)0, (Object)this.runTool("-help"));
        Assert.assertEquals((Object)0, (Object)this.runTool("-help", "transitionToActive"));
        this.assertOutputContains("Transitions the service into Active");
    }

    @Test
    public void testGetAllServiceState() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)STANDBY_READY_RESULT).when((Object)this.mockProtocol)).getServiceStatus();
        Assert.assertEquals((Object)0, (Object)this.runTool("-getAllServiceState"));
        this.assertOutputContains(String.format("%-50s %-10s", "1.2.3.1:12345", STANDBY_READY_RESULT.getState()));
        this.assertOutputContains(String.format("%-50s %-10s", "1.2.3.2:12345", STANDBY_READY_RESULT.getState()));
    }

    @Test
    public void testTransitionToActive() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)STANDBY_READY_RESULT).when((Object)this.mockProtocol)).getServiceStatus();
        Assert.assertEquals((Object)0, (Object)this.runTool("-transitionToActive", "nn1"));
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol)).transitionToActive((HAServiceProtocol.StateChangeRequestInfo)this.reqInfoCaptor.capture());
        Assert.assertEquals((Object)HAServiceProtocol.RequestSource.REQUEST_BY_USER, (Object)((HAServiceProtocol.StateChangeRequestInfo)this.reqInfoCaptor.getValue()).getSource());
    }

    @Test
    public void testMutativeOperationsWithAutoHaEnabled() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)STANDBY_READY_RESULT).when((Object)this.mockProtocol)).getServiceStatus();
        HdfsConfiguration conf = this.getHAConf();
        conf.setBoolean("dfs.ha.automatic-failover.enabled", true);
        conf.set("dfs.ha.fencing.methods", TestDFSHAAdmin.getFencerTrueCommand());
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)-1, (Object)this.runTool("-transitionToActive", "nn1"));
        Assert.assertTrue((boolean)this.errOutput.contains("Refusing to manually manage"));
        Assert.assertEquals((Object)-1, (Object)this.runTool("-transitionToStandby", "nn1"));
        Assert.assertTrue((boolean)this.errOutput.contains("Refusing to manually manage"));
        Assert.assertEquals((Object)-1, (Object)this.runTool("-transitionToObserver", "nn1"));
        Assert.assertTrue((boolean)this.errOutput.contains("Refusing to manually manage"));
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol, (VerificationMode)Mockito.never())).transitionToActive(this.anyReqInfo());
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol, (VerificationMode)Mockito.never())).transitionToStandby(this.anyReqInfo());
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol, (VerificationMode)Mockito.never())).transitionToObserver(this.anyReqInfo());
        TestDFSHAAdmin.setupConfirmationOnSystemIn();
        Assert.assertEquals((Object)0, (Object)this.runTool("-transitionToActive", "-forcemanual", "nn1"));
        TestDFSHAAdmin.setupConfirmationOnSystemIn();
        Assert.assertEquals((Object)0, (Object)this.runTool("-transitionToStandby", "-forcemanual", "nn1"));
        TestDFSHAAdmin.setupConfirmationOnSystemIn();
        Assert.assertEquals((Object)0, (Object)this.runTool("-transitionToObserver", "-forcemanual", "nn1"));
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol, (VerificationMode)Mockito.times((int)1))).transitionToActive((HAServiceProtocol.StateChangeRequestInfo)this.reqInfoCaptor.capture());
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol, (VerificationMode)Mockito.times((int)1))).transitionToStandby((HAServiceProtocol.StateChangeRequestInfo)this.reqInfoCaptor.capture());
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol, (VerificationMode)Mockito.times((int)1))).transitionToObserver((HAServiceProtocol.StateChangeRequestInfo)this.reqInfoCaptor.capture());
        for (HAServiceProtocol.StateChangeRequestInfo ri : this.reqInfoCaptor.getAllValues()) {
            Assert.assertEquals((Object)HAServiceProtocol.RequestSource.REQUEST_BY_USER_FORCED, (Object)ri.getSource());
        }
    }

    private static void setupConfirmationOnSystemIn() {
        System.setIn(new ByteArrayInputStream("yes\n".getBytes()));
    }

    @Test
    public void testMonitoringOperationsWithAutoHaEnabled() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)STANDBY_READY_RESULT).when((Object)this.mockProtocol)).getServiceStatus();
        HdfsConfiguration conf = this.getHAConf();
        conf.setBoolean("dfs.ha.automatic-failover.enabled", true);
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)0, (Object)this.runTool("-checkHealth", "nn1"));
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol)).monitorHealth();
        Assert.assertEquals((Object)0, (Object)this.runTool("-getServiceState", "nn1"));
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol)).getServiceStatus();
    }

    @Test
    public void testTransitionToStandby() throws Exception {
        Assert.assertEquals((Object)0, (Object)this.runTool("-transitionToStandby", "nn1"));
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol)).transitionToStandby(this.anyReqInfo());
    }

    @Test
    public void testTransitionToObserver() throws Exception {
        Assert.assertEquals((Object)0, (Object)this.runTool("-transitionToObserver", "nn1"));
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol)).transitionToObserver(this.anyReqInfo());
    }

    @Test
    public void testFailoverWithNoFencerConfigured() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)STANDBY_READY_RESULT).when((Object)this.mockProtocol)).getServiceStatus();
        Assert.assertEquals((Object)-1, (Object)this.runTool("-failover", "nn1", "nn2"));
    }

    @Test
    public void testFailoverWithFencerConfigured() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)STANDBY_READY_RESULT).when((Object)this.mockProtocol)).getServiceStatus();
        HdfsConfiguration conf = this.getHAConf();
        conf.set("dfs.ha.fencing.methods", TestDFSHAAdmin.getFencerTrueCommand());
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)0, (Object)this.runTool("-failover", "nn1", "nn2"));
    }

    @Test
    public void testFailoverWithFencerAndNameservice() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)STANDBY_READY_RESULT).when((Object)this.mockProtocol)).getServiceStatus();
        HdfsConfiguration conf = this.getHAConf();
        conf.set("dfs.ha.fencing.methods", TestDFSHAAdmin.getFencerTrueCommand());
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)0, (Object)this.runTool("-ns", NSID, "-failover", "nn1", "nn2"));
    }

    @Test
    public void testFailoverWithFencerConfiguredAndForce() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)STANDBY_READY_RESULT).when((Object)this.mockProtocol)).getServiceStatus();
        HdfsConfiguration conf = this.getHAConf();
        conf.set("dfs.ha.fencing.methods", TestDFSHAAdmin.getFencerTrueCommand());
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)0, (Object)this.runTool("-failover", "nn1", "nn2", "--forcefence"));
    }

    @Test
    public void testFailoverWithForceActive() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)STANDBY_READY_RESULT).when((Object)this.mockProtocol)).getServiceStatus();
        HdfsConfiguration conf = this.getHAConf();
        conf.set("dfs.ha.fencing.methods", TestDFSHAAdmin.getFencerTrueCommand());
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)0, (Object)this.runTool("-failover", "nn1", "nn2", "--forceactive"));
    }

    @Test
    public void testFailoverWithInvalidFenceArg() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)STANDBY_READY_RESULT).when((Object)this.mockProtocol)).getServiceStatus();
        HdfsConfiguration conf = this.getHAConf();
        conf.set("dfs.ha.fencing.methods", TestDFSHAAdmin.getFencerTrueCommand());
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)-1, (Object)this.runTool("-failover", "nn1", "nn2", "notforcefence"));
    }

    @Test
    public void testFailoverWithFenceButNoFencer() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)STANDBY_READY_RESULT).when((Object)this.mockProtocol)).getServiceStatus();
        Assert.assertEquals((Object)-1, (Object)this.runTool("-failover", "nn1", "nn2", "--forcefence"));
    }

    @Test
    public void testFailoverWithFenceAndBadFencer() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)STANDBY_READY_RESULT).when((Object)this.mockProtocol)).getServiceStatus();
        HdfsConfiguration conf = this.getHAConf();
        conf.set("dfs.ha.fencing.methods", "foobar!");
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)-1, (Object)this.runTool("-failover", "nn1", "nn2", "--forcefence"));
    }

    @Test
    public void testFailoverWithAutoHa() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)STANDBY_READY_RESULT).when((Object)this.mockProtocol)).getServiceStatus();
        HdfsConfiguration conf = this.getHAConf();
        conf.setBoolean("dfs.ha.automatic-failover.enabled", true);
        conf.set("dfs.ha.fencing.methods", TestDFSHAAdmin.getFencerTrueCommand());
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)0, (Object)this.runTool("-failover", "nn1", "nn2"));
        ((ZKFCProtocol)Mockito.verify((Object)this.mockZkfcProtocol)).gracefulFailover();
    }

    @Test
    public void testForceFenceOptionListedBeforeArgs() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)STANDBY_READY_RESULT).when((Object)this.mockProtocol)).getServiceStatus();
        HdfsConfiguration conf = this.getHAConf();
        conf.set("dfs.ha.fencing.methods", TestDFSHAAdmin.getFencerTrueCommand());
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)0, (Object)this.runTool("-failover", "--forcefence", "nn1", "nn2"));
    }

    @Test
    public void testGetServiceStatus() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)STANDBY_READY_RESULT).when((Object)this.mockProtocol)).getServiceStatus();
        Assert.assertEquals((Object)0, (Object)this.runTool("-getServiceState", "nn1"));
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol)).getServiceStatus();
    }

    @Test
    public void testCheckHealth() throws Exception {
        Assert.assertEquals((Object)0, (Object)this.runTool("-checkHealth", "nn1"));
        ((HAServiceProtocol)Mockito.verify((Object)this.mockProtocol)).monitorHealth();
        ((HAServiceProtocol)Mockito.doThrow((Throwable)new HealthCheckFailedException("fake health check failure")).when((Object)this.mockProtocol)).monitorHealth();
        Assert.assertEquals((Object)-1, (Object)this.runTool("-checkHealth", "nn1"));
        this.assertOutputContains("Health check failed: fake health check failure");
    }

    @Test
    public void testFencingConfigPerNameNode() throws Exception {
        ((HAServiceProtocol)Mockito.doReturn((Object)STANDBY_READY_RESULT).when((Object)this.mockProtocol)).getServiceStatus();
        String nsSpecificKey = "dfs.ha.fencing.methods.ns1";
        String nnSpecificKey = "dfs.ha.fencing.methods.ns1.nn1";
        HdfsConfiguration conf = this.getHAConf();
        conf.set("dfs.ha.fencing.methods", TestDFSHAAdmin.getFencerTrueCommand());
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)0, (Object)this.runTool("-failover", "nn1", "nn2", "--forcefence"));
        conf.set("dfs.ha.fencing.methods.ns1.nn1", TestDFSHAAdmin.getFencerFalseCommand());
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)-1, (Object)this.runTool("-failover", "nn1", "nn2", "--forcefence"));
        conf.unset("dfs.ha.fencing.methods.ns1.nn1");
        conf.set("dfs.ha.fencing.methods.ns1", TestDFSHAAdmin.getFencerFalseCommand());
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)-1, (Object)this.runTool("-failover", "nn1", "nn2", "--forcefence"));
        conf.set("dfs.ha.fencing.methods.ns1", TestDFSHAAdmin.getFencerTrueCommand());
        this.tool.setConf((Configuration)conf);
        Assert.assertEquals((Object)0, (Object)this.runTool("-failover", "nn1", "nn2", "--forcefence"));
    }

    private Object runTool(String ... args) throws Exception {
        this.errOutBytes.reset();
        this.outBytes.reset();
        LOG.info((Object)("Running: DFSHAAdmin " + Joiner.on((String)" ").join((Object[])args)));
        int ret = this.tool.run(args);
        this.errOutput = new String(this.errOutBytes.toByteArray(), Charsets.UTF_8);
        this.output = new String(this.outBytes.toByteArray(), Charsets.UTF_8);
        LOG.info((Object)("Err_output:\n" + this.errOutput + "\nOutput:\n" + this.output));
        return ret;
    }

    private HAServiceProtocol.StateChangeRequestInfo anyReqInfo() {
        return (HAServiceProtocol.StateChangeRequestInfo)Mockito.any();
    }
}

