/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.IncompatibleFilterException;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Triple;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ExportUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExportUtils.class);
    public static final String RAW_SCAN = "hbase.mapreduce.include.deleted.rows";
    public static final String EXPORT_BATCHING = "hbase.export.scanner.batch";
    public static final String EXPORT_CACHING = "hbase.export.scanner.caching";
    public static final String EXPORT_VISIBILITY_LABELS = "hbase.export.visibility.labels";

    public static void usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: Export [-D <property=value>]* <tablename> <outputdir> [<versions> [<starttime> [<endtime>]] [^[regex pattern] or [Prefix] to filter]]\n");
        System.err.println("  Note: -D properties will be applied to the conf used. ");
        System.err.println("  For example: ");
        System.err.println("   -D mapreduce.output.fileoutputformat.compress=true");
        System.err.println("   -D mapreduce.output.fileoutputformat.compress.codec=org.apache.hadoop.io.compress.GzipCodec");
        System.err.println("   -D mapreduce.output.fileoutputformat.compress.type=BLOCK");
        System.err.println("  Additionally, the following SCAN properties can be specified");
        System.err.println("  to control/limit what is exported..");
        System.err.println("   -D hbase.mapreduce.scan.column.family=<family1>,<family2>, ...");
        System.err.println("   -D hbase.mapreduce.include.deleted.rows=true");
        System.err.println("   -D hbase.mapreduce.scan.row.start=<ROWSTART>");
        System.err.println("   -D hbase.mapreduce.scan.row.stop=<ROWSTOP>");
        System.err.println("   -D hbase.client.scanner.caching=100");
        System.err.println("   -D hbase.export.visibility.labels=<labels>");
        System.err.println("For tables with very wide rows consider setting the batch size as below:\n   -D hbase.export.scanner.batch=10\n   -D hbase.export.scanner.caching=100");
    }

    private static Filter getExportFilter(String[] args) {
        FilterBase exportFilter;
        String filterCriteria;
        String string = filterCriteria = args.length > 5 ? args[5] : null;
        if (filterCriteria == null) {
            return null;
        }
        if (filterCriteria.startsWith("^")) {
            String regexPattern = filterCriteria.substring(1, filterCriteria.length());
            exportFilter = new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator(regexPattern));
        } else {
            exportFilter = new PrefixFilter(Bytes.toBytesBinary(filterCriteria));
        }
        return exportFilter;
    }

    public static boolean isValidArguements(String[] args) {
        return args != null && args.length >= 2;
    }

    public static Triple<TableName, Scan, Path> getArgumentsFromCommandLine(Configuration conf, String[] args) throws IOException {
        if (!ExportUtils.isValidArguements(args)) {
            return null;
        }
        return new Triple<TableName, Scan, Path>(TableName.valueOf(args[0]), ExportUtils.getScanFromCommandLine(conf, args), new Path(args[1]));
    }

    static Scan getScanFromCommandLine(Configuration conf, String[] args) throws IOException {
        int caching;
        int batching;
        boolean raw;
        Scan s2 = new Scan();
        int versions = args.length > 2 ? Integer.parseInt(args[2]) : 1;
        s2.setMaxVersions(versions);
        long startTime = args.length > 3 ? Long.parseLong(args[3]) : 0L;
        long endTime = args.length > 4 ? Long.parseLong(args[4]) : Long.MAX_VALUE;
        s2.setTimeRange(startTime, endTime);
        s2.setCacheBlocks(false);
        if (conf.get("hbase.mapreduce.scan.row.start") != null) {
            s2.setStartRow(Bytes.toBytesBinary(conf.get("hbase.mapreduce.scan.row.start")));
        }
        if (conf.get("hbase.mapreduce.scan.row.stop") != null) {
            s2.setStopRow(Bytes.toBytesBinary(conf.get("hbase.mapreduce.scan.row.stop")));
        }
        if (raw = Boolean.parseBoolean(conf.get(RAW_SCAN))) {
            s2.setRaw(raw);
        }
        for (String columnFamily : conf.getTrimmedStrings("hbase.mapreduce.scan.column.family")) {
            s2.addFamily(Bytes.toBytes(columnFamily));
        }
        Filter exportFilter = ExportUtils.getExportFilter(args);
        if (exportFilter != null) {
            LOG.info("Setting Scan Filter for Export.");
            s2.setFilter(exportFilter);
        }
        List<String> labels = null;
        if (conf.get(EXPORT_VISIBILITY_LABELS) != null && !(labels = Arrays.asList(conf.getStrings(EXPORT_VISIBILITY_LABELS))).isEmpty()) {
            s2.setAuthorizations(new Authorizations(labels));
        }
        if ((batching = conf.getInt(EXPORT_BATCHING, -1)) != -1) {
            try {
                s2.setBatch(batching);
            }
            catch (IncompatibleFilterException e) {
                LOG.error("Batching could not be set", (Throwable)e);
            }
        }
        if ((caching = conf.getInt(EXPORT_CACHING, 100)) != -1) {
            try {
                s2.setCaching(caching);
            }
            catch (IncompatibleFilterException e) {
                LOG.error("Caching could not be set", (Throwable)e);
            }
        }
        LOG.info("versions=" + versions + ", starttime=" + startTime + ", endtime=" + endTime + ", keepDeletedCells=" + raw + ", visibility labels=" + labels);
        return s2;
    }

    private ExportUtils() {
    }
}

