/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytesTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(BytesTestBase.class);

    @Test
    public void testShort() throws Exception {
        for (short n : Arrays.asList((short)Short.MIN_VALUE, (short)-100, (short)-1, (short)0, (short)1, (short)300, (short)Short.MAX_VALUE)) {
            byte[] bytes = Bytes.toBytes((short)n);
            Assertions.assertEquals((short)Bytes.toShort((byte[])bytes, (int)0, (int)bytes.length), (short)n);
        }
    }

    @Test
    public void testNullHashCode() {
        byte[] b = null;
        Exception ee = null;
        try {
            Bytes.hashCode(b);
        }
        catch (Exception e) {
            ee = e;
        }
        Assertions.assertNotNull((Object)ee);
    }

    @Test
    public void testAdd() {
        byte[] a = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] b = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] c = new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        byte[] result1 = Bytes.add((byte[])a, (byte[])b, (byte[])c);
        byte[] result2 = Bytes.add((byte[][])new byte[][]{a, b, c});
        Assertions.assertEquals((int)0, (int)Bytes.compareTo((byte[])result1, (byte[])result2));
    }

    @Test
    public void testSplit() {
        byte[][] parts;
        byte[] lowest = Bytes.toBytes((String)"AAA");
        byte[] middle = Bytes.toBytes((String)"CCC");
        byte[] highest = Bytes.toBytes((String)"EEE");
        for (byte[] bytes : parts = Bytes.split((byte[])lowest, (byte[])highest, (int)1)) {
            LOG.info(Bytes.toString((byte[])bytes));
        }
        Assertions.assertEquals((int)3, (int)parts.length);
        Assertions.assertTrue((boolean)Bytes.equals((byte[])parts[1], (byte[])middle));
        highest = Bytes.toBytes((String)"DDD");
        for (byte[] part : parts = Bytes.split((byte[])lowest, (byte[])highest, (int)2)) {
            LOG.info(Bytes.toString((byte[])part));
        }
        Assertions.assertEquals((int)4, (int)parts.length);
        Assertions.assertTrue((boolean)Bytes.equals((byte[])parts[2], (byte[])middle));
    }

    @Test
    public void testSplit2() {
        byte[][] parts;
        byte[] lowest = Bytes.toBytes((String)"http://A");
        byte[] highest = Bytes.toBytes((String)"http://z");
        byte[] middle = Bytes.toBytes((String)"http://]");
        for (byte[] part : parts = Bytes.split((byte[])lowest, (byte[])highest, (int)1)) {
            LOG.info(Bytes.toString((byte[])part));
        }
        Assertions.assertEquals((int)3, (int)parts.length);
        Assertions.assertTrue((boolean)Bytes.equals((byte[])parts[1], (byte[])middle));
    }

    @Test
    public void testSplit3() {
        byte[] low = new byte[]{1, 1, 1};
        byte[] high = new byte[]{1, 1, 3};
        try {
            Bytes.split((byte[])high, (byte[])low, (int)1);
            Assertions.fail((String)"Should not be able to split if low > high");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        byte[][] parts = Bytes.split((byte[])low, (byte[])high, (int)1);
        for (int i = 0; i < parts.length; ++i) {
            LOG.info("" + i + " -> " + Bytes.toStringBinary((byte[])parts[i]));
        }
        Assertions.assertEquals((int)3, (int)parts.length, (String)("Returned split should have 3 parts but has " + parts.length));
        parts = Bytes.split((byte[])low, (byte[])high, (int)2);
        Assertions.assertNotNull((Object)parts, (String)"Split with an additional byte");
        Assertions.assertEquals((int)parts.length, (int)(low.length + 1));
        try {
            Bytes.split((byte[])low, (byte[])high, (int)0);
            Assertions.fail((String)"Should not be able to split 0 times");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testToInt() {
        int[] ints;
        for (int anInt : ints = new int[]{-1, 123, Integer.MIN_VALUE, Integer.MAX_VALUE}) {
            byte[] b = Bytes.toBytes((int)anInt);
            Assertions.assertEquals((int)anInt, (int)Bytes.toInt((byte[])b));
            byte[] b2 = this.bytesWithOffset(b);
            Assertions.assertEquals((int)anInt, (int)Bytes.toInt((byte[])b2, (int)1));
            Assertions.assertEquals((int)anInt, (int)Bytes.toInt((byte[])b2, (int)1, (int)4));
        }
    }

    @Test
    public void testToLong() {
        long[] longs;
        for (long aLong : longs = new long[]{-1L, 123L, Long.MIN_VALUE, Long.MAX_VALUE}) {
            byte[] b = Bytes.toBytes((long)aLong);
            Assertions.assertEquals((long)aLong, (long)Bytes.toLong((byte[])b));
            byte[] b2 = this.bytesWithOffset(b);
            Assertions.assertEquals((long)aLong, (long)Bytes.toLong((byte[])b2, (int)1));
            Assertions.assertEquals((long)aLong, (long)Bytes.toLong((byte[])b2, (int)1, (int)8));
        }
    }

    @Test
    public void testToFloat() {
        float[] floats;
        for (float aFloat : floats = new float[]{-1.0f, 123.123f, Float.MAX_VALUE}) {
            byte[] b = Bytes.toBytes((float)aFloat);
            Assertions.assertEquals((float)aFloat, (float)Bytes.toFloat((byte[])b), (float)0.0f);
            byte[] b2 = this.bytesWithOffset(b);
            Assertions.assertEquals((float)aFloat, (float)Bytes.toFloat((byte[])b2, (int)1), (float)0.0f);
        }
    }

    @Test
    public void testToDouble() {
        double[] doubles;
        for (double aDouble : doubles = new double[]{Double.MIN_VALUE, Double.MAX_VALUE}) {
            byte[] b = Bytes.toBytes((double)aDouble);
            Assertions.assertEquals((double)aDouble, (double)Bytes.toDouble((byte[])b), (double)0.0);
            byte[] b2 = this.bytesWithOffset(b);
            Assertions.assertEquals((double)aDouble, (double)Bytes.toDouble((byte[])b2, (int)1), (double)0.0);
        }
    }

    @Test
    public void testToBigDecimal() {
        BigDecimal[] decimals;
        for (BigDecimal decimal : decimals = new BigDecimal[]{new BigDecimal("-1"), new BigDecimal("123.123"), new BigDecimal("123123123123")}) {
            byte[] b = Bytes.toBytes((BigDecimal)decimal);
            Assertions.assertEquals((Object)decimal, (Object)Bytes.toBigDecimal((byte[])b));
            byte[] b2 = this.bytesWithOffset(b);
            Assertions.assertEquals((Object)decimal, (Object)Bytes.toBigDecimal((byte[])b2, (int)1, (int)b.length));
        }
    }

    private byte[] bytesWithOffset(byte[] src) {
        byte[] result = new byte[src.length + 1];
        result[0] = -86;
        System.arraycopy(src, 0, result, 1, src.length);
        return result;
    }

    @Test
    public void testToBytesForByteBuffer() {
        byte[] array = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ByteBuffer target = ByteBuffer.wrap(array);
        target.position(2);
        target.limit(7);
        byte[] actual = Bytes.toBytes((ByteBuffer)target);
        byte[] expected = new byte[]{0, 1, 2, 3, 4, 5, 6};
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        Assertions.assertEquals((int)2, (int)target.position());
        Assertions.assertEquals((int)7, (int)target.limit());
        ByteBuffer target2 = target.slice();
        Assertions.assertEquals((int)0, (int)target2.position());
        Assertions.assertEquals((int)5, (int)target2.limit());
        byte[] actual2 = Bytes.toBytes((ByteBuffer)target2);
        byte[] expected2 = new byte[]{2, 3, 4, 5, 6};
        Assertions.assertArrayEquals((byte[])expected2, (byte[])actual2);
        Assertions.assertEquals((int)0, (int)target2.position());
        Assertions.assertEquals((int)5, (int)target2.limit());
    }

    @Test
    public void testGetBytesForByteBuffer() {
        byte[] array = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ByteBuffer target = ByteBuffer.wrap(array);
        target.position(2);
        target.limit(7);
        byte[] actual = Bytes.getBytes((ByteBuffer)target);
        byte[] expected = new byte[]{2, 3, 4, 5, 6};
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        Assertions.assertEquals((int)2, (int)target.position());
        Assertions.assertEquals((int)7, (int)target.limit());
    }

    @Test
    public void testReadAsVLong() throws Exception {
        long[] longs;
        for (long aLong : longs = new long[]{-1L, 123L, Long.MIN_VALUE, Long.MAX_VALUE}) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(baos);
            WritableUtils.writeVLong((DataOutput)output, (long)aLong);
            byte[] long_bytes_no_offset = baos.toByteArray();
            Assertions.assertEquals((long)aLong, (long)Bytes.readAsVLong((byte[])long_bytes_no_offset, (int)0));
            byte[] long_bytes_with_offset = this.bytesWithOffset(long_bytes_no_offset);
            Assertions.assertEquals((long)aLong, (long)Bytes.readAsVLong((byte[])long_bytes_with_offset, (int)1));
        }
    }

    @Test
    public void testToStringBinaryForBytes() {
        byte[] array = new byte[]{48, 57, 97, 122, 65, 90, 64, 1};
        String actual = Bytes.toStringBinary((byte[])array);
        String expected = "09azAZ@\\x01";
        Assertions.assertEquals((Object)expected, (Object)actual);
        String actual2 = Bytes.toStringBinary((byte[])array, (int)2, (int)3);
        String expected2 = "azA";
        Assertions.assertEquals((Object)expected2, (Object)actual2);
    }

    @Test
    public void testToStringBinaryForArrayBasedByteBuffer() {
        byte[] array = new byte[]{48, 57, 97, 122, 65, 90, 64, 1};
        ByteBuffer target = ByteBuffer.wrap(array);
        String actual = Bytes.toStringBinary((ByteBuffer)target);
        String expected = "09azAZ@\\x01";
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testToStringBinaryForReadOnlyByteBuffer() {
        byte[] array = new byte[]{48, 57, 97, 122, 65, 90, 64, 1};
        ByteBuffer target = ByteBuffer.wrap(array).asReadOnlyBuffer();
        String actual = Bytes.toStringBinary((ByteBuffer)target);
        String expected = "09azAZ@\\x01";
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testBinarySearch() {
        byte[][] arr = new byte[][]{{1}, {3}, {5}, {7}, {9}, {11}, {13}, {15}};
        byte[] key1 = new byte[]{3, 1};
        byte[] key2 = new byte[]{4, 9};
        byte[] key2_2 = new byte[]{4};
        byte[] key3 = new byte[]{5, 11};
        byte[] key4 = new byte[]{0};
        byte[] key5 = new byte[]{2};
        Assertions.assertEquals((int)1, (int)Bytes.binarySearch((byte[][])arr, (byte[])key1, (int)0, (int)1));
        Assertions.assertEquals((int)0, (int)Bytes.binarySearch((byte[][])arr, (byte[])key1, (int)1, (int)1));
        Assertions.assertEquals((int)-3, (int)Arrays.binarySearch(arr, key2_2, Bytes.BYTES_COMPARATOR));
        Assertions.assertEquals((int)-3, (int)Bytes.binarySearch((byte[][])arr, (byte[])key2, (int)0, (int)1));
        Assertions.assertEquals((int)4, (int)Bytes.binarySearch((byte[][])arr, (byte[])key2, (int)1, (int)1));
        Assertions.assertEquals((int)2, (int)Bytes.binarySearch((byte[][])arr, (byte[])key3, (int)0, (int)1));
        Assertions.assertEquals((int)5, (int)Bytes.binarySearch((byte[][])arr, (byte[])key3, (int)1, (int)1));
        Assertions.assertEquals((int)-1, (int)Bytes.binarySearch((byte[][])arr, (byte[])key4, (int)0, (int)1));
        Assertions.assertEquals((int)-2, (int)Bytes.binarySearch((byte[][])arr, (byte[])key5, (int)0, (int)1));
        for (int i = 0; i < arr.length; ++i) {
            Assertions.assertEquals((int)(-(i + 1)), (int)Bytes.binarySearch((byte[][])arr, (byte[])new byte[]{(byte)(arr[i][0] - 1)}, (int)0, (int)1));
            Assertions.assertEquals((int)(-(i + 2)), (int)Bytes.binarySearch((byte[][])arr, (byte[])new byte[]{(byte)(arr[i][0] + 1)}, (int)0, (int)1));
        }
    }

    @Test
    public void testToStringBytesBinaryReversible() {
        byte[] randomBytes = new byte[1000];
        for (int i = 0; i < 1000; ++i) {
            Bytes.random((byte[])randomBytes);
            this.verifyReversibleForBytes(randomBytes);
        }
        this.verifyReversibleForBytes(new byte[0]);
        this.verifyReversibleForBytes(new byte[]{92, 120, 65, 68});
        this.verifyReversibleForBytes(new byte[]{92, 120, 65, 68, 92});
    }

    private void verifyReversibleForBytes(byte[] originalBytes) {
        String convertedString = Bytes.toStringBinary((byte[])originalBytes);
        byte[] convertedBytes = Bytes.toBytesBinary((String)convertedString);
        if (Bytes.compareTo((byte[])originalBytes, (byte[])convertedBytes) != 0) {
            Assertions.fail((String)("Not reversible for\nbyte[]: " + Arrays.toString(originalBytes) + ",\nStringBinary: " + convertedString));
        }
    }

    @Test
    public void testStartsWith() {
        Assertions.assertTrue((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)"hello"), (byte[])Bytes.toBytes((String)"h")));
        Assertions.assertTrue((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)"hello"), (byte[])Bytes.toBytes((String)"")));
        Assertions.assertTrue((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)"hello"), (byte[])Bytes.toBytes((String)"hello")));
        Assertions.assertFalse((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)"hello"), (byte[])Bytes.toBytes((String)"helloworld")));
        Assertions.assertFalse((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)""), (byte[])Bytes.toBytes((String)"hello")));
    }

    @Test
    public void testIncrementBytes() {
        Assertions.assertTrue((boolean)BytesTestBase.checkTestIncrementBytes(10L, 1L));
        Assertions.assertTrue((boolean)BytesTestBase.checkTestIncrementBytes(12L, 123435445L));
        Assertions.assertTrue((boolean)BytesTestBase.checkTestIncrementBytes(124634654L, 1L));
        Assertions.assertTrue((boolean)BytesTestBase.checkTestIncrementBytes(10005460L, 5005645L));
        Assertions.assertTrue((boolean)BytesTestBase.checkTestIncrementBytes(1L, -1L));
        Assertions.assertTrue((boolean)BytesTestBase.checkTestIncrementBytes(10L, -1L));
        Assertions.assertTrue((boolean)BytesTestBase.checkTestIncrementBytes(10L, -5L));
        Assertions.assertTrue((boolean)BytesTestBase.checkTestIncrementBytes(1005435000L, -5L));
        Assertions.assertTrue((boolean)BytesTestBase.checkTestIncrementBytes(10L, -43657655L));
        Assertions.assertTrue((boolean)BytesTestBase.checkTestIncrementBytes(-1L, 1L));
        Assertions.assertTrue((boolean)BytesTestBase.checkTestIncrementBytes(-26L, 5034520L));
        Assertions.assertTrue((boolean)BytesTestBase.checkTestIncrementBytes(-10657200L, 5L));
        Assertions.assertTrue((boolean)BytesTestBase.checkTestIncrementBytes(-12343250L, 45376475L));
        Assertions.assertTrue((boolean)BytesTestBase.checkTestIncrementBytes(-10L, -5L));
        Assertions.assertTrue((boolean)BytesTestBase.checkTestIncrementBytes(-12343250L, -5L));
        Assertions.assertTrue((boolean)BytesTestBase.checkTestIncrementBytes(-12L, -34565445L));
        Assertions.assertTrue((boolean)BytesTestBase.checkTestIncrementBytes(-1546543452L, -34565445L));
    }

    private static boolean checkTestIncrementBytes(long val, long amount) {
        byte[] value = Bytes.toBytes((long)val);
        byte[] testValue = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        if (value[0] > 0) {
            testValue = new byte[8];
        }
        System.arraycopy(value, 0, testValue, testValue.length - value.length, value.length);
        long incrementResult = Bytes.toLong((byte[])Bytes.incrementBytes((byte[])value, (long)amount));
        return Bytes.toLong((byte[])testValue) + amount == incrementResult;
    }

    @Test
    public void testFixedSizeString() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        Bytes.writeStringFixedSize((DataOutput)dos, (String)"Hello", (int)5);
        Bytes.writeStringFixedSize((DataOutput)dos, (String)"World", (int)18);
        Bytes.writeStringFixedSize((DataOutput)dos, (String)"", (int)9);
        try {
            Bytes.writeStringFixedSize((DataOutput)dos, (String)"Too\u2013Long", (int)9);
            Assertions.fail((String)"Exception expected");
        }
        catch (IOException ex) {
            Assertions.assertEquals((Object)"Trying to write 10 bytes (Too\\xE2\\x80\\x93Long) into a field of length 9", (Object)ex.getMessage());
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream dis = new DataInputStream(bais);
        Assertions.assertEquals((Object)"Hello", (Object)Bytes.readStringFixedSize((DataInput)dis, (int)5));
        Assertions.assertEquals((Object)"World", (Object)Bytes.readStringFixedSize((DataInput)dis, (int)18));
        Assertions.assertEquals((Object)"", (Object)Bytes.readStringFixedSize((DataInput)dis, (int)9));
    }

    @Test
    public void testCopy() {
        byte[] bytes = Bytes.toBytes((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        byte[] copy = Bytes.copy((byte[])bytes);
        Assertions.assertNotSame((Object)bytes, (Object)copy);
        Assertions.assertTrue((boolean)Bytes.equals((byte[])bytes, (byte[])copy));
    }

    @Test
    public void testToBytesBinaryTrailingBackslashes() {
        try {
            Bytes.toBytesBinary((String)"abc\\x00\\x01\\");
        }
        catch (StringIndexOutOfBoundsException ex) {
            Assertions.fail((String)("Illegal string access: " + ex.getMessage()));
        }
    }

    @Test
    public void testToStringBinary_toBytesBinary_Reversable() {
        String bytes = Bytes.toStringBinary((byte[])Bytes.toBytes((double)2.17));
        Assertions.assertEquals((double)2.17, (double)Bytes.toDouble((byte[])Bytes.toBytesBinary((String)bytes)), (double)0.0);
    }

    @Test
    public void testUnsignedBinarySearch() {
        byte[] bytes = new byte[]{0, 5, 123, 127, -128, -100, -1};
        Assertions.assertEquals((int)1, (int)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)5));
        Assertions.assertEquals((int)3, (int)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)127));
        Assertions.assertEquals((int)4, (int)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)-128));
        Assertions.assertEquals((int)5, (int)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)-100));
        Assertions.assertEquals((int)6, (int)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)-1));
        Assertions.assertEquals((int)-2, (int)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)2));
        Assertions.assertEquals((int)-7, (int)Bytes.unsignedBinarySearch((byte[])bytes, (int)0, (int)bytes.length, (byte)-5));
    }

    @Test
    public void testUnsignedIncrement() {
        byte[] a = Bytes.toBytes((int)0);
        int a2 = Bytes.toInt((byte[])Bytes.unsignedCopyAndIncrement((byte[])a), (int)0);
        Assertions.assertEquals((int)1, (int)a2);
        byte[] b = Bytes.toBytes((int)-1);
        byte[] actual = Bytes.unsignedCopyAndIncrement((byte[])b);
        Assertions.assertNotSame((Object)b, (Object)actual);
        byte[] expected = new byte[]{1, 0, 0, 0, 0};
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        byte[] c = Bytes.toBytes((int)255);
        int c2 = Bytes.toInt((byte[])Bytes.unsignedCopyAndIncrement((byte[])c), (int)0);
        Assertions.assertEquals((int)256, (int)c2);
    }

    @Test
    public void testIndexOf() {
        byte[] array = Bytes.toBytes((String)"hello");
        Assertions.assertEquals((int)1, (int)Bytes.indexOf((byte[])array, (byte)101));
        Assertions.assertEquals((int)4, (int)Bytes.indexOf((byte[])array, (byte)111));
        Assertions.assertEquals((int)-1, (int)Bytes.indexOf((byte[])array, (byte)97));
        Assertions.assertEquals((int)0, (int)Bytes.indexOf((byte[])array, (byte[])Bytes.toBytes((String)"hel")));
        Assertions.assertEquals((int)2, (int)Bytes.indexOf((byte[])array, (byte[])Bytes.toBytes((String)"ll")));
        Assertions.assertEquals((int)-1, (int)Bytes.indexOf((byte[])array, (byte[])Bytes.toBytes((String)"hll")));
    }

    @Test
    public void testContains() {
        byte[] array = Bytes.toBytes((String)"hello world");
        Assertions.assertTrue((boolean)Bytes.contains((byte[])array, (byte)101));
        Assertions.assertTrue((boolean)Bytes.contains((byte[])array, (byte)100));
        Assertions.assertFalse((boolean)Bytes.contains((byte[])array, (byte)97));
        Assertions.assertTrue((boolean)Bytes.contains((byte[])array, (byte[])Bytes.toBytes((String)"world")));
        Assertions.assertTrue((boolean)Bytes.contains((byte[])array, (byte[])Bytes.toBytes((String)"ello")));
        Assertions.assertFalse((boolean)Bytes.contains((byte[])array, (byte[])Bytes.toBytes((String)"owo")));
    }

    @Test
    public void testZero() {
        int i;
        byte[] array = Bytes.toBytes((String)"hello");
        Bytes.zero((byte[])array);
        for (byte b : array) {
            Assertions.assertEquals((int)0, (int)b);
        }
        array = Bytes.toBytes((String)"hello world");
        Bytes.zero((byte[])array, (int)2, (int)7);
        Assertions.assertFalse((array[0] == 0 ? 1 : 0) != 0);
        Assertions.assertFalse((array[1] == 0 ? 1 : 0) != 0);
        for (i = 2; i < 9; ++i) {
            Assertions.assertEquals((int)0, (int)array[i]);
        }
        for (i = 9; i < array.length; ++i) {
            Assertions.assertFalse((array[i] == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPutBuffer() {
        byte i;
        byte[] b = new byte[100];
        for (i = 0; i < 100; i = (byte)(i + 1)) {
            Bytes.putByteBuffer((byte[])b, (int)i, (ByteBuffer)ByteBuffer.wrap(new byte[]{i}));
        }
        for (i = 0; i < 100; i = (byte)(i + 1)) {
            Assertions.assertEquals((byte)i, (byte)b[i]);
        }
    }

    @Test
    public void testToFromHex() {
        ArrayList<String> testStrings = new ArrayList<String>(8);
        testStrings.addAll(Arrays.asList("", "00", "A0", "ff", "FFffFFFFFFFFFF", "12", "0123456789abcdef", "283462839463924623984692834692346ABCDFEDDCA0"));
        for (String testString : testStrings) {
            byte[] byteData = Bytes.fromHex((String)testString);
            Assertions.assertEquals((int)(testString.length() / 2), (int)byteData.length);
            String string = Bytes.toHex((byte[])byteData);
            Assertions.assertTrue((boolean)testString.equalsIgnoreCase(string));
        }
        ArrayList<Object> testByteData = new ArrayList<Object>(5);
        testByteData.addAll(Arrays.asList(new byte[0], new byte[1], new byte[10], {1, 2, 3, 4, 5}, {-1}));
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 0; i < 20; ++i) {
            byte[] byArray = new byte[((Random)rand).nextInt(100)];
            Bytes.random((byte[])byArray);
            testByteData.add(byArray);
        }
        for (byte[] byArray : testByteData) {
            String hexString = Bytes.toHex((byte[])byArray);
            Assertions.assertEquals((int)(byArray.length * 2), (int)hexString.length());
            byte[] result = Bytes.fromHex((String)hexString);
            Assertions.assertArrayEquals((byte[])byArray, (byte[])result);
        }
    }

    @Test
    public void testFindCommonPrefix() throws Exception {
        byte[] hello = Bytes.toBytes((String)"hello");
        byte[] helloWorld = Bytes.toBytes((String)"helloworld");
        Assertions.assertEquals((int)5, (int)Bytes.findCommonPrefix((byte[])hello, (byte[])helloWorld, (int)hello.length, (int)helloWorld.length, (int)0, (int)0));
        Assertions.assertEquals((int)5, (int)Bytes.findCommonPrefix((byte[])hello, (byte[])hello, (int)hello.length, (int)hello.length, (int)0, (int)0));
        Assertions.assertEquals((int)3, (int)Bytes.findCommonPrefix((byte[])hello, (byte[])hello, (int)(hello.length - 2), (int)(hello.length - 2), (int)2, (int)2));
        Assertions.assertEquals((int)0, (int)Bytes.findCommonPrefix((byte[])hello, (byte[])hello, (int)0, (int)0, (int)0, (int)0));
        byte[] hellohello = Bytes.toBytes((String)"hellohello");
        byte[] hellohellohi = Bytes.toBytes((String)"hellohellohi");
        Assertions.assertEquals((int)10, (int)Bytes.findCommonPrefix((byte[])hellohello, (byte[])hellohellohi, (int)hellohello.length, (int)hellohellohi.length, (int)0, (int)0));
        Assertions.assertEquals((int)10, (int)Bytes.findCommonPrefix((byte[])hellohellohi, (byte[])hellohello, (int)hellohellohi.length, (int)hellohello.length, (int)0, (int)0));
        Assertions.assertEquals((int)10, (int)Bytes.findCommonPrefix((byte[])hellohello, (byte[])hellohello, (int)hellohello.length, (int)hellohello.length, (int)0, (int)0));
        hellohello[2] = 0;
        Assertions.assertEquals((int)2, (int)Bytes.findCommonPrefix((byte[])hellohello, (byte[])hellohellohi, (int)hellohello.length, (int)hellohellohi.length, (int)0, (int)0));
    }
}

